/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c170.imp.srv;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import es.aeat.adht.jdit.api.ADHT_JDIT_Factory;
import es.aeat.pret.c170.api.bean.AscendienteBean;
import es.aeat.pret.c170.api.bean.DescendienteBean;
import es.aeat.pret.c170.api.bean.ErrorValidacionBean;
import es.aeat.pret.c170.api.bean.PerceptorBean;
import es.aeat.pret.c170.api.srv.CalculoRetencionesSrv;
import es.aeat.pret.c170.imp.bean.AscendienteBeanImpl;
import es.aeat.pret.c170.imp.bean.DescendienteBeanImpl;
import es.aeat.pret.c170.imp.bean.ErrorValidacionBeanImpl;
import es.aeat.pret.c170.imp.bean.PerceptorBeanImpl;
import es.aeat.pret.c170.util.ValidaNif;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

public class CalculoRetencionesSrvImpl
implements CalculoRetencionesSrv {
    public static final String VALIDOSNIF = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final BigDecimal LIMITE_33007_CON_20 = new BigDecimal("33007.20");
    private static final BigDecimal LIMITE_22000 = new BigDecimal("22000.00");
    private static final BigDecimal LIMITE = new BigDecimal("0.43");
    private static final BigDecimal CERODOS = new BigDecimal("0.02");
    private static final BigDecimal BD1200 = new BigDecimal("1200.00");
    private static final BigDecimal BD600 = new BigDecimal("600.00");
    private static final BigDecimal BD030 = new BigDecimal("0.30");
    private static final BigDecimal BD90000 = new BigDecimal("90000.00");
    private static final BigDecimal BD5550 = new BigDecimal("5550.00");
    private static final BigDecimal BD2000 = new BigDecimal("2000.00");
    private static final BigDecimal BD1400 = new BigDecimal("1400.00");
    private static final BigDecimal BD8100 = new BigDecimal("8100.00");
    private static final BigDecimal BD11250 = new BigDecimal("11250.00");
    private static final BigDecimal BD3700 = new BigDecimal("3700.00");
    private static final BigDecimal BD14450 = new BigDecimal("14450.00");
    private static final BigDecimal BD115625 = new BigDecimal("1.15625");
    private static final BigDecimal BD7750 = new BigDecimal("7750.00");
    private static final BigDecimal BD3500 = new BigDecimal("3500.00");
    private static final BigDecimal BD1150 = new BigDecimal("1150.00");
    private static final BigDecimal BD2400 = new BigDecimal("2400.00");
    private static final BigDecimal BD2700 = new BigDecimal("2700.00");
    private static final BigDecimal BD4000 = new BigDecimal("4000.00");
    private static final BigDecimal BD4500 = new BigDecimal("4500.00");
    private static final BigDecimal BD2800 = new BigDecimal("2800.00");
    private static final BigDecimal BD9000 = new BigDecimal("9000.00");
    private static final BigDecimal BD3000 = new BigDecimal("3000.00");
    private static final BigDecimal BD1980 = new BigDecimal("1980.00");
    private static final BigDecimal BD2 = new BigDecimal("2.00");
    private static final BigDecimal BD17138 = new BigDecimal("17138.00");
    private static final BigDecimal BD14266 = new BigDecimal("14266.00");
    private static final BigDecimal BD15803 = new BigDecimal("15803.00");
    private static final BigDecimal BD13696 = new BigDecimal("13696.00");
    private static final BigDecimal BD14985 = new BigDecimal("14985.00");
    private static final BigDecimal BD12000 = new BigDecimal("12000.00");
    private static final BigDecimal BD12607 = new BigDecimal("12607.00");
    private static final BigDecimal BD13275 = new BigDecimal("13275.00");
    private static final BigDecimal BD12450 = new BigDecimal("12450.00");
    private static final BigDecimal BD019 = new BigDecimal("0.19");
    private static final BigDecimal BD20200 = new BigDecimal("20200.00");
    private static final BigDecimal BD236550 = new BigDecimal("2365.50");
    private static final BigDecimal BD024 = new BigDecimal("0.24");
    private static final BigDecimal BD60000 = new BigDecimal("60000.00");
    private static final BigDecimal BD872550 = new BigDecimal("8725.50");
    private static final BigDecimal BD045 = new BigDecimal("0.45");
    private static final BigDecimal BD1790150 = new BigDecimal("17901.50");
    private static final BigDecimal BD35200 = new BigDecimal("35200.00");
    private static final BigDecimal BD42255 = new BigDecimal("4225.50");
    private static final BigDecimal BD037 = new BigDecimal("0.37");

    @Override
    public boolean validar(PerceptorBean perceptorBean, boolean desdeFichero) {
        Boolean presviv;
        int situFam;
        this.calculoYComputoDeDescendientes(perceptorBean);
        this.calculoYComputoDeAscendientes(perceptorBean);
        this.setRegularizacion(perceptorBean);
        perceptorBean.resetErrores();
        ValidaNif vln = new ValidaNif();
        String nifRet = (String)perceptorBean.getValor("NIFRET");
        int resul = vln.checkNif(nifRet);
        if (nifRet.trim().equals("")) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9001", "No existe NIF del retenedor.", "NIFRET", -1));
        } else if (!this.validaNifMayus(nifRet)) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9002", "El NIF del retenedor es incorrecto.", "NIFRET", -1));
        } else if (resul == -1 || !vln.isOk()) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9003", "El NIF del retenedor es incorrecto.", "NIFRET", -1));
        }
        if (!ValidaNif.validaNombre(resul, (String)perceptorBean.getValor("APERET"))) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9004", "Contenido incorrecto en Apellidos y nombre del retenedor.", "APERET", -1));
        }
        String nifPer = (String)perceptorBean.getValor("NIFPER");
        resul = vln.checkNif(nifPer);
        if (nifPer.trim().equals("") || !vln.esPersonaFisica(resul, false)) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9005", "NIF del perceptor obligatorio de persona f\u00edsica.", "NIFPER", -1));
        } else if (!this.validaNifMayus(nifPer)) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9006", "NIF del perceptor obligatorio de persona f\u00edsica.", "NIFPER", -1));
        } else if (resul == -1 || !vln.isOk()) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9007", "NIF del perceptor incorrecto.", "NIFPER", -1));
        }
        if (!CalculoRetencionesSrvImpl.validaNombrePerceptor((String)perceptorBean.getValor("APEPER"), resul)) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9009", "Contenido incorrecto en Apellidos y nombre del perceptor.", "APEPER", -1));
        }
        boolean bValidarRangoA\u00f1o = true;
        Integer anioPer = (Integer)perceptorBean.getValor("ANOPER");
        if (anioPer == 0) {
            if (!desdeFichero) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9010", "A\u00f1o de nacimiento del perceptor obligatorio.", "ANOPER", -1));
            } else {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9011", "A\u00f1o nacimiento perceptor incorrecto.", "ANOPER", -1));
            }
            bValidarRangoA\u00f1o = false;
        }
        if (bValidarRangoA\u00f1o && (anioPer < 1905 || anioPer > 2017)) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9012", "A\u00f1o nacimiento perceptor incorrecto.", "ANOPER", -1));
        }
        if ((situFam = ((Integer)perceptorBean.getValor("SITUFAM")).intValue()) < 1 || situFam > 3) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9013", "La situaci\u00f3n familiar del perceptor es obligatoria.", "SITUFAM", -1));
        }
        int numDes = (Integer)perceptorBean.getValor("NUMDES");
        if (situFam == 1 && numDes == 0) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9014", "La situaci\u00f3n familiar \"1\" exige que el contribuyente tenga al menos un descendiente que d\u00e9 derecho a la reducci\u00f3n de la tributaci\u00f3n conjunta para familias monoparentales.", "SITUFAM", -1));
        }
        if (situFam == 2) {
            String nifCon = (String)perceptorBean.getValor("NIFCON");
            resul = vln.checkNif(nifCon);
            if (nifCon.trim().equals("")) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9015", "NIF del c\u00f3nyuge obligatorio.", "NIFCON", -1));
            } else if (!this.validaNifMayus(nifCon)) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9016", "El NIF del c\u00f3nyuge es incorrecto.", "NIFCON", -1));
            } else if (resul == -1 || !vln.isOk()) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9017", "El NIF del c\u00f3nyuge es incorrecto.", "NIFCON", -1));
            } else if (!vln.esPersonaFisica(resul, false)) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9018", "El NIF del c\u00f3nyuge ha de ser de persona f\u00edsica.", "NIFCON", -1));
            } else if (nifCon.equals(nifPer)) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9019", "El NIF del c\u00f3nyuge no puede ser el mismo que el del contribuyente.", "NIFCON", -1));
            }
        }
        vln = null;
        int situPer = (Integer)perceptorBean.getValor("SITUPER");
        if (situPer != 1 && situPer != 2 && situPer != 3 && situPer != 4) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9020", "El tipo de situaci\u00f3n del perceptor es incorrecto.", "SITUPER", -1));
        }
        int contrato = (Integer)perceptorBean.getValor("CONTRATO");
        if (situPer == 1 && contrato != 1 && contrato != 2 && contrato != 3 && contrato != 4) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9021", "El tipo de contrato es obligatorio.", "CONTRATO", -1));
        }
        List descendientes = (List)perceptorBean.getValor("descendientes");
        int nD = descendientes.size();
        int i = 0;
        while (i < nD) {
            int adopcion;
            int nacimiento;
            DescendienteBean d = (DescendienteBean)descendientes.get(i);
            int edad = 2017 - d.getAnioNacimiento();
            if (edad > 24 && d.getDiscapacidad() == 0) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9022", "Descendientes mayores de 25 a\u00f1os sin discapacidad no dan derecho a m\u00ednimo.", "descendientes", i));
            }
            if (d.getAnioAdopcion() != 0 && (nacimiento = d.getAnioNacimiento().intValue()) > (adopcion = d.getAnioAdopcion().intValue())) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9024", "El a\u00f1o de adopci\u00f3n debe ser igual o mayor al a\u00f1o de nacimiento.", "descendientes", i));
            }
            d = null;
            ++i;
        }
        List ascendientes = (List)perceptorBean.getValor("ascendientes");
        int nA = ascendientes.size();
        int i2 = 0;
        while (i2 < nA) {
            AscendienteBean a = (AscendienteBean)ascendientes.get(i2);
            int edad = 2017 - a.getAnioNacimiento();
            if (edad < 65 && a.getDiscapacidad() == 0) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9023", "Ascendientes menores de 65 a\u00f1os sin discapacidad no dan derecho a m\u00ednimo.", "ascendientes", i2));
            }
            a = null;
            ++i2;
        }
        BigDecimal retrib = (BigDecimal)perceptorBean.getValor("RETRIB");
        if (retrib.equals(PerceptorBean.CERO)) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9025", "Las retribuciones totales son obligatorias.", "RETRIB", -1));
        }
        if (((BigDecimal)perceptorBean.getValor("IRREGULAR1")).compareTo(BD90000) > 0) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9026", "La cuant\u00eda m\u00e1xima de la reducci\u00f3n (art.\u00ba 18.2 LIRPF) no puede superar el importe de 90.000 euros.", "IRREGULAR1", -1));
        }
        if (((BigDecimal)perceptorBean.getValor("IRREGULAR1")).compareTo(retrib.multiply(BD030)) > 0) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R90281", "La cuant\u00eda m\u00e1xima de la reducci\u00f3n (art.18.2 LIRPF) no puede superar, con car\u00e1cter general, el 30% de las retribuciones totales.", "IRREGULAR1", -1));
        }
        if ((presviv = (Boolean)perceptorBean.getValor("PRESVIV")).booleanValue() && retrib.compareTo(LIMITE_33007_CON_20) >= 0) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9028", "Las retribuciones totales anuales consignadas no son inferiores a 33.007,20 euros, por lo que en la pantalla de datos econ\u00f3micos deber\u00e1 desactivarse la casilla relativa a los pagos por pr\u00e9stamos destinados a la adquisici\u00f3n o rehabilitaci\u00f3n de la vivienda habitual del perceptor.", "PRESVIV", -1));
        }
        boolean regularizacion = (Boolean)perceptorBean.getValor("REGULARIZACION");
        BigDecimal tipoa = (BigDecimal)perceptorBean.getValor("TIPOA");
        BigDecimal minperfaa = (BigDecimal)perceptorBean.getValor("MINPERFAA");
        Object basea = perceptorBean.getValor("BASEA");
        boolean[] causa = (boolean[])perceptorBean.getValor("CAUSA");
        boolean minorado = (Boolean)perceptorBean.getValor("MINORADO");
        BigDecimal minopagoa = (BigDecimal)perceptorBean.getValor("MINOPAGOA");
        BigDecimal percibido = (BigDecimal)perceptorBean.getValor("PERCIBIDO");
        if (regularizacion) {
            boolean rencemea;
            boolean resiceme;
            int i3;
            int i4;
            if (causa[9]) {
                i4 = 0;
                i4 = 1;
                while (i4 <= 11) {
                    if (causa[i4] && i4 != 9) {
                        perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9032", "Ha seleccionado causas de regularizaci\u00f3n incompatibles entre s\u00ed.", "CAUSA", 9));
                        break;
                    }
                    ++i4;
                }
                if (!presviv.booleanValue()) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9033", "Si el perceptor no comunica que efect\u00faa pagos por pr\u00e9stamos, la causa de regularizaci\u00f3n no puede ser la realizaci\u00f3n de pagos por pr\u00e9stamos destinados para la adquisici\u00f3n de la vivienda habitual.", "PRESVIV", -1));
                }
                if (!basea.equals(PerceptorBean.CERO)) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9034", "Base para calcular el tipo de retenci\u00f3n determinada antes de la regularizaci\u00f3n incompatible con la causa de regularizaci\u00f3n consignada.", "BASEA", -1));
                }
                if (!minperfaa.equals(PerceptorBean.CERO)) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9035", "M\u00ednimo personal y familiar determinado antes de la regularizaci\u00f3n incompatible con la causa de regularizaci\u00f3n consignada.", "MINPERFAA", -1));
                }
                if (!tipoa.equals(PerceptorBean.CERO)) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9036", "Tipo de retenci\u00f3n aplicado con anterioridad a la regularizaci\u00f3n incompatible con la causa de regularizaci\u00f3n consignada.", "TIPOA", -1));
                }
            }
            if (causa[10]) {
                i4 = 0;
                i4 = 1;
                while (i4 <= 11) {
                    if (causa[i4] && i4 != 10) {
                        perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9037", "Ha seleccionado causas de regularizaci\u00f3n incompatibles entre s\u00ed.", "CAUSA", 10));
                        break;
                    }
                    ++i4;
                }
                if (!basea.equals(PerceptorBean.CERO)) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9038", "Base para calcular el tipo de retenci\u00f3n determinada antes de la regularizaci\u00f3n incompatible con la causa de regularizaci\u00f3n consignada.", "BASEA", -1));
                }
                if (!minperfaa.equals(PerceptorBean.CERO)) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9039", "M\u00ednimo personal y familiar determinado antes de la regularizaci\u00f3n incompatible con la causa de regularizaci\u00f3n consignada.", "MINPERFAA", -1));
                }
                if (!tipoa.equals(PerceptorBean.CERO)) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9040", "Tipo de retenci\u00f3n aplicado con anterioridad a la regularizaci\u00f3n incompatible con la causa de regularizaci\u00f3n consignada.", "TIPOA", -1));
                }
                if (presviv.booleanValue() && retrib.compareTo(LIMITE_33007_CON_20) < 0) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9041", "Si el perceptor ha comunicado que efect\u00faa pagos para el pr\u00e9stamo de su vivienda la causa de regularizaci\u00f3n no puede ser la improcedencia de reducci\u00f3n del tipo de retenci\u00f3n por pagos de pr\u00e9stamos destinados a la adquisici\u00f3n o rehabilitaci\u00f3n de su vivienda habitual.", "PRESVIV", -1));
                }
            }
            if (minorado && minopagoa.compareTo(PerceptorBean.CERO) == 0) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9042", "Debe consignar el importe de la minoraci\u00f3n por pagos de pr\u00e9stamos para vivienda antes de la regularizaci\u00f3n.", "MINOPAGOA", -1));
            }
            BigDecimal aux1 = LIMITE_33007_CON_20.multiply(CERODOS).setScale(2, 4);
            BigDecimal retriba = (BigDecimal)perceptorBean.getValor("RETRIBA");
            BigDecimal aux2 = retriba.multiply(CERODOS).setScale(2, 1);
            if (minorado && (minopagoa.compareTo(aux1) > 0 || minopagoa.compareTo(aux2) > 0)) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9044", "El importe de la minoraci\u00f3n por pagos de pr\u00e9stamos para vivienda determinado antes de la regularizaci\u00f3n no puede superar el 2 por 100 de las retribuciones totales anuales determinadas antes de la regularizaci\u00f3n ni tampoco ser mayor de 660,14 euros.", "MINORADO", -1));
            }
            aux1 = null;
            aux2 = null;
            if (!causa[9] && presviv.booleanValue() && !minorado && !causa[11]) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9045", "Si el perceptor ha comunicado que realiza pagos para el pr\u00e9stamo de su vivienda y antes de la regularizaci\u00f3n no se aplic\u00f3 minoraci\u00f3n por dicho concepto por pagos, la causa de regularizaci\u00f3n debe ser \"El perceptor ha comunicado que realiza pagos por pr\u00e9stamos destinados a la adquisici\u00f3n o rehabilitaci\u00f3n de su vivienda habitual\".", "MINORADO", -1));
            }
            if (causa[11]) {
                BigDecimal importea;
                boolean rencemea2;
                i3 = 0;
                i3 = 1;
                while (i3 <= 11) {
                    if (causa[i3] && i3 != 11) {
                        perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9046", "Ha seleccionado causas de regularizaci\u00f3n incompatibles entre s\u00ed.", "CAUSA", 11));
                        break;
                    }
                    ++i3;
                }
                if ((double)minopagoa.compareTo(PerceptorBean.CERO) > 0.0) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9047", "Importe de la minoraci\u00f3n por pagos de pr\u00e9stamos para la vivienda determinado antes de la regularizaci\u00f3n es incompatible con Otras causas de regularizaci\u00f3n.", "MINOPAGOA", -1));
                }
                if ((double)retriba.compareTo(PerceptorBean.CERO) > 0.0) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9050", "Retribuciones anuales consideradas con anterioridad a la regularizaci\u00f3n incompatible con Otras causas de regularizaci\u00f3n.", "RETRIBA", -1));
                }
                if (rencemea2 = ((Boolean)perceptorBean.getValor("RENCEMEA")).booleanValue()) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9052", "Los rendimientos anteriores a la regularizaci\u00f3n fueron obtenidos en Ceuta o Melilla incompatible con Otras causas de regularizaci\u00f3n.", "RENCEMEA", -1));
                }
                if (minorado) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9048", "En alg\u00fan momento antes de la regularizaci\u00f3n se aplic\u00f3 minoraci\u00f3n por  pagos de pr\u00e9stamos para vivienda es incompatible con Otras causas de regularizaci\u00f3n.", "MINORADO", -1));
                }
                if (!(importea = (BigDecimal)perceptorBean.getValor("IMPORTEA")).equals(PerceptorBean.CERO)) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9051", "Retenciones totales anuales determinadas antes de la regularizaci\u00f3n incompatible  con Otras causas de regularizaci\u00f3n.", "CAUSA", 11));
                }
                if (!basea.equals(PerceptorBean.CERO)) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9053", "Base para calcular el tipo de retenci\u00f3n determinada antes de la regularizaci\u00f3n incompatible con Otras causas de regularizaci\u00f3n.", "CAUSA", 11));
                }
                if (!minperfaa.equals(PerceptorBean.CERO)) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9054", "M\u00ednimo personal y familiar determinado antes de la regularizaci\u00f3n incompatible con Otras causas de regularizaci\u00f3n.", "CAUSA", 11));
                }
                if (!tipoa.equals(PerceptorBean.CERO)) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9055", "Tipo de retenci\u00f3n aplicado con anterioridad a la regularizaci\u00f3n incompatible con Otras causas de regularizaci\u00f3n", "CAUSA", 11));
                }
            } else if (!causa[11]) {
                if (retriba.compareTo(percibido) < 0) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9056", "Las Retribuciones ya satisfechas con anterioridad a la regularizaci\u00f3n no pueden ser superiores a las Retribuciones anuales consideradas con anterioridad.", "RETRIBA", -1));
                }
                if (retriba.equals(PerceptorBean.CERO)) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9057", "Las retribuciones anuales consideradas con anterioridad a la regularizaci\u00f3n son obligatorias.", "RETRIBA", -1));
                }
                if (!causa[9] && !causa[10] && !causa[11] && minperfaa.equals(PerceptorBean.CERO)) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9058", "M\u00ednimo personal y familiar determinado antes de la regularizaci\u00f3n es obligatorio.", "MINPERFAA", -1));
                }
            }
            if (percibido.equals(PerceptorBean.CERO)) {
                if (!desdeFichero) {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9059", "Las retribuciones ya satisfechas con anterioridad a la regularizaci\u00f3n son obligatorias.", "PERCIBIDO", -1));
                } else {
                    perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9060", "Falta contenido en Retribuciones ya satisfechas.", "PERCIBIDO", -1));
                }
            }
            if (retrib.compareTo(percibido) <= 0) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9061", "Las Retribuciones totales consignadas en Datos econ\u00f3micos (importes anuales) no pueden ser inferiores o iguales a las Retribuciones ya satisfechas con anterioridad a la regularizaci\u00f3n.", "RETRIB", -1));
            }
            i3 = 1;
            while (i3 < causa.length) {
                if (causa[i3]) break;
                ++i3;
            }
            if (i3 == causa.length) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9062", "No ha seleccionado ninguna causa de regularizaci\u00f3n.", "CAUSA", -1));
            }
            if (causa[3] && perceptorBean.getValor("CONYUGE").equals(PerceptorBean.CERO)) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9063", "No ha consignado el importe de la Pensi\u00f3n compensatoria a favor del c\u00f3nyuge.", "CONYUGE", -1));
            }
            if (causa[4] && perceptorBean.getValor("ANUALIDADES").equals(PerceptorBean.CERO)) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9064", "No ha consignado el importe de las Anualidades por alimentos a favor de hijos.", "ANUALIDADES", -1));
            }
            if (causa[5] && situFam != 3) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9065", "Si selecciona como causa de regularizaci\u00f3n el cambio de la situaci\u00f3n familiar '2' a la situaci\u00f3n familiar '3', s\u00f3lo puede seleccionar situaci\u00f3n familiar '3'.", "SITUFAM", -1));
            }
            if (causa[6] && causa[7] || causa[6] && causa[8] || causa[7] && causa[8]) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9066", "Ha seleccionado dos causas de regularizaci\u00f3n incompatibles entre s\u00ed.", "CAUSA", -1));
            }
            if ((resiceme = ((Boolean)perceptorBean.getValor("RESICEME")).booleanValue()) && causa[6]) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9068", "Si el contribuyente es residente en Ceuta o Melilla, la causa de regularizaci\u00f3n no puede ser la p\u00e9rdida de la condici\u00f3n de residente en Ceuta o Melilla.", "CAUSA", 6));
            }
            if (!resiceme && causa[7]) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9069", "Si el contribuyente no es residente en Ceuta o Melilla, la causa de regularizaci\u00f3n no puede ser la adquisici\u00f3n de la condici\u00f3n de residente en Ceuta o Melilla.", "CAUSA", 7));
            }
            if (!resiceme && causa[8]) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9070", "Si el contribuyente no es residente en Ceuta o Melilla, la causa de regularizaci\u00f3n no puede ser comenzar a realizar trabajos fuera de Ceuta o Melilla por residentes en Ceuta o Melilla.", "RESICEME", -1));
            }
            if (((Boolean)perceptorBean.getValor("RENCEME")).booleanValue() && causa[8]) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9071", "Si el contribuyente obtiene rendimientos en Ceuta o Melilla, la causa de Regularizaci\u00f3n no puede ser comenzar a realizar trabajos fuera de Ceuta o Melilla.", "CAUSA", 8));
            }
            if (!(rencemea = ((Boolean)perceptorBean.getValor("RENCEMEA")).booleanValue()) && causa[6]) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9072", "Si el contribuyente no obten\u00eda rendimientos en Ceuta o Melilla con anterioridad a la regularizaci\u00f3n, no podr\u00e1 seleccionar como causa de regularizaci\u00f3n la p\u00e9rdida de la condici\u00f3n de residente en Ceuta o Melilla.", "CAUSA", 6));
            }
            if (!rencemea && causa[8]) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9073", "Si el contribuyente no obten\u00eda rendimientos en Ceuta o Melilla con anterioridad a la regularizaci\u00f3n, la causa de \u00e9sta no puede ser comenzar a realizar trabajos fuera de Ceuta o Melilla.", "CAUSA", 8));
            }
            if (tipoa.compareTo(PerceptorBean.CERO) < 0 || tipoa.compareTo(PerceptorBean.TIPO_MAXIMO_N2017) > 0) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9074", "Tipo de retenci\u00f3n anterior debe estar comprendido entre 0 y " + PerceptorBean.TIPO_MAXIMO_N2017.intValue() + ".", "TIPOA", -1));
            }
        } else if (!regularizacion) {
            if (((Boolean)perceptorBean.getValor("MINORADO")).booleanValue()) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9075", "Minoraci\u00f3n por pagos de pr\u00e9stamos para vivienda antes de la regularizaci\u00f3n incompatible con Regularizaci\u00f3n no cumplimentada.", "MINORADO", -1));
            }
            if (!perceptorBean.getValor("MINOPAGOA").equals(PerceptorBean.CERO)) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9076", "Importe de la minoraci\u00f3n por pagos de pr\u00e9stamos para vivienda antes de la regularizaci\u00f3n incompatible con Regularizaci\u00f3n no cumplimentada.", "MINOPAGO", -1));
            }
            if (((Boolean)perceptorBean.getValor("RENCEMEA")).booleanValue()) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9077", "Los rendimientos anteriores a la regularizaci\u00f3n fueron obtenidos en Ceuta o Melilla incompatible con Regularizaci\u00f3n no cumplimentada.", "CAUSA", -1));
            }
            int i5 = 1;
            while (i5 <= causa.length) {
                if (!causa[i5]) break;
                ++i5;
            }
            if (i5 == causa.length) {
                perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9078", "Si no hay Regularizaci\u00f3n no puede seleccionar ninguna causa de Regularizaci\u00f3n.", "CAUSA", -1));
            }
        }
        BigDecimal retriba = (BigDecimal)perceptorBean.getValor("RETRIBA");
        if (regularizacion && retrib.compareTo(retriba) > 0 && (causa[9] || causa[10])) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9079", "La causa de regularizaci\u00f3n consignada es incompatible con el aumento del importe de las retribuciones totales anuales. En consecuencia, deber\u00e1n efectuarse dos regularizaciones sucesivas: la primera, por la causa consignada, sin considerar el aumento de retribuciones, y la segunda, por la causa de regularizaci\u00f3n correspondiente a dicho aumento.", "CAUSA", 9));
        }
        if (regularizacion && retrib.compareTo(retriba) < 0 && (causa[9] || causa[10])) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9080", "La causa de regularizaci\u00f3n consignada es incompatible con la disminuci\u00f3n del importe de las retribuciones totales anuales. En consecuencia, deber\u00e1n efectuarse dos regularizaciones sucesivas: la primera, por la causa de regularizaci\u00f3n correspondiente a la disminuci\u00f3n de retribuciones, y la segunda, por la causa de regularizaci\u00f3n consignada.", "CAUSA", 9));
        }
        if (regularizacion && causa[10] && presviv.booleanValue()) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9081", "La causa de regularizaci\u00f3n consignada es incompatible con la activaci\u00f3n de la casilla de la pantalla de Datos Econ\u00f3micos relativa a los pagos por pr\u00e9stamos destinados a la vivienda habitual del perceptor. En consecuencia, deber\u00e1 desactivarse dicha casilla.", "PRESVIV", -1));
        }
        if (regularizacion && causa[10] && (minopagoa.equals(PerceptorBean.CERO) || !minorado)) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9082", "Si la causa de regularizaci\u00f3n es la 10 debe indicar, que en alg\u00fan momento se aplic\u00f3 la minoraci\u00f3n por pagos y consignar el importe de la misma anteriormente determinado.", "MINOPAGOA", -1));
        }
        BigDecimal percibido02 = CERODOS.multiply(percibido);
        if (regularizacion && !causa[10] && !presviv.booleanValue() && minopagoa.compareTo(percibido02) > 0) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9086", "El importe de la minoraci\u00f3n por pagos de pr\u00e9stamos para vivienda determinado antes de la regularizaci\u00f3n no puede superar el 2 por 100 de las retribuciones ya satisfechas con anterioridad a la regularizaci\u00f3n.", "MINOPAGOA", -1));
        }
        percibido02 = null;
        return perceptorBean.isCorrecto();
    }

    @Override
    public void calcular(PerceptorBean perceptorBean) {
        this.calculosGastosDeducibles(perceptorBean);
        this.rendimientoNetoTrabajo(perceptorBean);
        this.reduccionPorObtencionDeRendimientosDelTrabajo(perceptorBean);
        this.rendimientoNetoReducido(perceptorBean);
        this.reduccionPensionistaDeLaSSOClasesPasivas(perceptorBean);
        this.reduccionMasDe2Descendientes(perceptorBean);
        this.reduccionPorSerDesempleado(perceptorBean);
        this.minimoPersonalYFamiliar(perceptorBean);
        this.baseParaCalcularElTipoDeretencion(perceptorBean);
        this.cuotaDeRetencion(perceptorBean);
        this.tipoPrevioRetencion(perceptorBean);
        this.aplicacionReduccionPagoPrestamos(perceptorBean);
        this.tipoDeRetencionAplicable(perceptorBean);
        this.importeAnualRetencionesIngresosACuenta(perceptorBean);
        if (((Boolean)perceptorBean.getValor("REGULARIZACION")).booleanValue()) {
            this.regularizacion(perceptorBean);
        }
    }

    private void regularizacion(PerceptorBean perceptorBean) {
        BigDecimal aux1 = null;
        BigDecimal aux2 = null;
        boolean[] causa = (boolean[])perceptorBean.getValor("CAUSA");
        Boolean rencemea = (Boolean)perceptorBean.getValor("RENCEMEA");
        Boolean ceumeli = (Boolean)perceptorBean.getValor("CEUMELI");
        BigDecimal retrib = perceptorBean.getValorAsBigDecimal("RETRIB");
        if (((Boolean)perceptorBean.getValor("CEUMELI")).booleanValue() && !rencemea.booleanValue() && causa[7]) {
            aux1 = perceptorBean.getValorAsBigDecimal("PERCIBIDO").multiply(perceptorBean.getValorAsBigDecimal("CUOTA").divide(retrib, 10, 4));
            aux2 = retrib.subtract(perceptorBean.getValorAsBigDecimal("PERCIBIDO")).multiply(perceptorBean.getValorAsBigDecimal("CUOTA").divide(BD2).divide(retrib, 10, 4));
            perceptorBean.setValor("IMPORTEREG", aux1.add(aux2));
        } else if (rencemea.booleanValue() && causa[8]) {
            aux1 = perceptorBean.getValorAsBigDecimal("PERCIBIDO").multiply(perceptorBean.getValorAsBigDecimal("CUOTA").divide(BD2).divide(retrib, 10, 4));
            aux2 = retrib.subtract(perceptorBean.getValorAsBigDecimal("PERCIBIDO")).multiply(perceptorBean.getValorAsBigDecimal("CUOTA").divide(retrib, 10, 4));
            perceptorBean.setValor("IMPORTEREG", aux1.add(aux2));
        } else if (ceumeli.booleanValue() && rencemea.booleanValue()) {
            perceptorBean.setValor("IMPORTEREG", perceptorBean.getValorAsBigDecimal("CUOTA").divide(BD2));
        } else {
            perceptorBean.setValor("IMPORTEREG", perceptorBean.getValorAsBigDecimal("CUOTA"));
        }
        aux1 = null;
        aux2 = null;
        BigDecimal AUX = null;
        Boolean presviv = (Boolean)perceptorBean.getValor("PRESVIV");
        Boolean minorado = (Boolean)perceptorBean.getValor("MINORADO");
        BigDecimal percibido = perceptorBean.getValorAsBigDecimal("PERCIBIDO");
        if (causa[1] || causa[2] || causa[3] || causa[4] || causa[5] || causa[6] || causa[7] || causa[8]) {
            if (((Boolean)perceptorBean.getValor("MINORADO")).booleanValue() && presviv.booleanValue() && (double)retrib.compareTo(LIMITE_33007_CON_20) < 0.0) {
                BigDecimal retriba = perceptorBean.getValorAsBigDecimal("RETRIBA");
                AUX = retrib.subtract(retriba).abs();
                if (retrib.compareTo(retriba) > 0) {
                    perceptorBean.setValor("MINOPAGO", perceptorBean.getValorAsBigDecimal("MINOPAGOA").add(AUX.multiply(CERODOS)));
                } else if (retrib.compareTo(retriba) < 0) {
                    perceptorBean.setValor("MINOPAGO", perceptorBean.getValorAsBigDecimal("MINOPAGOA").subtract(AUX.multiply(CERODOS)));
                } else {
                    perceptorBean.setValor("MINOPAGO", perceptorBean.getValorAsBigDecimal("MINOPAGOA"));
                }
            } else if (((Boolean)perceptorBean.getValor("MINORADO")).booleanValue() && !presviv.booleanValue()) {
                perceptorBean.setValor("MINOPAGO", perceptorBean.getValorAsBigDecimal("MINOPAGOA"));
            } else {
                perceptorBean.setValor("MINOPAGO", PerceptorBean.CERO);
            }
        } else if (causa[9] && presviv.booleanValue() && retrib.compareTo(LIMITE_33007_CON_20) < 0) {
            AUX = retrib.subtract(percibido);
            if (minorado.booleanValue()) {
                perceptorBean.setValor("MINOPAGO", perceptorBean.getValorAsBigDecimal("MINOPAGOA").add(AUX.multiply(CERODOS)));
            } else {
                perceptorBean.setValor("MINOPAGO", AUX.multiply(CERODOS));
            }
        } else if (minorado.booleanValue() && !presviv.booleanValue() && causa[10]) {
            AUX = retrib.subtract(percibido).multiply(CERODOS);
            perceptorBean.setValor("MINOPAGO", perceptorBean.getValorAsBigDecimal("MINOPAGOA").subtract(AUX));
        } else if (causa[11] && presviv.booleanValue() && retrib.compareTo(LIMITE_33007_CON_20) < 0) {
            aux1 = retrib.subtract(percibido);
            perceptorBean.setValor("MINOPAGO", aux1.multiply(CERODOS));
        } else {
            perceptorBean.setValor("MINOPAGO", PerceptorBean.CERO);
        }
        if (presviv.booleanValue() && perceptorBean.getValorAsBigDecimal("MINOPAGO").compareTo(PerceptorBean.PORCENTAJE2) > 0) {
            perceptorBean.setValor("MINOPAGO", PerceptorBean.PORCENTAJE2);
        }
        perceptorBean.setValor("MINOPAGO", perceptorBean.getValorAsBigDecimal("MINOPAGO").setScale(2, 1));
        AUX = CERODOS.multiply(LIMITE_33007_CON_20).setScale(2, 4);
        if (perceptorBean.getValorAsBigDecimal("MINOPAGO").compareTo(AUX) > 0) {
            perceptorBean.setValor("MINOPAGO", AUX);
        }
        AUX = null;
        BigDecimal dividendo = perceptorBean.getValorAsBigDecimal("IMPORTEREG").subtract(perceptorBean.getValorAsBigDecimal("RETENIDO")).subtract(perceptorBean.getValorAsBigDecimal("MINOPAGO"));
        BigDecimal divisor = retrib.subtract(percibido);
        BigDecimal resul = dividendo.divide(divisor, 10, 4);
        perceptorBean.setValor("TIPOREG", resul.movePointRight(2));
        dividendo = null;
        divisor = null;
        resul = null;
        if (perceptorBean.getValorAsBigDecimal("TIPOREG").compareTo(PerceptorBean.CERO) < 0) {
            perceptorBean.setValor("TIPOREG", PerceptorBean.CERO);
        }
        perceptorBean.setValor("TIPOREG", perceptorBean.getValorAsBigDecimal("TIPOREG").setScale(2, 1));
        int situper = (Integer)perceptorBean.getValor("SITUPER");
        int contrato = (Integer)perceptorBean.getValor("CONTRATO");
        if (ceumeli.booleanValue()) {
            if (rencemea.booleanValue() && perceptorBean.getValorAsBigDecimal("TIPOREG").compareTo(PerceptorBean.TIPO_MAXIMO_CEUTA_N2017) > 0) {
                perceptorBean.setValor("TIPOREG", PerceptorBean.TIPO_MAXIMO_CEUTA_N2017);
            } else if (perceptorBean.getValorAsBigDecimal("TIPOREG").compareTo(PerceptorBean.TIPO_MAXIMO_N2017) > 0) {
                perceptorBean.setValor("TIPOREG", PerceptorBean.TIPO_MAXIMO_N2017);
            } else if (situper == 1 && contrato == 3) {
                perceptorBean.setValor("TIPOREG", perceptorBean.getValorAsBigDecimal("TIPOREG").max(PerceptorBean.TIPO_MINIMO_RELACIONESPECIAL_CEUTA));
            } else if (situper == 1 && contrato == 2) {
                perceptorBean.setValor("TIPOREG", perceptorBean.getValorAsBigDecimal("TIPOREG").max(PerceptorBean.TIPO_MINIMO_PEONADAS_CEUTA));
            }
        } else if (perceptorBean.getValorAsBigDecimal("TIPOREG").compareTo(PerceptorBean.TIPO_MAXIMO_N2017) > 0) {
            perceptorBean.setValor("TIPOREG", PerceptorBean.TIPO_MAXIMO_N2017);
        } else if (situper == 1 && contrato == 3) {
            perceptorBean.setValor("TIPOREG", perceptorBean.getValorAsBigDecimal("TIPOREG").max(PerceptorBean.TIPO_MINIMO_REL_ESPECIALES));
        } else if (situper == 1 && contrato == 2) {
            perceptorBean.setValor("TIPOREG", perceptorBean.getValorAsBigDecimal("TIPOREG").max(PerceptorBean.TIPO_MINIMO_PEONADAS));
        }
        perceptorBean.setValor("IMPORTE", retrib.subtract(percibido).multiply(perceptorBean.getValorAsBigDecimal("TIPOREG")).movePointLeft(2).add(perceptorBean.getValorAsBigDecimal("RETENIDO")).setScale(2, 4));
        if (!(causa[5] || causa[6] || causa[8] || causa[9] || causa[10] || causa[11])) {
            boolean revisar = false;
            BigDecimal diferencia = perceptorBean.getValorAsBigDecimal("BASEA").subtract(perceptorBean.getValorAsBigDecimal("MINPERFAA")).compareTo(PerceptorBean.CERO) > 0 ? perceptorBean.getValorAsBigDecimal("BASEA").subtract(perceptorBean.getValorAsBigDecimal("MINPERFAA")) : PerceptorBean.CERO;
            BigDecimal increimporte = PerceptorBean.CERO;
            BigDecimal increbasemin = PerceptorBean.CERO;
            if (diferencia.compareTo(perceptorBean.getValorAsBigDecimal("BASE").subtract(perceptorBean.getValorAsBigDecimal("MINPERFA"))) >= 0 && perceptorBean.getValorAsBigDecimal("TIPOREG").compareTo(perceptorBean.getValorAsBigDecimal("TIPOA")) > 0) {
                perceptorBean.setValor("TIPOREG", perceptorBean.getValorAsBigDecimal("TIPOA"));
                revisar = true;
            } else if (diferencia.compareTo(perceptorBean.getValorAsBigDecimal("BASE").subtract(perceptorBean.getValorAsBigDecimal("MINPERFA"))) < 0 && perceptorBean.getValorAsBigDecimal("IMPORTEA").compareTo(perceptorBean.getValorAsBigDecimal("IMPORTE")) < 0 && (increimporte = perceptorBean.getValorAsBigDecimal("IMPORTE").subtract(perceptorBean.getValorAsBigDecimal("IMPORTEA"))).compareTo(increbasemin = perceptorBean.getValorAsBigDecimal("BASE").subtract(perceptorBean.getValorAsBigDecimal("MINPERFA")).subtract(diferencia)) > 0) {
                revisar = true;
                perceptorBean.setValor("IMPORTE", perceptorBean.getValorAsBigDecimal("IMPORTEA").add(increbasemin));
                perceptorBean.setValor("TIPOREG", perceptorBean.getValorAsBigDecimal("IMPORTE").subtract(perceptorBean.getValorAsBigDecimal("RETENIDO")).divide(retrib.subtract(percibido), 10, 4).movePointRight(2));
                if (perceptorBean.getValorAsBigDecimal("TIPOREG").compareTo(PerceptorBean.CERO) < 0) {
                    perceptorBean.setValor("TIPOREG", PerceptorBean.CERO);
                } else {
                    perceptorBean.setValor("TIPOREG", perceptorBean.getValorAsBigDecimal("TIPOREG").setScale(2, 1));
                    perceptorBean.setValor("IMPORTE", retrib.subtract(percibido).multiply(perceptorBean.getValorAsBigDecimal("TIPOREG")).movePointLeft(2).add(perceptorBean.getValorAsBigDecimal("RETENIDO")));
                    increimporte = perceptorBean.getValorAsBigDecimal("IMPORTE").subtract(perceptorBean.getValorAsBigDecimal("IMPORTEA"));
                }
                if (increimporte.compareTo(increbasemin) > 0 && perceptorBean.getValorAsBigDecimal("TIPOREG").compareTo(PerceptorBean.CERO) > 0) {
                    perceptorBean.setValor("TIPOREG", perceptorBean.getValorAsBigDecimal("IMPORTEA").add(increbasemin).subtract(perceptorBean.getValorAsBigDecimal("RETENIDO")).divide(retrib.subtract(percibido), 10, 4).movePointRight(2));
                    perceptorBean.setValor("TIPOREG", perceptorBean.getValorAsBigDecimal("TIPOREG").setScale(2, 1));
                }
            }
            increimporte = null;
            increbasemin = null;
            diferencia = null;
            if (revisar) {
                if (ceumeli.booleanValue()) {
                    if (situper == 1 && contrato == 3 && perceptorBean.getValorAsBigDecimal("TIPOREG").compareTo(PerceptorBean.TIPO_MINIMO_RELACIONESPECIAL_CEUTA) < 0) {
                        perceptorBean.setValor("TIPOREG", PerceptorBean.TIPO_MINIMO_RELACIONESPECIAL_CEUTA);
                    } else if (situper == 1 && contrato == 2 && perceptorBean.getValorAsBigDecimal("TIPOREG").compareTo(PerceptorBean.TIPO_MINIMO_PEONADAS_CEUTA) < 0) {
                        perceptorBean.setValor("TIPOREG", PerceptorBean.TIPO_MINIMO_PEONADAS_CEUTA);
                    }
                } else if (situper == 1 && contrato == 3 && perceptorBean.getValorAsBigDecimal("TIPOREG").compareTo(PerceptorBean.TIPO_MINIMO_REL_ESPECIALES) < 0) {
                    perceptorBean.setValor("TIPOREG", PerceptorBean.TIPO_MINIMO_REL_ESPECIALES);
                } else if (situper == 1 && contrato == 2 && perceptorBean.getValorAsBigDecimal("TIPOREG").compareTo(PerceptorBean.TIPO_MINIMO_PEONADAS) < 0) {
                    perceptorBean.setValor("TIPOREG", PerceptorBean.TIPO_MINIMO_PEONADAS);
                }
                perceptorBean.setValor("IMPORTE", retrib.subtract(percibido).multiply(perceptorBean.getValorAsBigDecimal("TIPOREG")).movePointLeft(2).add(perceptorBean.getValorAsBigDecimal("RETENIDO")));
            }
            perceptorBean.setValor("IMPORTE", perceptorBean.getValorAsBigDecimal("IMPORTE").setScale(2, 4));
        }
    }

    private void importeAnualRetencionesIngresosACuenta(PerceptorBean perceptorBean) {
        perceptorBean.setValor("IMPORTE", perceptorBean.getValorAsBigDecimal("RETRIB").multiply(perceptorBean.getValorAsBigDecimal("TIPO")).movePointLeft(2).setScale(2, 4));
    }

    private void tipoDeRetencionAplicable(PerceptorBean perceptorBean) {
        perceptorBean.setValor("TIPO", perceptorBean.getValorAsBigDecimal("DIFERENCIAPOSITIVA").divide(perceptorBean.getValorAsBigDecimal("RETRIB"), 10, 4).movePointRight(2).setScale(2, 1));
        int situper = (Integer)perceptorBean.getValor("SITUPER");
        int contrato = (Integer)perceptorBean.getValor("CONTRATO");
        if (((Boolean)perceptorBean.getValor("CEUMELI")).booleanValue()) {
            if (situper == 1 && contrato == 3) {
                perceptorBean.setValor("TIPO", perceptorBean.getValorAsBigDecimal("TIPO").max(PerceptorBean.TIPO_MINIMO_RELACIONESPECIAL_CEUTA));
            } else if (situper == 1 && contrato == 2) {
                perceptorBean.setValor("TIPO", perceptorBean.getValorAsBigDecimal("TIPO").max(PerceptorBean.TIPO_MINIMO_PEONADAS_CEUTA));
            }
        } else if (situper == 1 && contrato == 3) {
            perceptorBean.setValor("TIPO", perceptorBean.getValorAsBigDecimal("TIPO").max(PerceptorBean.TIPO_MINIMO_REL_ESPECIALES));
        } else if (situper == 1 && contrato == 2) {
            perceptorBean.setValor("TIPO", perceptorBean.getValorAsBigDecimal("TIPO").max(PerceptorBean.TIPO_MINIMO_PEONADAS));
        }
    }

    private void aplicacionReduccionPagoPrestamos(PerceptorBean perceptorBean) {
        if ((double)perceptorBean.getValorAsBigDecimal("RETRIB").compareTo(LIMITE_33007_CON_20) < 0.0 && ((Boolean)perceptorBean.getValor("PRESVIV")).booleanValue()) {
            perceptorBean.setValor("MINOPAGO", perceptorBean.getValorAsBigDecimal("RETRIB").multiply(CERODOS));
        } else {
            perceptorBean.setValor("MINOPAGO", PerceptorBean.CERO);
        }
        perceptorBean.setValor("MINOPAGO", perceptorBean.getValorAsBigDecimal("MINOPAGO").setScale(2, 1));
        if (((Boolean)perceptorBean.getValor("CEUMELI")).booleanValue()) {
            perceptorBean.setValor("DIFERENCIAPOSITIVA", perceptorBean.getValorAsBigDecimal("CUOTA").divide(BD2).subtract(perceptorBean.getValorAsBigDecimal("MINOPAGO")));
        } else {
            perceptorBean.setValor("DIFERENCIAPOSITIVA", perceptorBean.getValorAsBigDecimal("CUOTA").subtract(perceptorBean.getValorAsBigDecimal("MINOPAGO")));
        }
        if (perceptorBean.getValorAsBigDecimal("DIFERENCIAPOSITIVA").compareTo(PerceptorBean.CERO) < 0) {
            perceptorBean.setValor("DIFERENCIAPOSITIVA", PerceptorBean.CERO);
        }
    }

    private void tipoPrevioRetencion(PerceptorBean perceptorBean) {
        perceptorBean.setValor("CEUMELI", (Boolean)perceptorBean.getValor("RESICEME") != false && (Boolean)perceptorBean.getValor("RENCEME") != false);
        if (((Boolean)perceptorBean.getValor("CEUMELI")).booleanValue()) {
            perceptorBean.setValor("CUOTACM", perceptorBean.getValorAsBigDecimal("CUOTA").divide(BD2));
        } else {
            perceptorBean.setValor("CUOTACM", PerceptorBean.CERO);
        }
    }

    private void cuotaDeRetencion(PerceptorBean perceptorBean) {
        this.rendimientosExentosDeRetencion(perceptorBean);
        if (((Boolean)perceptorBean.getValor("EXENTOS")).booleanValue()) {
            perceptorBean.setValor("CUOTA", PerceptorBean.CERO);
            perceptorBean.setValor("TIPO", PerceptorBean.CERO);
        } else {
            this.rendimientosSujetosARetencion(perceptorBean);
        }
    }

    private void rendimientosSujetosARetencion(PerceptorBean perceptorBean) {
        BigDecimal base1 = PerceptorBean.CERO;
        BigDecimal base2 = PerceptorBean.CERO;
        BigDecimal cuota1_1 = PerceptorBean.CERO;
        BigDecimal cuota1_2 = PerceptorBean.CERO;
        BigDecimal limite = PerceptorBean.CERO;
        if (perceptorBean.getValorAsBigDecimal("ANUALIDADES").compareTo(PerceptorBean.CERO) > 0 && perceptorBean.getValorAsBigDecimal("BASE").subtract(perceptorBean.getValorAsBigDecimal("ANUALIDADES")).compareTo(PerceptorBean.CERO) > 0) {
            base1 = perceptorBean.getValorAsBigDecimal("BASE").subtract(perceptorBean.getValorAsBigDecimal("ANUALIDADES"));
            base2 = perceptorBean.getValorAsBigDecimal("ANUALIDADES");
            cuota1_1 = this.escala(base1);
            cuota1_2 = this.escala(base2);
            perceptorBean.setValor("CUOTA1", cuota1_1.add(cuota1_2));
        } else {
            perceptorBean.setValor("CUOTA1", this.escala(perceptorBean.getValorAsBigDecimal("BASE")));
        }
        if (perceptorBean.getValorAsBigDecimal("ANUALIDADES").compareTo(PerceptorBean.CERO) > 0 && perceptorBean.getValorAsBigDecimal("BASE").subtract(perceptorBean.getValorAsBigDecimal("ANUALIDADES")).compareTo(PerceptorBean.CERO) > 0) {
            perceptorBean.setValor("CUOTA2", this.escala(perceptorBean.getValorAsBigDecimal("MINPERFA").add(BD1980)));
        } else {
            perceptorBean.setValor("CUOTA2", this.escala(perceptorBean.getValorAsBigDecimal("MINPERFA")));
        }
        if (perceptorBean.getValorAsBigDecimal("CUOTA1").compareTo(perceptorBean.getValorAsBigDecimal("CUOTA2")) > 0) {
            perceptorBean.setValor("CUOTA", perceptorBean.getValorAsBigDecimal("CUOTA1").subtract(perceptorBean.getValorAsBigDecimal("CUOTA2")));
        } else {
            perceptorBean.setValor("CUOTA", PerceptorBean.CERO);
        }
        if (perceptorBean.getValorAsBigDecimal("RETRIB").compareTo(LIMITE_22000) <= 0) {
            Integer numdes = (Integer)perceptorBean.getValor("NUMDES");
            switch ((Integer)perceptorBean.getValor("SITUFAM")) {
                case 1: {
                    if (numdes == 1) {
                        limite = perceptorBean.getValorAsBigDecimal("RETRIB").subtract(BD14266.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"))).multiply(LIMITE);
                        break;
                    }
                    if (numdes <= 1) break;
                    limite = perceptorBean.getValorAsBigDecimal("RETRIB").subtract(BD15803.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"))).multiply(LIMITE);
                    break;
                }
                case 2: {
                    if (numdes == 0) {
                        limite = perceptorBean.getValorAsBigDecimal("RETRIB").subtract(BD13696.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"))).multiply(LIMITE);
                        break;
                    }
                    if (numdes == 1) {
                        limite = perceptorBean.getValorAsBigDecimal("RETRIB").subtract(BD14985.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"))).multiply(LIMITE);
                        break;
                    }
                    if (numdes <= 1) break;
                    limite = perceptorBean.getValorAsBigDecimal("RETRIB").subtract(BD17138.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"))).multiply(LIMITE);
                    break;
                }
                case 3: {
                    if (numdes == 0) {
                        limite = perceptorBean.getValorAsBigDecimal("RETRIB").subtract(BD12000.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"))).multiply(LIMITE);
                        break;
                    }
                    if (numdes == 1) {
                        limite = perceptorBean.getValorAsBigDecimal("RETRIB").subtract(BD12607.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"))).multiply(LIMITE);
                        break;
                    }
                    if (numdes <= 1) break;
                    limite = perceptorBean.getValorAsBigDecimal("RETRIB").subtract(BD13275.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"))).multiply(LIMITE);
                    break;
                }
                default: {
                    limite = PerceptorBean.CERO;
                }
            }
            if (perceptorBean.getValorAsBigDecimal("CUOTA").compareTo(limite) > 0 && limite.compareTo(PerceptorBean.CERO) > 0) {
                perceptorBean.setValor("CUOTA", limite);
            }
        }
        base1 = null;
        base2 = null;
        cuota1_1 = null;
        cuota1_2 = null;
        limite = null;
    }

    private BigDecimal escala(BigDecimal blt) {
        BigDecimal cuota = PerceptorBean.CERO;
        cuota = blt.compareTo(BD12450) < 0 ? blt.multiply(BD019) : (blt.compareTo(BD20200) < 0 ? BD236550.add(blt.subtract(BD12450).multiply(BD024)) : (blt.compareTo(BD35200) < 0 ? BD42255.add(blt.subtract(BD20200).multiply(BD030)) : (blt.compareTo(BD60000) < 0 ? BD872550.add(blt.subtract(BD35200).multiply(BD037)) : BD1790150.add(blt.subtract(BD60000).multiply(BD045)))));
        return cuota;
    }

    private void rendimientosExentosDeRetencion(PerceptorBean perceptorBean) {
        BigDecimal aux = PerceptorBean.CERO;
        perceptorBean.setValor("EXENTOS", false);
        if (perceptorBean.getValorAsBigDecimal("RETRIB").compareTo(BD17138.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"))) <= 0) {
            Integer situfam = (Integer)perceptorBean.getValor("SITUFAM");
            Integer numdes = (Integer)perceptorBean.getValor("NUMDES");
            if (situfam == 1) {
                boolean retribmenoroigualaux;
                aux = BD14266.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"));
                boolean bl = retribmenoroigualaux = perceptorBean.getValorAsBigDecimal("RETRIB").compareTo(aux) <= 0;
                if (numdes == 1 && retribmenoroigualaux) {
                    perceptorBean.setValor("EXENTOS", true);
                } else {
                    aux = BD15803.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"));
                    boolean bl2 = retribmenoroigualaux = perceptorBean.getValorAsBigDecimal("RETRIB").compareTo(aux) <= 0;
                    if (numdes > 1 && retribmenoroigualaux) {
                        perceptorBean.setValor("EXENTOS", true);
                    }
                }
            } else if (situfam == 2) {
                boolean retribmenoroigualaux;
                aux = BD13696.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"));
                boolean bl = retribmenoroigualaux = perceptorBean.getValorAsBigDecimal("RETRIB").compareTo(aux) <= 0;
                if (numdes == 0 && retribmenoroigualaux) {
                    perceptorBean.setValor("EXENTOS", true);
                } else {
                    aux = BD14985.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"));
                    boolean bl3 = retribmenoroigualaux = perceptorBean.getValorAsBigDecimal("RETRIB").compareTo(aux) <= 0;
                    if (numdes == 1 && retribmenoroigualaux) {
                        perceptorBean.setValor("EXENTOS", true);
                    } else {
                        aux = BD17138.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"));
                        boolean bl4 = retribmenoroigualaux = perceptorBean.getValorAsBigDecimal("RETRIB").compareTo(aux) <= 0;
                        if (numdes > 1 && retribmenoroigualaux) {
                            perceptorBean.setValor("EXENTOS", true);
                        }
                    }
                }
            } else if (situfam == 3) {
                boolean retribmenoroigualaux;
                aux = BD12000.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"));
                boolean bl = retribmenoroigualaux = perceptorBean.getValorAsBigDecimal("RETRIB").compareTo(aux) <= 0;
                if (numdes == 0 && retribmenoroigualaux) {
                    perceptorBean.setValor("EXENTOS", true);
                } else {
                    aux = BD12607.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"));
                    boolean bl5 = retribmenoroigualaux = perceptorBean.getValorAsBigDecimal("RETRIB").compareTo(aux) <= 0;
                    if (numdes == 1 && retribmenoroigualaux) {
                        perceptorBean.setValor("EXENTOS", true);
                    } else {
                        aux = BD13275.add(perceptorBean.getValorAsBigDecimal("PENSION")).add(perceptorBean.getValorAsBigDecimal("DESEM"));
                        boolean bl6 = retribmenoroigualaux = perceptorBean.getValorAsBigDecimal("RETRIB").compareTo(aux) <= 0;
                        if (numdes > 1 && retribmenoroigualaux) {
                            perceptorBean.setValor("EXENTOS", true);
                        }
                    }
                }
            }
        }
        aux = null;
    }

    private void baseParaCalcularElTipoDeretencion(PerceptorBean perceptorBean) {
        perceptorBean.setValor("REDU", perceptorBean.getValorAsBigDecimal("PENSION").add(perceptorBean.getValorAsBigDecimal("HIJOS")).add(perceptorBean.getValorAsBigDecimal("DESEM")).add(perceptorBean.getValorAsBigDecimal("CONYUGE")));
        if (perceptorBean.getValorAsBigDecimal("RNTREDU").compareTo(perceptorBean.getValorAsBigDecimal("REDU")) > 0) {
            perceptorBean.setValor("BASE", perceptorBean.getValorAsBigDecimal("RNTREDU").subtract(perceptorBean.getValorAsBigDecimal("REDU")));
        } else {
            perceptorBean.setValor("BASE", PerceptorBean.CERO);
        }
    }

    private void minimoPersonalYFamiliar(PerceptorBean perceptorBean) {
        this.minimoDelContribuyente(perceptorBean);
        this.minimoPorDescendientesMenor25A\u00f1osODiscapacitados(perceptorBean);
        this.minimoPorAscendientesMayor65A\u00f1osODiscapacitados(perceptorBean);
        this.minimoPorDiscapacidad(perceptorBean);
        perceptorBean.setValor("MINPERFA", perceptorBean.getValorAsBigDecimal("MINCON").add(perceptorBean.getValorAsBigDecimal("MINDES")).add(perceptorBean.getValorAsBigDecimal("MINAS")).add(perceptorBean.getValorAsBigDecimal("MINDIS")));
    }

    private void minimoPorDiscapacidad(PerceptorBean perceptorBean) {
        this.minimoPorDiscapacidadDelContribuyente(perceptorBean);
        this.minimoPordiscapacidadDeDescendientesYAscendientes(perceptorBean);
        perceptorBean.setValor("MINDIS", perceptorBean.getValorAsBigDecimal("MINDISC").add(perceptorBean.getValorAsBigDecimal("MDISDEAS")));
    }

    private void minimoPordiscapacidadDeDescendientesYAscendientes(PerceptorBean perceptorBean) {
        List descendientes = (List)perceptorBean.getValor("descendientes");
        int tamDesc = descendientes.size();
        BigDecimal disDes = PerceptorBean.CERO;
        BigDecimal asisDesc = PerceptorBean.CERO;
        int i = 0;
        while (i < tamDesc) {
            DescendienteBean d = (DescendienteBean)perceptorBean.getValor("descendientesOrdenados", i);
            BigDecimal porEntero = d.isPorEntero() ? PerceptorBean.UNO : PerceptorBean.UNMEDIO;
            int disca = d.getDiscapacidad();
            if (disca == 1) {
                disDes = disDes.add(BD3000.multiply(porEntero));
            } else if (disca == 2) {
                disDes = disDes.add(BD9000.multiply(porEntero));
            }
            if (disca == 2) {
                asisDesc = asisDesc.add(BD3000.multiply(porEntero));
            } else if (disca == 1 && d.isMovilidadReducida()) {
                asisDesc = asisDesc.add(BD3000.multiply(porEntero));
            }
            d = null;
            porEntero = null;
            ++i;
        }
        perceptorBean.setValor("DISDES", disDes.setScale(2, 4));
        perceptorBean.setValor("ASISDES", asisDesc.setScale(2, 4));
        disDes = null;
        asisDesc = null;
        List ascendientes = (List)perceptorBean.getValor("ascendientes");
        int tamAsc = ascendientes.size();
        BigDecimal disAsc = PerceptorBean.CERO;
        BigDecimal asisAsc = PerceptorBean.CERO;
        int i2 = 0;
        while (i2 < tamAsc) {
            AscendienteBean a = (AscendienteBean)ascendientes.get(i2);
            BigDecimal convivencia = new BigDecimal(a.getConvivencia());
            int disca = a.getDiscapacidad();
            if (disca == 1) {
                disAsc = disAsc.add(BD3000.divide(convivencia, 10, 4));
            } else if (disca == 2) {
                disAsc = disAsc.add(BD9000.divide(convivencia, 10, 4));
            }
            if (disca == 2) {
                asisAsc = asisAsc.add(BD3000.divide(convivencia, 10, 4));
            } else if (disca == 1 && a.isMovilidadReducida()) {
                asisAsc = asisAsc.add(BD3000.divide(convivencia, 10, 4));
            }
            a = null;
            convivencia = null;
            ++i2;
        }
        perceptorBean.setValor("DISAS", disAsc.setScale(2, 4));
        perceptorBean.setValor("ASISAS", asisAsc.setScale(2, 4));
        perceptorBean.setValor("MDISDEAS", perceptorBean.getValorAsBigDecimal("DISDES").add(perceptorBean.getValorAsBigDecimal("DISAS")).add(perceptorBean.getValorAsBigDecimal("ASISDES")).add(perceptorBean.getValorAsBigDecimal("ASISAS")));
        disAsc = null;
        asisAsc = null;
    }

    private void minimoPorDiscapacidadDelContribuyente(PerceptorBean perceptorBean) {
        Integer discaper = (Integer)perceptorBean.getValor("DISCAPER");
        if (discaper == 2) {
            perceptorBean.setValor("DISPER", BD9000);
        } else if (discaper == 1) {
            perceptorBean.setValor("DISPER", BD3000);
        } else {
            perceptorBean.setValor("DISPER", PerceptorBean.CERO);
        }
        if (discaper == 2 || discaper == 1 && ((Boolean)perceptorBean.getValor("MOVILPER")).booleanValue()) {
            perceptorBean.setValor("ASISPER", BD3000);
        } else {
            perceptorBean.setValor("ASISPER", PerceptorBean.CERO);
        }
        perceptorBean.setValor("MINDISC", perceptorBean.getValorAsBigDecimal("DISPER").add(perceptorBean.getValorAsBigDecimal("ASISPER")));
    }

    private void minimoPorAscendientesMayor65A\u00f1osODiscapacitados(PerceptorBean perceptorBean) {
        BigDecimal as65 = PerceptorBean.CERO;
        BigDecimal as75 = PerceptorBean.CERO;
        ArrayList ascendientes = (ArrayList)perceptorBean.getValor("ascendientes");
        if (ascendientes == null) {
            ascendientes = new ArrayList();
        }
        int nD = ascendientes.size();
        int i = 0;
        while (i < nD) {
            AscendienteBean a = (AscendienteBean)ascendientes.get(i);
            BigDecimal convivencia = new BigDecimal(a.getConvivencia());
            as65 = as65.add(BD1150.divide(convivencia, 10, 4));
            int a\u00f1oAsc = a.getAnioNacimiento();
            int edadAsc = 2017 - a\u00f1oAsc;
            if (edadAsc > 74) {
                as75 = as75.add(BD1400.divide(convivencia, 10, 4));
            }
            a = null;
            convivencia = null;
            ++i;
        }
        perceptorBean.setValor("AS65", as65.setScale(2, 4));
        perceptorBean.setValor("AS75", as75.setScale(2, 4));
        perceptorBean.setValor("MINAS", perceptorBean.getValorAsBigDecimal("AS65").add(perceptorBean.getValorAsBigDecimal("AS75")));
        as65 = null;
        as75 = null;
    }

    private void minimoPorDescendientesMenor25A\u00f1osODiscapacitados(PerceptorBean perceptorBean) {
        ArrayList descendientes = (ArrayList)perceptorBean.getValor("descendientes");
        if (descendientes == null) {
            descendientes = new ArrayList();
        }
        int tamDesc = descendientes.size();
        BigDecimal mindesg = PerceptorBean.CERO;
        BigDecimal mindes3 = PerceptorBean.CERO;
        int i = 0;
        while (i < tamDesc) {
            DescendienteBean d = (DescendienteBean)perceptorBean.getValor("descendientesOrdenados", i);
            int a\u00f1oDesc = d.getAnioNacimiento();
            BigDecimal porEntero = d.isPorEntero() ? PerceptorBean.UNO : PerceptorBean.UNMEDIO;
            switch (i) {
                case 0: {
                    mindesg = mindesg.add(BD2400.multiply(porEntero));
                    break;
                }
                case 1: {
                    mindesg = mindesg.add(BD2700.multiply(porEntero));
                    break;
                }
                case 2: {
                    mindesg = mindesg.add(BD4000.multiply(porEntero));
                    break;
                }
                default: {
                    mindesg = mindesg.add(BD4500.multiply(porEntero));
                }
            }
            int a\u00f1oAdop = d.getAnioAdopcion();
            if (a\u00f1oDesc > 2014) {
                mindes3 = mindes3.add(BD2800.multiply(porEntero));
            } else if (a\u00f1oAdop >= a\u00f1oDesc && a\u00f1oAdop - a\u00f1oDesc < 19 && a\u00f1oAdop > 2014) {
                mindes3 = mindes3.add(BD2800.multiply(porEntero));
            }
            d = null;
            porEntero = null;
            ++i;
        }
        perceptorBean.setValor("MINDESG", mindesg.setScale(2, 4));
        perceptorBean.setValor("MINDES3", mindes3.setScale(2, 4));
        mindesg = null;
        mindes3 = null;
        perceptorBean.setValor("MINDES", perceptorBean.getValorAsBigDecimal("MINDESG").add(perceptorBean.getValorAsBigDecimal("MINDES3")));
    }

    private void minimoDelContribuyente(PerceptorBean perceptorBean) {
        perceptorBean.setValor("MINPER", BD5550);
        long edad = 2017 - (Integer)perceptorBean.getValor("ANOPER");
        if (edad > 64L) {
            perceptorBean.setValor("PER65", BD1150);
        } else {
            perceptorBean.setValor("PER65", PerceptorBean.CERO);
        }
        if (edad > 74L) {
            perceptorBean.setValor("PER75", BD1400);
        } else {
            perceptorBean.setValor("PER75", PerceptorBean.CERO);
        }
        perceptorBean.setValor("MINCON", perceptorBean.getValorAsBigDecimal("MINPER").add(perceptorBean.getValorAsBigDecimal("PER65")).add(perceptorBean.getValorAsBigDecimal("PER75")));
        if (perceptorBean.getValorAsBigDecimal("MINCON").compareTo(BD8100) > 0) {
            perceptorBean.setValor("MINCON", BD8100);
        }
    }

    private void reduccionPorSerDesempleado(PerceptorBean perceptorBean) {
        if ((Integer)perceptorBean.getValor("SITUPER") == 3) {
            perceptorBean.setValor("DESEM", BD1200);
        } else {
            perceptorBean.setValor("DESEM", PerceptorBean.CERO);
        }
    }

    private void reduccionMasDe2Descendientes(PerceptorBean perceptorBean) {
        if ((Integer)perceptorBean.getValor("NUMDES") > 2) {
            perceptorBean.setValor("HIJOS", BD600);
        } else {
            perceptorBean.setValor("HIJOS", PerceptorBean.CERO);
        }
    }

    private void reduccionPensionistaDeLaSSOClasesPasivas(PerceptorBean perceptorBean) {
        if ((Integer)perceptorBean.getValor("SITUPER") == 2) {
            perceptorBean.setValor("PENSION", BD600);
        } else {
            perceptorBean.setValor("PENSION", PerceptorBean.CERO);
        }
    }

    private void calculosGastosDeducibles(PerceptorBean perceptorBean) {
        perceptorBean.setValor("GASTOSGEN", BD2000);
        if (((Boolean)perceptorBean.getValor("MOVIL")).booleanValue()) {
            perceptorBean.setValor("INCREGASMOVIL", BD2000);
        } else {
            perceptorBean.setValor("INCREGASMOVIL", PerceptorBean.CERO);
        }
        if ((Integer)perceptorBean.getValor("SITUPER") == 1) {
            int discaper = (Integer)perceptorBean.getValor("DISCAPER");
            if (discaper == 2 || discaper == 1 && ((Boolean)perceptorBean.getValor("MOVILPER")).booleanValue()) {
                perceptorBean.setValor("INCREGASDISTRA", BD7750);
            } else if (discaper == 1) {
                perceptorBean.setValor("INCREGASDISTRA", BD3500);
            } else {
                perceptorBean.setValor("INCREGASDISTRA", PerceptorBean.CERO);
            }
        } else {
            perceptorBean.setValor("INCREGASDISTRA", PerceptorBean.CERO);
        }
        perceptorBean.setValor("OTROSGASTOS", perceptorBean.getValorAsBigDecimal("GASTOSGEN").add(perceptorBean.getValorAsBigDecimal("INCREGASMOVIL")).add(perceptorBean.getValorAsBigDecimal("INCREGASDISTRA")));
        BigDecimal valor = perceptorBean.getValorAsBigDecimal("RETRIB").subtract(perceptorBean.getValorAsBigDecimal("COTIZACIONES"));
        if (valor.compareTo(PerceptorBean.CERO) < 0) {
            perceptorBean.setValor("OTROSGASTOS", PerceptorBean.CERO);
        } else if (perceptorBean.getValorAsBigDecimal("OTROSGASTOS").compareTo(valor) > 0) {
            perceptorBean.setValor("OTROSGASTOS", valor);
        }
        perceptorBean.setValor("GASTOS", perceptorBean.getValorAsBigDecimal("COTIZACIONES").add(perceptorBean.getValorAsBigDecimal("OTROSGASTOS")));
    }

    private void rendimientoNetoTrabajo(PerceptorBean perceptorBean) {
        perceptorBean.setValor("RNT", PerceptorBean.CERO.max(perceptorBean.getValorAsBigDecimal("RETRIB").subtract(perceptorBean.getValorAsBigDecimal("IRREGULAR1")).subtract(perceptorBean.getValorAsBigDecimal("IRREGULAR2")).subtract(perceptorBean.getValorAsBigDecimal("COTIZACIONES"))));
    }

    private void reduccionPorObtencionDeRendimientosDelTrabajo(PerceptorBean perceptorBean) {
        this.reduccionDeCaracterGeneral(perceptorBean);
    }

    private void reduccionDeCaracterGeneral(PerceptorBean perceptorBean) {
        if (perceptorBean.getValorAsBigDecimal("RNT").compareTo(BD11250) <= 0) {
            perceptorBean.setValor("RED20", BD3700);
        } else if (perceptorBean.getValorAsBigDecimal("RNT").compareTo(BD14450) <= 0) {
            BigDecimal valor = perceptorBean.getValorAsBigDecimal("RNT").subtract(BD11250);
            BigDecimal valor2 = BD115625.multiply(valor);
            BigDecimal red20 = BD3700.subtract(valor2);
            perceptorBean.setValor("RED20", new BigDecimal(red20.setScale(2, 4).toString()));
            valor = null;
            valor2 = null;
            red20 = null;
        } else {
            perceptorBean.setValor("RED20", PerceptorBean.CERO);
        }
    }

    private void rendimientoNetoReducido(PerceptorBean perceptorBean) {
        perceptorBean.setValor("RNTREDU", perceptorBean.getValorAsBigDecimal("RNT").subtract(perceptorBean.getValorAsBigDecimal("OTROSGASTOS")).subtract(perceptorBean.getValorAsBigDecimal("RED20")));
        perceptorBean.setValor("RNTREDU", perceptorBean.getValorAsBigDecimal("RNTREDU").max(PerceptorBean.CERO));
    }

    @Override
    public PerceptorBean createPerceptorBean() {
        return new PerceptorBeanImpl();
    }

    @Override
    public List<ErrorValidacionBean> getErrores(PerceptorBean perceptorBean) {
        return Collections.unmodifiableList(perceptorBean.getErrores());
    }

    private void calculoYComputoDeDescendientes(PerceptorBean perceptorBean) {
        int numDesc = 0;
        int numDes3 = 0;
        int numDes325 = 0;
        int numDes3En = 0;
        int numDes325En = 0;
        int numDesMas3 = 0;
        int numDesMas3En = 0;
        int numDes3365 = 0;
        int numDes3365En = 0;
        int numDescMov = 0;
        int numDes65 = 0;
        int numDes65En = 0;
        int numDescMovEn = 0;
        this.ordenarDescendientes(perceptorBean);
        List descendientesOrdenados = (List)perceptorBean.getValor("descendientesOrdenados");
        String comhijo1 = "";
        String comhijo2 = "";
        String comhijo3 = "";
        int nD = descendientesOrdenados.size();
        int i = 0;
        while (i < nD) {
            DescendienteBean descendiente = (DescendienteBean)descendientesOrdenados.get(i);
            int a\u00f1oDesc = descendiente.getAnioNacimiento();
            int edadDesc = 2017 - a\u00f1oDesc;
            int a\u00f1oAdop = descendiente.getAnioAdopcion();
            BigDecimal porEntero = descendiente.isPorEntero() ? PerceptorBean.UNO : PerceptorBean.UNMEDIO;
            int disca = descendiente.getDiscapacidad();
            ++numDesc;
            if (edadDesc < 3 || a\u00f1oAdop > 2014) {
                ++numDes3;
                if (porEntero.equals(PerceptorBean.UNO)) {
                    ++numDes3En;
                }
            } else if (edadDesc >= 3 && edadDesc < 25 || edadDesc >= 25 && disca != 0) {
                ++numDes325;
                if (porEntero.equals(PerceptorBean.UNO)) {
                    ++numDes325En;
                }
            }
            switch (numDesc) {
                case 1: {
                    comhijo1 = porEntero.equals(PerceptorBean.UNO) ? "Por entero" : "Por mitad";
                    break;
                }
                case 2: {
                    comhijo2 = porEntero.equals(PerceptorBean.UNO) ? "Por entero" : "Por mitad";
                    break;
                }
                case 3: {
                    comhijo3 = porEntero.equals(PerceptorBean.UNO) ? "Por entero" : "Por mitad";
                    break;
                }
                default: {
                    ++numDesMas3;
                    if (!porEntero.equals(PerceptorBean.UNO)) break;
                    ++numDesMas3En;
                }
            }
            if (disca == 1) {
                ++numDes3365;
                if (descendiente.isMovilidadReducida()) {
                    ++numDescMov;
                }
                if (porEntero.equals(PerceptorBean.UNO)) {
                    ++numDes3365En;
                    if (descendiente.isMovilidadReducida()) {
                        ++numDescMovEn;
                    }
                }
            } else if (disca == 2) {
                ++numDes65;
                if (porEntero.equals(PerceptorBean.UNO)) {
                    ++numDes65En;
                }
            }
            descendiente = null;
            porEntero = null;
            ++i;
        }
        perceptorBean.setValor("NUMDES", numDesc);
        perceptorBean.setValor("NUMDES3", numDes3);
        perceptorBean.setValor("NUMDES325", numDes325);
        perceptorBean.setValor("NUMDESMAS3", numDesMas3);
        perceptorBean.setValor("NUMDESMAS3EN", numDesMas3En);
        perceptorBean.setValor("NUMDES325EN", numDes325En);
        perceptorBean.setValor("NUMDES3EN", numDes3En);
        perceptorBean.setValor("NUMDES3365", numDes3365);
        perceptorBean.setValor("NUMDES3365EN", numDes3365En);
        perceptorBean.setValor("NUMDESMOV", numDescMov);
        perceptorBean.setValor("NUMDESMOVEN", numDescMovEn);
        perceptorBean.setValor("NUMDES65", numDes65);
        perceptorBean.setValor("NUMDES65EN", numDes65En);
        perceptorBean.setValor("COMHIJO1", comhijo1);
        perceptorBean.setValor("COMHIJO2", comhijo2);
        perceptorBean.setValor("COMHIJO3", comhijo3);
    }

    private void calculoYComputoDeAscendientes(PerceptorBean perceptorBean) {
        int numAsc = 0;
        int numAs65A = 0;
        int numAs65AEn = 0;
        int numAs75A = 0;
        int numAs75AEn = 0;
        int numAs3365 = 0;
        int numAs3365En = 0;
        int numAs65 = 0;
        int numAs65En = 0;
        int numAsMov = 0;
        int numAsMovEn = 0;
        List ascendientes = (List)perceptorBean.getValor("ascendientes");
        int nD = ascendientes.size();
        int i = 0;
        while (i < nD) {
            AscendienteBean ascendiente = (AscendienteBean)ascendientes.get(i);
            BigDecimal convivencia = new BigDecimal(ascendiente.getConvivencia());
            int edadAs = 2017 - ascendiente.getAnioNacimiento();
            int disca = ascendiente.getDiscapacidad();
            ++numAsc;
            if (edadAs > 74) {
                ++numAs75A;
                if (convivencia.intValue() == 1) {
                    ++numAs75AEn;
                }
            } else if (edadAs <= 74 && edadAs > 64 || edadAs <= 64 && disca != 0) {
                ++numAs65A;
                if (convivencia.intValue() == 1) {
                    ++numAs65AEn;
                }
            }
            if (disca == 1) {
                ++numAs3365;
                if (convivencia.intValue() == 1) {
                    ++numAs3365En;
                }
                if (ascendiente.isMovilidadReducida()) {
                    ++numAsMov;
                    if (convivencia.intValue() == 1) {
                        ++numAsMovEn;
                    }
                }
            } else if (disca == 2) {
                ++numAs65;
                if (convivencia.intValue() == 1) {
                    ++numAs65En;
                }
            }
            ascendiente = null;
            convivencia = null;
            ++i;
        }
        perceptorBean.setValor("NUMAS", numAsc);
        perceptorBean.setValor("NUMAS65A", numAs65A);
        perceptorBean.setValor("NUMAS65AEN", numAs65AEn);
        perceptorBean.setValor("NUMAS75A", numAs75A);
        perceptorBean.setValor("NUMAS75AEN", numAs75AEn);
        perceptorBean.setValor("NUMAS3365", numAs3365);
        perceptorBean.setValor("NUMAS3365EN", numAs3365En);
        perceptorBean.setValor("NUMAS65", numAs65);
        perceptorBean.setValor("NUMAS65EN", numAs65En);
        perceptorBean.setValor("NUMASMOV", numAsMov);
        perceptorBean.setValor("NUMASMOVEN", numAsMovEn);
    }

    private void setRegularizacion(PerceptorBean perceptorBean) {
        boolean[] causa = (boolean[])perceptorBean.getValor("CAUSA");
        boolean regularizacion = false;
        int i = 1;
        while (i < causa.length) {
            if (((Boolean)perceptorBean.getValor("CAUSA", i)).booleanValue()) {
                regularizacion = true;
                break;
            }
            ++i;
        }
        perceptorBean.setValor("REGULARIZACION", regularizacion);
    }

    private boolean validaNifMayus(String nif) {
        int length = nif.length();
        int i = 0;
        while (i < length) {
            if (VALIDOSNIF.indexOf(nif.charAt(i)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean validaNombrePerceptor(String nombre, int resul) {
        return ValidaNif.validaNombre(resul, nombre);
    }

    protected void ordenarDescendientes(PerceptorBean perceptorBean) {
        List descendientes = (List)perceptorBean.getValor("descendientes");
        List descendientesOrdenados = (List)perceptorBean.getValor("descendientesOrdenados");
        descendientesOrdenados.clear();
        descendientesOrdenados.addAll(Collections.nCopies(descendientes.size(), perceptorBean.createDescendienteBean()));
        Collections.copy(descendientesOrdenados, descendientes);
        Collections.sort(descendientesOrdenados, new Comparator<DescendienteBean>(){

            @Override
            public int compare(DescendienteBean o1, DescendienteBean o2) {
                return o1.getAnioNacimiento() - o2.getAnioNacimiento();
            }
        });
        perceptorBean.setValor("descendientesOrdenados", descendientesOrdenados);
    }

    @Override
    public boolean avisoMonoparental(PerceptorBean perceptorBean) {
        List descendientes = (List)perceptorBean.getValor("descendientes");
        int nD = descendientes.size();
        int i = 0;
        while (i < nD) {
            DescendienteBean d = (DescendienteBean)descendientes.get(i);
            int a\u00f1oDesc = d.getAnioNacimiento();
            int disca = d.getDiscapacidad();
            if (a\u00f1oDesc > 1999) {
                return false;
            }
            if (a\u00f1oDesc <= 1999 && disca == 2) {
                return false;
            }
            d = null;
            ++i;
        }
        return true;
    }

    @Override
    public boolean avisoTipoA(PerceptorBean perceptorBean) {
        if (!((Boolean)perceptorBean.getValor("REGULARIZACION")).booleanValue()) {
            return false;
        }
        boolean[] causa = (boolean[])perceptorBean.getValor("CAUSA");
        if (causa[9] || causa[11] || causa[10]) {
            return false;
        }
        BigDecimal tipoACalculado = perceptorBean.getValorAsBigDecimal("RETENIDO").divide(perceptorBean.getValorAsBigDecimal("PERCIBIDO"), 10, 4).setScale(2, 1);
        BigDecimal diferencia = perceptorBean.getValorAsBigDecimal("TIPOA").subtract(tipoACalculado).abs();
        int resultado = PerceptorBean.MARGEN_ERROR_TIPO.compareTo(diferencia);
        diferencia = null;
        tipoACalculado = null;
        if (resultado == 0) {
            return false;
        }
        return resultado <= 0;
    }

    @Override
    public boolean avisosBaseA(PerceptorBean perceptorBean) {
        if (!((Boolean)perceptorBean.getValor("REGULARIZACION")).booleanValue()) {
            return false;
        }
        boolean[] causa = (boolean[])perceptorBean.getValor("CAUSA");
        return !causa[11] && !causa[10] && !causa[9] && perceptorBean.getValorAsBigDecimal("BASEA").equals(PerceptorBean.CERO);
    }

    @Override
    public boolean avisosRetribA(PerceptorBean perceptorBean) {
        return (Boolean)perceptorBean.getValor("REGULARIZACION") != false && (Boolean)perceptorBean.getValor("CAUSA", 11) != false && perceptorBean.getValorAsBigDecimal("RETRIB").compareTo(perceptorBean.getValorAsBigDecimal("PERCIBIDO")) < 0;
    }

    @Override
    public boolean validarPostCalculos(PerceptorBean perceptorBean) {
        boolean[] causa = (boolean[])perceptorBean.getValor("CAUSA");
        if (causa[1] && perceptorBean.getValorAsBigDecimal("BASE").compareTo(perceptorBean.getValorAsBigDecimal("BASEA")) == 0) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9083", "De los datos introducidos no se desprende que se hayan producido variaciones en la base para determinar el tipo de retenci\u00f3n, lo cual es incompatible con la causa de regularizaci\u00f3n consignada.", "BASEA", -1));
        }
        if (causa[2] && perceptorBean.getValorAsBigDecimal("MINPERFA").compareTo(perceptorBean.getValorAsBigDecimal("MINPERFAA")) == 0) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9084", "De los datos introducidos no se desprende que se hayan producido variaciones en el m\u00ednimo personal y familiar para determinar el tipo de retenci\u00f3n, lo cual es incompatible con la causa de regularizaci\u00f3n consignada.", "MINPERFAA", -1));
        }
        if (((Boolean)perceptorBean.getValor("REGULARIZACION")).booleanValue() && !perceptorBean.getValorAsBigDecimal("MINOPAGOA").equals(PerceptorBean.CERO) && perceptorBean.getValorAsBigDecimal("MINOPAGO").compareTo(PerceptorBean.CERO) < 0) {
            perceptorBean.addError(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9085", "La cantidad consignada en importe de la minoraci\u00f3n por pagos de pr\u00e9stamos para la vivienda determinado antes de la regularizaci\u00f3n es incorrecta.", "MINOPAGOA", -1));
        }
        return perceptorBean.isCorrecto();
    }

    @Override
    public String getVersion() {
        Properties prop = new Properties();
        try {
            prop.load(this.getClass().getResourceAsStream("/WEB-INF/modelo.properties"));
        }
        catch (IOException e) {
            ADHT_JDIT_Factory.getContextoSrv().getLog().warning(e.getMessage());
        }
        return prop.getProperty("version.mc");
    }

    @Override
    public PerceptorBean createPerceptorBeanFromJson(String perceptorJson) {
        class DescendienteAdapter
        extends TypeAdapter<DescendienteBean> {
            DescendienteAdapter() {
            }

            public DescendienteBean read(JsonReader reader) throws IOException {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                int anioNacimiento = 0;
                int anioAdopcion = 0;
                boolean porEntero = false;
                int discapacidad = 0;
                boolean movilidadReducida = false;
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if (name.equals("anioNacimiento")) {
                        anioNacimiento = reader.nextInt();
                        continue;
                    }
                    if (name.equals("anioAdopcion")) {
                        anioAdopcion = reader.nextInt();
                        continue;
                    }
                    if (name.equals("porEntero")) {
                        porEntero = reader.nextBoolean();
                        continue;
                    }
                    if (name.equals("discapacidad")) {
                        discapacidad = reader.nextInt();
                        continue;
                    }
                    if (name.equals("movilidadReducida")) {
                        movilidadReducida = reader.nextBoolean();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                return new DescendienteBeanImpl(anioNacimiento, anioAdopcion, porEntero, discapacidad, movilidadReducida);
            }

            public void write(JsonWriter arg0, DescendienteBean arg1) throws IOException {
            }
        }
        class AscendienteAdapter
        extends TypeAdapter<AscendienteBean> {
            AscendienteAdapter() {
            }

            public AscendienteBean read(JsonReader reader) throws IOException {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                int anioNacimiento = 0;
                int convivencia = 0;
                int discapacidad = 0;
                boolean movilidadReducida = false;
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if (name.equals("anioNacimiento")) {
                        anioNacimiento = reader.nextInt();
                        continue;
                    }
                    if (name.equals("convivencia")) {
                        convivencia = reader.nextInt();
                        continue;
                    }
                    if (name.equals("discapacidad")) {
                        discapacidad = reader.nextInt();
                        continue;
                    }
                    if (name.equals("movilidadReducida")) {
                        movilidadReducida = reader.nextBoolean();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                return new AscendienteBeanImpl(anioNacimiento, convivencia, discapacidad, movilidadReducida);
            }

            public void write(JsonWriter arg0, AscendienteBean arg1) throws IOException {
            }
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(DescendienteBean.class, (Object)new DescendienteAdapter()).registerTypeAdapter(AscendienteBean.class, (Object)new AscendienteAdapter()).create();
        PerceptorBean bean = (PerceptorBean)gson.fromJson(perceptorJson, PerceptorBeanImpl.class);
        return bean;
    }
}

