/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c170.imp.srv;

import es.aeat.pret.c170.api.bean.PerceptorBean;
import es.aeat.pret.c170.api.srv.CalculoRetencionesSrv;
import es.aeat.pret.c170.api.srv.ValidarLeerFicheroSrv;
import es.aeat.pret.c170.util.Sello;
import es.aeat.pret.c170.util.StaxEscribirError;
import es.aeat.pret.c170.util.StaxEscribirFichero;
import es.aeat.pret.c170.util.StaxLeerRetenedor;
import es.aeat.pret.c170.util.StaxLeerRetenido;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.bind.ValidationEvent;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidarLeerFicheroSrvImpl
implements ValidarLeerFicheroSrv {
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private File ficheroSalida = null;
    private File ficheroError = null;
    private StaxEscribirFichero stax = null;
    private StaxEscribirError staxE = null;
    private boolean tenemosError = false;
    private boolean errorImportacion = false;
    private int erroresImportacion = 0;
    private Validator validator = null;
    private boolean comprobandoSalida = false;
    private StaxLeerRetenido staxReti = null;
    private StaxLeerRetenedor staxReto = null;
    private int numRetenidos;
    private int nuneroRetenedorese;
    private int[] cuantosRetenidos;
    private String nombreFicheroEntrada;

    @Override
    public void crearValidadorXML(String salida, String errores, Schema schema) {
        try {
            this.ficheroSalida = File.createTempFile("r170", salida);
            this.ficheroError = File.createTempFile("r170", errores);
            System.out.println("CREAMOS FICHEROS " + this.ficheroSalida.getAbsolutePath() + " " + this.ficheroError.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.ficheroSalida.exists()) {
            this.ficheroSalida.delete();
        }
        if (this.ficheroError.exists()) {
            this.ficheroError.delete();
        }
        this.validator = schema.newValidator();
        this.validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void fatalError(SAXParseException arg0) throws SAXException {
                if (ValidarLeerFicheroSrvImpl.this.comprobandoSalida && arg0.getMessage().startsWith("cvc-elt.1")) {
                    ValidarLeerFicheroSrvImpl.this.errorImportacion = true;
                } else {
                    if (ValidarLeerFicheroSrvImpl.this.staxE == null) {
                        ValidarLeerFicheroSrvImpl.this.staxE = new StaxEscribirError();
                        ValidarLeerFicheroSrvImpl.this.staxE.startDocument(ValidarLeerFicheroSrvImpl.this.ficheroError);
                    }
                    ValidarLeerFicheroSrvImpl.this.staxE.escribirErrorGeneral(arg0);
                    ValidarLeerFicheroSrvImpl.this.errorImportacion = true;
                    ValidarLeerFicheroSrvImpl validarLeerFicheroSrvImpl = ValidarLeerFicheroSrvImpl.this;
                    validarLeerFicheroSrvImpl.erroresImportacion = validarLeerFicheroSrvImpl.erroresImportacion + 1;
                    ValidarLeerFicheroSrvImpl.this.terminaFicheroStax();
                }
            }

            @Override
            public void error(SAXParseException arg0) throws SAXException {
                if (ValidarLeerFicheroSrvImpl.this.comprobandoSalida && arg0.getMessage().startsWith("cvc-elt.1")) {
                    ValidarLeerFicheroSrvImpl.this.errorImportacion = true;
                } else {
                    if (ValidarLeerFicheroSrvImpl.this.staxE == null) {
                        ValidarLeerFicheroSrvImpl.this.staxE = new StaxEscribirError();
                        ValidarLeerFicheroSrvImpl.this.staxE.startDocument(ValidarLeerFicheroSrvImpl.this.ficheroError);
                    }
                    ValidarLeerFicheroSrvImpl.this.staxE.escribirErrorGeneral(arg0);
                    ValidarLeerFicheroSrvImpl.this.errorImportacion = true;
                    ValidarLeerFicheroSrvImpl validarLeerFicheroSrvImpl = ValidarLeerFicheroSrvImpl.this;
                    validarLeerFicheroSrvImpl.erroresImportacion = validarLeerFicheroSrvImpl.erroresImportacion + 1;
                    ValidarLeerFicheroSrvImpl.this.terminaFicheroStax();
                }
            }

            @Override
            public void warning(SAXParseException arg0) throws SAXException {
            }
        });
    }

    public void terminaFicheroStax() {
        if (this.stax != null && !this.stax.isTerminado()) {
            this.stax.endDocument();
            this.stax = null;
        }
    }

    public void terminaFicheroStaxError() {
        if (this.staxE != null && !this.staxE.isTerminado()) {
            this.staxE.endDocument();
            this.staxE = null;
        }
    }

    protected void crearErrorGeneral(ValidationEvent event2) {
        if (this.staxE == null) {
            this.staxE = new StaxEscribirError();
            this.staxE.startDocument(this.ficheroError);
        }
        this.staxE.escribirErrorImportacion(event2.getLocator().getLineNumber(), event2.getLocator().getColumnNumber(), event2.getMessage());
        this.terminaFicheroStax();
        this.errorImportacion = true;
    }

    @Override
    public boolean validaXmlSalidaStax(String ficheroXMLEntrada) throws SAXException {
        Schema schema = null;
        SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        URL resource = this.getClass().getClassLoader().getResource("es/aeat/pret/c170/xml/xsd/AEATRetenciones2017S.xsd");
        schema = sf.newSchema(resource);
        this.errorImportacion = false;
        this.erroresImportacion = 0;
        this.nombreFicheroEntrada = ficheroXMLEntrada;
        this.crearValidadorXML("SRET2017.xml", "ERR2017.xml", schema);
        return this.xmlCorrectoSalidaStax();
    }

    @Override
    public boolean validaXmlEntradaStax(String ficheroXMLEntrada) throws SAXException {
        Schema schema = null;
        SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        URL resource = this.getClass().getClassLoader().getResource("es/aeat/pret/c170/xml/xsd/AEATRetenciones2017E.xsd");
        schema = sf.newSchema(resource);
        this.nombreFicheroEntrada = ficheroXMLEntrada;
        if (this.erroresImportacion > 0) {
            this.terminaFicheroStaxError();
            return false;
        }
        this.comprobandoSalida = false;
        this.errorImportacion = false;
        this.erroresImportacion = 0;
        this.crearValidadorXML("SRET2017.xml", "ERR2017.xml", schema);
        return this.xmlCorrectoEntradaStax(false);
    }

    @Override
    public void validaXmlEntradaParaCalculos(String ficheroXMLEntrada) {
        try {
            Schema schema = null;
            SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);
            URL resource = this.getClass().getClassLoader().getResource("es/aeat/pret/c170/xml/xsd/AEATRetenciones2017E.xsd");
            schema = sf.newSchema(resource);
            this.numRetenidos = 0;
            this.nuneroRetenedorese = 0;
            this.nombreFicheroEntrada = ficheroXMLEntrada;
            StringBuffer fileNameSalida = new StringBuffer("SRET2017-");
            StringBuffer fileNameErr = new StringBuffer("ERR2017-");
            SimpleDateFormat formatFileName = new SimpleDateFormat("yyyyMMdd-HHmmss");
            String date = formatFileName.format(new Date());
            fileNameSalida.append(date);
            fileNameErr.append(date);
            fileNameSalida.append(".xml");
            fileNameErr.append(".xml");
            this.crearValidadorXML(fileNameSalida.toString(), fileNameErr.toString(), schema);
            fileNameSalida = null;
            fileNameErr = null;
            if (this.xmlCorrectoEntradaStax(true)) {
                FileInputStream fisReto = null;
                FileInputStream fisReti = null;
                try {
                    fisReto = new FileInputStream(new File(this.nombreFicheroEntrada));
                    this.prepararReaderRetenedor(fisReto, null, false, false);
                    this.nuneroRetenedorese = this.leeRetenedor(0).size();
                    this.cuantosRetenidos = new int[this.nuneroRetenedorese];
                    fisReto.close();
                    fisReto = null;
                    this.cerrarReaderRetenedor();
                    fisReti = new FileInputStream(new File(this.nombreFicheroEntrada));
                    this.prepararReaderRetenido(fisReti, null, false, false);
                    int totalRetenidos = 0;
                    int numReti = 0;
                    int i = 0;
                    while (i < this.nuneroRetenedorese) {
                        numReti = this.leeRetenido(i, 0).size();
                        totalRetenidos += numReti;
                        this.cuantosRetenidos[i] = numReti;
                        ++i;
                    }
                    this.numRetenidos = totalRetenidos;
                    fisReti.close();
                    fisReti = null;
                    this.cerrarReaderRetenido();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (this.tenemosError) {
                this.numRetenidos = 0;
                this.nuneroRetenedorese = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void cerrarReaderRetenedor() {
        if (this.staxReto != null) {
            this.staxReto.cerrarReader();
            this.staxReto = null;
        }
    }

    @Override
    public void cerrarReaderRetenido() {
        if (this.staxReti != null) {
            this.staxReti.cerrarReader();
            this.staxReti = null;
        }
    }

    @Override
    public ArrayList<String> leeRetenido(int indiceRetenedor, int indiceRetenido) {
        try {
            this.staxReti.readXml(indiceRetenedor, indiceRetenido);
            if (this.staxReti.getLista() != null) {
                return this.staxReti.getLista();
            }
            return null;
        }
        catch (XMLStreamException e) {
            if (this.staxE == null) {
                this.staxE = new StaxEscribirError();
                this.staxE.startDocument(this.ficheroError);
            }
            this.staxE.escribirErrorImportacion(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e.getMessage());
            this.tenemosError = true;
            return null;
        }
    }

    @Override
    public ArrayList<String> leeRetenedor(int indiceRetenedor) {
        try {
            this.staxReto.readXml(indiceRetenedor);
            if (this.staxReto.getLista() != null) {
                return this.staxReto.getLista();
            }
            return null;
        }
        catch (XMLStreamException e) {
            if (this.staxE == null) {
                this.staxE = new StaxEscribirError();
                this.staxE.startDocument(this.ficheroError);
            }
            this.staxE.escribirErrorImportacion(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e.getMessage());
            this.tenemosError = true;
            return null;
        }
    }

    @Override
    public void prepararReaderRetenido(FileInputStream fisReti, PerceptorBean modelo, boolean importarXML, boolean buscarRetenido) {
        try {
            if (this.staxReti == null) {
                this.staxReti = new StaxLeerRetenido();
            }
            this.staxReti.crearXMLReader(fisReti, modelo, importarXML, buscarRetenido);
            this.staxReti.preparamosLectura();
        }
        catch (XMLStreamException e) {
            if (this.staxE == null) {
                this.staxE = new StaxEscribirError();
                this.staxE.startDocument(this.ficheroError);
            }
            this.staxE.escribirErrorImportacion(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e.getMessage());
            this.tenemosError = true;
        }
    }

    @Override
    public void prepararReaderRetenedor(FileInputStream fisReto, PerceptorBean modelo, boolean importarXML, boolean buscarRetenedor) {
        try {
            if (this.staxReto == null) {
                this.staxReto = new StaxLeerRetenedor();
            }
            this.staxReto.crearXMLReader(fisReto, modelo, importarXML, buscarRetenedor);
            this.staxReto.preparamosLectura();
        }
        catch (XMLStreamException e) {
            if (this.staxE == null) {
                this.staxE = new StaxEscribirError();
                this.staxE.startDocument(this.ficheroError);
            }
            this.staxE.escribirErrorImportacion(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e.getMessage());
            this.tenemosError = true;
        }
    }

    @Override
    public boolean xmlCorrectoEntradaStax(boolean calculo) {
        InputStream ruta;
        block8: {
            ruta = null;
            ruta = this.nombreFicheroEntrada.endsWith(".tmp") ? new FileInputStream(new File(this.nombreFicheroEntrada)) : new ByteArrayInputStream(this.nombreFicheroEntrada.getBytes());
            this.validaXML((FileInputStream)ruta);
            if (!this.errorImportacion) break block8;
            ruta.close();
            this.terminaFicheroStaxError();
            ruta = null;
            return false;
        }
        try {
            ruta.close();
            ruta = null;
        }
        catch (FileNotFoundException e) {
            System.out.println("No esiste fichero entrada: " + e.getMessage());
            this.tenemosError = true;
            try {
                ruta.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ruta = null;
            return false;
        }
        catch (IOException e) {
            System.out.println("IO EXCEPTION 2");
            e.printStackTrace();
            this.tenemosError = true;
            try {
                ruta.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ruta = null;
            return false;
        }
        this.terminaFicheroStaxError();
        return true;
    }

    @Override
    public boolean xmlCorrectoSalidaStax() {
        InputStream ruta;
        block8: {
            this.comprobandoSalida = true;
            ruta = null;
            ruta = this.nombreFicheroEntrada.endsWith(".tmp") ? new FileInputStream(new File(this.nombreFicheroEntrada)) : new ByteArrayInputStream(this.nombreFicheroEntrada.getBytes());
            this.validaXML((FileInputStream)ruta);
            this.comprobandoSalida = false;
            if (!this.errorImportacion) break block8;
            ruta.close();
            ruta = null;
            return false;
        }
        try {
            ruta.close();
            ruta = null;
        }
        catch (FileNotFoundException e) {
            System.out.println("No esiste fichero entrada: " + e.getMessage());
            this.comprobandoSalida = false;
            this.tenemosError = true;
            try {
                ruta.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ruta = null;
            return false;
        }
        catch (IOException e) {
            System.out.println("IO EXCEPTION 4");
            e.printStackTrace();
            this.tenemosError = true;
            try {
                ruta.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ruta = null;
            return false;
        }
        this.terminaFicheroStaxError();
        return true;
    }

    @Override
    public void validaXML(InputStream fis) throws IOException {
        try {
            this.validator.validate(new SAXSource(new InputSource(fis)));
        }
        catch (SAXException e) {
            System.out.println("EXCEPTION EN VALIDAXML");
        }
    }

    @Override
    public File salidaXML(boolean errorPerceptor) {
        if (!(this.tenemosError || this.errorImportacion || errorPerceptor)) {
            if (this.ficheroError != null && this.ficheroError.exists()) {
                System.out.println("BORRAMOS " + this.ficheroError.getAbsolutePath() + " " + this.ficheroError.delete());
                this.ficheroError.delete();
            }
            return this.ficheroSalida;
        }
        if (this.ficheroSalida.exists()) {
            System.out.println("BORRAMOS " + this.ficheroSalida.getAbsolutePath() + " " + this.ficheroSalida.delete());
            this.ficheroSalida.delete();
        }
        return this.ficheroError;
    }

    @Override
    public boolean isOk() {
        if (!this.tenemosError && !this.errorImportacion) {
            return true;
        }
        if (this.staxE != null) {
            this.terminaFicheroStaxError();
        }
        return false;
    }

    @Override
    public void generarXML(String nifRetenedor, String nombreRetenedor, String nombreRetenido, PerceptorBean modelo) {
        modelo.setValor("APEPER", nombreRetenido);
        modelo.setValor("NIFRET", nifRetenedor);
        modelo.setValor("APERET", nombreRetenedor);
        try {
            this.ficheroSalida = File.createTempFile("genXMLr170", "SRET2017.xml");
            System.out.println("GENERARXML " + this.ficheroSalida.getAbsolutePath());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (this.ficheroSalida.exists()) {
            this.ficheroSalida.delete();
        }
        this.stax = new StaxEscribirFichero();
        this.stax.startDocument(modelo, this.ficheroSalida);
        this.stax.startRetenedor();
        this.stax.escribirRetenido();
        this.stax.endRetenedor();
        this.stax.endDocument();
        this.ponerSello();
        this.stax = null;
    }

    @Override
    public void ponerSello() {
        try {
            FileInputStream fis = new FileInputStream(this.ficheroSalida);
            String sello = this.crearSello(fis);
            fis.close();
            fis = null;
            RandomAccessFile raf = new RandomAccessFile(this.ficheroSalida, "rw");
            int primero = raf.readLine().length();
            int indexLine = raf.readLine().indexOf("Sello=");
            raf.seek(indexLine += "Sello=".length() + primero);
            byte[] c1 = new byte[1];
            String s = null;
            do {
                raf.read(c1, 0, 1);
            } while (!(s = new String(c1)).equals("\""));
            raf.write(sello.getBytes());
            raf.close();
            raf = null;
            Object var2_3 = null;
        }
        catch (Exception e1) {
            System.out.println(e1.toString());
        }
    }

    public String crearSello(InputStream bys) throws IOException {
        int leidos;
        byte[] datos = new byte[5120];
        Sello sello = new Sello();
        while ((leidos = bys.read(datos)) != -1) {
            sello.update(datos, 0, leidos);
        }
        datos = null;
        String cad = sello.sellar();
        cad = String.valueOf(cad) + "M";
        sello = null;
        return cad;
    }

    @Override
    public void empiezaDocumento(PerceptorBean modelo) {
        try {
            this.ficheroSalida = File.createTempFile("genXMLr170", "SRET2017.xml");
            System.out.println("EMPIEZA DOCUMENTO " + this.ficheroSalida.getAbsolutePath());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (this.ficheroSalida.exists()) {
            this.ficheroSalida.delete();
        }
        this.stax = new StaxEscribirFichero();
        this.stax.startDocument(modelo, this.ficheroSalida);
    }

    @Override
    public void terminarDocumento() {
        this.stax.endDocument();
    }

    @Override
    public void empiezaRetenedor() {
        this.stax.startRetenedor();
    }

    @Override
    public void terminaRetenedor() {
        this.stax.endRetenedor();
    }

    @Override
    public void empiezaRetenido() {
        this.stax.escribirRetenido();
    }

    @Override
    public void empiezaDocumentoError() {
        if (this.ficheroSalida.exists()) {
            if (this.stax != null) {
                this.stax.endDocument();
                this.stax = null;
            }
            this.ficheroSalida.delete();
        }
        if (this.staxE == null) {
            try {
                this.ficheroError = File.createTempFile("genXMLr170", "ERR2017.xml");
                System.out.println("EMPIEZA DOCUMENTO ERROR " + this.ficheroError.getAbsolutePath());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (this.ficheroError.exists()) {
                this.ficheroError.delete();
            }
            this.staxE = new StaxEscribirError();
            this.staxE.startDocument(this.ficheroError);
        }
    }

    @Override
    public void crearFicheroErrorRetenidoSTAX(CalculoRetencionesSrv calculo, PerceptorBean modelo, int ordenRetenedor, int ordenRetenido) {
        if (this.staxE == null) {
            this.staxE = new StaxEscribirError();
            this.staxE.startDocument(this.ficheroError);
        }
        if (!this.staxE.isEmpezadoErrorNormal()) {
            this.staxE.empiezaErrorNormal();
        }
        if (!this.staxE.isEmpezadoRetenedor()) {
            this.staxE.empiezaErrorRetenedor((String)modelo.getValor("NIFRET"), ordenRetenedor + 1);
        }
        this.staxE.errorRetenido(calculo.getErrores(modelo), (String)modelo.getValor("NIFPER"), ordenRetenido + 1);
    }

    @Override
    public void terminarDocumentoError() {
        if (this.staxE != null) {
            this.staxE.endDocument();
        }
    }

    @Override
    public void terminaRetenedorError() {
        if (this.staxE != null) {
            this.staxE.endErrorRetenedor();
        }
    }

    @Override
    public void inicializaValidador() {
        this.stax = null;
        this.staxE = null;
        this.tenemosError = false;
        this.errorImportacion = false;
        this.erroresImportacion = 0;
        this.comprobandoSalida = false;
        this.staxReti = null;
        this.staxReto = null;
        this.ficheroSalida = null;
        this.ficheroError = null;
        this.validator = null;
        this.numRetenidos = 0;
        this.nuneroRetenedorese = 0;
        this.cuantosRetenidos = null;
        this.nombreFicheroEntrada = null;
    }

    @Override
    public int[] getListaRetenidos() {
        return this.cuantosRetenidos;
    }

    @Override
    public int getNumeroRetenedoresTotal() {
        return this.nuneroRetenedorese;
    }

    @Override
    public int getNumeroRetenidosTotal() {
        return this.numRetenidos;
    }
}

