/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c170.mc;

import es.aeat.pret.c170.mc.AnalizarLineaComandoException;
import es.aeat.pret.c170.mc.Parametro;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class AnalizarLineaComandos {
    private static final String NUM_ERROR1 = "0001";
    private static final String TEXTO_ERROR1 = " Error en el formato de par\u00e1metro";
    private static final String NUM_ERROR2 = "0002";
    private static final String TEXTO_ERROR2 = " Error, este nombre de par\u00e1metro no existe";
    private static final String NUM_ERROR3 = "0003";
    private static final String TEXTO_ERROR3 = " Error, Tiene un par\u00e1metro con valor obligatorio";
    private static final String NUM_ERROR4 = "0004";
    private static final String NUM_ERROR5 = "0005";
    private static final String TEXTO_ERROR4 = " Error, Tiene un par\u00e1metro con valor \u00fanico";
    private static final String TEXTO_ERROR5 = " Error, Valor no permitido";
    private Collection listaParametros = new ArrayList();
    private StringBuffer sParametro;

    public void setParametro(String _nombres, boolean _obligatorio, String _valorDefecto, boolean _valorUnico, String[] _valores) {
        Parametro miParam = new Parametro();
        if (_nombres == null) {
            miParam.setNombre(_nombres);
        } else {
            miParam.setNombre(_nombres.toUpperCase());
        }
        miParam.setObligatorio(_obligatorio);
        miParam.setValorDefecto(_valorDefecto);
        miParam.setValorUnico(_valorUnico);
        miParam.setValores(_valores);
        this.listaParametros.add(miParam);
    }

    public void setParametro(String _nombres, boolean _obligatorio, String _valorDefecto, boolean _valorUnico) {
        Parametro miParam = new Parametro();
        if (_nombres == null) {
            miParam.setNombre(_nombres);
        } else {
            miParam.setNombre(_nombres.toUpperCase());
        }
        miParam.setObligatorio(_obligatorio);
        miParam.setValorDefecto(_valorDefecto);
        miParam.setValorUnico(_valorUnico);
        this.listaParametros.add(miParam);
    }

    public String getParametro(String _nombre) throws AnalizarLineaComandoException {
        for (Parametro paramAux : this.listaParametros) {
            if (!paramAux.getNombre().equals(_nombre)) continue;
            if (paramAux.getValorParametro() == null || paramAux.getValorParametro() == "") {
                if (paramAux.getValorDefecto() == null || paramAux.getValorDefecto() == "") {
                    throw new AnalizarLineaComandoException("ERROR");
                }
                return paramAux.getValorDefecto();
            }
            return paramAux.getValorParametro();
        }
        throw new AnalizarLineaComandoException("ERROR");
    }

    public void parse(String[] _lineaComando) throws AnalizarLineaComandoException {
        int i = 0;
        while (i < _lineaComando.length) {
            if (!this.validaFormatoParametro(_lineaComando[i])) {
                throw new AnalizarLineaComandoException(this.generaMensaje(NUM_ERROR1, _lineaComando[i], TEXTO_ERROR1).toString());
            }
            if (!this.validaNombreParametro(_lineaComando[i])) {
                throw new AnalizarLineaComandoException(this.generaMensaje(NUM_ERROR2, _lineaComando[i].substring(0, 3), TEXTO_ERROR2).toString());
            }
            ++i;
        }
        if (!this.validaValorObligatorio()) {
            throw new AnalizarLineaComandoException(this.generaMensaje(NUM_ERROR3, this.sParametro.toString(), TEXTO_ERROR3).toString());
        }
        if (!this.validaValorUnico()) {
            throw new AnalizarLineaComandoException(this.generaMensaje(NUM_ERROR4, this.sParametro.toString(), TEXTO_ERROR4).toString());
        }
        Parametro mal = this.validaValoresPermitidos();
        if (mal != null) {
            throw new AnalizarLineaComandoException(this.generaMensaje(NUM_ERROR5, "/" + mal.getNombre() + ":", TEXTO_ERROR5).toString());
        }
    }

    private StringBuffer generaMensaje(String sNumero, String _lineaComando, String sTexto) {
        StringBuffer mesError = new StringBuffer();
        mesError.append(sNumero);
        if (_lineaComando != null) {
            mesError.append(" ");
            mesError.append(_lineaComando);
        }
        mesError.append(sTexto);
        return mesError;
    }

    private boolean validaFormatoParametro(String _parametro) {
        if (_parametro.charAt(0) != '/') {
            return false;
        }
        int pos = _parametro.indexOf(":");
        if (pos == -1) {
            return false;
        }
        if (pos != 2) {
            return false;
        }
        return _parametro.length() > 3;
    }

    private boolean validaNombreParametro(String _parametro) {
        int pos = _parametro.indexOf(":");
        String sAux = _parametro;
        String letra = sAux.substring(--pos, pos + 1);
        for (Parametro paramAux : this.listaParametros) {
            if (!paramAux.getNombre().equals(letra.toUpperCase())) continue;
            paramAux.setValorParametro(sAux.substring(pos += 2, _parametro.length()));
            return true;
        }
        return false;
    }

    private boolean validaValorObligatorio() {
        for (Parametro paramAux : this.listaParametros) {
            this.sParametro = new StringBuffer(4);
            this.sParametro.append('/');
            this.sParametro.append(paramAux.getNombre());
            this.sParametro.append(':');
            if (!(paramAux.isObligatorio() ? paramAux.getValorParametro() == null || paramAux.getValorParametro().equals("") : !(paramAux.getValorParametro() != null && !paramAux.getValorParametro().equals("") || paramAux.getValorDefecto() != null && !paramAux.getValorDefecto().equals("")))) continue;
            return false;
        }
        return true;
    }

    private Parametro validaValoresPermitidos() {
        for (Parametro paramAux : this.listaParametros) {
            if (paramAux.validaValores()) continue;
            return paramAux;
        }
        return null;
    }

    private boolean validaValorUnico() {
        Iterator it = this.listaParametros.iterator();
        int i = 0;
        while (it.hasNext()) {
            Parametro paramAux = (Parametro)it.next();
            this.sParametro = new StringBuffer(4);
            this.sParametro.append('/');
            this.sParametro.append(paramAux.getNombre());
            this.sParametro.append(':');
            if (paramAux.isValorUnico()) {
                String cadAux = new String();
                if (paramAux.getValorParametro() == null || paramAux.getValorParametro().equals("")) {
                    if (paramAux.getValorDefecto() == null || paramAux.getValorDefecto().equals("")) {
                        return false;
                    }
                    cadAux = paramAux.getValorDefecto();
                } else {
                    cadAux = paramAux.getValorParametro();
                }
                if (this.buscaValorRepetido(i, cadAux)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean buscaValorRepetido(int actual, String cadena) {
        Iterator it = this.listaParametros.iterator();
        int j = 0;
        while (it.hasNext()) {
            Parametro paramAux = (Parametro)it.next();
            if (actual != j && (paramAux.getValorParametro() == null || paramAux.getValorParametro().equals("") ? paramAux.getValorDefecto().equals(cadena) : paramAux.getValorParametro().equals(cadena))) {
                return true;
            }
            ++j;
        }
        return false;
    }
}

