/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c180.imp.srv;

import es.aeat.adht.jdit.api.ADHT_JDIT_Factory;
import es.aeat.pret.c180.api.bean.ErrorValidacionBean;
import es.aeat.pret.c180.api.bean.PerceptorBean;
import es.aeat.pret.c180.api.srv.CalculoRetencionesSrv;
import es.aeat.pret.c180.api.srv.ValidarLeerFicheroSrv;
import es.aeat.pret.c180.imp.bean.PerceptorBeanImpl;
import es.aeat.pret.c180.util.EscribirFicheroError;
import es.aeat.pret.c180.util.EscribirFicheroSalida;
import es.aeat.pret.c180.util.LeeRetenedor;
import es.aeat.pret.c180.util.LeeRetenido;
import es.aeat.pret.c180.util.Sello;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidarLeerFicheroSrvImpl
implements ValidarLeerFicheroSrv {
    private static final long serialVersionUID = 1L;
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    private static Logger getLog() {
        if ("true".equals(System.getProperty("mc"))) {
            return Logger.getLogger(PerceptorBeanImpl.class.getName());
        }
        return ADHT_JDIT_Factory.getContextoSrv().getLog();
    }

    private void crearValidadorXML(String salida, String errores, final PerceptorBean per, Validator validator) {
        try {
            per.setFicheroSalida(File.createTempFile("r180", salida));
            per.setFicheroError(File.createTempFile("r180", errores));
        }
        catch (IOException e) {
            ValidarLeerFicheroSrvImpl.getLog().severe(e.getMessage());
        }
        if (per.getFicheroSalida().exists()) {
            per.getFicheroSalida().delete();
        }
        if (per.getFicheroError().exists()) {
            per.getFicheroError().delete();
        }
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void fatalError(SAXParseException arg0) throws SAXException {
                if (per.isComprobandoSalida() && arg0.getMessage().startsWith("cvc-elt.1")) {
                    per.setErrorImportacion(true);
                } else {
                    ValidarLeerFicheroSrvImpl.this.crearStaxError(per);
                    per.getStaxE().escribirErrorGeneral(arg0);
                    per.setErrorImportacion(true);
                    int erroresNuevos = per.getErroresImportacion() + 1;
                    per.setErroresImportacion(erroresNuevos);
                    ValidarLeerFicheroSrvImpl.this.terminaFicheroStax(per);
                }
            }

            @Override
            public void error(SAXParseException arg0) throws SAXException {
                if (per.isComprobandoSalida() && arg0.getMessage().startsWith("cvc-elt.1")) {
                    per.setErrorImportacion(true);
                } else {
                    ValidarLeerFicheroSrvImpl.this.crearStaxError(per);
                    per.getStaxE().escribirErrorGeneral(arg0);
                    per.setErrorImportacion(true);
                    int erroresNuevos = per.getErroresImportacion() + 1;
                    per.setErroresImportacion(erroresNuevos);
                    ValidarLeerFicheroSrvImpl.this.terminaFicheroStax(per);
                }
            }

            @Override
            public void warning(SAXParseException arg0) throws SAXException {
            }
        });
    }

    private void crearStaxError(PerceptorBean per) {
        if (per.getStaxE() == null) {
            per.setStaxE(new EscribirFicheroError());
            per.getStaxE().startDocument(per.getFicheroError());
        }
    }

    public void terminaFicheroStax(PerceptorBean per) {
        if (per.getStax() != null && !per.getStax().isTerminado()) {
            per.getStax().endDocument();
            per.setStax(null);
        }
    }

    public void terminaFicheroStaxError(PerceptorBean per) {
        if (per.getStaxE() != null && !per.getStaxE().isTerminado()) {
            per.getStaxE().endDocument();
            per.setStaxE(null);
        }
    }

    @Override
    public boolean validaXmlSalidaStax(String ficheroXMLEntrada, PerceptorBean per) throws SAXException {
        SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        URL resource = this.getClass().getClassLoader().getResource("es/aeat/pret/c180/xml/xsd/AEATRetenciones2018S.xsd");
        Schema schema = sf.newSchema(resource);
        per.setErrorImportacion(false);
        per.setErroresImportacion(0);
        per.setNombreFicheroEntrada(ficheroXMLEntrada);
        Validator validator = schema.newValidator();
        this.crearValidadorXML("SRET2018.xml", "ERR2018.xml", per, validator);
        return this.xmlCorrectoSalidaStax(per, validator);
    }

    @Override
    public boolean validaXmlEntradaStax(String ficheroXMLEntrada, PerceptorBean per) throws SAXException {
        SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        URL resource = this.getClass().getClassLoader().getResource("es/aeat/pret/c180/xml/xsd/AEATRetenciones2018E.xsd");
        Schema schema = sf.newSchema(resource);
        per.setNombreFicheroEntrada(ficheroXMLEntrada);
        if (per.getErroresImportacion() > 0) {
            this.terminaFicheroStaxError(per);
            return false;
        }
        per.setComprobandoSalida(false);
        per.setErrorImportacion(false);
        per.setErroresImportacion(0);
        Validator validator = schema.newValidator();
        this.crearValidadorXML("SRET2018.xml", "ERR2018.xml", per, validator);
        return this.xmlCorrectoEntradaStax(false, per, validator);
    }

    @Override
    public void validaXmlEntradaParaCalculos(String ficheroXMLEntrada, PerceptorBean per) {
        try {
            SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);
            URL resource = this.getClass().getClassLoader().getResource("es/aeat/pret/c180/xml/xsd/AEATRetenciones2018E.xsd");
            Schema schema = sf.newSchema(resource);
            per.setNumRetenidos(0);
            per.setNuneroRetenedorese(0);
            per.setNombreFicheroEntrada(ficheroXMLEntrada);
            StringBuilder fileNameSalida = new StringBuilder("SRET2018-");
            StringBuilder fileNameErr = new StringBuilder("ERR2018-");
            SimpleDateFormat formatFileName = new SimpleDateFormat("yyyyMMdd-HHmmss");
            String date = formatFileName.format(new Date());
            fileNameSalida.append(date);
            fileNameErr.append(date);
            fileNameSalida.append(".xml");
            fileNameErr.append(".xml");
            Validator validator = schema.newValidator();
            this.crearValidadorXML(fileNameSalida.toString(), fileNameErr.toString(), per, validator);
            fileNameSalida = null;
            fileNameErr = null;
            if (this.xmlCorrectoEntradaStax(true, per, validator)) {
                FileInputStream fisReto = null;
                FileInputStream fisReti = null;
                try {
                    fisReto = new FileInputStream(new File(per.getNombreFicheroEntrada()));
                    this.prepararReaderRetenedor(fisReto, per, false, false, true);
                    int numR = this.leeRetenedor(0, per).size();
                    per.setNuneroRetenedorese(numR);
                    int[] miCuantosRetenidos = new int[numR];
                    fisReto.close();
                    fisReto = null;
                    this.cerrarReaderRetenedor(per);
                    fisReti = new FileInputStream(new File(per.getNombreFicheroEntrada()));
                    this.prepararReaderRetenido(fisReti, per, false, false, true);
                    int totalRetenidos = 0;
                    int numReti = 0;
                    int i = 0;
                    while (i < numR) {
                        numReti = this.leeRetenido(i, 0, per).size();
                        totalRetenidos += numReti;
                        miCuantosRetenidos[i] = numReti;
                        ++i;
                    }
                    per.setCuantosRetenidos(miCuantosRetenidos);
                    per.setNumRetenidos(totalRetenidos);
                    fisReti.close();
                    fisReti = null;
                    this.cerrarReaderRetenido(per);
                }
                catch (FileNotFoundException e) {
                    ValidarLeerFicheroSrvImpl.getLog().severe(e.getMessage());
                }
            }
            if (per.isTenemosError()) {
                per.setNumRetenidos(0);
                per.setNuneroRetenedorese(0);
            }
        }
        catch (Exception e) {
            ValidarLeerFicheroSrvImpl.getLog().severe(e.getMessage());
        }
    }

    @Override
    public void cerrarReaderRetenedor(PerceptorBean per) {
        if (per.getStaxReto() != null) {
            per.getStaxReto().cerrarReader();
            per.setStaxReto(null);
        }
    }

    @Override
    public void cerrarReaderRetenido(PerceptorBean per) {
        if (per.getStaxReti() != null) {
            per.getStaxReti().cerrarReader();
            per.setStaxReti(null);
        }
    }

    @Override
    public List<String> leeRetenido(int indiceRetenedor, int indiceRetenido, PerceptorBean per) {
        try {
            per.getStaxReti().readXml(indiceRetenedor, indiceRetenido);
            if (per.getStaxReti().getLista() != null) {
                return per.getStaxReti().getLista();
            }
            return null;
        }
        catch (XMLStreamException e) {
            this.crearStaxError(per);
            per.getStaxE().escribirErrorImportacion(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e.getMessage());
            per.setTenemosError(true);
            return null;
        }
    }

    @Override
    public List<String> leeRetenedor(int indiceRetenedor, PerceptorBean per) {
        try {
            per.getStaxReto().readXml(indiceRetenedor);
            if (per.getStaxReto().getLista() != null) {
                return per.getStaxReto().getLista();
            }
            return null;
        }
        catch (XMLStreamException e) {
            this.crearStaxError(per);
            per.getStaxE().escribirErrorImportacion(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e.getMessage());
            per.setTenemosError(true);
            return null;
        }
    }

    @Override
    public void prepararReaderRetenido(FileInputStream fisReti, PerceptorBean per, boolean importarXML, boolean buscarRetenido, boolean soloLeer) {
        try {
            if (per.getStaxReti() == null) {
                per.setStaxReti(new LeeRetenido());
            }
            per.getStaxReti().crearXMLReader(fisReti, per, importarXML, buscarRetenido, soloLeer);
            per.getStaxReti().preparamosLectura();
        }
        catch (XMLStreamException e) {
            this.crearStaxError(per);
            per.getStaxE().escribirErrorImportacion(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e.getMessage());
            per.setTenemosError(true);
        }
    }

    @Override
    public void prepararReaderRetenedor(FileInputStream fisReto, PerceptorBean per, boolean importarXML, boolean buscarRetenedor, boolean soloLeer) {
        try {
            if (per.getStaxReto() == null) {
                per.setStaxReto(new LeeRetenedor());
            }
            per.getStaxReto().crearXMLReader(fisReto, per, importarXML, buscarRetenedor, soloLeer);
            per.getStaxReto().preparamosLectura();
        }
        catch (XMLStreamException e) {
            this.crearStaxError(per);
            per.getStaxE().escribirErrorImportacion(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e.getMessage());
            per.setTenemosError(true);
        }
    }

    @Override
    public boolean xmlCorrectoEntradaStax(boolean calculo, PerceptorBean per, Validator validator) {
        InputStream ruta;
        block11: {
            ruta = null;
            ruta = per.getNombreFicheroEntrada().endsWith(".tmp") ? new FileInputStream(new File(per.getNombreFicheroEntrada())) : new ByteArrayInputStream(per.getNombreFicheroEntrada().getBytes());
            try {
                validator.validate(new SAXSource(new InputSource((FileInputStream)ruta)));
            }
            catch (SAXException e) {
                ValidarLeerFicheroSrvImpl.getLog().severe("ERROR DE ESQUEMA " + e.getMessage());
            }
            if (!per.isErrorImportacion()) break block11;
            ruta.close();
            this.terminaFicheroStaxError(per);
            ruta = null;
            return false;
        }
        try {
            ruta.close();
            ruta = null;
        }
        catch (FileNotFoundException e) {
            ValidarLeerFicheroSrvImpl.getLog().severe("No esiste fichero entrada:" + e.getMessage());
            per.setTenemosError(true);
            try {
                if (ruta != null) {
                    ruta.close();
                }
            }
            catch (IOException e1) {
                ValidarLeerFicheroSrvImpl.getLog().severe(e1.getMessage());
            }
            ruta = null;
            return false;
        }
        catch (IOException e) {
            ValidarLeerFicheroSrvImpl.getLog().severe("IO EXCEPTION 2");
            ValidarLeerFicheroSrvImpl.getLog().severe(e.getMessage());
            per.setTenemosError(true);
            try {
                ruta.close();
            }
            catch (IOException e1) {
                ValidarLeerFicheroSrvImpl.getLog().severe(e1.getMessage());
            }
            ruta = null;
            return false;
        }
        this.terminaFicheroStaxError(per);
        return true;
    }

    @Override
    public boolean xmlCorrectoSalidaStax(PerceptorBean per, Validator validator) {
        InputStream ruta;
        block11: {
            per.setComprobandoSalida(true);
            ruta = null;
            ruta = per.getNombreFicheroEntrada().endsWith(".tmp") ? new FileInputStream(new File(per.getNombreFicheroEntrada())) : new ByteArrayInputStream(per.getNombreFicheroEntrada().getBytes());
            try {
                validator.validate(new SAXSource(new InputSource((FileInputStream)ruta)));
            }
            catch (SAXException e) {
                ValidarLeerFicheroSrvImpl.getLog().severe("ERROR VALIDATOR " + e.getMessage());
            }
            per.setComprobandoSalida(false);
            if (!per.isErrorImportacion()) break block11;
            ruta.close();
            ruta = null;
            return false;
        }
        try {
            ruta.close();
            ruta = null;
        }
        catch (FileNotFoundException e) {
            ValidarLeerFicheroSrvImpl.getLog().severe("No esiste fichero entrada: " + e.getMessage());
            per.setComprobandoSalida(false);
            per.setTenemosError(true);
            try {
                if (ruta != null) {
                    ruta.close();
                }
            }
            catch (IOException e1) {
                ValidarLeerFicheroSrvImpl.getLog().severe(e1.getMessage());
            }
            ruta = null;
            return false;
        }
        catch (IOException e) {
            ValidarLeerFicheroSrvImpl.getLog().severe("IO EXCEPTION 4");
            ValidarLeerFicheroSrvImpl.getLog().severe(e.getMessage());
            per.setTenemosError(true);
            try {
                ruta.close();
            }
            catch (IOException e1) {
                ValidarLeerFicheroSrvImpl.getLog().severe(e1.getMessage());
            }
            ruta = null;
            return false;
        }
        this.terminaFicheroStaxError(per);
        return true;
    }

    @Override
    public File salidaXML(boolean errorPerceptor, PerceptorBean per) {
        if (!(per.isTenemosError() || per.isErrorImportacion() || errorPerceptor)) {
            if (per.getFicheroError() != null && per.getFicheroError().exists()) {
                per.getFicheroError().delete();
            }
            return per.getFicheroSalida();
        }
        if (per.getFicheroSalida().exists()) {
            per.getFicheroSalida().delete();
        }
        return per.getFicheroError();
    }

    @Override
    public boolean isOk(PerceptorBean per) {
        if (!per.isTenemosError() && !per.isErrorImportacion()) {
            return true;
        }
        if (per.getStaxE() != null) {
            this.terminaFicheroStaxError(per);
        }
        return false;
    }

    @Override
    public void generarXML(String nifRetenedor, String nombreRetenedor, String nombreRetenido, PerceptorBean per) {
        per.setValor("apeper", nombreRetenido);
        per.setValor("nifret", nifRetenedor);
        per.setValor("aperet", nombreRetenedor);
        try {
            per.setFicheroSalida(File.createTempFile("genXMLr180", "SRET2018.xml"));
        }
        catch (IOException e1) {
            ValidarLeerFicheroSrvImpl.getLog().severe(e1.getMessage());
        }
        if (per.getFicheroSalida().exists()) {
            per.getFicheroSalida().delete();
        }
        per.setStax(new EscribirFicheroSalida());
        per.getStax().startDocument(per);
        per.getStax().startRetenedor();
        per.getStax().escribirRetenido();
        per.getStax().endRetenedor();
        per.getStax().endDocument();
        this.ponerSello(per);
        per.setStax(null);
    }

    @Override
    public void ponerSello(PerceptorBean per) {
        block13: {
            FileInputStream fis = null;
            try {
                try {
                    String s;
                    fis = new FileInputStream(per.getFicheroSalida());
                    String sello = this.crearSello(fis);
                    RandomAccessFile raf = new RandomAccessFile(per.getFicheroSalida(), "rw");
                    int primero = raf.readLine().length();
                    int indexLine = raf.readLine().indexOf("Sello=");
                    raf.seek(indexLine += "Sello=".length() + primero);
                    byte[] c1 = new byte[1];
                    do {
                        raf.read(c1, 0, 1);
                    } while (!"\"".equals(s = new String(c1)));
                    raf.write(sello.getBytes());
                    raf.close();
                    raf = null;
                    sello = null;
                }
                catch (Exception e1) {
                    ValidarLeerFicheroSrvImpl.getLog().severe(e1.getMessage());
                    if (fis == null) break block13;
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public String crearSello(InputStream bys) throws IOException {
        int leidos;
        byte[] datos = new byte[5120];
        Sello sello = new Sello();
        while ((leidos = bys.read(datos)) != -1) {
            sello.update(datos, 0, leidos);
        }
        datos = null;
        String cad = sello.sellar();
        cad = String.valueOf(cad) + "M";
        sello = null;
        return cad;
    }

    @Override
    public void empiezaDocumento(PerceptorBean per) {
        per.setStax(new EscribirFicheroSalida());
        per.getStax().startDocument(per);
    }

    @Override
    public void terminarDocumento(PerceptorBean per) {
        per.getStax().endDocument();
    }

    @Override
    public void empiezaRetenedor(PerceptorBean per) {
        per.getStax().startRetenedor();
    }

    @Override
    public void terminaRetenedor(PerceptorBean per) {
        per.getStax().endRetenedor();
    }

    @Override
    public void empiezaRetenido(PerceptorBean per) {
        per.getStax().escribirRetenido();
    }

    @Override
    public void empiezaDocumentoError(PerceptorBean per) {
        if (per.getFicheroSalida().exists()) {
            if (per.getStax() != null) {
                per.getStax().endDocument();
                per.setStax(null);
            }
            per.getFicheroSalida().delete();
        }
        this.crearStaxError(per);
    }

    @Override
    public void crearFicheroErrorRetenidoSTAX(CalculoRetencionesSrv calculo, PerceptorBean per, int ordenRetenedor, int ordenRetenido) {
        this.crearStaxError(per);
        if (!per.getStaxE().isEmpezadoErrorNormal()) {
            per.getStaxE().empiezaErrorNormal();
        }
        if (!per.getStaxE().isEmpezadoRetenedor()) {
            per.getStaxE().empiezaErrorRetenedor((String)per.getValor("nifret"), ordenRetenedor + 1);
        }
        List<ErrorValidacionBean> lista = calculo.getErrores(per);
        per.getStaxE().errorRetenido(lista, (String)per.getValor("nifper"), ordenRetenido + 1);
        lista = null;
    }

    @Override
    public void terminarDocumentoError(PerceptorBean per) {
        if (per.getStaxE() != null) {
            per.getStaxE().endDocument();
        }
    }

    @Override
    public void terminaRetenedorError(PerceptorBean per) {
        if (per.getStaxE() != null) {
            per.getStaxE().endErrorRetenedor();
        }
    }

    @Override
    public void inicializaValidador(PerceptorBean per) {
        per.setStax(null);
        per.setStaxE(null);
        per.setTenemosError(false);
        per.setErrorImportacion(false);
        per.setErroresImportacion(0);
        per.setComprobandoSalida(false);
        per.setStaxReti(null);
        per.setStaxReto(null);
        per.setFicheroSalida(null);
        per.setFicheroError(null);
        per.setNumRetenidos(0);
        per.setNuneroRetenedorese(0);
        per.setCuantosRetenidos(null);
        per.setNombreFicheroEntrada(null);
    }

    @Override
    public int[] getListaRetenidos(PerceptorBean per) {
        return per.getCuantosRetenidos();
    }

    @Override
    public int getNumeroRetenedoresTotal(PerceptorBean per) {
        return per.getNuneroRetenedorese();
    }

    @Override
    public int getNumeroRetenidosTotal(PerceptorBean per) {
        return per.getNumRetenidos();
    }
}

