/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c181.mc;

import es.aeat.pret.c181.mc.AnalizarLineaComandoException;
import es.aeat.pret.c181.mc.Parametro;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class AnalizarLineaComandos {
    private static final String NUM_ERROR1 = "0001";
    private static final String TEXTO_ERROR1 = " Error en el formato de par\u00e1metro";
    private static final String NUM_ERROR2 = "0002";
    private static final String TEXTO_ERROR2 = " Error, este nombre de par\u00e1metro no existe";
    private static final String NUM_ERROR3 = "0003";
    private static final String TEXTO_ERROR3 = " Error, Tiene un par\u00e1metro con valor obligatorio";
    private static final String NUM_ERROR4 = "0004";
    private static final String NUM_ERROR5 = "0005";
    private static final String TEXTO_ERROR4 = " Error, Tiene un par\u00e1metro con valor \u00fanico";
    private static final String TEXTO_ERROR5 = " Error, Valor no permitido";
    private Collection listaParametros = new ArrayList();
    private StringBuilder sParametro;

    public void setParametro(String nombres, boolean obligatorio, String valorDefecto, boolean valorUnico, String[] valores) {
        Parametro miParam = new Parametro();
        if (nombres == null) {
            miParam.setNombre(null);
        } else {
            miParam.setNombre(nombres.toUpperCase());
        }
        miParam.setObligatorio(obligatorio);
        miParam.setValorDefecto(valorDefecto);
        miParam.setValorUnico(valorUnico);
        miParam.setValores(valores);
        this.listaParametros.add(miParam);
    }

    public void setParametro(String nombres, boolean obligatorio, String valorDefecto, boolean valorUnico) {
        Parametro miParam = new Parametro();
        if (nombres == null) {
            miParam.setNombre(null);
        } else {
            miParam.setNombre(nombres.toUpperCase());
        }
        miParam.setObligatorio(obligatorio);
        miParam.setValorDefecto(valorDefecto);
        miParam.setValorUnico(valorUnico);
        this.listaParametros.add(miParam);
    }

    public String getParametro(String nombre) throws AnalizarLineaComandoException {
        for (Parametro paramAux : this.listaParametros) {
            if (!paramAux.getNombre().equals(nombre)) continue;
            if (paramAux.getValorParametro() == null || paramAux.getValorParametro() == "") {
                if (paramAux.getValorDefecto() == null || paramAux.getValorDefecto() == "") {
                    throw new AnalizarLineaComandoException("ERROR");
                }
                return paramAux.getValorDefecto();
            }
            return paramAux.getValorParametro();
        }
        throw new AnalizarLineaComandoException("ERROR");
    }

    public void parse(String[] lineaComando) throws AnalizarLineaComandoException {
        int i = 0;
        while (i < lineaComando.length) {
            if (!this.validaFormatoParametro(lineaComando[i])) {
                throw new AnalizarLineaComandoException(this.generaMensaje(NUM_ERROR1, lineaComando[i], TEXTO_ERROR1).toString());
            }
            if (!this.validaNombreParametro(lineaComando[i])) {
                throw new AnalizarLineaComandoException(this.generaMensaje(NUM_ERROR2, lineaComando[i].substring(0, 3), TEXTO_ERROR2).toString());
            }
            ++i;
        }
        if (!this.validaValorObligatorio()) {
            throw new AnalizarLineaComandoException(this.generaMensaje(NUM_ERROR3, this.sParametro.toString(), TEXTO_ERROR3).toString());
        }
        if (!this.validaValorUnico()) {
            throw new AnalizarLineaComandoException(this.generaMensaje(NUM_ERROR4, this.sParametro.toString(), TEXTO_ERROR4).toString());
        }
        Parametro mal = this.validaValoresPermitidos();
        if (mal != null) {
            throw new AnalizarLineaComandoException(this.generaMensaje(NUM_ERROR5, "/" + mal.getNombre() + ":", TEXTO_ERROR5).toString());
        }
    }

    private StringBuilder generaMensaje(String sNumero, String lineaComando, String sTexto) {
        StringBuilder mesError = new StringBuilder();
        mesError.append(sNumero);
        if (lineaComando != null) {
            mesError.append(" ");
            mesError.append(lineaComando);
        }
        mesError.append(sTexto);
        return mesError;
    }

    private boolean validaFormatoParametro(String parametro) {
        if (parametro.charAt(0) != '/') {
            return false;
        }
        int pos = parametro.indexOf(58);
        if (pos == -1) {
            return false;
        }
        if (pos != 2) {
            return false;
        }
        return parametro.length() > 3;
    }

    private boolean validaNombreParametro(String parametro) {
        int pos = parametro.indexOf(58);
        String sAux = parametro;
        String letra = sAux.substring(--pos, pos + 1);
        for (Parametro paramAux : this.listaParametros) {
            if (!paramAux.getNombre().equalsIgnoreCase(letra)) continue;
            paramAux.setValorParametro(sAux.substring(pos += 2, parametro.length()));
            return true;
        }
        return false;
    }

    private boolean validaValorObligatorio() {
        for (Parametro paramAux : this.listaParametros) {
            this.sParametro = new StringBuilder(4);
            this.sParametro.append('/');
            this.sParametro.append(paramAux.getNombre());
            this.sParametro.append(':');
            if (!(paramAux.isObligatorio() ? paramAux.getValorParametro() == null || "".equals(paramAux.getValorParametro()) : !(paramAux.getValorParametro() != null && !"".equals(paramAux.getValorParametro()) || paramAux.getValorDefecto() != null && !"".equals(paramAux.getValorDefecto())))) continue;
            return false;
        }
        return true;
    }

    private Parametro validaValoresPermitidos() {
        for (Parametro paramAux : this.listaParametros) {
            if (paramAux.validaValores()) continue;
            return paramAux;
        }
        return null;
    }

    private boolean validaValorUnico() {
        Iterator it = this.listaParametros.iterator();
        int i = 0;
        while (it.hasNext()) {
            Parametro paramAux = (Parametro)it.next();
            this.sParametro = new StringBuilder(4);
            this.sParametro.append('/');
            this.sParametro.append(paramAux.getNombre());
            this.sParametro.append(':');
            if (paramAux.isValorUnico()) {
                String cadAux;
                if (paramAux.getValorParametro() == null || "".equals(paramAux.getValorParametro())) {
                    if (paramAux.getValorDefecto() == null || "".equals(paramAux.getValorDefecto())) {
                        return false;
                    }
                    cadAux = paramAux.getValorDefecto();
                } else {
                    cadAux = paramAux.getValorParametro();
                }
                if (this.buscaValorRepetido(i, cadAux)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean buscaValorRepetido(int actual, String cadena) {
        Iterator it = this.listaParametros.iterator();
        int j = 0;
        while (it.hasNext()) {
            Parametro paramAux = (Parametro)it.next();
            if (actual != j && (paramAux.getValorParametro() == null || "".equals(paramAux.getValorParametro()) ? paramAux.getValorDefecto().equals(cadena) : paramAux.getValorParametro().equals(cadena))) {
                return true;
            }
            ++j;
        }
        return false;
    }
}

