/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c181.mc;

import es.aeat.pret.c181.imp.srv.CalculoRetencionesXMLSrvImpl;
import es.aeat.pret.c181.mc.AnalizarLineaComandoException;
import es.aeat.pret.c181.mc.AnalizarLineaComandos;
import es.aeat.pret.c181.mc.PathTrabajo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ResourceBundle;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ModuloCalculo {
    private static final String NO_SE_HA_BORRADO = "NO SE HA BORRADO";
    private static Logger logger = LoggerFactory.getLogger(ModuloCalculo.class);

    private ModuloCalculo() {
    }

    public static void procesarFicheroXml(String fichero, String errores, String flag, String salida) {
        block17: {
            System.setProperty("mc", "true");
            if (!new File(errores).delete()) {
                logger.error(NO_SE_HA_BORRADO);
            }
            if (!new File(salida).delete()) {
                logger.error(NO_SE_HA_BORRADO);
            }
            if (!new File(fichero).exists()) {
                try {
                    ModuloCalculo.generarErrorEntradaNoExiste(new File(errores));
                }
                catch (FileNotFoundException e) {
                    logger.error("Imposible crear fichero de errores.");
                }
                return;
            }
            CalculoRetencionesXMLSrvImpl mod = null;
            String copiaEntrada = null;
            String pathResultado = null;
            try {
                try {
                    copiaEntrada = ModuloCalculo.copyFile(fichero, null);
                    mod = new CalculoRetencionesXMLSrvImpl();
                    pathResultado = mod.procesar(new File(copiaEntrada), null);
                    if (pathResultado.contains("SRET")) {
                        if (!new File(salida).delete()) {
                            logger.error(NO_SE_HA_BORRADO);
                        }
                        ModuloCalculo.copyFile(pathResultado, salida);
                        break block17;
                    }
                    if (!new File(errores).delete()) {
                        logger.error(NO_SE_HA_BORRADO);
                    }
                    ModuloCalculo.copyFile(pathResultado, errores);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    if (copiaEntrada != null && !new File(copiaEntrada).delete()) {
                        logger.error(NO_SE_HA_BORRADO);
                    }
                    if (pathResultado != null && !new File(pathResultado).delete()) {
                        logger.error(NO_SE_HA_BORRADO);
                    }
                }
            }
            finally {
                if (copiaEntrada != null && !new File(copiaEntrada).delete()) {
                    logger.error(NO_SE_HA_BORRADO);
                }
                if (pathResultado != null && !new File(pathResultado).delete()) {
                    logger.error(NO_SE_HA_BORRADO);
                }
            }
        }
    }

    public static String procesarFicheroXML(String entradaXML) throws SAXException, IOException {
        System.setProperty("mc", "true");
        Channel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        CalculoRetencionesXMLSrvImpl mod = null;
        File dest = null;
        String pathResultado = null;
        try {
            dest = File.createTempFile("stringfile-", null);
            destChannel = new FileOutputStream(dest).getChannel();
            byte[] bytesEntrada = entradaXML.getBytes();
            sourceChannel = Channels.newChannel(new ByteArrayInputStream(bytesEntrada));
            ((FileChannel)destChannel).transferFrom((ReadableByteChannel)sourceChannel, 0L, bytesEntrada.length);
            try {
                mod = new CalculoRetencionesXMLSrvImpl();
                pathResultado = mod.procesar(dest, null);
                String string = ModuloCalculo.fileToString(pathResultado);
                return string;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (destChannel != null) {
                destChannel.close();
            }
            if (dest != null && !dest.delete()) {
                logger.error("No se pudo borrar el fichero " + dest.getAbsolutePath());
            }
            if (pathResultado != null && !new File(pathResultado).delete()) {
                logger.error(NO_SE_HA_BORRADO);
            }
        }
        return null;
    }

    private static void generarErrorEntradaNoExiste(File errores) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(errores);
        writer.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>");
        writer.println("<AEATRetencionesError2018>");
        writer.println("<ErrorGeneral>");
        writer.println("<Linea>0</Linea>");
        writer.println("<Posicion>0</Posicion>");
        writer.println("<Descripcion>El fichero de entrada no existe.</Descripcion>");
        writer.println("</ErrorGeneral>");
        writer.println("</AEATRetencionesError2018>");
        writer.flush();
        writer.close();
    }

    private static String fileToString(String origen) throws IOException {
        AbstractInterruptibleChannel sourceChannel = null;
        Channel destChannel = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            File source = new File(origen);
            sourceChannel = new FileInputStream(source).getChannel();
            destChannel = Channels.newChannel(baos);
            ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
            while (((FileChannel)sourceChannel).read(buffer) != -1) {
                buffer.flip();
                destChannel.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                destChannel.write(buffer);
            }
            String string = baos.toString();
            return string;
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (destChannel != null) {
                destChannel.close();
            }
        }
    }

    private static String copyFile(String origen, String destino) throws IOException {
        AbstractInterruptibleChannel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            File dest;
            File source = new File(origen);
            sourceChannel = new FileInputStream(source).getChannel();
            if (destino == null) {
                dest = File.createTempFile("copyOf-" + source.getName() + "-", null);
                dest.deleteOnExit();
            } else {
                dest = new File(destino);
            }
            destChannel = new FileOutputStream(dest).getChannel();
            ((FileChannel)destChannel).transferFrom((ReadableByteChannel)((Object)sourceChannel), 0L, ((FileChannel)sourceChannel).size());
            String string = dest.getPath();
            return string;
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (destChannel != null) {
                destChannel.close();
            }
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        System.setProperty("mc", "true");
        ModuloCalculo.configLog();
        logger = LoggerFactory.getLogger(ModuloCalculo.class);
        AnalizarLineaComandos alc = new AnalizarLineaComandos();
        alc.setParametro("E", true, null, true);
        alc.setParametro("R", true, null, true);
        alc.setParametro("S", true, null, true);
        alc.setParametro("I", false, "null", false);
        String fichero = null;
        try {
            alc.parse(args);
            fichero = alc.getParametro("E");
            String errores = alc.getParametro("R");
            String flag = "";
            String salida = alc.getParametro("S");
            String adicional = alc.getParametro("I");
            if (!"null".equals(adicional)) {
                ResourceBundle bundle = ResourceBundle.getBundle("es/aeat/pret/c181/mc/retenciones");
                System.out.println(String.valueOf(bundle.getString("acercade.titulo")) + " " + bundle.getString("acercade.periodo") + " " + bundle.getString("version.mc"));
            }
            ModuloCalculo.procesarFicheroXml(fichero, errores, flag, salida);
        }
        catch (AnalizarLineaComandoException ex) {
            logger.error("Error en l\u00ednea de comandos", ex);
            System.exit(1);
        }
    }

    private static void configLog() {
        try {
            LogManager logManager = LogManager.getLogManager();
            InputStream prop = ModuloCalculo.class.getResourceAsStream("/es/aeat/pret/rd15/julio/recursos/logging.properties");
            logManager.readConfiguration(prop);
            prop.close();
            File file = new File(PathTrabajo.getPathTrabajoSinProtocolo(), "slf4j-jdk14-1.6.1.jar");
            if (file.exists()) {
                ModuloCalculo.addURL(file.toURI().toURL());
            }
        }
        catch (Exception e) {
            logger.error("Error, could not add URL to system classloader", e);
        }
    }

    private static void addURL(URL u) throws IOException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        Method method = sysclass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)sysloader, u);
    }
}

