/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c190.imp.srv;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import es.aeat.pret.c190.api.bean.AscendienteBean;
import es.aeat.pret.c190.api.bean.DescendienteBean;
import es.aeat.pret.c190.api.bean.ErrorValidacionBean;
import es.aeat.pret.c190.api.bean.PerceptorBean;
import es.aeat.pret.c190.api.bean.PerceptorBeanTipos;
import es.aeat.pret.c190.api.srv.CalculoRetencionesSrv;
import es.aeat.pret.c190.imp.bean.AscendienteBeanImpl;
import es.aeat.pret.c190.imp.bean.DescendienteBeanImpl;
import es.aeat.pret.c190.imp.bean.ErrorValidacionBeanImpl;
import es.aeat.pret.c190.imp.bean.PerceptorBeanImpl;
import es.aeat.pret.c190.util.ValidaNif;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

public class CalculoRetencionesSrvImpl
implements CalculoRetencionesSrv {
    private static final long serialVersionUID = 1L;
    private static final String REGULARIZACION_CONSIGNADA = "regularizaci\u00f3n consignada.";
    private static final String REGULARIZACION_INCOMPATIBLES_ENTRE_SI = "Ha seleccionado causas de regularizaci\u00f3n incompatibles entre s\u00ed.";
    public static final String VALIDOSNIF = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final BigDecimal LIMITE_33007_CON_20 = new BigDecimal("33007.20");
    private static final BigDecimal LIMITE_22000 = new BigDecimal("22000.00");
    private static final BigDecimal LIMITE = new BigDecimal("0.43");
    private static final BigDecimal CERODOS = new BigDecimal("0.02");
    private static final BigDecimal BD1200 = new BigDecimal("1200.00");
    private static final BigDecimal BD600 = new BigDecimal("600.00");
    private static final BigDecimal BD030 = new BigDecimal("0.30");
    private static final BigDecimal BD90000 = new BigDecimal("90000.00");
    private static final BigDecimal BD5550 = new BigDecimal("5550.00");
    private static final BigDecimal BD2000 = new BigDecimal("2000.00");
    private static final BigDecimal BD1400 = new BigDecimal("1400.00");
    private static final BigDecimal BD8100 = new BigDecimal("8100.00");
    private static final BigDecimal BD7750 = new BigDecimal("7750.00");
    private static final BigDecimal BD3500 = new BigDecimal("3500.00");
    private static final BigDecimal BD1150 = new BigDecimal("1150.00");
    private static final BigDecimal BD2400 = new BigDecimal("2400.00");
    private static final BigDecimal BD2700 = new BigDecimal("2700.00");
    private static final BigDecimal BD4000 = new BigDecimal("4000.00");
    private static final BigDecimal BD4500 = new BigDecimal("4500.00");
    private static final BigDecimal BD2800 = new BigDecimal("2800.00");
    private static final BigDecimal BD9000 = new BigDecimal("9000.00");
    private static final BigDecimal BD3000 = new BigDecimal("3000.00");
    private static final BigDecimal BD1980 = new BigDecimal("1980.00");
    private static final BigDecimal BD2 = new BigDecimal("2.00");
    private static final BigDecimal BD5565 = new BigDecimal("5565.00");
    private static final BigDecimal BD13115 = new BigDecimal("13115.00");
    private static final BigDecimal BD16825 = new BigDecimal("16825.00");
    private static final BigDecimal BD15 = new BigDecimal("1.5");
    private static final BigDecimal BD040 = new BigDecimal("0.40");
    private static final BigDecimal BD66014 = new BigDecimal("660.14");
    private static final BigDecimal BD12450 = new BigDecimal("12450.00");
    private static final BigDecimal BD019 = new BigDecimal("0.19");
    private static final BigDecimal BD20200 = new BigDecimal("20200.00");
    private static final BigDecimal BD236550 = new BigDecimal("2365.50");
    private static final BigDecimal BD024 = new BigDecimal("0.24");
    private static final BigDecimal BD60000 = new BigDecimal("60000.00");
    private static final BigDecimal BD872550 = new BigDecimal("8725.50");
    private static final BigDecimal BD045 = new BigDecimal("0.45");
    private static final BigDecimal BD1790150 = new BigDecimal("17901.50");
    private static final BigDecimal BD35200 = new BigDecimal("35200.00");
    private static final BigDecimal BD42255 = new BigDecimal("4225.50");
    private static final BigDecimal BD037 = new BigDecimal("0.37");
    private static final String POR_MITAD = "Por mitad";
    private static final String POR_ENTERO = "Por entero";
    private static final String DESCENDIENTES_ORDENADOS = "descendientesOrdenados";
    private static final String ERR_RETRIBA = "retriba";
    private static final String ERR_MINORADO = "minorado";
    private static final String ERR_MINOPAGOA = "minopagoa";
    private static final String ERR_TIPOA = "tipoa";
    private static final String ERR_MINPERFAA = "minperfaa";
    private static final String ERR_BASEA = "basea";
    private static final String ERR_CAUSA = "causa";
    private static final String ERR_PRESVIV = "presviv";
    private static final String ERR_DESCENDIENTES = "descendientes";
    private static final String ERR_NIFCON = "nifcon";
    private static final String ERR_ANOPER = "anoper";
    private static final String ERR_NIFPER = "nifper";
    private static final String ERR_NIFRET = "nifret";
    private static final String ERR_SITUFAM = "situfam";
    private static final String ERR_PERCIBIDO = "percibido";
    private static final String ERR_RETRIB = "retrib";
    private static final String ERR_IRREGULAR1 = "irregular1";
    private static final BigDecimal BD17634 = new BigDecimal("17634.00");
    private static final BigDecimal BD15947 = new BigDecimal("15947.00");
    private static final BigDecimal BD17100 = new BigDecimal("17100.00");
    private static final BigDecimal BD15456 = new BigDecimal("15456.00");
    private static final BigDecimal BD16481 = new BigDecimal("16481.00");
    private static final BigDecimal BD14000 = new BigDecimal("14000.00");
    private static final BigDecimal BD14516 = new BigDecimal("14516.00");
    private static final BigDecimal BD15093 = new BigDecimal("15093.00");

    @Override
    public boolean validar(PerceptorBean perceptorBean, boolean desdeFichero) {
        Boolean presviv;
        BigDecimal irregular1;
        int situFam;
        this.calculoYComputoDeDescendientes(perceptorBean);
        this.calculoYComputoDeAscendientes(perceptorBean);
        this.setRegularizacion(perceptorBean);
        if (perceptorBean.getErr() == null) {
            perceptorBean.borrarErr();
        }
        ValidaNif vln = new ValidaNif();
        String nifRet = (String)perceptorBean.getValor(ERR_NIFRET);
        int resul = vln.checkNif(nifRet);
        if ("".equals(nifRet.trim())) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9001", "No existe NIF del retenedor.", ERR_NIFRET, -1));
        } else if (!this.validaNifMayus(nifRet)) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9002", "El NIF del retenedor es incorrecto.", ERR_NIFRET, -1));
        } else if (resul == -1 || !vln.isOk()) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9003", "El NIF del retenedor es incorrecto.", ERR_NIFRET, -1));
        }
        String nifPer = (String)perceptorBean.getValor(ERR_NIFPER);
        resul = vln.checkNif(nifPer);
        if ("".equals(nifPer.trim()) || !vln.esPersonaFisica(resul, false)) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9005", "NIF del perceptor obligatorio de persona f\u00edsica.", ERR_NIFPER, -1));
        } else if (!this.validaNifMayus(nifPer)) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9006", "NIF del perceptor obligatorio de persona f\u00edsica.", ERR_NIFPER, -1));
        } else if (resul == -1 || !vln.isOk()) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9007", "NIF del perceptor incorrecto.", ERR_NIFPER, -1));
        }
        boolean bValidarRangoAnio = true;
        Integer anioPer = (Integer)perceptorBean.getValor(ERR_ANOPER);
        if (anioPer == 0) {
            if (!desdeFichero) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9010", "A\u00f1o de nacimiento del perceptor obligatorio.", ERR_ANOPER, -1));
            } else {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9011", "A\u00f1o nacimiento perceptor incorrecto.", ERR_ANOPER, -1));
            }
            bValidarRangoAnio = false;
        }
        if (bValidarRangoAnio && (anioPer < 1905 || anioPer > 2019)) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9012", "A\u00f1o nacimiento perceptor incorrecto.", ERR_ANOPER, -1));
        }
        if ((situFam = ((Integer)perceptorBean.getValor(ERR_SITUFAM)).intValue()) < 1 || situFam > 3) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9013", "La situaci\u00f3n familiar del perceptor es obligatoria.", ERR_SITUFAM, -1));
        }
        int numDes = (Integer)perceptorBean.getValor("numdes");
        if (situFam == 1 && numDes == 0) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9014", "La situaci\u00f3n familiar \"1\" exige que el contribuyente tenga al menos un descendiente que d\u00e9 derecho a la reducci\u00f3n de la tributaci\u00f3n conjunta para familias monoparentales.", ERR_SITUFAM, -1));
        }
        if (situFam == 2) {
            String nifCon = (String)perceptorBean.getValor(ERR_NIFCON);
            resul = vln.checkNif(nifCon);
            if ("".equals(nifCon.trim())) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9015", "NIF del c\u00f3nyuge obligatorio.", ERR_NIFCON, -1));
            } else if (!this.validaNifMayus(nifCon)) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9016", "El NIF del c\u00f3nyuge es incorrecto.", ERR_NIFCON, -1));
            } else if (resul == -1 || !vln.isOk()) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9017", "El NIF del c\u00f3nyuge es incorrecto.", ERR_NIFCON, -1));
            } else if (!vln.esPersonaFisica(resul, false)) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9018", "El NIF del c\u00f3nyuge ha de ser de persona f\u00edsica.", ERR_NIFCON, -1));
            } else if (nifCon.equals(nifPer)) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9019", "El NIF del c\u00f3nyuge no puede ser el mismo que el del contribuyente.", ERR_NIFCON, -1));
            }
        }
        vln = null;
        int situPer = (Integer)perceptorBean.getValor("situper");
        if (situPer != 1 && situPer != 2 && situPer != 3 && situPer != 4) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9020", "Situaci\u00f3n laboral del perceptor incorrecta.", "situper", -1));
        }
        int contrato = (Integer)perceptorBean.getValor("contrato");
        if (situPer == 1 && contrato != 1 && contrato != 2 && contrato != 3 && contrato != 4) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9021", "Tipo de contrato incorrecto.", "contrato", -1));
        }
        List descendientes = (List)perceptorBean.getValor(ERR_DESCENDIENTES);
        int nD = descendientes.size();
        int i = 0;
        while (i < nD) {
            int edad = 2019 - ((DescendienteBean)descendientes.get(i)).getAnioNacimiento();
            if (edad > 24 && ((DescendienteBean)descendientes.get(i)).getDiscapacidad() == 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9022", "Descendientes mayores de 25 a\u00f1os sin discapacidad no dan derecho a m\u00ednimo.", ERR_DESCENDIENTES, i));
            }
            if (((DescendienteBean)descendientes.get(i)).getAnioAdopcion() != 0 && ((DescendienteBean)descendientes.get(i)).getAnioNacimiento() > ((DescendienteBean)descendientes.get(i)).getAnioAdopcion()) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9024", "El a\u00f1o de adopci\u00f3n debe ser igual o mayor al a\u00f1o de nacimiento.", ERR_DESCENDIENTES, i));
            }
            ++i;
        }
        descendientes = null;
        List ascendientes = (List)perceptorBean.getValor("ascendientes");
        int nA = ascendientes.size();
        int i2 = 0;
        while (i2 < nA) {
            int edad = 2019 - ((AscendienteBean)ascendientes.get(i2)).getAnioNacimiento();
            if (edad < 65 && ((AscendienteBean)ascendientes.get(i2)).getDiscapacidad() == 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9023", "Ascendientes menores de 65 a\u00f1os sin discapacidad no dan derecho a m\u00ednimo.", "ascendientes", i2));
            }
            ++i2;
        }
        ascendientes = null;
        BigDecimal retrib = perceptorBean.getValorAsBigDecimal(ERR_RETRIB);
        if (retrib.compareTo(BigDecimal.ZERO) == 0) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9025", "Las retribuciones totales son obligatorias.", ERR_RETRIB, -1));
        }
        if ((irregular1 = perceptorBean.getValorAsBigDecimal(ERR_IRREGULAR1)).compareTo(BD90000) > 0) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9026", "La cuant\u00eda m\u00e1xima de la reducci\u00f3n (art.\u00ba 18.2 LIRPF) no puede superar el importe de 90.000 euros.", ERR_IRREGULAR1, -1));
        }
        if (irregular1.compareTo(retrib.multiply(BD030)) > 0) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R90281", "La cuant\u00eda m\u00e1xima de la reducci\u00f3n (art.18.2 LIRPF) no puede superar con car\u00e1cter general, el 30% de las retribuciones totales.", ERR_IRREGULAR1, -1));
        }
        if ((presviv = (Boolean)perceptorBean.getValor(ERR_PRESVIV)).booleanValue() && retrib.compareTo(LIMITE_33007_CON_20) >= 0) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9028", "Las retribuciones totales anuales consignadas no son inferiores a 33.007,20 euros, por lo que en la pantalla de datos econ\u00f3micos deber\u00e1 desactivarse la casilla relativa a los pagos por pr\u00e9stamos destinados a la adquisici\u00f3n o rehabilitaci\u00f3n de la vivienda habitual del perceptor.", ERR_PRESVIV, -1));
        }
        boolean regularizacion = (Boolean)perceptorBean.getValor("regularizacion");
        BigDecimal tipoa = perceptorBean.getValorAsBigDecimal(ERR_TIPOA);
        BigDecimal minperfaa = perceptorBean.getValorAsBigDecimal(ERR_MINPERFAA);
        BigDecimal basea = perceptorBean.getValorAsBigDecimal(ERR_BASEA);
        boolean[] causa = (boolean[])perceptorBean.getValor(ERR_CAUSA);
        boolean minorado = (Boolean)perceptorBean.getValor(ERR_MINORADO);
        BigDecimal minopagoa = perceptorBean.getValorAsBigDecimal(ERR_MINOPAGOA);
        BigDecimal percibido = perceptorBean.getValorAsBigDecimal(ERR_PERCIBIDO);
        BigDecimal retriba = perceptorBean.getValorAsBigDecimal(ERR_RETRIBA);
        BigDecimal importea = perceptorBean.getValorAsBigDecimal("importea");
        boolean resiceme = (Boolean)perceptorBean.getValor("resiceme");
        boolean rencemea = (Boolean)perceptorBean.getValor("rencemea");
        boolean renceme = (Boolean)perceptorBean.getValor("renceme");
        if (regularizacion) {
            int i3;
            if (causa[9]) {
                i3 = 1;
                while (i3 <= 11) {
                    if (causa[i3] && i3 != 9) {
                        perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9032", REGULARIZACION_INCOMPATIBLES_ENTRE_SI, ERR_CAUSA, 9));
                        break;
                    }
                    ++i3;
                }
                if (!presviv.booleanValue()) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9033", "Si el perceptor no comunica que efect\u00faa pagos por pr\u00e9stamos, la causa de regularizaci\u00f3n no puede ser la realizaci\u00f3n de pagos por pr\u00e9stamos destinados para la adquisici\u00f3n de la vivienda habitual.", ERR_PRESVIV, -1));
                }
                if (basea.compareTo(BigDecimal.ZERO) > 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9034", "Base para calcular el tipo de retenci\u00f3n determinada antes de la regularizaci\u00f3n incompatible con la causa de regularizaci\u00f3n consignada.", ERR_BASEA, -1));
                }
                if (minperfaa.compareTo(BigDecimal.ZERO) > 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9035", "M\u00ednimo personal y familiar determinado antes de la regularizaci\u00f3n incompatible con la causa de regularizaci\u00f3n consignada.", ERR_MINPERFAA, -1));
                }
                if (tipoa.compareTo(BigDecimal.ZERO) > 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9036", "Tipo de retenci\u00f3n aplicado con anterioridad a la regularizaci\u00f3n incompatible con la causa de regularizaci\u00f3n consignada.", ERR_TIPOA, -1));
                }
            }
            if (causa[10]) {
                i3 = 1;
                while (i3 <= 11) {
                    if (causa[i3] && i3 != 10) {
                        perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9037", REGULARIZACION_INCOMPATIBLES_ENTRE_SI, ERR_CAUSA, 10));
                        break;
                    }
                    ++i3;
                }
                if (basea.compareTo(BigDecimal.ZERO) > 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9038", "Base para calcular el tipo de retenci\u00f3n determinada antes de la regularizaci\u00f3n incompatible con la causa de regularizaci\u00f3n consignada.", ERR_BASEA, -1));
                }
                if (minperfaa.compareTo(BigDecimal.ZERO) > 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9039", "M\u00ednimo personal y familiar determinado antes de la regularizaci\u00f3n incompatible con la causa de regularizaci\u00f3n consignada.", ERR_MINPERFAA, -1));
                }
                if (tipoa.compareTo(BigDecimal.ZERO) > 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9040", "Tipo de retenci\u00f3n aplicado con anterioridad a la regularizaci\u00f3n incompatible con la causa de regularizaci\u00f3n consignada.", ERR_TIPOA, -1));
                }
                if (presviv.booleanValue() && retrib.compareTo(LIMITE_33007_CON_20) < 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9041", "Si el perceptor ha comunicado que efect\u00faa pagos para el pr\u00e9stamo de su vivienda la causa de regularizaci\u00f3n no puede ser la improcedencia de reducci\u00f3n del tipo de retenci\u00f3n por pagos de pr\u00e9stamos destinados a la adquisici\u00f3n o rehabilitaci\u00f3n de su vivienda habitual.", ERR_PRESVIV, -1));
                }
            }
            if (minorado && minopagoa.compareTo(BigDecimal.ZERO) == 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9042", "Debe consignar el importe de la minoraci\u00f3n por pagos de pr\u00e9stamos para vivienda antes de la regularizaci\u00f3n.", ERR_MINOPAGOA, -1));
            }
            if (minorado && (minopagoa.compareTo(BD66014) > 0 || minopagoa.compareTo(retriba.multiply(CERODOS).setScale(2, 1)) > 0)) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9044", "El importe de la minoraci\u00f3n por pagos de pr\u00e9stamos para vivienda determinado antes de la regularizaci\u00f3n no puede superar el 2 por 100 de las retribuciones totales anuales determinadas antes de la regularizaci\u00f3n ni tampoco ser mayor de 660,14 euros.", ERR_MINORADO, -1));
            }
            if (!causa[9] && !causa[11] && presviv.booleanValue() && !minorado) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9045", "Si el perceptor ha comunicado que realiza pagos para el pr\u00e9stamo de su vivienda y antes de la regularizaci\u00f3n no se aplic\u00f3 minoraci\u00f3n por dicho concepto por pagos, la causa de regularizaci\u00f3n debe ser \"El perceptor ha comunicado que realiza pagos por pr\u00e9stamos destinados a la adquisici\u00f3n o rehabilitaci\u00f3n de su vivienda habitual\".", ERR_MINORADO, -1));
            }
            if (causa[11]) {
                i3 = 1;
                while (i3 <= 11) {
                    if (causa[i3] && i3 != 11) {
                        perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9046", REGULARIZACION_INCOMPATIBLES_ENTRE_SI, ERR_CAUSA, 11));
                        break;
                    }
                    ++i3;
                }
                if (importea.compareTo(BigDecimal.ZERO) > 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9051", "Retenciones totales anuales determinadas antes de la regularizaci\u00f3n incompatible con Otras causas de regularizaci\u00f3n.", ERR_CAUSA, 11));
                }
                if (basea.compareTo(BigDecimal.ZERO) > 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9053", "Base para calcular el tipo de retenci\u00f3n determinada antes de la regularizaci\u00f3n incompatible con Otras causas de regularizaci\u00f3n.", ERR_CAUSA, 11));
                }
                if (minperfaa.compareTo(BigDecimal.ZERO) > 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9054", "M\u00ednimo personal y familiar determinado antes de la regularizaci\u00f3n incompatible con Otras causas de regularizaci\u00f3n.", ERR_CAUSA, 11));
                }
                if (tipoa.compareTo(BigDecimal.ZERO) > 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9055", "Tipo de retenci\u00f3n aplicado con anterioridad a la regularizaci\u00f3n incompatible con Otras causas de regularizaci\u00f3n.", ERR_CAUSA, 11));
                }
                if (retriba.compareTo(BigDecimal.ZERO) > 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9047", "Retribuciones anuales consideradas con anterioridad a la regularizaci\u00f3n incompatible con Otras causas de regularizaci\u00f3n.", ERR_CAUSA, 11));
                }
                if (rencemea) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9048", "Los rendimientos anteriores a la regularizaci\u00f3n fueron obtenidos en Ceuta o Melilla incompatible con Otras causas de regularizaci\u00f3n.", ERR_CAUSA, 11));
                }
                if (minorado) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9049", "En alg\u00fan momento antes de la regularizaci\u00f3n se aplic\u00f3 minoraci\u00f3n por pagos de pr\u00e9stamos para vivienda es incompatible con otras causas de regularizaci\u00f3n.", ERR_CAUSA, 11));
                }
                if (minopagoa.compareTo(BigDecimal.ZERO) != 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9050", "Importe de la minoraci\u00f3n por pagos de pr\u00e9stamos para vivienda determinado antes de la regularizaci\u00f3n es incompatible con otras causas de regularizaci\u00f3n.", ERR_CAUSA, 11));
                }
            } else if (!causa[11]) {
                if (retriba.compareTo(percibido) < 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9056", "Las Retribuciones ya satisfechas con anterioridad a la regularizaci\u00f3n no pueden ser superiores a las Retribuciones anuales consideradas con anterioridad.", ERR_RETRIBA, -1));
                }
                if (retriba.compareTo(BigDecimal.ZERO) == 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9057", "Las retribuciones anuales consideradas con anterioridad a la regularizaci\u00f3n son obligatorias.", ERR_RETRIBA, -1));
                }
                if (!causa[9] && !causa[10] && minperfaa.compareTo(BigDecimal.ZERO) == 0) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9058", "M\u00ednimo personal y familiar determinado antes de la regularizaci\u00f3n es obligatorio.", ERR_MINPERFAA, -1));
                }
            }
            if (percibido.compareTo(BigDecimal.ZERO) == 0) {
                if (!desdeFichero) {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9059", "Las retribuciones ya satisfechas con anterioridad a la regularizaci\u00f3n son obligatorias.", ERR_PERCIBIDO, -1));
                } else {
                    perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9060", "Falta contenido en Retribuciones ya satisfechas.", ERR_PERCIBIDO, -1));
                }
            }
            if (retrib.compareTo(percibido) <= 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9061", "Las Retribuciones totales consignadas en Datos econ\u00f3micos (importes anuales) no pueden ser inferiores o iguales a las Retribuciones ya satisfechas con anterioridad a la regularizaci\u00f3n.", ERR_RETRIB, -1));
            }
            i3 = 1;
            while (i3 < causa.length) {
                if (causa[i3]) break;
                ++i3;
            }
            if (i3 == causa.length) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9062", "No ha seleccionado ninguna causa de regularizaci\u00f3n.", ERR_CAUSA, -1));
            }
            if (causa[3] && perceptorBean.getValorAsBigDecimal("conyuge").compareTo(BigDecimal.ZERO) == 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9063", "No ha consignado el importe de la Pensi\u00f3n compensatoria a favor del c\u00f3nyuge.", "conyuge", -1));
            }
            if (causa[4] && perceptorBean.getValorAsBigDecimal("anualidades").compareTo(BigDecimal.ZERO) == 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9064", "No ha consignado el importe de las Anualidades por alimentos a favor de hijos.", "anualidades", -1));
            }
            if (causa[5] && situFam != 3) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9065", "Si selecciona como causa de regularizaci\u00f3n el cambio de la situaci\u00f3n familiar '2' a la situaci\u00f3n familiar '3', s\u00f3lo puede seleccionar situaci\u00f3n familiar '3'.", ERR_SITUFAM, -1));
            }
            if (causa[6] && causa[7] || causa[6] && causa[8] || causa[7] && causa[8]) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9066", "Ha seleccionado dos causas de regularizaci\u00f3n incompatibles entre s\u00ed.", ERR_CAUSA, -1));
            }
            if (resiceme && causa[6]) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9068", "Si el contribuyente es residente en Ceuta o Melilla, la causa de regularizaci\u00f3n no puede ser la p\u00e9rdida de la condici\u00f3n de residente en Ceuta o Melilla.", ERR_CAUSA, 6));
            }
            if (!resiceme && causa[7]) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9069", "Si el contribuyente no es residente en Ceuta o Melilla, la causa de regularizaci\u00f3n no puede ser la adquisici\u00f3n de la condici\u00f3n de residente en Ceuta o Melilla.", ERR_CAUSA, 7));
            }
            if (!resiceme && causa[8]) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9070", "Si el contribuyente no es residente en Ceuta o Melilla, la causa de regularizaci\u00f3n no puede ser comenzar a realizar trabajos fuera de Ceuta o Melilla por residentes en Ceuta o Melilla.", "resiceme", -1));
            }
            if (renceme && causa[8]) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9071", "Si el contribuyente obtiene rendimientos en Ceuta o Melilla, la causa de Regularizaci\u00f3n no puede ser comenzar a realizar trabajos fuera de Ceuta o Melilla.", ERR_CAUSA, 8));
            }
            if (!rencemea && causa[6]) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9072", "Si el contribuyente no obten\u00eda rendimientos en Ceuta o Melilla con anterioridad a la regularizaci\u00f3n, no podr\u00e1 seleccionar como causa de regularizaci\u00f3n la p\u00e9rdida de la condici\u00f3n de residente en Ceuta o Melilla.", ERR_CAUSA, 6));
            }
            if (!rencemea && causa[8]) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9073", "Si el contribuyente no obten\u00eda rendimientos en Ceuta o Melilla con anterioridad a la regularizaci\u00f3n, la causa de \u00e9sta no puede ser comenzar a realizar trabajos fuera de Ceuta o Melilla.", ERR_CAUSA, 8));
            }
            if (tipoa.compareTo(BigDecimal.ZERO) < 0 || tipoa.compareTo(PerceptorBeanTipos.TIPO_MAXIMO_N2019) > 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9074", "Tipo de retenci\u00f3n anterior debe estar comprendido entre 0 y " + PerceptorBeanTipos.TIPO_MAXIMO_N2019.intValue() + ".", ERR_TIPOA, -1));
            }
            if (retrib.compareTo(retriba) > 0 && (causa[9] || causa[10])) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9079", "La causa de regularizaci\u00f3n consignada es incompatible con el aumento del importe de las retribuciones totales anuales. En consecuencia, deber\u00e1n efectuarse dos regularizaciones sucesivas: la primera, por la causa consignada, sin considerar el aumento de retribuciones, y la segunda, por la causa de regularizaci\u00f3n correspondiente a dicho aumento.", ERR_CAUSA, 9));
            }
            if (retrib.compareTo(retriba) < 0 && (causa[9] || causa[10])) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9080", "La causa de regularizaci\u00f3n consignada es incompatible con la disminuci\u00f3n del importe de las retribuciones totales anuales. En consecuencia, deber\u00e1n efectuarse dos regularizaciones sucesivas: la primera, por la causa de regularizaci\u00f3n correspondiente a la disminuci\u00f3n de retribuciones, y la segunda, por la causa de regularizaci\u00f3n consignada.", ERR_CAUSA, 9));
            }
            if (causa[10] && presviv.booleanValue()) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9081", "La causa de regularizaci\u00f3n consignada es incompatible con la activaci\u00f3n de la casilla de la pantalla de Datos Econ\u00f3micos relativa a los pagos por pr\u00e9stamos destinados a la vivienda habitual del perceptor. En consecuencia, deber\u00e1 desactivarse dicha casilla.", ERR_PRESVIV, -1));
            }
            if (causa[10] && minopagoa.compareTo(BigDecimal.ZERO) == 0 && !minorado) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9082", "Si la causa de regularizaci\u00f3n es la 10 debe indicar, que en alg\u00fan momento se aplic\u00f3 la minoraci\u00f3n por pagos y consignar el importe de la misma anteriormente determinado.", ERR_MINOPAGOA, -1));
            }
            if (!causa[10] && !presviv.booleanValue() && minopagoa.compareTo(CERODOS.multiply(percibido)) > 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9086", "El importe de la minoraci\u00f3n por pagos de pr\u00e9stamos para vivienda determinado antes de la regularizaci\u00f3n no puede superar el 2 por 100 de las retribuciones ya satisfechas con anterioridad a la regularizaci\u00f3n.", ERR_MINOPAGOA, -1));
            }
        } else if (!regularizacion) {
            if (percibido.compareTo(BigDecimal.ZERO) > 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9087", "Retribuciones ya satisfechas con anterioridad a la regularizaci\u00f3n incompatible con Regularizaci\u00f3n no cumplimentada.", ERR_PERCIBIDO, -1));
            }
            if (perceptorBean.getValorAsBigDecimal("retenido").compareTo(BigDecimal.ZERO) > 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9088", "Retenciones e ingresos a cuenta ya practicados incompatible con Regularizaci\u00f3n no cumplimentada.", "retenido", -1));
            }
            if (retriba.compareTo(BigDecimal.ZERO) > 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9089", "Retribuciones anuales consideradas con anterioridad a la regularizaci\u00f3n incompatible con Regularizaci\u00f3n no cumplimentada.", ERR_RETRIBA, -1));
            }
            if (importea.compareTo(BigDecimal.ZERO) > 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9090", "Retenciones totales anuales determinadas antes de la regularizaci\u00f3n incompatible con Regularizaci\u00f3n no cumplimentada.", "importea", -1));
            }
            if (rencemea) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9077", "Los rendimientos anteriores a la regularizaci\u00f3n fueron obtenidos en Ceuta o Melilla incompatible con Regularizaci\u00f3n no cumplimentada.", ERR_CAUSA, -1));
            }
            if (basea.compareTo(BigDecimal.ZERO) > 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9091", "Base para calcular el tipo de retenci\u00f3n determinada antes de la regularizaci\u00f3n incompatible con Regularizaci\u00f3n no cumplimentada.", ERR_BASEA, -1));
            }
            if (minperfaa.compareTo(BigDecimal.ZERO) > 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9092", "M\u00ednimo personal y familiar determinado antes de la regularizaci\u00f3n incompatible con Regularizaci\u00f3n no cumplimentada.", ERR_MINPERFAA, -1));
            }
            if (tipoa.compareTo(BigDecimal.ZERO) > 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9093", "Tipo de retenci\u00f3n aplicado con anterioridad a la regularizaci\u00f3n incompatible con Regularizaci\u00f3n no cumplimentada.", ERR_TIPOA, -1));
            }
            if (minorado) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9075", "Minoraci\u00f3n por pagos de pr\u00e9stamos para vivienda antes de la regularizaci\u00f3n incompatible con Regularizaci\u00f3n no cumplimentada.", ERR_MINORADO, -1));
            }
            if (minopagoa.compareTo(BigDecimal.ZERO) != 0) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9076", "Importe de la minoraci\u00f3n por pagos de pr\u00e9stamos para vivienda antes de la regularizaci\u00f3n incompatible con Regularizaci\u00f3n no cumplimentada.", "minopago", -1));
            }
            int i4 = 1;
            while (i4 <= causa.length) {
                if (!causa[i4]) break;
                ++i4;
            }
            if (i4 == causa.length) {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9078", "Si no hay Regularizaci\u00f3n no puede seleccionar ninguna causa de Regularizaci\u00f3n.", ERR_CAUSA, -1));
            }
        }
        return perceptorBean.getErr().isEmpty();
    }

    @Override
    public void calcular(PerceptorBean perceptorBean) {
        this.calculosGastosDeducibles(perceptorBean);
        this.rendimientoNetoTrabajo(perceptorBean);
        this.reduccionPorObtencionDeRendimientosDelTrabajo(perceptorBean);
        this.rendimientoNetoReducido(perceptorBean);
        this.reduccionPensionistaDeLaSSOClasesPasivas(perceptorBean);
        this.reduccionMasDe2Descendientes(perceptorBean);
        this.reduccionPorSerDesempleado(perceptorBean);
        this.minimoPersonalYFamiliar(perceptorBean);
        this.baseParaCalcularElTipoDeretencion(perceptorBean);
        this.cuotaDeRetencion(perceptorBean);
        this.tipoPrevioRetencion(perceptorBean);
        this.aplicacionReduccionPagoPrestamos(perceptorBean);
        this.tipoDeRetencionAplicable(perceptorBean);
        this.importeAnualRetencionesIngresosACuenta(perceptorBean);
        if (((Boolean)perceptorBean.getValor("regularizacion")).booleanValue()) {
            this.regularizacion(perceptorBean);
        }
    }

    private void regularizacion(PerceptorBean perceptorBean) {
        BigDecimal aux;
        BigDecimal aux2;
        BigDecimal aux1;
        boolean[] causa = (boolean[])perceptorBean.getValor(ERR_CAUSA);
        Boolean rencemea = (Boolean)perceptorBean.getValor("rencemea");
        Boolean resiceme = (Boolean)perceptorBean.getValor("resiceme");
        Boolean renceme = (Boolean)perceptorBean.getValor("renceme");
        Boolean ceumeli = (Boolean)perceptorBean.getValor("ceumeli");
        BigDecimal retrib = perceptorBean.getValorAsBigDecimal(ERR_RETRIB);
        BigDecimal retriba = perceptorBean.getValorAsBigDecimal(ERR_RETRIBA);
        BigDecimal percibido = perceptorBean.getValorAsBigDecimal(ERR_PERCIBIDO);
        BigDecimal cuota = perceptorBean.getValorAsBigDecimal("cuota");
        if (ceumeli.booleanValue() && !rencemea.booleanValue() && causa[7]) {
            aux1 = percibido.multiply(cuota.divide(retrib, 10, 4));
            aux2 = retrib.subtract(percibido).multiply(cuota.multiply(BD040).divide(retrib, 10, 4));
            perceptorBean.setValor("importereg", aux1.add(aux2));
            perceptorBean.escribirDesarrollo("IMPORTEREG = " + percibido + " * (" + cuota + " / " + retrib + " + (" + retrib + " - " + percibido + ") * (" + cuota + " * 0.40) / " + retrib + " = " + perceptorBean.getValor("importereg"));
        } else if (resiceme.booleanValue() && !renceme.booleanValue() && rencemea.booleanValue() && causa[8]) {
            aux1 = percibido.multiply(cuota.multiply(BD040).divide(retrib, 10, 4));
            aux2 = retrib.subtract(percibido).multiply(cuota.divide(retrib, 10, 4));
            perceptorBean.setValor("importereg", aux1.add(aux2));
            perceptorBean.escribirDesarrollo("IMPORTEREG = " + percibido + " * (" + cuota + " * 0.40) / " + retrib + " + (" + retrib + " - " + percibido + ") * " + cuota + " / " + retrib + " = " + perceptorBean.getValor("importereg"));
        } else if (ceumeli.booleanValue() && rencemea.booleanValue()) {
            perceptorBean.setValor("importereg", cuota.multiply(BD040));
            perceptorBean.escribirDesarrollo("IMPORTEREG = " + cuota + " * 0,40");
        } else {
            perceptorBean.setValor("importereg", cuota);
            perceptorBean.escribirDesarrollo("IMPORTEREG = " + cuota);
        }
        aux1 = null;
        aux2 = null;
        Boolean presviv = (Boolean)perceptorBean.getValor(ERR_PRESVIV);
        Boolean minorado = (Boolean)perceptorBean.getValor(ERR_MINORADO);
        BigDecimal minopagoa = perceptorBean.getValorAsBigDecimal(ERR_MINOPAGOA);
        if (causa[1] || causa[2] || causa[3] || causa[4] || causa[5] || causa[6] || causa[7] || causa[8]) {
            if (minorado.booleanValue() && presviv.booleanValue() && retrib.compareTo(LIMITE_33007_CON_20) < 0) {
                aux = retrib.subtract(retriba).abs();
                if (retrib.compareTo(retriba) > 0) {
                    perceptorBean.setValor("minopago", minopagoa.add(aux.multiply(CERODOS)));
                    perceptorBean.escribirDesarrollo("MINOPAGO = " + minopagoa + " + 2% * (" + retriba + " \u2013 " + retrib + ")");
                } else if (retrib.compareTo(retriba) < 0) {
                    perceptorBean.setValor("minopago", minopagoa.subtract(aux.multiply(CERODOS)));
                    perceptorBean.escribirDesarrollo("MINOPAGO = " + minopagoa + " - 2% * (" + retriba + " \u2013 " + retrib + ")");
                } else {
                    perceptorBean.setValor("minopago", minopagoa);
                    perceptorBean.escribirDesarrollo("MINOPAGO = " + minopagoa);
                }
            } else if (minorado.booleanValue() && !presviv.booleanValue()) {
                perceptorBean.setValor("minopago", minopagoa);
                perceptorBean.escribirDesarrollo("MINOPAGO = " + minopagoa);
            } else {
                perceptorBean.setValor("minopago", BigDecimal.ZERO);
                perceptorBean.escribirDesarrollo("MINOPAGO = 0  ");
            }
        } else if (causa[9] && presviv.booleanValue() && retrib.compareTo(LIMITE_33007_CON_20) < 0) {
            aux = retrib.subtract(percibido);
            if (minorado.booleanValue()) {
                perceptorBean.setValor("minopago", minopagoa.add(aux.multiply(CERODOS)));
                perceptorBean.escribirDesarrollo("MINOPAGO = " + minopagoa + " + 2% * (" + retrib + " \u2013 " + percibido + ")");
            } else {
                perceptorBean.setValor("minopago", aux.multiply(CERODOS));
                perceptorBean.escribirDesarrollo("MINOPAGO = 2% * (" + retrib + " \u2013 " + percibido + ")");
            }
        } else if (causa[10] && minorado.booleanValue() && !presviv.booleanValue()) {
            aux = retrib.subtract(percibido).multiply(CERODOS);
            perceptorBean.setValor("minopago", minopagoa.subtract(aux));
            perceptorBean.escribirDesarrollo("MINOPAGO = " + minopagoa + " - 2% * (" + retrib + " \u2013 " + percibido + ")");
        } else if (causa[11] && presviv.booleanValue() && retrib.compareTo(LIMITE_33007_CON_20) < 0) {
            aux1 = retrib.subtract(percibido);
            perceptorBean.setValor("minopago", aux1.multiply(CERODOS));
            perceptorBean.escribirDesarrollo("MINOPAGO = 2% * (" + retrib + " \u2013 " + percibido + ")");
        } else {
            perceptorBean.setValor("minopago", BigDecimal.ZERO);
            perceptorBean.escribirDesarrollo("MINOPAGO = 0");
        }
        if (presviv.booleanValue() && perceptorBean.getValorAsBigDecimal("minopago").compareTo(PerceptorBeanTipos.PORCENTAJE2) > 0) {
            perceptorBean.setValor("minopago", PerceptorBeanTipos.PORCENTAJE2);
            perceptorBean.escribirDesarrollo("MINOPAGO = 2,00%*33.007,20");
        }
        perceptorBean.setValor("minopago", perceptorBean.getValorAsBigDecimal("minopago").setScale(2, 1));
        perceptorBean.escribirDesarrollo("MINOPAGO = " + perceptorBean.getValor("minopago"));
        aux = CERODOS.multiply(LIMITE_33007_CON_20).setScale(2, 4);
        if (perceptorBean.getValorAsBigDecimal("minopago").compareTo(aux) > 0) {
            perceptorBean.setValor("minopago", aux);
        }
        aux = null;
        BigDecimal dividendo = perceptorBean.getValorAsBigDecimal("importereg").subtract(perceptorBean.getValorAsBigDecimal("retenido")).subtract(perceptorBean.getValorAsBigDecimal("minopago"));
        BigDecimal divisor = retrib.subtract(percibido);
        BigDecimal resul = dividendo.divide(divisor, 10, 4);
        perceptorBean.setValor("tiporeg", resul.movePointRight(2));
        perceptorBean.escribirDesarrollo("TIPOREG = [( " + perceptorBean.getValorAsBigDecimal("importereg") + " - " + perceptorBean.getValorAsBigDecimal("retenido") + " - " + perceptorBean.getValorAsBigDecimal("minopago") + ") / (" + retrib + " - " + percibido + ")] * 100 = " + perceptorBean.getValor("tiporeg"));
        dividendo = null;
        divisor = null;
        resul = null;
        if (perceptorBean.getValorAsBigDecimal("tiporeg").compareTo(BigDecimal.ZERO) < 0) {
            perceptorBean.setValor("tiporeg", BigDecimal.ZERO);
            perceptorBean.escribirDesarrollo("TIPOREG = 0,00");
        }
        perceptorBean.setValor("tiporeg", perceptorBean.getValorAsBigDecimal("tiporeg").setScale(2, 1));
        perceptorBean.escribirDesarrollo("TIPOREG = " + perceptorBean.getValor("tiporeg"));
        int situper = (Integer)perceptorBean.getValor("situper");
        int contrato = (Integer)perceptorBean.getValor("contrato");
        if (ceumeli.booleanValue()) {
            if (rencemea.booleanValue() && perceptorBean.getValorAsBigDecimal("tiporeg").compareTo(PerceptorBeanTipos.TIPO_MAXIMO_CEUTA_N2019) > 0) {
                perceptorBean.setValor("tiporeg", PerceptorBeanTipos.TIPO_MAXIMO_CEUTA_N2019);
                perceptorBean.escribirDesarrollo("TIPOREG = 18,00");
            } else if (perceptorBean.getValorAsBigDecimal("tiporeg").compareTo(PerceptorBeanTipos.TIPO_MAXIMO_N2019) > 0) {
                perceptorBean.setValor("tiporeg", PerceptorBeanTipos.TIPO_MAXIMO_N2019);
                perceptorBean.escribirDesarrollo("TIPOREG = 45,00 ");
            } else if (situper == 1 && contrato == 3) {
                perceptorBean.setValor("tiporeg", perceptorBean.getValorAsBigDecimal("tiporeg").max(PerceptorBeanTipos.TIPO_MINIMO_RELACIONESPECIAL_CEUTA));
                perceptorBean.escribirDesarrollo("TIPOREG = 6,00");
            } else if (situper == 1 && contrato == 2) {
                perceptorBean.setValor("tiporeg", perceptorBean.getValorAsBigDecimal("tiporeg").max(PerceptorBeanTipos.TIPO_MINIMO_PEONADAS_CEUTA));
                perceptorBean.escribirDesarrollo("TIPOREG = 0,80");
            }
        } else if (perceptorBean.getValorAsBigDecimal("tiporeg").compareTo(PerceptorBeanTipos.TIPO_MAXIMO_N2019) > 0) {
            perceptorBean.setValor("tiporeg", PerceptorBeanTipos.TIPO_MAXIMO_N2019);
            perceptorBean.escribirDesarrollo("TIPOREG = 45,00");
        } else if (situper == 1 && contrato == 3) {
            perceptorBean.setValor("tiporeg", perceptorBean.getValorAsBigDecimal("tiporeg").max(PerceptorBeanTipos.TIPO_MINIMO_REL_ESPECIALES));
            perceptorBean.escribirDesarrollo("TIPOREG = 15,00");
        } else if (situper == 1 && contrato == 2) {
            perceptorBean.setValor("tiporeg", perceptorBean.getValorAsBigDecimal("tiporeg").max(PerceptorBeanTipos.TIPO_MINIMO_PEONADAS));
            perceptorBean.escribirDesarrollo("TIPOREG = 2,00");
        }
        perceptorBean.setValor("importe", retrib.subtract(percibido).multiply(perceptorBean.getValorAsBigDecimal("tiporeg")).movePointLeft(2).add(perceptorBean.getValorAsBigDecimal("retenido")).setScale(2, 4));
        perceptorBean.escribirDesarrollo("IMPORTE = REDONDEAR ({[(" + retrib + " \u2013 " + percibido + ") * " + perceptorBean.getValorAsBigDecimal("tiporeg") + "] / 100 + " + perceptorBean.getValorAsBigDecimal("retenido") + ") = " + perceptorBean.getValor("importe"));
        if (!(causa[5] || causa[6] || causa[8] || causa[9] || causa[10] || causa[11])) {
            boolean revisar = false;
            BigDecimal diferencia = perceptorBean.getValorAsBigDecimal(ERR_BASEA).subtract(perceptorBean.getValorAsBigDecimal(ERR_MINPERFAA)).compareTo(BigDecimal.ZERO) > 0 ? perceptorBean.getValorAsBigDecimal(ERR_BASEA).subtract(perceptorBean.getValorAsBigDecimal(ERR_MINPERFAA)) : BigDecimal.ZERO;
            perceptorBean.escribirDesarrollo("DIFERENCIA = (" + perceptorBean.getValorAsBigDecimal(ERR_BASEA) + " \u2013 " + perceptorBean.getValorAsBigDecimal(ERR_MINPERFAA) + " = " + diferencia);
            BigDecimal increimporte = BigDecimal.ZERO;
            BigDecimal increbasemin = BigDecimal.ZERO;
            if (diferencia.compareTo(perceptorBean.getValorAsBigDecimal("base").subtract(perceptorBean.getValorAsBigDecimal("minperfa"))) >= 0 && perceptorBean.getValorAsBigDecimal("tiporeg").compareTo(perceptorBean.getValorAsBigDecimal(ERR_TIPOA)) > 0) {
                perceptorBean.setValor("tiporeg", perceptorBean.getValorAsBigDecimal(ERR_TIPOA));
                perceptorBean.escribirDesarrollo("TIPOREG = " + perceptorBean.getValorAsBigDecimal(ERR_TIPOA));
                revisar = true;
            } else if (diferencia.compareTo(perceptorBean.getValorAsBigDecimal("base").subtract(perceptorBean.getValorAsBigDecimal("minperfa"))) < 0 && perceptorBean.getValorAsBigDecimal("importea").compareTo(perceptorBean.getValorAsBigDecimal("importe")) < 0) {
                increimporte = perceptorBean.getValorAsBigDecimal("importe").subtract(perceptorBean.getValorAsBigDecimal("importea"));
                perceptorBean.escribirDesarrollo("INCREIMPORTE = " + perceptorBean.getValorAsBigDecimal("importe") + " - " + perceptorBean.getValorAsBigDecimal("importea"));
                increbasemin = perceptorBean.getValorAsBigDecimal("base").subtract(perceptorBean.getValorAsBigDecimal("minperfa")).subtract(diferencia);
                perceptorBean.escribirDesarrollo("INCREBASEMIN = (" + perceptorBean.getValorAsBigDecimal("base") + " - " + perceptorBean.getValorAsBigDecimal("minperfa") + ") - " + diferencia + " = " + increbasemin);
                if (increimporte.compareTo(increbasemin) > 0) {
                    revisar = true;
                    perceptorBean.setValor("importe", perceptorBean.getValorAsBigDecimal("importea").add(increbasemin));
                    perceptorBean.escribirDesarrollo("IMPORTE = " + perceptorBean.getValorAsBigDecimal("importea") + " + " + increbasemin + " = " + perceptorBean.getValor("importe"));
                    perceptorBean.setValor("tiporeg", perceptorBean.getValorAsBigDecimal("importe").subtract(perceptorBean.getValorAsBigDecimal("retenido")).divide(retrib.subtract(percibido), 10, 4).movePointRight(2));
                    perceptorBean.escribirDesarrollo("TIPOREG = [( " + perceptorBean.getValorAsBigDecimal("importe") + " - " + perceptorBean.getValorAsBigDecimal("retenido") + ") / (" + retrib + " - " + percibido + ")] * 100  = " + perceptorBean.getValor("tiporeg"));
                    if (perceptorBean.getValorAsBigDecimal("tiporeg").compareTo(BigDecimal.ZERO) < 0) {
                        perceptorBean.setValor("tiporeg", BigDecimal.ZERO);
                        perceptorBean.escribirDesarrollo("TIPOREG = 0");
                    } else {
                        perceptorBean.setValor("tiporeg", perceptorBean.getValorAsBigDecimal("tiporeg").setScale(2, 1));
                        perceptorBean.escribirDesarrollo("TIPOREG = " + perceptorBean.getValor("tiporeg"));
                        perceptorBean.setValor("importe", retrib.subtract(percibido).multiply(perceptorBean.getValorAsBigDecimal("tiporeg")).movePointLeft(2).add(perceptorBean.getValorAsBigDecimal("retenido")));
                        perceptorBean.escribirDesarrollo("IMPORTE = [( " + retrib + " - " + percibido + ") * " + perceptorBean.getValorAsBigDecimal("tiporeg") + "] / 100 } + " + perceptorBean.getValorAsBigDecimal("retenido") + " = " + perceptorBean.getValor("importe"));
                        increimporte = perceptorBean.getValorAsBigDecimal("importe").subtract(perceptorBean.getValorAsBigDecimal("importea"));
                        perceptorBean.escribirDesarrollo("INCREIMPORTE = " + perceptorBean.getValorAsBigDecimal("importe") + " - " + perceptorBean.getValorAsBigDecimal("importea") + " = " + increimporte);
                    }
                    if (increimporte.compareTo(increbasemin) > 0 && perceptorBean.getValorAsBigDecimal("tiporeg").compareTo(BigDecimal.ZERO) > 0) {
                        perceptorBean.setValor("tiporeg", perceptorBean.getValorAsBigDecimal("importea").add(increbasemin).subtract(perceptorBean.getValorAsBigDecimal("retenido")).divide(retrib.subtract(percibido), 10, 4).movePointRight(2));
                        perceptorBean.escribirDesarrollo("TIPOREG = [( " + perceptorBean.getValorAsBigDecimal("importea") + " + " + increbasemin + " - " + perceptorBean.getValorAsBigDecimal("retenido") + ") / (" + perceptorBean.getValorAsBigDecimal(ERR_RETRIB) + " - " + percibido + ")] * 100 = " + perceptorBean.getValor("tiporeg"));
                        perceptorBean.setValor("tiporeg", perceptorBean.getValorAsBigDecimal("tiporeg").setScale(2, 1));
                        perceptorBean.escribirDesarrollo("TIPOREG = TRUNCAR (TIPOREG)");
                    }
                }
            }
            increimporte = null;
            increbasemin = null;
            diferencia = null;
            if (revisar) {
                if (ceumeli.booleanValue()) {
                    if (situper == 1 && contrato == 3 && perceptorBean.getValorAsBigDecimal("tiporeg").compareTo(PerceptorBeanTipos.TIPO_MINIMO_RELACIONESPECIAL_CEUTA) < 0) {
                        perceptorBean.setValor("tiporeg", PerceptorBeanTipos.TIPO_MINIMO_RELACIONESPECIAL_CEUTA);
                        perceptorBean.escribirDesarrollo("TIPOREG = 6,00");
                    } else if (situper == 1 && contrato == 2 && perceptorBean.getValorAsBigDecimal("tiporeg").compareTo(PerceptorBeanTipos.TIPO_MINIMO_PEONADAS_CEUTA) < 0) {
                        perceptorBean.setValor("tiporeg", PerceptorBeanTipos.TIPO_MINIMO_PEONADAS_CEUTA);
                        perceptorBean.escribirDesarrollo("TIPOREG = 0,80");
                    }
                } else if (situper == 1 && contrato == 3 && perceptorBean.getValorAsBigDecimal("tiporeg").compareTo(PerceptorBeanTipos.TIPO_MINIMO_REL_ESPECIALES) < 0) {
                    perceptorBean.setValor("tiporeg", PerceptorBeanTipos.TIPO_MINIMO_REL_ESPECIALES);
                    perceptorBean.escribirDesarrollo("TIPOREG = 15");
                } else if (situper == 1 && contrato == 2 && perceptorBean.getValorAsBigDecimal("tiporeg").compareTo(PerceptorBeanTipos.TIPO_MINIMO_PEONADAS) < 0) {
                    perceptorBean.setValor("tiporeg", PerceptorBeanTipos.TIPO_MINIMO_PEONADAS);
                    perceptorBean.escribirDesarrollo("TIPOREG = 2");
                }
                perceptorBean.setValor("importe", retrib.subtract(percibido).multiply(perceptorBean.getValorAsBigDecimal("tiporeg")).movePointLeft(2).add(perceptorBean.getValorAsBigDecimal("retenido")));
                perceptorBean.escribirDesarrollo("IMPORTE = {[ ( " + perceptorBean.getValorAsBigDecimal(ERR_RETRIB) + " - " + perceptorBean.getValorAsBigDecimal(ERR_PERCIBIDO) + ") * " + perceptorBean.getValorAsBigDecimal("tiporeg") + " / 100 } + " + perceptorBean.getValorAsBigDecimal("retenido") + perceptorBean.getValor("importe"));
            }
            perceptorBean.setValor("importe", perceptorBean.getValorAsBigDecimal("importe").setScale(2, 4));
        }
    }

    private void importeAnualRetencionesIngresosACuenta(PerceptorBean perceptorBean) {
        perceptorBean.setValor("importe", perceptorBean.getValorAsBigDecimal(ERR_RETRIB).multiply(perceptorBean.getValorAsBigDecimal("tipo")).movePointLeft(2).setScale(2, 4));
        perceptorBean.escribirDesarrollo("IMPORTE = REDONDEAR1(( " + perceptorBean.getValorAsBigDecimal(ERR_RETRIB) + " * " + perceptorBean.getValorAsBigDecimal("tipo") + ") / 100 = " + perceptorBean.getValor("importe"));
    }

    private void tipoDeRetencionAplicable(PerceptorBean perceptorBean) {
        perceptorBean.setValor("tipo", perceptorBean.getValorAsBigDecimal("diferenciapositiva").divide(perceptorBean.getValorAsBigDecimal(ERR_RETRIB), 10, 4).movePointRight(2).setScale(2, 1));
        perceptorBean.escribirDesarrollo("TIPO = TRUNCAR(( " + perceptorBean.getValorAsBigDecimal("diferenciapositiva") + " / " + perceptorBean.getValorAsBigDecimal(ERR_RETRIB) + ") * 100 = " + perceptorBean.getValor("tipo"));
        int situper = (Integer)perceptorBean.getValor("situper");
        int contrato = (Integer)perceptorBean.getValor("contrato");
        if (((Boolean)perceptorBean.getValor("ceumeli")).booleanValue()) {
            if (situper == 1 && contrato == 3) {
                perceptorBean.setValor("tipo", perceptorBean.getValorAsBigDecimal("tipo").max(PerceptorBeanTipos.TIPO_MINIMO_RELACIONESPECIAL_CEUTA));
                perceptorBean.escribirDesarrollo("TIPO = 6,00");
            } else if (situper == 1 && contrato == 2) {
                perceptorBean.setValor("tipo", perceptorBean.getValorAsBigDecimal("tipo").max(PerceptorBeanTipos.TIPO_MINIMO_PEONADAS_CEUTA));
                perceptorBean.escribirDesarrollo("TIPO = 0,80");
            }
        } else if (situper == 1 && contrato == 3) {
            perceptorBean.setValor("tipo", perceptorBean.getValorAsBigDecimal("tipo").max(PerceptorBeanTipos.TIPO_MINIMO_REL_ESPECIALES));
            perceptorBean.escribirDesarrollo("TIPO = 15,00");
        } else if (situper == 1 && contrato == 2) {
            perceptorBean.setValor("tipo", perceptorBean.getValorAsBigDecimal("tipo").max(PerceptorBeanTipos.TIPO_MINIMO_PEONADAS));
            perceptorBean.escribirDesarrollo("TIPO = 2,00");
        }
    }

    private void aplicacionReduccionPagoPrestamos(PerceptorBean perceptorBean) {
        if (perceptorBean.getValorAsBigDecimal(ERR_RETRIB).compareTo(LIMITE_33007_CON_20) < 0 && ((Boolean)perceptorBean.getValor(ERR_PRESVIV)).booleanValue()) {
            perceptorBean.setValor("minopago", perceptorBean.getValorAsBigDecimal(ERR_RETRIB).multiply(CERODOS));
            perceptorBean.escribirDesarrollo("MINOPAGO = 2,00% * " + perceptorBean.getValorAsBigDecimal(ERR_RETRIB) + " = " + perceptorBean.getValor("minopago"));
        } else {
            perceptorBean.setValor("minopago", BigDecimal.ZERO);
            perceptorBean.escribirDesarrollo("MINOPAGO = 0");
        }
        perceptorBean.setValor("minopago", perceptorBean.getValorAsBigDecimal("minopago").setScale(2, 1));
        perceptorBean.escribirDesarrollo("MINOPAGO = TRUNCAR (MINOPAGO) = " + perceptorBean.getValor("minopago"));
        if (((Boolean)perceptorBean.getValor("ceumeli")).booleanValue()) {
            perceptorBean.setValor("diferenciapositiva", perceptorBean.getValorAsBigDecimal("cuota").multiply(BD040).subtract(perceptorBean.getValorAsBigDecimal("minopago")));
            perceptorBean.escribirDesarrollo("DIFERENCIA POSITIVA = (" + perceptorBean.getValorAsBigDecimal("cuota") + " * 0.40) - " + perceptorBean.getValorAsBigDecimal("minopago") + " = " + perceptorBean.getValor("diferenciapositiva"));
        } else {
            perceptorBean.setValor("diferenciapositiva", perceptorBean.getValorAsBigDecimal("cuota").subtract(perceptorBean.getValorAsBigDecimal("minopago")));
            perceptorBean.escribirDesarrollo("DIFERENCIA POSITIVA = " + perceptorBean.getValorAsBigDecimal("cuota") + " - " + perceptorBean.getValorAsBigDecimal("minopago") + " = " + perceptorBean.getValor("diferenciapositiva"));
        }
        if (perceptorBean.getValorAsBigDecimal("diferenciapositiva").compareTo(BigDecimal.ZERO) < 0) {
            perceptorBean.setValor("diferenciapositiva", BigDecimal.ZERO);
            perceptorBean.escribirDesarrollo("DIFERENCIAPOSITIVA = 0 ");
        }
    }

    private void tipoPrevioRetencion(PerceptorBean perceptorBean) {
        perceptorBean.setValor("ceumeli", (Boolean)perceptorBean.getValor("resiceme") != false && (Boolean)perceptorBean.getValor("renceme") != false);
        if (((Boolean)perceptorBean.getValor("ceumeli")).booleanValue()) {
            perceptorBean.setValor("cuotacm", perceptorBean.getValorAsBigDecimal("cuota").divide(BD2));
        } else {
            perceptorBean.setValor("cuotacm", BigDecimal.ZERO);
        }
    }

    private void cuotaDeRetencion(PerceptorBean perceptorBean) {
        this.rendimientosExentosDeRetencion(perceptorBean);
        if (((Boolean)perceptorBean.getValor("exentos")).booleanValue()) {
            perceptorBean.setValor("cuota", BigDecimal.ZERO);
            perceptorBean.setValor("tipo", BigDecimal.ZERO);
            perceptorBean.escribirDesarrollo("CUOTA = 0,00 ");
            perceptorBean.escribirDesarrollo("TIPO = 0,00");
        } else {
            this.rendimientosSujetosARetencion(perceptorBean);
        }
    }

    private void rendimientosSujetosARetencion(PerceptorBean perceptorBean) {
        BigDecimal base1 = BigDecimal.ZERO;
        BigDecimal base2 = BigDecimal.ZERO;
        BigDecimal cuota1_1 = BigDecimal.ZERO;
        BigDecimal cuota1_2 = BigDecimal.ZERO;
        BigDecimal limite = BigDecimal.ZERO;
        if (perceptorBean.getValorAsBigDecimal("anualidades").compareTo(BigDecimal.ZERO) > 0 && perceptorBean.getValorAsBigDecimal("base").subtract(perceptorBean.getValorAsBigDecimal("anualidades")).compareTo(BigDecimal.ZERO) > 0) {
            base1 = perceptorBean.getValorAsBigDecimal("base").subtract(perceptorBean.getValorAsBigDecimal("anualidades"));
            base2 = perceptorBean.getValorAsBigDecimal("anualidades");
            cuota1_1 = this.escala(base1, perceptorBean);
            cuota1_2 = this.escala(base2, perceptorBean);
            perceptorBean.setValor("cuota1", cuota1_1.add(cuota1_2));
            perceptorBean.escribirDesarrollo("CUOTA1 = " + cuota1_1 + " + " + cuota1_2);
        } else {
            perceptorBean.setValor("cuota1", this.escala(perceptorBean.getValorAsBigDecimal("base"), perceptorBean));
            perceptorBean.escribirDesarrollo("CUOTA1 = ESCALA (" + perceptorBean.getValorAsBigDecimal("base") + ") = " + perceptorBean.getValor("cuota1"));
        }
        if (perceptorBean.getValorAsBigDecimal("anualidades").compareTo(BigDecimal.ZERO) > 0 && perceptorBean.getValorAsBigDecimal("base").subtract(perceptorBean.getValorAsBigDecimal("anualidades")).compareTo(BigDecimal.ZERO) > 0) {
            perceptorBean.setValor("cuota2", this.escala(perceptorBean.getValorAsBigDecimal("minperfa").add(BD1980), perceptorBean));
            perceptorBean.escribirDesarrollo("CUOTA 2 = ESCALA (" + perceptorBean.getValorAsBigDecimal("minperfa") + " + 1980) = " + perceptorBean.getValor("cuota2"));
        } else {
            perceptorBean.setValor("cuota2", this.escala(perceptorBean.getValorAsBigDecimal("minperfa"), perceptorBean));
            perceptorBean.escribirDesarrollo("CUOTA2 = ESCALA (" + perceptorBean.getValorAsBigDecimal("minperfa") + ") = " + perceptorBean.getValor("cuota2"));
        }
        if (perceptorBean.getValorAsBigDecimal("cuota1").compareTo(perceptorBean.getValorAsBigDecimal("cuota2")) > 0) {
            perceptorBean.setValor("cuota", perceptorBean.getValorAsBigDecimal("cuota1").subtract(perceptorBean.getValorAsBigDecimal("cuota2")));
            perceptorBean.escribirDesarrollo("CUOTA = " + perceptorBean.getValorAsBigDecimal("cuota1") + " - " + perceptorBean.getValorAsBigDecimal("cuota2") + " = " + perceptorBean.getValor("cuota"));
        } else {
            perceptorBean.setValor("cuota", BigDecimal.ZERO);
            perceptorBean.escribirDesarrollo("CUOTA = 0,00");
        }
        BigDecimal retrib = perceptorBean.getValorAsBigDecimal(ERR_RETRIB);
        if (retrib.compareTo(LIMITE_22000) <= 0) {
            Integer situfam = (Integer)perceptorBean.getValor(ERR_SITUFAM);
            Integer numdes = (Integer)perceptorBean.getValor("numdes");
            BigDecimal pension = perceptorBean.getValorAsBigDecimal("pension");
            BigDecimal desem = perceptorBean.getValorAsBigDecimal("desem");
            if (situfam == 1) {
                if (numdes == 1) {
                    limite = retrib.subtract(BD15947.add(pension).add(desem)).multiply(LIMITE);
                    perceptorBean.escribirDesarrollo("LIMITE = " + retrib + " - (15.947,00 + " + perceptorBean.getValorAsBigDecimal("pension") + " + " + perceptorBean.getValorAsBigDecimal("desem") + ")] * 0,43 = " + limite);
                } else if (numdes > 1) {
                    limite = retrib.subtract(BD17100.add(pension).add(desem)).multiply(LIMITE);
                    perceptorBean.escribirDesarrollo("LIMITE = " + retrib + " - (17.100,00 + " + perceptorBean.getValorAsBigDecimal("pension") + " + " + perceptorBean.getValorAsBigDecimal("desem") + ")] * 0,43 = " + limite);
                }
            } else if (situfam == 2) {
                if (numdes == 0) {
                    limite = retrib.subtract(BD15456.add(pension).add(desem)).multiply(LIMITE);
                    perceptorBean.escribirDesarrollo("LIMITE = " + retrib + " - (15.456,00 + " + perceptorBean.getValorAsBigDecimal("pension") + " + " + perceptorBean.getValorAsBigDecimal("desem") + ")] * 0,43 = " + limite);
                } else if (numdes == 1) {
                    limite = retrib.subtract(BD16481.add(pension).add(desem)).multiply(LIMITE);
                    perceptorBean.escribirDesarrollo("LIMITE = " + retrib + " - (16.481,00 + " + perceptorBean.getValorAsBigDecimal("pension") + " + " + perceptorBean.getValorAsBigDecimal("desem") + ")] * 0,43 = " + limite);
                } else if (numdes > 1) {
                    limite = retrib.subtract(BD17634.add(pension).add(desem)).multiply(LIMITE);
                    perceptorBean.escribirDesarrollo("LIMITE = " + retrib + " - (17.634,00 + " + perceptorBean.getValorAsBigDecimal("pension") + " + " + perceptorBean.getValorAsBigDecimal("desem") + ")] * 0,43 = " + limite);
                }
            } else if (situfam == 3) {
                if (numdes == 0) {
                    limite = retrib.subtract(BD14000.add(pension).add(desem)).multiply(LIMITE);
                    perceptorBean.escribirDesarrollo("LIMITE = " + retrib + " - (14.000,00 + " + perceptorBean.getValorAsBigDecimal("pension") + " + " + perceptorBean.getValorAsBigDecimal("desem") + ")] * 0,43 = " + limite);
                } else if (numdes == 1) {
                    limite = retrib.subtract(BD14516.add(pension).add(desem)).multiply(LIMITE);
                    perceptorBean.escribirDesarrollo("LIMITE = " + retrib + " - (14.516,00 + " + perceptorBean.getValorAsBigDecimal("pension") + " + " + perceptorBean.getValorAsBigDecimal("desem") + ")] * 0,43 = " + limite);
                } else if (numdes > 1) {
                    limite = retrib.subtract(BD15093.add(pension).add(desem)).multiply(LIMITE);
                    perceptorBean.escribirDesarrollo("LIMITE = " + retrib + " - (15.093,00 + " + perceptorBean.getValorAsBigDecimal("pension") + " + " + perceptorBean.getValorAsBigDecimal("desem") + ")] * 0,43 = " + limite);
                }
            }
            if (perceptorBean.getValorAsBigDecimal("cuota").compareTo(limite) > 0 && limite.compareTo(BigDecimal.ZERO) > 0) {
                perceptorBean.setValor("cuota", limite);
                perceptorBean.escribirDesarrollo("CUOTA = " + limite);
            }
        }
        base1 = null;
        base2 = null;
        cuota1_1 = null;
        cuota1_2 = null;
        limite = null;
    }

    private BigDecimal escala(BigDecimal blt, PerceptorBean perceptroBean) {
        BigDecimal cuota;
        if (blt.compareTo(BD12450) < 0) {
            cuota = blt.multiply(BD019);
            perceptroBean.escribirDesarrollo("CUOTA = " + blt + " * 0.19 = " + cuota);
        } else if (blt.compareTo(BD20200) < 0) {
            cuota = BD236550.add(blt.subtract(BD12450).multiply(BD024));
            perceptroBean.escribirDesarrollo("CUOTA = 2365.50 + (" + blt + " - 12450.00 * 0.24) = " + cuota);
        } else if (blt.compareTo(BD35200) < 0) {
            cuota = BD42255.add(blt.subtract(BD20200).multiply(BD030));
            perceptroBean.escribirDesarrollo("CUOTA = 4225.50 + (" + blt + " - 20200.00 * 0.30) = " + cuota);
        } else if (blt.compareTo(BD60000) < 0) {
            cuota = BD872550.add(blt.subtract(BD35200).multiply(BD037));
            perceptroBean.escribirDesarrollo("CUOTA = 8725.50 + (" + blt + " - 35200.00 * 0.37) = " + cuota);
        } else {
            cuota = BD1790150.add(blt.subtract(BD60000).multiply(BD045));
            perceptroBean.escribirDesarrollo("CUOTA = 17901.50 + (" + blt + " - 60000.00 * 0.45) = " + cuota);
        }
        return cuota;
    }

    private void rendimientosExentosDeRetencion(PerceptorBean perceptorBean) {
        perceptorBean.setValor("exentos", false);
        BigDecimal pension = perceptorBean.getValorAsBigDecimal("pension");
        BigDecimal desem = perceptorBean.getValorAsBigDecimal("desem");
        BigDecimal retrib = perceptorBean.getValorAsBigDecimal(ERR_RETRIB);
        if (retrib.compareTo(BD17634.add(pension).add(desem)) <= 0) {
            Integer situfam = (Integer)perceptorBean.getValor(ERR_SITUFAM);
            Integer numdes = (Integer)perceptorBean.getValor("numdes");
            if (situfam == 1) {
                if (numdes == 1 && retrib.compareTo(BD15947.add(pension).add(desem)) <= 0) {
                    perceptorBean.setValor("exentos", true);
                    perceptorBean.escribirDesarrollo("EXENTOS = S");
                } else if (numdes > 1 && retrib.compareTo(BD17100.add(pension).add(desem)) <= 0) {
                    perceptorBean.setValor("exentos", true);
                    perceptorBean.escribirDesarrollo("EXENTOS = S");
                }
            } else if (situfam == 2) {
                if (numdes == 0 && retrib.compareTo(BD15456.add(pension).add(desem)) <= 0) {
                    perceptorBean.setValor("exentos", true);
                    perceptorBean.escribirDesarrollo("EXENTOS = S");
                } else if (numdes == 1 && retrib.compareTo(BD16481.add(pension).add(desem)) <= 0) {
                    perceptorBean.setValor("exentos", true);
                    perceptorBean.escribirDesarrollo("EXENTOS = S");
                } else if (numdes > 1 && retrib.compareTo(BD17634.add(pension).add(desem)) <= 0) {
                    perceptorBean.setValor("exentos", true);
                    perceptorBean.escribirDesarrollo("EXENTOS = S");
                }
            } else if (situfam == 3) {
                if (numdes == 0 && retrib.compareTo(BD14000.add(pension).add(desem)) <= 0) {
                    perceptorBean.setValor("exentos", true);
                    perceptorBean.escribirDesarrollo("EXENTOS = S");
                } else if (numdes == 1 && retrib.compareTo(BD14516.add(pension).add(desem)) <= 0) {
                    perceptorBean.setValor("exentos", true);
                    perceptorBean.escribirDesarrollo("EXENTOS = S");
                } else if (numdes > 1 && retrib.compareTo(BD15093.add(pension).add(desem)) <= 0) {
                    perceptorBean.setValor("exentos", true);
                    perceptorBean.escribirDesarrollo("EXENTOS = S");
                }
            }
        }
    }

    private void baseParaCalcularElTipoDeretencion(PerceptorBean perceptorBean) {
        perceptorBean.setValor("redu", perceptorBean.getValorAsBigDecimal("pension").add(perceptorBean.getValorAsBigDecimal("hijos")).add(perceptorBean.getValorAsBigDecimal("desem")).add(perceptorBean.getValorAsBigDecimal("conyuge")));
        perceptorBean.escribirDesarrollo("REDU = " + perceptorBean.getValorAsBigDecimal("pension") + " + " + perceptorBean.getValorAsBigDecimal("hijos") + " + " + perceptorBean.getValorAsBigDecimal("desem") + " + " + perceptorBean.getValorAsBigDecimal("conyuge") + " = " + perceptorBean.getValor("redu"));
        if (perceptorBean.getValorAsBigDecimal("rntredu").compareTo(perceptorBean.getValorAsBigDecimal("redu")) > 0) {
            perceptorBean.setValor("base", perceptorBean.getValorAsBigDecimal("rntredu").subtract(perceptorBean.getValorAsBigDecimal("redu")));
            perceptorBean.escribirDesarrollo("BASE = " + perceptorBean.getValorAsBigDecimal("pension") + " + " + perceptorBean.getValorAsBigDecimal("rntredu") + " - " + perceptorBean.getValorAsBigDecimal("redu") + " = " + perceptorBean.getValor("base"));
        } else {
            perceptorBean.setValor("base", BigDecimal.ZERO);
            perceptorBean.escribirDesarrollo("BASE = 0,00");
        }
    }

    private void minimoPersonalYFamiliar(PerceptorBean perceptorBean) {
        this.minimoDelContribuyente(perceptorBean);
        this.minimoPorDescendientesMenor25AniosODiscapacitados(perceptorBean);
        this.minimoPorAscendientesMayor65AniosODiscapacitados(perceptorBean);
        this.minimoPorDiscapacidad(perceptorBean);
        perceptorBean.setValor("minperfa", perceptorBean.getValorAsBigDecimal("mincon").add(perceptorBean.getValorAsBigDecimal("mindes")).add(perceptorBean.getValorAsBigDecimal("minas")).add(perceptorBean.getValorAsBigDecimal("mindis")));
    }

    private void minimoPorDiscapacidad(PerceptorBean perceptorBean) {
        this.minimoPorDiscapacidadDelContribuyente(perceptorBean);
        this.minimoPordiscapacidadDeDescendientesYAscendientes(perceptorBean);
        perceptorBean.setValor("mindis", perceptorBean.getValorAsBigDecimal("mindisc").add(perceptorBean.getValorAsBigDecimal("mdisdeas")));
    }

    private void minimoPordiscapacidadDeDescendientesYAscendientes(PerceptorBean perceptorBean) {
        List descendientes = (List)perceptorBean.getValor(ERR_DESCENDIENTES);
        int tamDesc = descendientes.size();
        descendientes = null;
        BigDecimal disDes = BigDecimal.ZERO;
        BigDecimal asisDesc = BigDecimal.ZERO;
        int i = 0;
        while (i < tamDesc) {
            DescendienteBean d = (DescendienteBean)perceptorBean.getValor(DESCENDIENTES_ORDENADOS, i);
            BigDecimal porEntero = d.isPorEntero() ? PerceptorBeanTipos.UNO : PerceptorBeanTipos.UNMEDIO;
            int disca = d.getDiscapacidad();
            if (disca == 1) {
                disDes = disDes.add(BD3000.multiply(porEntero));
            } else if (disca == 2) {
                disDes = disDes.add(BD9000.multiply(porEntero));
            }
            if (disca == 2 || disca == 1 && d.isMovilidadReducida()) {
                asisDesc = asisDesc.add(BD3000.multiply(porEntero));
            }
            d = null;
            porEntero = null;
            ++i;
        }
        perceptorBean.setValor("disdes", disDes.setScale(2, 4));
        perceptorBean.setValor("asisdes", asisDesc.setScale(2, 4));
        disDes = null;
        asisDesc = null;
        List ascendientes = (List)perceptorBean.getValor("ascendientes");
        int tamAsc = ascendientes.size();
        BigDecimal disAsc = BigDecimal.ZERO;
        BigDecimal asisAsc = BigDecimal.ZERO;
        int i2 = 0;
        while (i2 < tamAsc) {
            AscendienteBean a = (AscendienteBean)ascendientes.get(i2);
            BigDecimal convivencia = new BigDecimal(a.getConvivencia());
            int disca = a.getDiscapacidad();
            if (disca == 1) {
                disAsc = disAsc.add(BD3000.divide(convivencia, 10, 4));
            } else if (disca == 2) {
                disAsc = disAsc.add(BD9000.divide(convivencia, 10, 4));
            }
            if (disca == 2 || disca == 1 && a.isMovilidadReducida()) {
                asisAsc = asisAsc.add(BD3000.divide(convivencia, 10, 4));
            }
            a = null;
            convivencia = null;
            ++i2;
        }
        ascendientes = null;
        perceptorBean.setValor("disas", disAsc.setScale(2, 4));
        perceptorBean.setValor("asisas", asisAsc.setScale(2, 4));
        perceptorBean.setValor("mdisdeas", perceptorBean.getValorAsBigDecimal("disdes").add(perceptorBean.getValorAsBigDecimal("disas")).add(perceptorBean.getValorAsBigDecimal("asisdes")).add(perceptorBean.getValorAsBigDecimal("asisas")));
        disAsc = null;
        asisAsc = null;
    }

    private void minimoPorDiscapacidadDelContribuyente(PerceptorBean perceptorBean) {
        Integer discaper = (Integer)perceptorBean.getValor("discaper");
        if (discaper == 2) {
            perceptorBean.setValor("disper", BD9000);
        } else if (discaper == 1) {
            perceptorBean.setValor("disper", BD3000);
        } else {
            perceptorBean.setValor("disper", BigDecimal.ZERO);
        }
        if (discaper == 2 || discaper == 1 && ((Boolean)perceptorBean.getValor("movilper")).booleanValue()) {
            perceptorBean.setValor("asisper", BD3000);
        } else {
            perceptorBean.setValor("asisper", BigDecimal.ZERO);
        }
        perceptorBean.setValor("mindisc", perceptorBean.getValorAsBigDecimal("disper").add(perceptorBean.getValorAsBigDecimal("asisper")));
    }

    private void minimoPorAscendientesMayor65AniosODiscapacitados(PerceptorBean perceptorBean) {
        BigDecimal as65 = BigDecimal.ZERO;
        BigDecimal as75 = BigDecimal.ZERO;
        ArrayList ascendientes = (ArrayList)perceptorBean.getValor("ascendientes");
        if (ascendientes == null) {
            ascendientes = new ArrayList();
        }
        int nD = ascendientes.size();
        int i = 0;
        while (i < nD) {
            AscendienteBean a = (AscendienteBean)ascendientes.get(i);
            BigDecimal convivencia = new BigDecimal(a.getConvivencia());
            as65 = as65.add(BD1150.divide(convivencia, 10, 4));
            int anioAsc = a.getAnioNacimiento();
            int edadAsc = 2019 - anioAsc;
            if (edadAsc > 74) {
                as75 = as75.add(BD1400.divide(convivencia, 10, 4));
            }
            a = null;
            convivencia = null;
            ++i;
        }
        ascendientes = null;
        perceptorBean.setValor("as65", as65.setScale(2, 4));
        perceptorBean.setValor("as75", as75.setScale(2, 4));
        perceptorBean.setValor("minas", perceptorBean.getValorAsBigDecimal("as65").add(perceptorBean.getValorAsBigDecimal("as75")));
        as65 = null;
        as75 = null;
    }

    private void minimoPorDescendientesMenor25AniosODiscapacitados(PerceptorBean perceptorBean) {
        ArrayList descendientes = (ArrayList)perceptorBean.getValor(ERR_DESCENDIENTES);
        if (descendientes == null) {
            descendientes = new ArrayList();
        }
        int tamDesc = descendientes.size();
        descendientes = null;
        BigDecimal mindesg = BigDecimal.ZERO;
        BigDecimal mindes3 = BigDecimal.ZERO;
        int i = 0;
        while (i < tamDesc) {
            DescendienteBean d = (DescendienteBean)perceptorBean.getValor(DESCENDIENTES_ORDENADOS, i);
            int anioDesc = d.getAnioNacimiento();
            BigDecimal porEntero = d.isPorEntero() ? PerceptorBeanTipos.UNO : PerceptorBeanTipos.UNMEDIO;
            switch (i) {
                case 0: {
                    mindesg = mindesg.add(BD2400.multiply(porEntero));
                    break;
                }
                case 1: {
                    mindesg = mindesg.add(BD2700.multiply(porEntero));
                    break;
                }
                case 2: {
                    mindesg = mindesg.add(BD4000.multiply(porEntero));
                    break;
                }
                default: {
                    mindesg = mindesg.add(BD4500.multiply(porEntero));
                }
            }
            int anioAdop = d.getAnioAdopcion();
            if (anioDesc > 2016 || anioAdop >= anioDesc && anioAdop > 2016) {
                mindes3 = mindes3.add(BD2800.multiply(porEntero));
            }
            d = null;
            porEntero = null;
            ++i;
        }
        perceptorBean.setValor("mindesg", mindesg.setScale(2, 4));
        perceptorBean.setValor("mindes3", mindes3.setScale(2, 4));
        mindesg = null;
        mindes3 = null;
        perceptorBean.setValor("mindes", perceptorBean.getValorAsBigDecimal("mindesg").add(perceptorBean.getValorAsBigDecimal("mindes3")));
    }

    private void minimoDelContribuyente(PerceptorBean perceptorBean) {
        perceptorBean.setValor("minper", BD5550);
        long edad = 2019 - (Integer)perceptorBean.getValor(ERR_ANOPER);
        if (edad > 64L) {
            perceptorBean.setValor("per65", BD1150);
        } else {
            perceptorBean.setValor("per65", BigDecimal.ZERO);
        }
        if (edad > 74L) {
            perceptorBean.setValor("per75", BD1400);
        } else {
            perceptorBean.setValor("per75", BigDecimal.ZERO);
        }
        perceptorBean.setValor("mincon", perceptorBean.getValorAsBigDecimal("minper").add(perceptorBean.getValorAsBigDecimal("per65")).add(perceptorBean.getValorAsBigDecimal("per75")));
        perceptorBean.escribirDesarrollo("MINCON = " + perceptorBean.getValorAsBigDecimal("minper") + " + " + perceptorBean.getValorAsBigDecimal("per65") + " + " + perceptorBean.getValorAsBigDecimal("per75") + " = " + perceptorBean.getValor("mincon"));
        if (perceptorBean.getValorAsBigDecimal("mincon").compareTo(BD8100) > 0) {
            perceptorBean.setValor("mincon", BD8100);
        }
    }

    private void reduccionPorSerDesempleado(PerceptorBean perceptorBean) {
        if ((Integer)perceptorBean.getValor("situper") == 3) {
            perceptorBean.setValor("desem", BD1200);
        } else {
            perceptorBean.setValor("desem", BigDecimal.ZERO);
        }
    }

    private void reduccionMasDe2Descendientes(PerceptorBean perceptorBean) {
        if ((Integer)perceptorBean.getValor("numdes") > 2) {
            perceptorBean.setValor("hijos", BD600);
        } else {
            perceptorBean.setValor("hijos", BigDecimal.ZERO);
        }
    }

    private void reduccionPensionistaDeLaSSOClasesPasivas(PerceptorBean perceptorBean) {
        if ((Integer)perceptorBean.getValor("situper") == 2) {
            perceptorBean.setValor("pension", BD600);
        } else {
            perceptorBean.setValor("pension", BigDecimal.ZERO);
        }
    }

    private void calculosGastosDeducibles(PerceptorBean perceptorBean) {
        perceptorBean.setValor("gastosgen", BD2000);
        if (((Boolean)perceptorBean.getValor("movil")).booleanValue()) {
            perceptorBean.setValor("incregasmovil", BD2000);
        } else {
            perceptorBean.setValor("incregasmovil", BigDecimal.ZERO);
        }
        if ((Integer)perceptorBean.getValor("situper") == 1) {
            int discaper = (Integer)perceptorBean.getValor("discaper");
            if (discaper == 2 || discaper == 1 && ((Boolean)perceptorBean.getValor("movilper")).booleanValue()) {
                perceptorBean.setValor("incregasdistra", BD7750);
            } else if (discaper == 1) {
                perceptorBean.setValor("incregasdistra", BD3500);
            } else {
                perceptorBean.setValor("incregasdistra", BigDecimal.ZERO);
            }
        } else {
            perceptorBean.setValor("incregasdistra", BigDecimal.ZERO);
        }
        perceptorBean.setValor("otrosgastos", perceptorBean.getValorAsBigDecimal("gastosgen").add(perceptorBean.getValorAsBigDecimal("incregasmovil")).add(perceptorBean.getValorAsBigDecimal("incregasdistra")));
        perceptorBean.escribirDesarrollo("OTROS GASTOS = " + perceptorBean.getValorAsBigDecimal("gastosgen") + " + " + perceptorBean.getValorAsBigDecimal("incregasmovil") + " + " + perceptorBean.getValorAsBigDecimal("incregasdistra") + " = " + perceptorBean.getValor("otrosgastos"));
        BigDecimal valor = perceptorBean.getValorAsBigDecimal(ERR_RETRIB).subtract(perceptorBean.getValorAsBigDecimal("cotizaciones"));
        if (valor.compareTo(BigDecimal.ZERO) < 0) {
            perceptorBean.setValor("otrosgastos", BigDecimal.ZERO);
            perceptorBean.escribirDesarrollo("OTROS GASTOS = 0");
        } else if (perceptorBean.getValorAsBigDecimal("otrosgastos").compareTo(valor) > 0) {
            perceptorBean.setValor("otrosgastos", valor);
            perceptorBean.escribirDesarrollo("OTROS GASTOS = " + perceptorBean.getValorAsBigDecimal(ERR_RETRIB) + " - " + perceptorBean.getValorAsBigDecimal("cotizaciones") + " = " + valor);
        }
        perceptorBean.setValor("gastos", perceptorBean.getValorAsBigDecimal("cotizaciones").add(perceptorBean.getValorAsBigDecimal("otrosgastos")));
        perceptorBean.escribirDesarrollo("GASTOS = " + perceptorBean.getValorAsBigDecimal("cotizaciones") + " + " + perceptorBean.getValorAsBigDecimal("otrosgastos") + " = " + perceptorBean.getValor("gastos"));
    }

    private void rendimientoNetoTrabajo(PerceptorBean perceptorBean) {
        perceptorBean.setValor("rnt", BigDecimal.ZERO.max(perceptorBean.getValorAsBigDecimal(ERR_RETRIB).subtract(perceptorBean.getValorAsBigDecimal(ERR_IRREGULAR1)).subtract(perceptorBean.getValorAsBigDecimal("irregular2")).subtract(perceptorBean.getValorAsBigDecimal("cotizaciones"))));
        perceptorBean.escribirDesarrollo("RNT = " + perceptorBean.getValorAsBigDecimal(ERR_RETRIB) + " - " + perceptorBean.getValorAsBigDecimal(ERR_IRREGULAR1) + " - " + perceptorBean.getValorAsBigDecimal("irregular2") + " - " + perceptorBean.getValorAsBigDecimal("cotizaciones") + " = " + perceptorBean.getValor("rnt"));
    }

    private void reduccionPorObtencionDeRendimientosDelTrabajo(PerceptorBean perceptorBean) {
        this.reduccionDeCaracterGeneral(perceptorBean);
    }

    private void reduccionDeCaracterGeneral(PerceptorBean perceptorBean) {
        if (perceptorBean.getValorAsBigDecimal("rnt").compareTo(BD13115) <= 0) {
            perceptorBean.setValor("red20", BD5565);
            perceptorBean.escribirDesarrollo("RED20 = 5.565,00");
        } else if (perceptorBean.getValorAsBigDecimal("rnt").compareTo(BD16825) <= 0) {
            BigDecimal red20 = BD5565.subtract(BD15.multiply(perceptorBean.getValorAsBigDecimal("rnt").subtract(BD13115)));
            perceptorBean.setValor("red20", new BigDecimal(red20.setScale(2, 4).toString()));
            perceptorBean.escribirDesarrollo("RED20 = 5.565 - [1.5 * (" + perceptorBean.getValorAsBigDecimal("rnt") + " - 13.115,00)] = " + perceptorBean.getValor("red20"));
        } else {
            perceptorBean.setValor("red20", BigDecimal.ZERO);
            perceptorBean.escribirDesarrollo("RED20 = 0");
        }
    }

    private void rendimientoNetoReducido(PerceptorBean perceptorBean) {
        perceptorBean.setValor("rntredu", perceptorBean.getValorAsBigDecimal("rnt").subtract(perceptorBean.getValorAsBigDecimal("otrosgastos")).subtract(perceptorBean.getValorAsBigDecimal("red20")));
        perceptorBean.setValor("rntredu", perceptorBean.getValorAsBigDecimal("rntredu").max(BigDecimal.ZERO));
        perceptorBean.escribirDesarrollo("RNTREDU = " + perceptorBean.getValorAsBigDecimal("rnt") + " - " + perceptorBean.getValorAsBigDecimal("otrosgastos") + " - " + perceptorBean.getValorAsBigDecimal("red20") + " = " + perceptorBean.getValor("rntredu"));
    }

    @Override
    public PerceptorBean createPerceptorBean() {
        return new PerceptorBeanImpl();
    }

    @Override
    public List<ErrorValidacionBean> getErrores(PerceptorBean perceptorBean) {
        return Collections.unmodifiableList(perceptorBean.getErr());
    }

    private void calculoYComputoDeDescendientes(PerceptorBean perceptorBean) {
        int numDesc = 0;
        int numDes3 = 0;
        int numDes325 = 0;
        int numDes3En = 0;
        int numDes325En = 0;
        int numDesMas3 = 0;
        int numDesMas3En = 0;
        int numDes3365 = 0;
        int numDes3365En = 0;
        int numDescMov = 0;
        int numDes65 = 0;
        int numDes65En = 0;
        int numDescMovEn = 0;
        this.ordenarDescendientes(perceptorBean);
        List descendientesOrdenados = (List)perceptorBean.getValor(DESCENDIENTES_ORDENADOS);
        String comhijo1 = "";
        String comhijo2 = "";
        String comhijo3 = "";
        int nD = descendientesOrdenados.size();
        int i = 0;
        while (i < nD) {
            DescendienteBean descendiente = (DescendienteBean)descendientesOrdenados.get(i);
            int anioDesc = descendiente.getAnioNacimiento();
            int edadDesc = 2019 - anioDesc;
            int anioAdop = descendiente.getAnioAdopcion();
            BigDecimal porEntero = descendiente.isPorEntero() ? PerceptorBeanTipos.UNO : PerceptorBeanTipos.UNMEDIO;
            int disca = descendiente.getDiscapacidad();
            ++numDesc;
            if (edadDesc < 3 || anioAdop > 2016) {
                ++numDes3;
                if (porEntero.compareTo(PerceptorBeanTipos.UNO) == 0) {
                    ++numDes3En;
                }
            } else if (edadDesc >= 3 && edadDesc < 25 || edadDesc >= 25 && disca != 0) {
                ++numDes325;
                if (porEntero.compareTo(PerceptorBeanTipos.UNO) == 0) {
                    ++numDes325En;
                }
            }
            switch (numDesc) {
                case 1: {
                    comhijo1 = porEntero.compareTo(PerceptorBeanTipos.UNO) == 0 ? POR_ENTERO : POR_MITAD;
                    break;
                }
                case 2: {
                    comhijo2 = porEntero.compareTo(PerceptorBeanTipos.UNO) == 0 ? POR_ENTERO : POR_MITAD;
                    break;
                }
                case 3: {
                    comhijo3 = porEntero.compareTo(PerceptorBeanTipos.UNO) == 0 ? POR_ENTERO : POR_MITAD;
                    break;
                }
                default: {
                    ++numDesMas3;
                    if (porEntero.compareTo(PerceptorBeanTipos.UNO) != 0) break;
                    ++numDesMas3En;
                }
            }
            if (disca == 1) {
                ++numDes3365;
                if (descendiente.isMovilidadReducida()) {
                    ++numDescMov;
                }
                if (porEntero.compareTo(PerceptorBeanTipos.UNO) == 0) {
                    ++numDes3365En;
                    if (descendiente.isMovilidadReducida()) {
                        ++numDescMovEn;
                    }
                }
            } else if (disca == 2) {
                ++numDes65;
                if (porEntero.compareTo(PerceptorBeanTipos.UNO) == 0) {
                    ++numDes65En;
                }
            }
            descendiente = null;
            porEntero = null;
            ++i;
        }
        descendientesOrdenados = null;
        perceptorBean.setValor("numdes", numDesc);
        perceptorBean.setValor("numdes3", numDes3);
        perceptorBean.setValor("numdes325", numDes325);
        perceptorBean.setValor("numdesmas3", numDesMas3);
        perceptorBean.setValor("numdesmas3en", numDesMas3En);
        perceptorBean.setValor("numdes325en", numDes325En);
        perceptorBean.setValor("numdes3en", numDes3En);
        perceptorBean.setValor("numdes3365", numDes3365);
        perceptorBean.setValor("numdes3365en", numDes3365En);
        perceptorBean.setValor("numdesmov", numDescMov);
        perceptorBean.setValor("numdesmoven", numDescMovEn);
        perceptorBean.setValor("numdes65", numDes65);
        perceptorBean.setValor("numdes65en", numDes65En);
        perceptorBean.setValor("comhijo1", comhijo1);
        perceptorBean.setValor("comhijo2", comhijo2);
        perceptorBean.setValor("comhijo3", comhijo3);
    }

    private void calculoYComputoDeAscendientes(PerceptorBean perceptorBean) {
        int numAsc = 0;
        int numAs65A = 0;
        int numAs65AEn = 0;
        int numAs75A = 0;
        int numAs75AEn = 0;
        int numAs3365 = 0;
        int numAs3365En = 0;
        int numAs65 = 0;
        int numAs65En = 0;
        int numAsMov = 0;
        int numAsMovEn = 0;
        List ascendientes = (List)perceptorBean.getValor("ascendientes");
        int nD = ascendientes.size();
        int i = 0;
        while (i < nD) {
            AscendienteBean ascendiente = (AscendienteBean)ascendientes.get(i);
            BigDecimal convivencia = new BigDecimal(ascendiente.getConvivencia());
            int edadAs = 2019 - ascendiente.getAnioNacimiento();
            int disca = ascendiente.getDiscapacidad();
            ++numAsc;
            if (edadAs > 74) {
                ++numAs75A;
                if (convivencia.intValue() == 1) {
                    ++numAs75AEn;
                }
            } else if (edadAs <= 74 && edadAs > 64 || edadAs <= 64 && disca != 0) {
                ++numAs65A;
                if (convivencia.intValue() == 1) {
                    ++numAs65AEn;
                }
            }
            if (disca == 1) {
                ++numAs3365;
                if (convivencia.intValue() == 1) {
                    ++numAs3365En;
                }
                if (ascendiente.isMovilidadReducida()) {
                    ++numAsMov;
                    if (convivencia.intValue() == 1) {
                        ++numAsMovEn;
                    }
                }
            } else if (disca == 2) {
                ++numAs65;
                if (convivencia.intValue() == 1) {
                    ++numAs65En;
                }
            }
            ascendiente = null;
            convivencia = null;
            ++i;
        }
        ascendientes = null;
        perceptorBean.setValor("numas", numAsc);
        perceptorBean.setValor("numas65a", numAs65A);
        perceptorBean.setValor("numas65aen", numAs65AEn);
        perceptorBean.setValor("numas75a", numAs75A);
        perceptorBean.setValor("numas75aen", numAs75AEn);
        perceptorBean.setValor("numas3365", numAs3365);
        perceptorBean.setValor("numas3365en", numAs3365En);
        perceptorBean.setValor("numas65", numAs65);
        perceptorBean.setValor("numas65en", numAs65En);
        perceptorBean.setValor("numasmov", numAsMov);
        perceptorBean.setValor("numasmoven", numAsMovEn);
    }

    private void setRegularizacion(PerceptorBean perceptorBean) {
        boolean[] causa = (boolean[])perceptorBean.getValor(ERR_CAUSA);
        boolean regularizacion = false;
        int i = 1;
        while (i < causa.length) {
            if (((Boolean)perceptorBean.getValor(ERR_CAUSA, i)).booleanValue()) {
                regularizacion = true;
                break;
            }
            ++i;
        }
        perceptorBean.setValor("regularizacion", regularizacion);
    }

    private boolean validaNifMayus(String nif) {
        int length = nif.length();
        int i = 0;
        while (i < length) {
            if (VALIDOSNIF.indexOf(nif.charAt(i)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void ordenarDescendientes(PerceptorBean perceptorBean) {
        List descendientes = (List)perceptorBean.getValor(ERR_DESCENDIENTES);
        List descendientesOrdenados = (List)perceptorBean.getValor(DESCENDIENTES_ORDENADOS);
        descendientesOrdenados.clear();
        descendientesOrdenados.addAll(Collections.nCopies(descendientes.size(), perceptorBean.createDescendienteBean()));
        Collections.copy(descendientesOrdenados, descendientes);
        Collections.sort(descendientesOrdenados, new Comparator<DescendienteBean>(){

            @Override
            public int compare(DescendienteBean o1, DescendienteBean o2) {
                return o1.getAnioNacimiento() - o2.getAnioNacimiento();
            }
        });
        perceptorBean.setValor(DESCENDIENTES_ORDENADOS, descendientesOrdenados);
        descendientes = null;
        descendientesOrdenados = null;
    }

    @Override
    public boolean avisoMonoparental(PerceptorBean perceptorBean) {
        DescendienteBean d;
        List descendientes = (List)perceptorBean.getValor(ERR_DESCENDIENTES);
        int nD = descendientes.size();
        int i = 0;
        while (i < nD) {
            d = (DescendienteBean)descendientes.get(i);
            int anioDesc = d.getAnioNacimiento();
            int disca = d.getDiscapacidad();
            if (anioDesc > 2001) {
                return false;
            }
            if (anioDesc <= 2001 && disca == 2) {
                return false;
            }
            ++i;
        }
        d = null;
        descendientes = null;
        return true;
    }

    @Override
    public boolean avisoTipoA(PerceptorBean perceptorBean) {
        if (!((Boolean)perceptorBean.getValor("regularizacion")).booleanValue()) {
            return false;
        }
        boolean[] causa = (boolean[])perceptorBean.getValor(ERR_CAUSA);
        if (causa[9] || causa[11] || causa[10]) {
            return false;
        }
        BigDecimal tipoACalculado = perceptorBean.getValorAsBigDecimal("retenido").divide(perceptorBean.getValorAsBigDecimal(ERR_PERCIBIDO), 10, 4).setScale(4, 1);
        BigDecimal porcentajeTipoA = perceptorBean.getValorAsBigDecimal(ERR_TIPOA).divide(BigDecimal.valueOf(100L));
        BigDecimal diferencia = porcentajeTipoA.subtract(tipoACalculado).abs();
        int resultado = PerceptorBeanTipos.MARGEN_ERROR_TIPO.compareTo(diferencia);
        diferencia = null;
        tipoACalculado = null;
        return resultado != 0 && resultado <= 0;
    }

    @Override
    public boolean avisosBaseA(PerceptorBean perceptorBean) {
        if (!((Boolean)perceptorBean.getValor("regularizacion")).booleanValue()) {
            return false;
        }
        boolean[] causa = (boolean[])perceptorBean.getValor(ERR_CAUSA);
        return !causa[11] && !causa[10] && !causa[9] && perceptorBean.getValorAsBigDecimal(ERR_BASEA).compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    public boolean avisosRetribA(PerceptorBean perceptorBean) {
        return (Boolean)perceptorBean.getValor("regularizacion") != false && (Boolean)perceptorBean.getValor(ERR_CAUSA, 11) != false && perceptorBean.getValorAsBigDecimal(ERR_RETRIB).compareTo(perceptorBean.getValorAsBigDecimal(ERR_PERCIBIDO)) < 0;
    }

    @Override
    public boolean validarPostCalculos(PerceptorBean perceptorBean) {
        boolean[] causa = (boolean[])perceptorBean.getValor(ERR_CAUSA);
        if (causa[1] && perceptorBean.getValorAsBigDecimal("base").compareTo(perceptorBean.getValorAsBigDecimal(ERR_BASEA)) == 0) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9083", "De los datos introducidos no se desprende que se hayan producido variaciones en la base para determinar el tipo de retenci\u00f3n, lo cual es incompatible con la causa de regularizaci\u00f3n consignada.", ERR_BASEA, -1));
        }
        if (causa[2] && perceptorBean.getValorAsBigDecimal("minperfa").compareTo(perceptorBean.getValorAsBigDecimal(ERR_MINPERFAA)) == 0) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9084", "De los datos introducidos no se desprende que se hayan producido variaciones en el m\u00ednimo personal y familiar para determinar el tipo de retenci\u00f3n, lo cual es incompatible con la causa de regularizaci\u00f3n consignada.", ERR_MINPERFAA, -1));
        }
        if (((Boolean)perceptorBean.getValor("regularizacion")).booleanValue() && perceptorBean.getValorAsBigDecimal(ERR_MINOPAGOA).compareTo(BigDecimal.ZERO) != 0 && perceptorBean.getValorAsBigDecimal("minopago").compareTo(BigDecimal.ZERO) < 0) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "R9085", "La cantidad consignada en importe de la minoraci\u00f3n por pagos de pr\u00e9stamos para la vivienda determinado antes de la regularizaci\u00f3n es incorrecta.", ERR_MINOPAGOA, -1));
        }
        return perceptorBean.getErr().isEmpty();
    }

    @Override
    public String getVersion() {
        Properties prop = new Properties();
        try {
            prop.load(this.getClass().getResourceAsStream("/WEB-INF/modelo.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return prop.getProperty("version.mc");
    }

    @Override
    public PerceptorBean createPerceptorBeanFromJson(String perceptorJson) {
        class DescendienteAdapter
        extends TypeAdapter<DescendienteBean> {
            DescendienteAdapter() {
            }

            public DescendienteBean read(JsonReader reader) throws IOException {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                int anioNacimiento = 0;
                int anioAdopcion = 0;
                boolean porEntero = false;
                int discapacidad = 0;
                boolean movilidadReducida = false;
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if ("anioNacimiento".equals(name)) {
                        anioNacimiento = reader.nextInt();
                        continue;
                    }
                    if ("anioAdopcion".equals(name)) {
                        anioAdopcion = reader.nextInt();
                        continue;
                    }
                    if ("porEntero".equals(name)) {
                        porEntero = reader.nextBoolean();
                        continue;
                    }
                    if ("discapacidad".equals(name)) {
                        discapacidad = reader.nextInt();
                        continue;
                    }
                    if ("movilidadReducida".equals(name)) {
                        movilidadReducida = reader.nextBoolean();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                return new DescendienteBeanImpl(anioNacimiento, anioAdopcion, porEntero, discapacidad, movilidadReducida);
            }

            public void write(JsonWriter arg0, DescendienteBean arg1) throws IOException {
            }
        }
        class AscendienteAdapter
        extends TypeAdapter<AscendienteBean> {
            AscendienteAdapter() {
            }

            public AscendienteBean read(JsonReader reader) throws IOException {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                int anioNacimiento = 0;
                int convivencia = 0;
                int discapacidad = 0;
                boolean movilidadReducida = false;
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if ("anioNacimiento".equals(name)) {
                        anioNacimiento = reader.nextInt();
                        continue;
                    }
                    if ("convivencia".equals(name)) {
                        convivencia = reader.nextInt();
                        continue;
                    }
                    if ("discapacidad".equals(name)) {
                        discapacidad = reader.nextInt();
                        continue;
                    }
                    if ("movilidadReducida".equals(name)) {
                        movilidadReducida = reader.nextBoolean();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                return new AscendienteBeanImpl(anioNacimiento, convivencia, discapacidad, movilidadReducida);
            }

            public void write(JsonWriter arg0, AscendienteBean arg1) throws IOException {
            }
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(DescendienteBean.class, (Object)new DescendienteAdapter()).registerTypeAdapter(AscendienteBean.class, (Object)new AscendienteAdapter()).create();
        return (PerceptorBean)gson.fromJson(perceptorJson, PerceptorBeanImpl.class);
    }
}

