/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c200.c210.imp.srv;

import es.aeat.adht.util.api.ADHT_UTIL_Factory;
import es.aeat.adht.util.api.utilidades.DitDataInputStreamBean;
import es.aeat.adht.util.api.utilidades.DitDataOutputStreamBean;
import es.aeat.pret.c200.api.PRET_C200_Factory;
import es.aeat.pret.c200.api.bean.AscendienteBean;
import es.aeat.pret.c200.api.bean.DescendienteBean;
import es.aeat.pret.c200.api.bean.ErrorValidacionBean;
import es.aeat.pret.c200.api.bean.PerceptorBean;
import es.aeat.pret.c200.c210.api.PRET_C210_Factory;
import es.aeat.pret.c200.c210.api.srv.CalculoRetencionesCICSSrv;
import es.aeat.pret.c200.c210.api.srv.CalculoRetencionesSrv;
import es.aeat.pret.c200.imp.bean.ErrorValidacionBeanImpl;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CalculoRetencionesCICSSrvImpl
implements CalculoRetencionesCICSSrv {
    public DitDataOutputStreamBean procesaJDIT(DitDataInputStreamBean datos) throws Throwable {
        this.traza("Leyendo de la COMAREA");
        PerceptorBean perceptorBean = this.leerBeanDeComarea(datos);
        this.traza("Bean construido");
        if (perceptorBean.getErr().isEmpty()) {
            CalculoRetencionesSrv srv = PRET_C210_Factory.getCalculoRetencionesSrv();
            this.traza("Validando bean");
            if (srv.validar(perceptorBean, true)) {
                this.traza("Calculando resultado");
                srv.calcular(perceptorBean);
            } else {
                this.traza("Errores de validaci\u00f3n en c\u00e1lculo:\n\t" + perceptorBean.getErr());
            }
        } else {
            this.traza("Errores de validaci\u00f3n en c\u00e1lculo:\n\t" + perceptorBean.getErr());
        }
        return this.getComareaSalida(perceptorBean);
    }

    private DitDataOutputStreamBean getComareaSalida(PerceptorBean perceptorBean) {
        DitDataOutputStreamBean outputStreamBean = ADHT_UTIL_Factory.getDOSSrv().getDOS();
        if (perceptorBean.getErr().isEmpty()) {
            try {
                outputStreamBean.writeDouble(perceptorBean.getValorAsBigDecimal("tipo").doubleValue());
                outputStreamBean.writeDouble(perceptorBean.getValorAsBigDecimal("importe").doubleValue());
            }
            catch (IOException e) {
                this.traza(e.getMessage());
            }
        }
        return outputStreamBean;
    }

    private PerceptorBean leerBeanDeComarea(DitDataInputStreamBean datos) throws IOException {
        byte[] b = new byte[500];
        datos.read(b);
        String registro = new String(b);
        PerceptorBean perceptorBean = PRET_C200_Factory.getCalculoRetencionesSrv().createPerceptorBean();
        this.registroABean(perceptorBean, registro);
        return perceptorBean;
    }

    private void registroABean(PerceptorBean perceptorBean, String registro) {
        String clave;
        ArrayList erroresRegistro = new ArrayList();
        perceptorBean.setValor("nifper", registro.substring(17, 26));
        perceptorBean.setValor("anoper", registro.substring(152, 156));
        String ceutaMelilla = registro.substring(151, 152);
        if ("1".equals(ceutaMelilla)) {
            perceptorBean.setValor("resiceme", Boolean.TRUE);
            perceptorBean.setValor("renceme", Boolean.TRUE);
        }
        int discapacidad = Integer.parseInt(registro.substring(166, 167));
        switch (discapacidad) {
            case 1: {
                perceptorBean.setValor("discaper", 1);
                break;
            }
            case 2: {
                perceptorBean.setValor("discaper", 1);
                perceptorBean.setValor("movilper", Boolean.TRUE);
                break;
            }
            case 3: {
                perceptorBean.setValor("discaper", 2);
                break;
            }
        }
        String situacionFamiliar = registro.substring(156, 157);
        perceptorBean.setValor("situfam", situacionFamiliar);
        if ("2".equals(situacionFamiliar)) {
            perceptorBean.setValor("nifcon", registro.substring(157, 166));
        }
        if (!"ABC".contains(clave = registro.substring(77, 78))) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "E1901", "Clave de percepci\u00f3n no admitida", "", -1));
        } else if ("A".equals(clave)) {
            perceptorBean.setValor("situper", 1);
            perceptorBean.setValor("contrato", Integer.parseInt(registro.substring(167, 168)));
            String movilidadGeografica = registro.substring(169, 170);
            if ("1".equals(movilidadGeografica)) {
                perceptorBean.setValor("movil", Boolean.TRUE);
            }
        } else if ("B".equals(clave)) {
            String subclave = registro.substring(78, 80);
            if ("01".equals(subclave)) {
                perceptorBean.setValor("situper", 2);
            } else if ("02".equals(subclave)) {
                perceptorBean.setValor("situper", 4);
            } else {
                perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "E1902", "Subclave de percepci\u00f3n no admitida", "", -1));
            }
        } else {
            perceptorBean.setValor("situper", 3);
        }
        if ("N".equals(registro.substring(80, 81)) || "N".equals(registro.substring(107, 108))) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "E1903", "No se admiten reembolsos", "", -1));
        }
        if (Integer.parseInt(registro.substring(147, 151)) != 0) {
            perceptorBean.setErr(new ErrorValidacionBeanImpl(ErrorValidacionBean.TipoErrorValidacion.ERROR, "E1904", "No se admiten atrasos", "", -1));
        } else {
            BigDecimal retrib = new BigDecimal(registro.substring(81, 94)).add(new BigDecimal(registro.substring(108, 121))).movePointLeft(2);
            perceptorBean.setValor("retrib", retrib);
        }
        BigDecimal irregular1 = new BigDecimal(registro.substring(170, 183)).movePointLeft(2);
        perceptorBean.setValor("irregular1", irregular1);
        BigDecimal cotizaciones = new BigDecimal(registro.substring(183, 196)).movePointLeft(2);
        perceptorBean.setValor("cotizaciones", cotizaciones);
        BigDecimal pension = new BigDecimal(registro.substring(196, 209)).movePointLeft(2);
        perceptorBean.setValor("pension", pension);
        BigDecimal anualidades = new BigDecimal(registro.substring(209, 222)).movePointLeft(2);
        perceptorBean.setValor("anualidades", anualidades);
        if ("1".equals(registro.substring(254, 255))) {
            perceptorBean.setValor("minopago", Boolean.TRUE);
        }
        this.descendientes(perceptorBean, registro);
        this.ascencientes(perceptorBean, registro);
        if (!erroresRegistro.isEmpty()) {
            for (ErrorValidacionBeanImpl errorValidacionBean : erroresRegistro) {
                perceptorBean.setErr(errorValidacionBean);
            }
        }
    }

    private void descendientes(PerceptorBean perceptorBean, String registro) {
        DescendienteBean bean;
        DescendienteBean bean2;
        DescendienteBean bean3;
        DescendienteBean bean4;
        int numDescendientesResto;
        int numDescendietesMenor3 = Integer.parseInt(registro.substring(222, 223));
        if (numDescendietesMenor3 + (numDescendientesResto = Integer.parseInt(registro.substring(224, 226))) == 0) {
            return;
        }
        ArrayList<DescendienteBean> descendientes = new ArrayList<DescendienteBean>();
        int i = 0;
        while (i < numDescendientesResto) {
            bean4 = perceptorBean.createDescendienteBean();
            bean4.setAnioNacimiento(2000);
            descendientes.add(bean4);
            ++i;
        }
        i = 0;
        while (i < numDescendietesMenor3) {
            bean4 = perceptorBean.createDescendienteBean();
            bean4.setAnioNacimiento(2020);
            descendientes.add(bean4);
            ++i;
        }
        int numRestoPorEntero = Integer.parseInt(registro.substring(226, 228));
        int numMenor3PorEntero = Integer.parseInt(registro.substring(223, 224));
        boolean porEnteroHijo1 = "1".equals(registro.substring(250, 251));
        ((DescendienteBean)descendientes.get(0)).setPorEntero(porEnteroHijo1);
        if (porEnteroHijo1 && ((DescendienteBean)descendientes.get(0)).getAnioNacimiento() == 2000) {
            --numRestoPorEntero;
        } else if (porEnteroHijo1) {
            --numMenor3PorEntero;
        }
        if (descendientes.size() > 1) {
            boolean porEnteroHijo2 = "1".equals(registro.substring(251, 252));
            ((DescendienteBean)descendientes.get(1)).setPorEntero(porEnteroHijo2);
            if (porEnteroHijo2 && ((DescendienteBean)descendientes.get(1)).getAnioNacimiento() == 2000) {
                --numRestoPorEntero;
            } else if (porEnteroHijo2) {
                --numMenor3PorEntero;
            }
        }
        if (descendientes.size() > 2) {
            boolean porEnteroHijo3 = "1".equals(registro.substring(252, 253));
            ((DescendienteBean)descendientes.get(2)).setPorEntero(porEnteroHijo3);
            if (porEnteroHijo3 && ((DescendienteBean)descendientes.get(2)).getAnioNacimiento() == 2000) {
                --numRestoPorEntero;
            } else if (porEnteroHijo3) {
                --numMenor3PorEntero;
            }
        }
        int i2 = 2;
        while (i2 < numDescendientesResto + numDescendietesMenor3 && (numMenor3PorEntero > 0 || numRestoPorEntero > 0)) {
            DescendienteBean bean5 = (DescendienteBean)descendientes.get(i2);
            bean5.setPorEntero(true);
            if (bean5.getAnioNacimiento() == 2000) {
                --numRestoPorEntero;
                continue;
            }
            --numMenor3PorEntero;
        }
        int total3365 = Integer.parseInt(registro.substring(228, 230));
        int total3365Porentero = Integer.parseInt(registro.substring(230, 232));
        i2 = 0;
        while (total3365Porentero > 0) {
            bean3 = (DescendienteBean)descendientes.get(i2);
            if (bean3.isPorEntero()) {
                bean3.setDiscapacidad(1);
                --total3365Porentero;
                --total3365;
            }
            ++i2;
        }
        i2 = 0;
        while (total3365 > 0) {
            bean3 = (DescendienteBean)descendientes.get(i2);
            if (!bean3.isPorEntero()) {
                bean3.setDiscapacidad(1);
                --total3365;
            }
            ++i2;
        }
        int totalMovilidad = Integer.parseInt(registro.substring(232, 234));
        int totalMovilidadPorentero = Integer.parseInt(registro.substring(234, 236));
        i2 = 0;
        while (totalMovilidadPorentero > 0) {
            bean2 = (DescendienteBean)descendientes.get(i2);
            if (bean2.isPorEntero() && bean2.getDiscapacidad() == 1) {
                bean2.setMovilidadReducida(true);
                --totalMovilidadPorentero;
                --totalMovilidad;
            }
            ++i2;
        }
        i2 = 0;
        while (totalMovilidad > 0) {
            bean2 = (DescendienteBean)descendientes.get(i2);
            if (!bean2.isPorEntero() && bean2.getDiscapacidad() == 1) {
                bean2.setMovilidadReducida(true);
                --totalMovilidad;
            }
            ++i2;
        }
        int total65 = Integer.parseInt(registro.substring(236, 238));
        int total65Porentero = Integer.parseInt(registro.substring(238, 240));
        i2 = 0;
        while (total65Porentero > 0) {
            bean = (DescendienteBean)descendientes.get(i2);
            if (bean.isPorEntero() && bean.getDiscapacidad() == 0) {
                bean.setDiscapacidad(2);
                --total65Porentero;
                --total65;
            }
            ++i2;
        }
        i2 = 0;
        while (total65 > 0) {
            bean = (DescendienteBean)descendientes.get(i2);
            if (!bean.isPorEntero() && bean.getDiscapacidad() == 0) {
                bean.setDiscapacidad(2);
                --total65;
            }
            ++i2;
        }
        perceptorBean.setValor("descendientes", descendientes);
    }

    private void ascencientes(PerceptorBean perceptorBean, String registro) {
        int numMas75;
        int numMenos75 = Integer.parseInt(registro.substring(240, 241));
        if (numMenos75 + (numMas75 = Integer.parseInt(registro.substring(242, 243))) == 0) {
            return;
        }
        ArrayList<AscendienteBean> ascendientes = new ArrayList<AscendienteBean>();
        int numMenos75Porentero = Integer.parseInt(registro.substring(241, 242));
        int i = 0;
        while (i < numMenos75) {
            AscendienteBean ascendiente = perceptorBean.createAscendienteBean();
            ascendiente.setAnioNacimiento(1956);
            if (numMenos75Porentero > 0) {
                ascendiente.setConvivencia(1);
                --numMenos75Porentero;
            } else {
                ascendiente.setConvivencia(2);
            }
            ascendientes.add(ascendiente);
            ++i;
        }
        int numMas75Porentero = Integer.parseInt(registro.substring(243, 244));
        int i2 = 0;
        while (i2 < numMas75) {
            AscendienteBean ascendiente = perceptorBean.createAscendienteBean();
            ascendiente.setAnioNacimiento(1945);
            if (numMas75Porentero > 0) {
                ascendiente.setConvivencia(1);
                --numMas75Porentero;
            } else {
                ascendiente.setConvivencia(2);
            }
            ascendientes.add(ascendiente);
            ++i2;
        }
        perceptorBean.setValor("ascendientes", ascendientes);
    }

    private void traza(String mensaje) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.S");
        String laTraza = String.format("c200::CalculoRetencionesCICSSrv [%s]: %s", df.format(new Date()), mensaje);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, laTraza);
    }
}

