/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c200.web;

import es.aeat.adht.html.api.ADHT_HTML_Factory;
import es.aeat.adht.html.api.Aplicacion;
import es.aeat.adht.html.api.Pagina;
import es.aeat.adht.html.api.Pie;
import es.aeat.adht.jdit.api.ADHT_JDIT_Factory;
import es.aeat.pret.c200.mc.c220.ModuloCalculo;
import es.aeat.pret.c200.util.XQueryUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;

@WebServlet(value={"/mc"})
public class MCServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (ADHT_JDIT_Factory.getContextoSrv().getENTORNO() != 1) {
            resp.setStatus(404);
            return;
        }
        Pagina htmlCabecera = ADHT_HTML_Factory.getCabecera();
        Aplicacion htmlAplicacion = ADHT_HTML_Factory.getAplicacion();
        Pie htmlPie = ADHT_HTML_Factory.getPie();
        PrintWriter out = resp.getWriter();
        htmlCabecera.getPagina().setTitulo("Prueba m\u00f3dulo de c\u00e1lculo web").pintar(out);
        htmlAplicacion.getFormulario().setId("mc").setAccion("mc").setMetodo("POST").pintarAbrir(out);
        htmlAplicacion.getFormulario().getCuadro().setConLista().setTitulo("M\u00f3dulo de c\u00e1lculo de retenciones IRPF").pintarAbrir(out);
        htmlAplicacion.getFormulario().getTextForm("EJER").setRequired(true).setLiteral("Ejercicio").setNumCols("dos_cols").setValorElemento(Integer.valueOf(2022)).pintar(out);
        htmlAplicacion.getFormulario().getTextForm("PER").setRequired(true).setLiteral("Periodo").setNumCols("dos_cols").setValorElemento(Integer.valueOf(0)).pintar(out);
        htmlAplicacion.getFormulario().getTextArea("F01").setRequired(true).setLiteral("XML Entrada").setNumCols("ancho_99").setNColumnas(80).setNLineas(15).pintar(out);
        htmlAplicacion.getFormulario().getBoton().setMain(true).setLiteral("Calcular").pintar(out);
        htmlAplicacion.getFormulario().getCuadro().setConLista().pintarCerrar(out);
        htmlAplicacion.getFormulario().pintarCerrar(out);
        htmlPie.pintar(out);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StringBuilder xml;
        String periodo;
        if (ADHT_JDIT_Factory.getContextoSrv().getENTORNO() == 3) {
            response.setStatus(404);
            return;
        }
        String ejercicio = Optional.ofNullable(request.getParameter("EJER")).orElse("");
        if (this.comprobarEjercicioPeriodoFichero(ejercicio, periodo = Optional.ofNullable(request.getParameter("PER")).orElse(""), xml = new StringBuilder(Optional.ofNullable(request.getParameter("F01")).orElse("")))) {
            String res = ModuloCalculo.procesarFicheroXML(xml.toString());
            response.setContentType("text/xml");
            response.getWriter().write(res);
        } else {
            response.setStatus(400);
        }
    }

    private boolean comprobarEjercicioPeriodoFichero(String ejercicio, String periodo, StringBuilder xml) {
        block3: {
            if (Integer.parseInt(ejercicio) == 2022 && Integer.parseInt(periodo) == 0) break block3;
            return false;
        }
        try {
            Processor saxon = new Processor(false);
            DocumentBuilder documentBuilder = saxon.newDocumentBuilder();
            StreamSource src = new StreamSource(new StringReader(xml.toString()));
            XdmNode doc = documentBuilder.build((Source)src);
            XdmValue execQueryAtom = XQueryUtils.execQueryAtom(saxon, doc, "AEATRetencionesEntrada" + ejercicio);
            return execQueryAtom.size() > 0;
        }
        catch (NumberFormatException | SaxonApiException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "EJERCICIO, PERIODO O XML INCORRECTOS", e);
            return false;
        }
    }
}

