package es.aeat.pret.c200.api.srv;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.List;

import javax.xml.validation.Validator;

import org.xml.sax.SAXException;

import es.aeat.pret.c200.api.bean.PerceptorBean;


public interface ValidarLeerFicheroSrv extends Serializable {
	
	public boolean validaXmlSalidaStax(String ficheroXMLEntrada,PerceptorBean per) throws SAXException;
	public boolean validaXmlEntradaStax(String ficheroXMLEntrada,PerceptorBean per) throws SAXException;
	public void validaXmlEntradaParaCalculos(String ficheroXMLEntrada,PerceptorBean per);
	public void cerrarReaderRetenedor(PerceptorBean per);
	public void cerrarReaderRetenido(PerceptorBean per);
	public List<String> leeRetenido(int indiceRetenedor, int indiceRetenido, PerceptorBean per);
	public List<String> leeRetenedor(int indiceRetenedor, PerceptorBean per);
	public void prepararReaderRetenido(FileInputStream fisReti, PerceptorBean per, boolean importarXML, boolean buscarRetenido, boolean soloLeer);
	public void prepararReaderRetenedor(FileInputStream fisReto, PerceptorBean per, boolean importarXML, boolean buscarRetenedor, boolean soloLeer);
	public boolean xmlCorrectoEntradaStax(boolean calculo, PerceptorBean per, Validator validator);
	public boolean xmlCorrectoSalidaStax(PerceptorBean per, Validator validator);
	public File salidaXML(boolean errorPerceptor,PerceptorBean per);
	public boolean isOk(PerceptorBean per);
	public void generarXML(String nifRetenedor, String nombreRetenedor, String nombreRetenido, PerceptorBean per);
	public void empiezaDocumento(PerceptorBean per);
	public void terminarDocumento(PerceptorBean per);
	public void empiezaRetenedor(PerceptorBean per);
	public void terminaRetenedor(PerceptorBean per);
	public void empiezaRetenido(PerceptorBean per);
	public void empiezaDocumentoError(PerceptorBean per);
	public void terminarDocumentoError(PerceptorBean per);
	void crearFicheroErrorRetenidoSTAX(CalculoRetencionesSrv calculo, PerceptorBean per, int ordenRetenedor, int ordenRetenido);
	void terminaRetenedorError(PerceptorBean per);
	void inicializaValidador(PerceptorBean per);
	int[] getListaRetenidos(PerceptorBean per);
	int getNumeroRetenedoresTotal(PerceptorBean per);
	int getNumeroRetenidosTotal(PerceptorBean per);
	void ponerSello(PerceptorBean per);
}
