package es.aeat.pret.c200.util;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.logging.Logger;

public class ValidaNif implements java.io.Serializable{
	private static final long serialVersionUID = 1L;
	
    boolean nifOk = false;
    /** Para identificar el tamao de la cadena NIF, nueve posiciones */
    public static final int TAM_NIF                =  9;
    /** Para identificar que no es correcto */
    public static final int NIF_ERROR             = -1;
    /** El tamao del NIF es incorrecto */
    public static final int NIF_ERROR_TAMANO       = -2;
    /** El NIF est a blancos, luego es incorrecto */
    public static final int NIF_ERROR_BLANCOS      = -3;
    /** El NIF tiene caractres incorrectos */
    public static final int NIF_ERROR_CARACTERES   = -4;
    /** El NIF tiene ms letras de las vlidas */
    public static final int NIF_ERROR_3LETRAS      = -5;
    /** Actualmente no se est utilizando */
    public static final int NIF_ERROR_DATOSENTRADA = -6;
    
    /** El CIF es errneo */
    public static final int CIF_ERROR_DC        = -10;
    /** El NIF es errneo */
        public static final int NIF_ERROR_DC        = -11;
    /** El nmero de cifras del NIF es errneo */
    public static final int NIF_ERROR_NUM       = -12;
    /** El nmero de cifras del NIF es errneo */
    public static final int NIF_ERROR_DOSNUM    = -13;
    
    /** Est validando un DNI que no comienza por 0, y esto es error */
    public static final int DNI_ERROR_MAX       = -20;
    /** El NIF tiene todas sus cifras iguales y es incorrecto */
    public static final int DNI_ERROR_VALOR     = -21;
    
    /** El DNI tiene todas sus cifras distintas y es correcto pero no se puede validar ms */
    public static final int DNI_OK              =  0;
    
    /** El NIF es correcto */
    public static final int NIF_OK              =  1;
    /** El NIF pertenece a No residentes en Espaa */
    public static final int NIF_NORESIDENTES    =  2;
    /** El NIF pertenece a menores de 14 aos */
    public static final int NIF_MENORES14ANOS   =  3;
    /** El NIF pertenece a extranjeros */
    public static final int NIF_EXTRANJEROS     =  4;
    
    /** El CIF es correcto */
    public static final int CIF_OK              = 20;
    /** El CIF es correcto, de extranjero */
    public static final int CIF_EXTRANJERO_OK   = 21;
    /** El CIF es correcto, de organizacin */
    public static final int CIF_ORGANIZACION_OK = 22;
    /** El CIF es correcto, de no residentes */
    // esta variable se refiere a nif en Regimen Atribucion Rentas
    public static final int CIF_NORESIDENTES_OK = 23; 
        
    /** Tabla char de nmeros */
    protected static final char[] NUMEROS =
    {'0','1','2','3','4','5','6','7','8','9'};
    /** Tabla char de letras */
    protected static final char[] LETRAS =
    {'A','B','C','D','E','F','G','H','I','J','K','L','M','N','P','Q','R','S','T','V','W','X','Y','Z'};
    /** Tabla char de letras de NIF */
    protected static final char[] LETRAS_NIF   =
    {'T','R','W','A','G','M','Y','F','P','D','X','B','N','J','Z','S','Q','V','H','L','C','K','E'};
    /** Tabla char de letras de CIF */
    protected static final char[] LETRAS_2_CIF  =
    {'A','B','C','D','E','F','G','H','I','J'};
    /** Tabla char de letras de CIF correctas */
    // aadimos nuevas letras J,U,V
    protected static final char[] LETRAS_CIF   = {'A','B','C','D','E','F','G','H','J','U','V'}; 
    /** Tabla char de letras de CIF organizaciones */
    // aadimos nuevas letras W, R, manteniendo las letras A,B,C,D,E,F,G
    protected static final char[]  LETRAS_CIFORG_Y_EXTR= {'A','B','C','D','E','F','G','P','Q','S','N','W','R'}; 
    /** Tabla char de letras de CIF no residentes */    
    // aadimos nuevas letras J,U,V
    protected static final char[] LETRAS_REGATRIBRENTAS = {'E','G','H','J','U','V'}; 
    // nuevo grupo para identificar las entidades extranjeras (N,W), manteniendo las letras A,B,C,D,E,F,G
    protected static final char[] LETRAS_CIFEXT = {'A','B','C','D','E','F','G','N','W'};
    // nuevo grupo para identificar los NIF de extranjeros
    protected static final char[] LETRAS_NIFEXT = {'X','Y','Z'}; 
    
    /** cadena para tener el contenido a ceros, con el tamao de NIF */
    public static final String CEROS ="000000000";
    
    private String elNif = "";
    
    /** checkNif es la funcin que realiza la validacin del NIF
     * @param nifEntra La cadena que recibe es el NIF/CIF a validar
     * @return int Valor numrico que le indica el resultado de la validacin siendo los
     *valores definidos como constantes.
     *
     */
    public int checkNif(String nifEntra) {
        
        if(nifEntra == null || nifEntra.length()== 0 ){
            return NIF_ERROR;
        }
        
        elNif = aNif(nifEntra);
        if( elNif != null){
            return vNif(elNif);
        } else{
            return NIF_ERROR;
        }
    }
    
    /** checkNifSinFormatear es la funcion que realiza la 
     * validacin del NIF sin formatear
     * @param nifEntra La cadena que recibe es el NIF/CIF a validar
     * @return int Valor numrico que le indica el resultado de la validacin siendo los
     *valores definidos como constantes.
     *
     */
    public int checkNifSinFormatear(String nifEntra) {
        
        if(nifEntra == null || nifEntra.length()== 0 ){
            return NIF_ERROR;
        }
        
        return vNif(nifEntra);
    }
    
    /**  getNif sirve para devolver el NIF ya formateado
     *   @return el nif ya formateado
     */
    public String getNif() {
        return elNif;
    }
    
    /**  vNif Funcin que realiza la validacin de NIF
     * @param sNif La cadena que recibe es el NIF/CIF a validar
     * @return int Valor numrico que le indica el resultado de la validacin siendo los
     *valores definidos como constantes. */
    public int vNif(String sNif) {
        
        // -----------------------------------------------
        nifOk = false;
        String dos = null;
        int i;
        int multi=0;
        int suma=0;
        long cuent=0L;
        long resto=0L;
        // -----------------------------------------------
        sNif = sNif.trim();
        if( sNif.length() != TAM_NIF){
            return NIF_ERROR_TAMANO;
        }
                
        //SI TIENE ALGO DISTINTO DE DIGITOS (0 a 9) O DE CARACTERES VALIDOS
        //(Letras)
        char letra1 = 0;
        char letra2 = 0;
        int numeroLetras = 0;
        int posLetra1 = 0;
        int posLetra2 = 0;
        char[] datos = sNif.toCharArray();
        char ch;
        int tipo;
        for(i = 0; i < TAM_NIF; i++) {
            ch = datos[i];
            tipo = Character.getType(ch);
            
            if( tipo == Character.UPPERCASE_LETTER && numeroLetras == 0) {
                numeroLetras++;
                letra1=ch;
                posLetra1=i;
            } else{
                if( tipo == Character.UPPERCASE_LETTER && numeroLetras == 1) {
                    numeroLetras++;
                    letra2=ch;
                    posLetra2=i;
                } else{
                    if( tipo == Character.UPPERCASE_LETTER && numeroLetras == 2){
                        return NIF_ERROR_3LETRAS;
                    } else{
                        if( tipo != Character.DECIMAL_DIGIT_NUMBER ){
                            return NIF_ERROR_CARACTERES;
                        }
                    }
                }
            }
        }
        
        //--------------DNI NORMAL
        if(numeroLetras == 0) {
            if(datos[0] != '0'){
                return DNI_ERROR_MAX;
            } else {
                String sdos = sNif.substring(1);
                if( "11111111".equals(sdos) || "22222222".equals(sdos) || "33333333".equals(sdos) ||
                "44444444".equals(sdos) || "55555555".equals(sdos) || "66666666".equals(sdos) ||
                "77777777".equals(sdos) || "88888888".equals(sdos) || "99999999".equals(sdos) ||
                "00000000".equals(sdos)   ){
                    return DNI_ERROR_VALOR;
                }
            }
            //nifOk = true
            //No Considero un DNI como OK
            return DNI_OK;
        }
        
        //------------- CIF normal --------------------------
        if( numeroLetras == 1 && caracEnCad(LETRAS_CIF, datos[posLetra1]) &&
            posLetra1 == 0 && Character.isDigit(datos[TAM_NIF-1]) ) {
            
            for( i=1 ; i < TAM_NIF-1 ; i++) {
                if(i==2 || i==4 || i==6){
                    suma+=(datos[i]-'0');
                } else {
                    multi=(datos[i]-'0') * 2;
                    if(multi > 9){
                    	multi-=9;
                    }
                    suma+=multi;
                }
            }
            
            suma=10-suma%10;
            if(suma==10){ 
            	suma=0;
            }
            if(suma == (datos[i]-'0')) {
                if( caracEnCad(LETRAS_REGATRIBRENTAS,datos[posLetra1]) ) {
                    nifOk = true;
                    return CIF_NORESIDENTES_OK;
                }
                nifOk = true;
                return CIF_OK;
            } else {
            	return CIF_ERROR_DC;
            }
        }
        
        
        //--------- CIF EXTRAN --------------------------
        //--------- CIF ORGANI --------------------------
        if( numeroLetras==2 && (caracEnCad(LETRAS_CIFORG_Y_EXTR,datos[posLetra1])) && 
        		posLetra1==0 && posLetra2==TAM_NIF-1 && caracEnCad(LETRAS_2_CIF,datos[posLetra2])){
            
            for(i=1;i<TAM_NIF-1;i++) {
                if(i==2 || i==4 || i==6){
                    suma+=(datos[i]-'0');
                } else {
                    multi=(datos[i]-'0') * 2;
                    if(multi > 9) {
                    	multi-=9;
                    }
                    suma+=multi;
                }
            }
            suma=10-suma%10;
            if(LETRAS_2_CIF[suma-1]== datos[posLetra2]) {
                nifOk = true;
                // utilizamos el nuevo grupo de entidades extranjeras
                if(caracEnCad(LETRAS_CIFEXT,datos[posLetra1])){
                    return CIF_EXTRANJERO_OK;
                }
                return CIF_ORGANIZACION_OK;
            } else{
                return CIF_ERROR_DC;
            }
        }
        
        //-------------- NIF NORMAL        
        if(numeroLetras==1 && caracEnCad(LETRAS,datos[TAM_NIF-1]) &&
           caracEnCad(LETRAS_NIF,datos[posLetra1]) && posLetra1==TAM_NIF-1) {
        	StringBuilder buf = new StringBuilder(sNif.substring(0, posLetra1));
            //	buf.deleteCharAt(PosLetra1) // Solo aparece desde JDK 1.2
            cuent = Long.parseLong(buf.toString());
            resto = cuent % 23;
            if(resto+1 > 23){
                return NIF_ERROR_NUM;
            }
            if(letra1 == LETRAS_NIF[(int)(resto)]) {
                if("00000001R".equals(sNif) || "00000000T".equals(sNif) || "99999999R".equals(sNif)){
                    return NIF_ERROR;
                } else {
                	nifOk = true;
                    return NIF_OK;
                }
            } else{
            	return NIF_ERROR_DC;
            }
        }
        
        //--------- NIF  < 14
        //--------- NIF NO RESIDENTES
        if(numeroLetras==2 && (datos[0]=='K' || datos[0]=='L'|| datos[0]=='M') &&
           caracEnCad(LETRAS_NIF,datos[posLetra2]) && posLetra2==TAM_NIF-1) {
            
            dos = sNif.substring(1,3);
            if( !caracEnCad(NUMEROS, dos.charAt(0)) || !caracEnCad(NUMEROS, dos.charAt(1)) ){
                return NIF_ERROR_DOSNUM;
            }
            
            /**
             * Correo de Antonliano 29/04/2015
             * S esa restriccin estaba hasta 2007 que obligaba a que los dos primeros dgitos despus de la K, L o M fueran los de la delegacin. Se retir la restriccin con el RGAT de aquel ao.
			 * Saludos
			 * Antoliano
			i = Integer.parseInt(dos);
            if ( i < 1 || i > 56) {
				return NIF_ERROR;
			}
             */
            dos = sNif.substring(1,posLetra2);
            cuent=Long.parseLong(dos);
            resto=cuent % 23;
            resto++;
            if(resto > 23){
                return NIF_ERROR_NUM;
            }
            if(letra2 == LETRAS_NIF[(int)(resto-1)]) {
                nifOk = true;
                return NIF_NORESIDENTES;
            } else {
            	return NIF_ERROR_DC;
            }
        }
        
        //--------- NIF EXTRANJEROS        
        if ("X0000000T".equals(sNif)) {
        	return NIF_ERROR; 
        }
        // comprobamos que el primer caracter es X,Y o Z y no solo X
        if(numeroLetras==2 && caracEnCad(LETRAS_NIFEXT,datos[0]) &&
           caracEnCad(LETRAS_NIF,datos[posLetra2]) && posLetra2==TAM_NIF-1) {
            
            dos = sNif.substring(1,posLetra2);
            cuent=Long.parseLong(dos);
            // modificacion en el calculo para NIF > 9999999
            if(datos[0]=='Y'){
            	cuent+=10000000;
            } else if(datos[0]=='Z'){
            	cuent+=20000000;
            }
            
            resto = cuent % 23;
            resto++;
            if(resto > 23){
                return NIF_ERROR_NUM;
            }
            
            if(letra2 == LETRAS_NIF[(int)(resto-1)]) {
                nifOk = true;
                return NIF_EXTRANJEROS;
            } else{
                return NIF_ERROR_DC;
            }
        }
                
        return NIF_ERROR;
    }
    /** isOk devuelve si es correcto o no, el DNI/NIF en procesos intermedios
     * @return boolean true-false en funcin de si es corrcto o no el DNI-NIF.
     */
    public boolean isOk() {
        return nifOk;
    }
    /** aNif Esta funcin se encarga de quitar los blancos intermedios a la cadena,
     *  de pasar a maysculas las letras de la cadena y los ceros. 
     *  @param origen recibe la cadena sin formatear
     *  @return String, la cadena ya formateada.
     */
    public String aNif(String origen) {
    	StringBuilder inter = new StringBuilder(TAM_NIF);
        //Pasamos a mayusculas
        String destino = origen.toUpperCase();
        //Eliminamos blancos intermedios.
        //destino = quitaBlanInter(destino)
        destino = quitaCaracRaros(destino);
        //Ajustamos a la derecha
        //NifDerecha(destino)
        //Rellenamos con ceros a la izquierda
        int tam = destino.length();
        if( tam > TAM_NIF){
            return "";
        }
        
        if( tam != TAM_NIF) {
            inter.append(CEROS.substring(0,TAM_NIF-tam));
            inter.append(destino);
            destino = inter.toString();
        }
        
        
        /*  -----------------------------------------------------------------------
         * Comentamos este cdigo para que no fallen los NIF con X, NO EXTRANJEROS
         * // NIF's extranjeros. X en la primera posicin
         * tam = destino.indexOf('X')
         *
         * (tam != -1 ) 
         * ( tam != 0 ) 
         * inter = StringBuilder(destino.substring(0,tam))
         * //               inter.deleteCharAt(tam); solo aparece a partir de JDK 1.2
         * inter.append(destino.substring(tam))
         * inter.insert(0,'X')
         * destino = inter.toString()
         * 
         * 
         *
         * -------------------------------------- */
        return destino;
    }
    /** quitaCaracRaros Esta funcin quita de la cadena que recibe como parmetro, 
     *  los caractres que no sean letras o nmeros  
     *  @param datos Cadena subsceptible de contener caracteres extraos.
     *  @return (String) La cadena, con letras y nmeros.
     */
    public static String quitaCaracRaros(String datos) {
        StringBuilder buf = new StringBuilder(datos.length());
        StringCharacterIterator iter= new StringCharacterIterator(datos);
        
        for(char c = iter.first(); c != CharacterIterator.DONE; c = iter.next()) {
            if( Character.isLetterOrDigit( c ) ) {
                buf.append( c );
            }
        }
        
        return buf.toString();
    }
    
    /** quitaBlanInter Esta funcin quita de la cadena que recibe como parmetro, 
     *  los caractres intermedios, los espacios  
     *  @param datos Cadena subsceptible de contener espacios entre medias.
     *  @return String La cadena, sin espacios entre medias.
     */
    public static String quitaBlanInter(String datos) {
        StringBuilder buf = new StringBuilder(datos.length());
        StringCharacterIterator iter= new StringCharacterIterator(datos);
        
        for(char c = iter.first(); c != CharacterIterator.DONE; c = iter.next()) {
            if( c != ' ') {
                buf.append( c );
            }
        }
        
        return buf.toString();
    }
    /** quitaBCaracter Esta funcin quita de la cadena que recibe como parmetro, 
     *  el carcter que recibe como segundo parmetro
     *  @param datos Cadena subsceptible de contener el caracter a quitar.
     *  @param car Carcter a quitar.
     *  @return String La cadena, sin el carcter indicado.
     */
    public static String quitaCaracter(String datos,char car) {
        StringBuilder buf = new StringBuilder(datos.length());
        StringCharacterIterator iter= new StringCharacterIterator(datos);
        
        for(char c = iter.first(); c != CharacterIterator.DONE; c = iter.next()) {
            if( c != car) {
                buf.append( c );
            }
        }
        
        return buf.toString();
    }
    
    
    /**  
     *  Busca un carcter en una cadena dada en el primer parmetro,
     *  el carcter que recibe como segundo parmetro
     *  @param datos Cadena subsceptible de contener el caracter a buscar.
     *  @param ch Carcter a buscar.
     *  @return boolean true si encontr el carcter.
     *  @return boolean false si no lo encontr.
     */
    public static boolean caracEnCad(char[] datos, char ch) {
        boolean bRet = false;
        int tam = datos.length;
        for(int i= 0; i < tam; i++) {
            if( datos[i] == ch) {
                bRet = true;
                break;
            }
        }
        return bRet;
    }
    
    
    /** 
     *  Busca un carcter en una cadena dada en el primer parmetro,
     *  el carcter que recibe como segundo parmetro
     *  @param datos Cadena subsceptible de contener el caracter a buscar.
     *  @param ch Carcter a buscar.
     *  @return boolean true si encontr el carcter.
     *  @return boolean false si no lo encontr.
     */
    public static boolean caracEnCad(String datos, char ch) {
        
        boolean bRet = false;
        StringCharacterIterator iter= new StringCharacterIterator(datos);
        
        for(char c = iter.first(); c != CharacterIterator.DONE; c = iter.next()) {
            if( c == ch) {
                bRet = true;
                break;
            }
        }
        return bRet;
    }
    
    /** 
     *  Quita los acentos en una cadena dada en el parmetro.
     *  @param datos Cadena subsceptible de contener acentos.
     *  @return String Cadena sin acentos.
     */
    public static String quitaAcentos(String datos) {
        StringBuilder cads = new StringBuilder(datos.length());
        StringCharacterIterator iter= new StringCharacterIterator(datos);
        
        for(char c = iter.first(); c != CharacterIterator.DONE; c = iter.next()) {
            
            switch( c ) {
                case '':
                    c = 'a';
                    break;
                case '':
                    c = 'e';
                    break;
                case '':
                    c = 'i';
                    break;
                case '':
                    c = 'o';
                    break;
                case '':
                    c = 'u';
                    break;
                case '':
                    c = 'A';
                    break;
                case '':
                    c = 'E';
                    break;
                case '':
                    c = 'I';
                    break;
                case '':
                    c = 'O';
                    break;
                case '':
                    c = 'U';
                    break;
                default:
                    break;
            }
            cads.append(c);
        }
        return cads.toString();
    }
    
    
    /** 
     *  Rellena a ceros el tamao que le indican en el segundo parmetro.
     *  @return String Cadena rellena de ceros.
     */
    public static String rellenaCeros(String datos,int tam) {
        
        StringBuilder buff = new StringBuilder(41);
        int tamAct = datos.length();
        if( tamAct != TAM_NIF && tamAct < tam){
            buff.append(CEROS.substring(0,tam-tamAct));
        }
        buff.append(datos);
        return buff.toString();
    }
    
    /** 
     *  Cambiar la 'coma' por el 'punto' en la cadena indicada.
     *  @return String Cadena con los cambios.
     */
    public static String cambComaPunto(String datos) {
        return datos.replace(',','.');
    }
    
    /** 
     * Esta funcin nos dice si un cdigo devuelto por vNif pertenece a una persona fsica.
     * @param bDNI Si el parmetro bDNI es false no se admitir un DNI_OK como una persona fsica vlida
     *
     */
    public boolean esPersonaFisica(int nTipoNif, boolean bDNI) {
        boolean  bPersonaFisica;
        
        if (bDNI){
            bPersonaFisica = nTipoNif >= DNI_OK && nTipoNif < CIF_OK;
        } else{
            bPersonaFisica = nTipoNif > DNI_OK && nTipoNif < CIF_OK;
        }
        return bPersonaFisica;
    }
    
    
    /**
     * Esta funcin intenta validar el Cdigo Cuenta Cliente  (CCC)
     */
    public int controlaCuenta( String cad ) {
        int i;
        int j;
        int[] peso = { 6, 3, 7, 9, 10, 5, 8, 4 , 2, 1} ;
        long suma=0L;
        long mod=0L ;
        
        char[] datos = cad.toCharArray();
        try {
            for( i = 7,j=0; i >= 0; i--,j++ ){
                suma+= (datos[i]-48) * peso[j];
            }
            mod = Math.abs( (suma%11) - 11 );
            if ( mod == 10 ){
                mod = 1;
            }
            if ( mod == 11 ){
                mod = 0;
            }
            if ( mod != (datos[8]-48) ){
                return 1 ;
            }
            
            // Segunda parte
            suma = 0;
            for( i = 19,j=0; i >= 10; i--,j++ ) {
                suma+= (datos[i]-48) * peso[j] ;
            }
            mod = Math.abs( (suma%11) - 11 );
            if ( mod == 10 ){
                mod = 1;
            }
            if ( mod == 11 ){
                mod = 0;
            }
            if ( mod != datos[9]-48 ){
                return 2 ;
            }
        } catch( ArrayIndexOutOfBoundsException e) {
        	Logger.getLogger(ValidaNif.class.getName()).warning("Fuera de los lmites del Array");
        }
        
        return 0;
    }
    
    /** 
     * Esta funcin intenta validar la Cuenta Vivienda  (CCV)
     */
    public int controlaCuentaCCV( String cad ) {
        int i;
        int j;
        int[] peso = { 6, 3, 7, 9, 10, 5, 8, 4 } ;
        int[] peso2 = { 2, 3, 4, 5, 6, 7, 2, 3, 4, 5 } ;
        long suma;
        long mod ;
        
        char[] datos = cad.toCharArray();
        mod = 0;
        suma = 0;
        try {
            for( i = 7,j=0; i >= 0; i--,j++ ){
                suma+= (datos[i]-48) * peso[j];
            }
            
            mod = Math.abs( (suma%11) - 11 );
            if ( mod == 10 ){
                mod = 1;
            }
            if ( mod == 11 ){
                mod = 0;
            }
            if ( mod != (datos[8]-48) ){
                return 1 ;
            }
            
            // Segunda parte
            suma = 0;
            
            for( i = 19,j=0; i >= 10; i--,j++ ) {
                suma += (datos[i]-48) * peso2[j] ;
            }
            
            mod = Math.abs( (suma%11) - 11 );
            if ( mod == 10 ){
                mod = 0;
            }
            if ( mod == 11 ){
                mod = 1;
            }
            if ( mod != (datos[9]-48) ){
                return 2 ;
            }
        } catch( ArrayIndexOutOfBoundsException e) {
 //       	Index.mostrarError("Fuera de los lmites del Array")
        	Logger.getLogger(ValidaNif.class.getName()).warning("Fuera de los lmites del Array");
        }
        
        return 0;
    }
    
/*    
    public static void main(String[] args){
        
        int res;
        ValidaNif val = new ValidaNif();
        String[] cad={"G79102638","G28592160","G78882255","G81153116","G81152159",
        "G79315198","H81688780","H79521118","G80102254","G80102247",
        "G80219983","G80264658","G80319205","G80331911","G80361256",
        "G80771561","G80789209","G81153090","G81152118","G81688806",
        "G81713364","G81746786","G08175474","G81752347","G81810509",
        "G81835043","G81835050","H81835068","G81851974","G81869323"
        };
        
        String[] cad2={"00301640112710000391",
        "00301640192710000381",
        "00301640102710000382",
        "00301640122710000419",
        "00301640142710000175",
        "00301640122710000383",
        "01095996652710087601",
        "00301640142710000384",
        "00301640162710000385",
        "00301640182710000386",
        "0030164022710000174",
        "00301640112710000387",
        "00301640112710000388",
        "00301640182710000390",
        "98341640132710000389"
        };
            //    for( int i = 0; i < cad.length; i++) {
            //            res = val.checkNif(cad[i]);
            //            System.err.println("Entra-"+cad[i]);
            //     
//	ya comentada de antes		if( res == ValidaNif.DNI_OK || res == ValidaNif.CIF_OK || res > 0)
            //            if( res >= 0)
            //                    System.err.println("Nif OK-"+val.getNif());
            //            else
            //                    System.err.println("Error="+ res+"-"+val.getNif());
            //    }
        for( int i = 0; i < 6; i++) {
            //		for( int i = 0; i < cad2.length; i++) {
            
            res = val.controlaCuenta(cad2[i]);
            if( res == 0)
                System.err.println("CCV OK-"+cad2[i]+"-"+res);
            else
                System.err.println("CCV- MAL="+ res+"-"+cad2[i] );
            
        }
    }
*/    
    
    
    
    /** 
     * Esta funcin valida el nombre, que se ajuste al formato BOE, las tres primeras
     * letras deben ser distintas. Adems en funcin de si es para import junto a NIF o CIF
     * tiene validaciones complementerias.
     * @param nifCif Si es Nif o Cif
     * @param nombre Cadena a validar
     * @return true o false, en funcin de si es correcto o no el nombre introducido.
     */
    
    public static boolean  validaNombre(int nifCif, String nombre)   {
        int resul;
        int p;
        
        if ("".equals(nombre.trim()) || nombre.length() < 3) {
            return false;
        }
        
        if( (nifCif >= CIF_OK) && (nifCif <= CIF_NORESIDENTES_OK) ) {
            resul = 2;
        } else{
        	// Si no se me pasa el NIF, simulo un nif vlido.
            resul = 1; 
        }
        // Tenemos un CIF. No hay que hacer validaciones
        if (resul == 2)  {
            if(nombre.charAt(0) == ' ') {
            	// comienza con un blanco AJGP 18.DIC.2000
                return false;
            } else{
                return true;
            }
        } else  { 
        	// Tenemos un NIF
            if(!isAlfa(nombre)) {
                return false;
            }
            
            int res;
            // Tres primeros caracteres rellenos (el 3 puede ser un blanco)
            for (res=0; res < 3; res++) {
                if (res == 2)  {
                	// el tercer carcter puede ser un blanco.
                    if (!isAlfa(nombre.charAt(res)) && nombre.charAt(res) != '\'') {
                        return false;
                    }
                } else if (!isAlfa(nombre.charAt(res)) && nombre.charAt(res) != '\'' || nombre.charAt(res) == ' ') {
                    return false;
                }
            }
            
            // Tres primeras letras no pueden ser iguales.
            for (resul=1; resul < 3; resul++) {
                if (nombre.charAt(0) != nombre.charAt(resul)) {
                    break;
                }
            }
            
            if (resul == 3) {
                return false;
            }
            
            // Buscamos 2 palabras, la primera de longitud mnima 2.
            p = 0;
            
            // detecto apellido1 con al menos dos caracteres vlidos
            if (nombre.charAt(p++) == ' ') {          
            	// si empieza con blancos error
                return false;
            }
            
            if (nombre.charAt(p) == ' ' || nombre.charAt(p) == '\0') {
                return false;
            }
            
            for (++p; p < nombre.length(); p++) {
                if (nombre.charAt(p) ==    ' ') {
                    break;
                }
            }
            
            // detecto el primer blanco de la cadena
            if (p == nombre.length()) {
                return false;
            }
            
            // detecto que apellido2 tenga al menos un carcter no blanco vlido
            if (nombre.charAt(++p) ==  ' ' || nombre.charAt(p) == '\0') {
                return false;
            }
        }
        return true;
    } 
    
    /** 
     * Esta funcin Sirve para validar un carcter.
     * @param ch Caracter a validar
     * @return true o false, en funcin de si encuentra o no el carcter introducido.
     */
    public static boolean isAlfa(char ch) {
        String letras ="ABCDEFGHIJKLMNOPQRSTUVWXYZ,',-. ";
        
        return letras.indexOf(ch) != -1;
    }
    
    /** 
     * Esta funcin Sirve para validar una cadena.
     * @param cad Cadena a validar
     * @return true o false, en funcin de si encuentra o no los caracteres introducidos.
     */
    public static boolean isAlfa(String cad) {
    	String nuevoCad = cad.toUpperCase();
        
        for (int i = 0; i < nuevoCad.length(); i ++) {
            if ( !isAlfa(nuevoCad.charAt(i))){
                return false;
            }
        }
        return true;
    }
}