package es.aeat.pret.c200.c231.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import org.xml.sax.SAXParseException;

//import com.sun.xml.internal.txw2.output.IndentingXMLStreamWriter;

import es.aeat.pret.c200.api.bean.ErrorValidacionBean;
import es.aeat.pret.c200.api.staxi.IEscribirError;
import es.aeat.pret.c200.imp.bean.PerceptorBeanImpl;

public class EscribirFicheroError implements IEscribirError{

	private static final long serialVersionUID = 1L;
	private static final String DESCENDIENTES = "descendientes";
	private static final String ASCENDIENTES = "ascendientes";
	private static final String CODIGO = "Codigo";
	private static final String ERROR = "Error";
	private static final String ORDEN2 = "Orden";
	private static final String DESCRIPCION = "Descripcion";
	FileOutputStream os;
	XMLOutputFactory xof;
	XMLStreamWriter writer = null;
	
	int retenidos=0;
	boolean empezadoRetenedor=false;
	boolean empezadoErrorNormal=false;
	boolean terminado=false;
	boolean errorRetenedorUnico=false;
	boolean escritoRetenido=false;
	
	
	private Logger getLog() {
		return Logger.getLogger(PerceptorBeanImpl.class.getName());
	}
	
	@Override
	public boolean isTerminado() {
		return terminado;
	}

	@Override
	public boolean isEmpezadoErrorNormal() {
		return empezadoErrorNormal;
	}

	@Override
	public boolean isEmpezadoRetenedor() {
		return empezadoRetenedor;
	}

	@Override
	public void startDocument(File ficheroError) {
		xof = XMLOutputFactory.newInstance(); 
		
		writer = null;
		
		try {
			os = new FileOutputStream(ficheroError);
			
//			writer = new IndentingXMLStreamWriter(xof.createXMLStreamWriter(os, "ISO-8859-1"));
			writer = xof.createXMLStreamWriter(os, "ISO-8859-1");
			xof=null;
			// EMPEZAMOS DOCUMENTO
			writer.writeStartDocument("ISO-8859-1","1.0");
			writer.writeStartElement("AEATRetencionesError2023");
			writer.flush();
		
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		} catch (FileNotFoundException e) {
			getLog().severe(e.getMessage());
		}
	}

	@Override
	public void endDocument() {
		try {			
			// AEATRetencionesError2023
			writer.writeEndElement(); 
			writer.writeEndDocument();

			writer.flush();
			writer.close();
			
			os.flush();
			os.close();
			
			writer=null;
			empezadoRetenedor=false;
			empezadoErrorNormal=false;
			terminado=true;
			
			os=null;
						
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
			
		} catch (IOException e) {
			getLog().severe(e.getMessage());
		}
	}

	@Override
	public void escribirErrorImportacion(Integer linea, Integer pos, String desc) {
		try {
			writer.writeStartElement("ErrorGeneral");
				
			writer.writeStartElement("Linea");
			writer.writeCharacters(linea.toString());
			//Linea
			writer.writeEndElement();
				
			writer.writeStartElement("Posicion");
			writer.writeCharacters(pos.toString());
			//Posicion
			writer.writeEndElement();
					
			writer.writeStartElement(DESCRIPCION);
			writer.writeCharacters(desc);
			//Descripcion
			writer.writeEndElement();

			//ErrorGeneral
			writer.writeEndElement();
			
			writer.flush();
		
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		} 
	}

	@Override
	public void escribirErrorGeneral(SAXParseException event) {
		try {
			Integer integ = null;
			writer.writeStartElement("ErrorGeneral");
				
			writer.writeStartElement("Linea");
			integ = event.getLineNumber();
			writer.writeCharacters(integ.toString());
			//Linea
			writer.writeEndElement();
			
			writer.writeStartElement("Posicion");
			integ = event.getColumnNumber();
			writer.writeCharacters(integ.toString());
			//Posicion
			writer.writeEndElement();
			integ=null;
			
			writer.writeStartElement(DESCRIPCION);
			writer.writeCharacters(event.getMessage());
			//Descripcion
			writer.writeEndElement();
			
			//ErrorGeneral
			writer.writeEndElement();
				
			writer.flush();
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		}
	}

	@Override
	public void endErrorRetenedor() {
		try {
			writer.writeEndElement();
			writer.flush();
			empezadoRetenedor=false;
			empezadoErrorNormal=true;
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		}//Retenedor
	}

	@Override
	public void empiezaErrorNormal() {
		try {
			// EMPEZAMOS ERROR NORMAL
			writer.writeStartElement("IdDoc");
			writer.writeStartElement("CodModelo");
			writer.writeCharacters("RET");
			//CodModelo
			writer.writeEndElement();
			writer.writeStartElement("Ejercicio");
			writer.writeCharacters("2023");
			//Ejercicio
			writer.writeEndElement();
			//IdDoc
			writer.writeEndElement();
			
			writer.flush();
			empezadoErrorNormal=true;
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		}
	}

	@Override
	public void empiezaErrorRetenedor(String nif, Integer orden) {
		try {
			escritoRetenido=false;
			errorRetenedorUnico=false;
			retenidos=0;
			writer.writeStartElement("Retenedor");
			writer.writeStartElement("Nif");
			writer.writeCharacters(nif);
			//Nif
			writer.writeEndElement();
			writer.writeStartElement(ORDEN2);
			writer.writeCharacters(orden.toString());
			//Orden
			writer.writeEndElement();
			
			writer.flush();
			empezadoRetenedor=true;
		
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		}
	}

	@Override
	public void errorRetenido(List<ErrorValidacionBean> lista, String nif,
			Integer indiceRetenido) {
		try {
			ErrorValidacionBean err = lista.get(0);
			if(!errorRetenedorUnico){
				// comprobamos si tenemos error en retenedor, que tiene que ser el primero
				//String codigoError = lista.get(0)[0]
				String codigoError = err.getCodigo();
				if ("R9001".equalsIgnoreCase(codigoError)
						|| "R9002".equalsIgnoreCase(codigoError)
						|| "R9003".equalsIgnoreCase(codigoError)
						|| "R9004".equalsIgnoreCase(codigoError)) {
					errorRetenedorUnico=true;
				} else {
					escritoRetenido=true;
					writer.writeStartElement("Retenido");
					writer.writeStartElement("Nif");
					writer.writeCharacters(nif);
					//Nif
					writer.writeEndElement();
					writer.writeStartElement(ORDEN2);
					writer.writeCharacters(indiceRetenido.toString());
					//Orden
					writer.writeEndElement();
				}
			} else if(errorRetenedorUnico && lista.size()==1 ){
				// tengo solo el error unico
				return;
			} else if(errorRetenedorUnico && lista.size()!=1 ){
				// tengo por lo menos otro error a parte del unico
				escritoRetenido=true;
				writer.writeStartElement("Retenido");
				writer.writeStartElement("Nif");
				writer.writeCharacters(nif);
				//Nif
				writer.writeEndElement();
				writer.writeStartElement(ORDEN2);
				writer.writeCharacters(indiceRetenido.toString());
				//Orden
				writer.writeEndElement();
			}
			
			int indiceAnteriorDesc=0;
			boolean descCerrado=true;
			int numErrores = lista.size();

			for (int i = 0; i < numErrores; i++) {
				err = lista.get(i);

				String codigoError = err.getCodigo();
				String descripcion = err.getMensaje();
				String nombreCampo = err.getPartida();
				Integer incideAsDes = err.getIndice(); 
				if ("R9001".equalsIgnoreCase(codigoError)
						|| "R9002".equalsIgnoreCase(codigoError)
						|| "R9003".equalsIgnoreCase(codigoError)
						|| "R9004".equalsIgnoreCase(codigoError)) {
			
					// solo lo escribimos para el primer retenido
					if (retenidos == 0) {
						if(!descCerrado){
							descCerrado=true;
							//Descendiente
							writer.writeEndElement();
						}
						
						writer.writeStartElement(ERROR);
						writer.writeStartElement(CODIGO);
						writer.writeCharacters(codigoError);
						//Codigo
						writer.writeEndElement();
						writer.writeStartElement(DESCRIPCION);
						writer.writeCharacters(descripcion);
						//Descripcion
						writer.writeEndElement();
						//Error
						writer.writeEndElement();
						errorRetenedorUnico=true;
					}
				} else {
					if (nombreCampo.equalsIgnoreCase(ASCENDIENTES)) {
						if(!descCerrado){
							descCerrado=true;
							//Descendiente
							writer.writeEndElement();
						}
						
						writer.writeStartElement("Ascendiente");
						writer.writeStartElement(ORDEN2);
						Integer orden = incideAsDes+1;
						writer.writeCharacters(orden.toString());
						//Orden
						writer.writeEndElement();
						
						writer.writeStartElement(ERROR);
						writer.writeStartElement(CODIGO);
						writer.writeCharacters(codigoError);
						//Cogido
						writer.writeEndElement();
						writer.writeStartElement(DESCRIPCION);
						writer.writeCharacters(descripcion);
						//Descripcion
						writer.writeEndElement();
						//Error
						writer.writeEndElement();
						
						//Ascendiente
						writer.writeEndElement();
					} else if (nombreCampo.equalsIgnoreCase(DESCENDIENTES)) {
						Integer orden = incideAsDes+1;
						if(orden!=indiceAnteriorDesc){
							if(indiceAnteriorDesc!=0){
								//Descendiente
								writer.writeEndElement();
								descCerrado=true;
							}
							writer.writeStartElement("Descendiente");
							descCerrado=false;
							writer.writeStartElement(ORDEN2);
							writer.writeCharacters(orden.toString());
							//Orden
							writer.writeEndElement();
						}
						
						writer.writeStartElement(ERROR);
						writer.writeStartElement(CODIGO);
						writer.writeCharacters(codigoError);
						//Cogido
						writer.writeEndElement();
						writer.writeStartElement(DESCRIPCION);
						writer.writeCharacters(descripcion);
						//Descripcion
						writer.writeEndElement();
						//Error
						writer.writeEndElement();
						
						indiceAnteriorDesc=orden;
						
						if(orden!=indiceAnteriorDesc){
							//Descendiente
							writer.writeEndElement();
						}
					} else {
						// error que no es de desc/asc
						if(!descCerrado){
							descCerrado=true;
							//Descendiente
							writer.writeEndElement();
						}
						writer.writeStartElement(ERROR);
						writer.writeStartElement(CODIGO);
						writer.writeCharacters(codigoError);
						//Cogido
						writer.writeEndElement();
						writer.writeStartElement(DESCRIPCION);
						writer.writeCharacters(descripcion);
						//Descripcion
						writer.writeEndElement();
						//Error
						writer.writeEndElement();
					}
				}
				
				codigoError = null;
				descripcion = null;
				nombreCampo = null;
				incideAsDes = null;
			}
			if(escritoRetenido){
				escritoRetenido=false;
				//Retenido
				writer.writeEndElement();
			}
			retenidos++;
			
			writer.flush();
	
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		}
	}

}
