package es.aeat.pret.c200.api.bean;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import es.aeat.pret.c200.api.staxi.IEscribirError;
import es.aeat.pret.c200.api.staxi.IEscribirSalida;
import es.aeat.pret.c200.api.staxi.ILeeRetenedor;
import es.aeat.pret.c200.api.staxi.ILeeRetenido;


/**
 * Interfaz bean de perceptor para el clculo de retenciones.
 * 
 * @author f00999ec
 *
 */
/**
 * @author f00999ec
 *
 */
public interface PerceptorBean extends Serializable {
	
	/**
	 * Obtiene el valor de una partida del bean a partir de su nombre de partida.
	 * 
	 * @param partida Nombre de la partida que queremos 
	 * 		recuperar.
	 * @return El valor de la partida.
	 */
	Object getValor(String partida);
	

	/**
	 * Obtiene el valor de una partida del bean a partir de su nombre de partida.
	 * 
	 * @param partida Nombre de la partida que queremos 
	 * 		recuperar.
	 * @return El valor de la partida.
	 */
	BigDecimal getValorAsBigDecimal(String partida);
	
	
	/**
	 * Establece el valor de una partida del bean a partir de su nombre de partida.
	 * 
	 * @param partida: La partida cuyo valor queremos modificar
	 * @param valor: El nuevo valor que queremos establecer en la partida.
	 */
	void setValor(String partida, Object valor);

	/**
	 * Obtiene el valor de una partida indexada del bean a partir de su nombre de partida y
	 * un nmero de ndice
	 * 
	 * @param partida Nombre de la partida que queremos 
	 * 		recuperar.
	 * 
	 * @param indice. ndice de la partida que queremos recuperar.
	 *
	 * @return El valor de la partida.
	 */

	Object getValor(String partida, int indice);
	
	/**
	 * Establece el valor de una partida indexada del bean a partir de su nombre de partida y un
	 * ndice
	 * 
	 * @param partida: La partida cuyo valor queremos modificar
	 * @param inidice: El ndice de la partida que queremos modificar.
	 */
	void setValor(String partida, Object valor, int indice);
	
	/**
	 * Crea un objeto AscendienteBean a partir de los datos recibidos como parmetros
	 * y lo aade a la lista de Ascendientes.
	 * 
	 * @param aoNacimiento Ao de nadicmiento del ascendiente
	 * @param convivencia Nivel de convivencia (por defiecto 1)
	 * @param discapacidad Grado de discapacidad (por defecto 0)
	 * @param movilidadReducida Indicador de movilidad reducida
	 * 
	 * @return un nuevo bean con los datos
	 */
	AscendienteBean createAscendienteBean(Integer anioNacimiento, Integer convivencia, Integer discapacidad, boolean movilidadReducida);


	/**
	 * Crea un objeto DescendienteBean a partir de los datos recibidos como parmetros
	 * y lo aade a la lista de descendientes.
	 * 
	 * @param aoNacimiento Ao de nacimiento del descendiente
	 * @param aoAdopcion Ao de adopcin del descendiente
	 * @param porEntero computado por entero (por defencto false)
	 * @param discapacidad Grado de discapacidad (por defecto 0)
	 * @param movilidadReducida Indicador de movilidad reducida (por defecto false) 
	 * 
	 * @return
	 */
	DescendienteBean createDescendienteBean(Integer anioNacimiento, Integer anioAdopcion,
			boolean porEntero, Integer discapacidad, boolean movilidadReducida);


	/**
	 * Crea un objeto AscendienteBean inicializado a sus valores por defecto.
	 * No lo aade a la lista de ascendientes del perceptor.
	 * 
	 * @return
	 */
	AscendienteBean createAscendienteBean();


	/**
	 * Crea un objeto DescendienteBean inicializado a sus valores por defecto.
	 * No lo aade a la lista de descendientes del perceptor.
	 * @return
	 */
	DescendienteBean createDescendienteBean();


	/**
	 * Borra todos los datos de este bean y los deja en sus 
	 * valores por defecto.
	 */
	void borraDatos();


	/**
	 * Genera un documento XML vlido com el contenido de este bean
	 * 
	 * @param nifRetenedor: NIF del retenedor
	 * @param nombreRetenedor: Nombre del retenedor
	 * @param nombreRetenido: Nombre del retenido.
	 * @return El documento XML
	 
	String generarXML(String nifRetenedor, String nombreRetenedor,
			String nombreRetenido);
*/	
	public List<DescendienteBean> getDescendientes();
	public List<AscendienteBean> getAscendientes();

	//validarLeerFichero
	public File getFicheroSalida();

	public void setFicheroSalida(File ficheroSalida);

	public File getFicheroError();

	public void setFicheroError(File ficheroError);
	
	public String getNombreFicheroEntrada();

	public void setNombreFicheroEntrada(String nombreFicheroEntrada);
	
	public int[] getCuantosRetenidos();

	public void setCuantosRetenidos(int[] cuantosRetenidos);
	
	public int getNuneroRetenedorese();

	public void setNuneroRetenedorese(int nuneroRetenedorese);

	public int getNumRetenidos();

	public void setNumRetenidos(int numRetenidos);
	
	public boolean isErrorImportacion();

	public void setErrorImportacion(boolean errorImportacion);
	
	public boolean isTenemosError();

	public void setTenemosError(boolean tenemosError);
	
	public boolean isComprobandoSalida();

	public void setComprobandoSalida(boolean comprobandoSalida);
	
	public int getErroresImportacion();

	public void setErroresImportacion(int erroresImportacion);

	public ILeeRetenedor getStaxReto();
	
	public void setStaxReto(ILeeRetenedor staxReto);

	public ILeeRetenido getStaxReti();
	
	public void setStaxReti(ILeeRetenido staxReti);
	
	public IEscribirSalida getStax();
	
	public void setStax(IEscribirSalida stax);

	public IEscribirError getStaxE();
	
	public void setStaxE(IEscribirError staxE);
	
	// calculoxmlsrvimpl
	public boolean isCerradaSalidaPorError();

	public void setCerradaSalidaPorError(boolean cerradaSalidaPorError);
	
	public boolean isHuboErroresAntes();

	public void setHuboErroresAntes(boolean huboErroresAntes);

	public boolean isErrorValidacion();

	public void setErrorValidacion(boolean errorValidacion);

	public boolean isAbiertoRetenedor();

	public void setAbiertoRetenedor(boolean abiertoRetenedor);

	public int getIndiceRetenedor();

	public void setIndiceRetenedor(int indiceRetenedor);

	public int getIndiceRetenido();

	public void setIndiceRetenido(int indiceRetenido);

	public File getFicheroSalidaCalculo();

	public void setFicheroSalidaCalculo(File ficheroSalidaCalculo);
	
	public int getNumeroRetenedoresCalculo();
	
	public void setNumeroRetenedoresCalculo(int numeroRetenedoresCalculo);
	
	public int getNumeroRetenidosCalculo();

	public void setNumeroRetenidosCalculo(int numeroRetenidosCalculo);
	
	public void setErr(ErrorValidacionBean error);
	
	public List<ErrorValidacionBean> getErr();
	
	public void borrarErr();
	
	public void escribirDesarrollo(String texto);
	
	public String obtenerDesarrollo();
	
	public void borrarDesarrollo();
}
