package es.aeat.pret.c200.c241.util;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;

import es.aeat.pret.c200.api.bean.PerceptorBean;
import es.aeat.pret.c200.api.bean.PerceptorBeanTipos;
import es.aeat.pret.c200.api.staxi.ILeeRetenedor;
import es.aeat.pret.c200.imp.bean.PerceptorBeanImpl;
import es.aeat.pret.c200.util.NombreNif;

public class LeeRetenedor implements ILeeRetenedor{

	private static final long serialVersionUID = 1L;
	
	private enum Element {NIF,APELLIDOSNOMBRE,RETENEDOR,AEATRETENCIONESENTRADA2024, AEATRETENCIONESSALIDA2024, IDDOC, CODMODELO, EJERCICIO ,RETENIDO}
	private XMLInputFactory factory=null; 
	private final HashMap<String, Element> nameToTypeMapping = new HashMap<>(); 
	private StringBuilder currentText; 
	private Element currentElement; 
	private PerceptorBean modelo=null;
	int indiceRetenedorLeido=-1;
	int indiceRetenedorALeer;
	private ArrayList<NombreNif> lista = null;
	private NombreNif retenedor;
	boolean estamosRetenedor=false;
	String nif;
	XMLStreamReader xmlReader = null;
	// para no importar las causas al traer el xml al programa, ni nif y nombre
	boolean importarXML=false;
	boolean buscarRetenedor=false;
	boolean soloLeer=false;
	
	
	public LeeRetenedor(){
		nameToTypeMapping.put( "Nif" , Element.NIF); 
		nameToTypeMapping.put( "ApellidosNombre" , Element.APELLIDOSNOMBRE); 
		nameToTypeMapping.put( "Retenedor" , Element.RETENEDOR);
		nameToTypeMapping.put( "IdDoc" , Element.IDDOC); 
		nameToTypeMapping.put( "AEATRetencionesEntrada2024" , Element.AEATRETENCIONESENTRADA2024);
		nameToTypeMapping.put( "AEATRetencionesSalida2024" , Element.AEATRETENCIONESSALIDA2024);
		nameToTypeMapping.put( "CodModelo" , Element.CODMODELO);
		nameToTypeMapping.put( "Ejercicio" , Element.EJERCICIO);
		nameToTypeMapping.put( "Retenido" , Element.RETENIDO);
	}
	
	@Override
	public void preparamosLectura() {
		indiceRetenedorLeido=-1;
	}

	@Override
	public void crearXMLReader(FileInputStream input, PerceptorBean modelo,
			boolean importarXML, boolean buscarRetenedor, boolean soloLeer)
			throws XMLStreamException {
		if(factory==null){
			factory = XMLInputFactory.newInstance();
			// Prevenir ataques XXE
			factory.setProperty(XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES, false);
			factory.setProperty(XMLInputFactory.SUPPORT_DTD, false);
		}
		if(xmlReader==null){
			xmlReader = factory.createXMLStreamReader(input);
		}
		
		this.modelo=modelo;
		this.importarXML=importarXML;
		this.buscarRetenedor=buscarRetenedor;
		this.soloLeer=soloLeer;
	}

	@Override
	public void cerrarReader() {
		try {
			if(lista!=null){
				lista=null;
			}
			
			if(xmlReader!=null){
				xmlReader.close();
				xmlReader=null;
			}
			
			modelo=null;
			factory=null;
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		}
	}

	@Override
	public void readXml(int indiceRetenedorALeer) throws XMLStreamException {
		this.indiceRetenedorALeer=indiceRetenedorALeer;

		while (xmlReader.hasNext()) {
			int eventType = xmlReader.next();
			
			switch(eventType) { 
				case XMLEvent.CHARACTERS:
					processText(xmlReader.getText()); 
					break;
				case XMLEvent.END_ELEMENT: 
					if(ended(xmlReader.getLocalName())){
						return;
					}
					break;
				case XMLEvent.START_ELEMENT: 
					startElement(xmlReader.getLocalName()); 
					break;
				case XMLEvent.DTD:
				case XMLEvent.COMMENT:
				case XMLEvent.CDATA: 
				case XMLEvent.SPACE:
				default:
					break;
			} 
		}
	}
	
	private void startElement(String localName) throws XMLStreamException { 
		currentElement = nameToTypeMapping.get(localName); 
		currentText = new StringBuilder(256); 

		// no quiero que haga nada con esto
		if(currentElement == Element.IDDOC || currentElement == Element.CODMODELO 
				|| currentElement == Element.EJERCICIO ){
			return;
		}
		// leemos
		if(soloLeer){
			
			if(currentElement == Element.AEATRETENCIONESENTRADA2024){
				lista=new ArrayList<>();
				estamosRetenedor=false;
			}
			
			if(currentElement == Element.AEATRETENCIONESSALIDA2024){
				lista=new ArrayList<>();
				estamosRetenedor=false;
			}
			
			if(currentElement == Element.RETENEDOR) {
				if(buscarRetenedor){
					indiceRetenedorLeido++;
				}
				estamosRetenedor=true;
				retenedor=new NombreNif();
				return;
			}
			if(currentElement == Element.RETENIDO) {
				estamosRetenedor=false;
				return;
			} else {
				return;
			}
		} else {
			// guardamos
			if(currentElement == Element.RETENEDOR) {
				modelo.borraDatos();
				
				indiceRetenedorLeido++;
				estamosRetenedor=true;
				return;
			}
			if(currentElement == Element.RETENIDO) {
				estamosRetenedor=false;
				return;
			} else {
				return;
			}
		}
	}
	
	private boolean ended(String localName) {
		currentElement = nameToTypeMapping.get(localName);
		if(currentElement != null) { 
			// no quiero que haga nada con esto
			if(currentElement == Element.AEATRETENCIONESENTRADA2024 || currentElement == Element.IDDOC 
					|| currentElement == Element.CODMODELO || currentElement == Element.EJERCICIO ){
				return false;
			}
			// leemos
			if(soloLeer){
				
				if(!"Retenedor".equalsIgnoreCase(currentElement.toString()) &&
						!"Nif".equalsIgnoreCase(currentElement.toString()) &&
						!"ApellidosNombre".equalsIgnoreCase(currentElement.toString())){
					// para que siga leyendo
					return false; 
				}
				
				switch (currentElement) {
					case NIF:
						if(estamosRetenedor){
							retenedor.setNif(currentText.toString());
						}
						break; 
						
					case APELLIDOSNOMBRE:
						if(estamosRetenedor){
							retenedor.setNombre(currentText.toString());
						}
						break; 
					
					case RETENEDOR:
						if(buscarRetenedor && indiceRetenedorALeer==indiceRetenedorLeido){
							lista.add(retenedor);
						}
						else if(!buscarRetenedor){
							lista.add(retenedor);
						}
						retenedor=null;
						estamosRetenedor=false;
						break;
						
					default:
						break;
				}
			} else {
				// guardamos
				// cuando estamos calculando o metiendo importando xml a modelo
				if(indiceRetenedorALeer!=indiceRetenedorLeido){
					return false;
				}
				
				switch (currentElement) {
					case NIF:		
						if(estamosRetenedor){
							// si estamos en ConvertirXML (XML a programa), el NIF lo rellenamos nosotros
							if(!importarXML){						
								modelo.setValor(PerceptorBeanTipos.P_NIFRET, currentText.toString());
							} else {
								//modelo.setDato("NIFRET", ModeloRetencionesRemote.NIFRET)
								modelo.setValor(PerceptorBeanTipos.P_NIFRET, (String)modelo.getValor(PerceptorBeanTipos.P_NIFRET));
							}
						}
						break; 
						
					case APELLIDOSNOMBRE:
						if(estamosRetenedor){
							// si estamos en ConvertirXML (XML a programa), el NIF lo rellenamos nosotros
							if(!importarXML){
								modelo.setValor(PerceptorBeanTipos.P_APERET, currentText.toString());
							} else {
								//modelo.setDato("APERET", ModeloRetencionesRemote.APERET)
								modelo.setValor(PerceptorBeanTipos.P_APERET, (String)modelo.getValor(PerceptorBeanTipos.P_APERET));
							}
						}
						break; 
				
					case RETENEDOR:
						estamosRetenedor=false;
						return true;
					
					default:
						break;
				}
			}

			currentElement = null; 
			currentText = null; 
			
		}
		return false;
	} 
	
	private void processText(String text) { 
		
		if(currentElement != null && currentText != null) { 
			currentText.append(text); 
		} 
	} 

	@Override
	public List<String> getLista() {
		if(lista==null){
			return null;
		}
		
		ArrayList<String> hm = new ArrayList<>();
		int numl = lista.size();
		for(int i=0;i<numl;i++){
			NombreNif nn = (NombreNif)lista.get(i);
			hm.add(nn.getNombre()+"-"+nn.getNif());
		}
		
		return hm;
	}

	private Logger getLog() {
		return Logger.getLogger(PerceptorBeanImpl.class.getName());
	}
	
}
