package es.aeat.pret.c200.api.bean;

import java.io.Serializable;

public interface ErrorValidacionBean extends Serializable{
	
	/**
	 * Tipos de errores de validacin.
	 *
	 */
	enum TipoErrorValidacion {ERROR, AVISO, ERROR_ESQUEMA}
	
	/**
	 * Devuelve el tipo de error de este error.
	 * @return Tipo de error de validacin.
	 */
	TipoErrorValidacion getTipo();

	/**
	 * Devuelve el cdigo de error de este error.
	 * @return El cdigo de error.
	 */
	String getCodigo();
	
	/**
	 * Devuelve el mensaje de error asociado a este error.
	 * @return
	 */
	String getMensaje();

	/**
	 * Devuelve el nombre de la partida que origin este error.
	 * @return el nombre de la partida
	 */
	String getPartida();
	
	/**
	 * Si la partida que origin el error es una partida indexada,
	 * devuelve el ndice del elemento que origin el error. 
	 *
	 * @return
	 */
	int getIndice();
	
}
