package es.aeat.pret.c200.api.srv;

import java.io.Serializable;

import es.aeat.pret.c200.api.bean.PerceptorBean;
import es.aeat.pret.c200.api.exception.RetencionesExcepcion;

/**
 * Servicio de clculo de retenciones para calificacin RETMAL. 
 *
 */
public interface CalculoRETMALSrv extends Serializable {
	/**
	 * Realiza un clculo de retenciones a partir de un registro de perceptor
	 * del modelo 190. El ejercicio se obtiene del propio registro. 
	 * 
	 * <p>Ejemplo de uso</p>  
	 *	
	 *  <pre> 
	 * 	String registro = "21902021...........";
	 *	CalculoRETMALSrv retmalSrv = PRET_C200_Factory.getCalculoRETMALSrv();
	 *
	 *	PerceptorBean bean = null;
	 *	try {
	 *	   bean = retmalSrv.calcular(registro);
	 *	} catch (RetencionesExcepcion e) { 
	 *		// TODO: HACER COSAS CON LA EXCEPCIN
	 *	}
     *
	 *	// COMPROBAR EL RESULTADO DEL CLCULO
	 *	List&lt;ErrorValidacionBean&gt; err = bean.getErr();
     *
	 *	if (err.isEmpty()) {
	 *	   // SI LA LISTA DE ERRORES EST VACA ES QUE EL CLCULO FUE BIEN
	 *	   final BigDecimal tipoRetencion = bean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPO);
	 *	   final BigDecimal importeRetencion = bean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTE);
	 *	} else {
	 *	   // MOSTRAR LA LISTA DE ERRORES
	 *	   err.stream().forEach(e -> System.out.println(e.getCodigo() + " " + e.getMensaje()));
	 *	}
	 *  </pre>
	 * 
	 * @param registro190 El registro del 190
	 * @return un bean con el resultado del clculo
	 */
	PerceptorBean calcular(String registro190) throws RetencionesExcepcion;
}
