package es.aeat.pret.c200.c210.imp.srv;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;

import es.aeat.pret.c200.api.bean.PerceptorBean;
import es.aeat.pret.c200.api.bean.PerceptorBeanTipos;
import es.aeat.pret.c200.c210.api.srv.CalculoRetencionesSrv;
import es.aeat.pret.c200.api.bean.AscendienteBean;
import es.aeat.pret.c200.api.bean.DescendienteBean;
import es.aeat.pret.c200.api.bean.ErrorValidacionBean;
import es.aeat.pret.c200.api.bean.ErrorValidacionBean.TipoErrorValidacion;
import es.aeat.pret.c200.imp.bean.AscendienteBeanImpl;
import es.aeat.pret.c200.imp.bean.DescendienteBeanImpl;
import es.aeat.pret.c200.imp.bean.ErrorValidacionBeanImpl;
import es.aeat.pret.c200.imp.bean.PerceptorBeanImpl;
import es.aeat.pret.c200.util.ValidaNif;


public class CalculoRetencionesSrvImpl implements CalculoRetencionesSrv {
	
	private static final long serialVersionUID = 1L;
	private static final String REGULARIZACION_CONSIGNADA = "regularizacin consignada.";

	private static final String REGULARIZACION_INCOMPATIBLES_ENTRE_SI = "Ha seleccionado causas de regularizacin incompatibles entre s.";


	/**
	 * Lista de los caracteres admitidos en en un NIF
	 */
	public static final String VALIDOSNIF = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

	private static final BigDecimal LIMITE_33007_CON_20 = new BigDecimal("33007.20");
	private static final BigDecimal LIMITE_22000 = new BigDecimal("22000.00");
	private static final BigDecimal LIMITE = new BigDecimal("0.43");

	private static final BigDecimal CERODOS = new BigDecimal("0.02");

	private static final BigDecimal BD1200 = new BigDecimal("1200.00");
	private static final BigDecimal BD600 = new BigDecimal("600.00");

	// 2016 
	private static final BigDecimal BD030 = new BigDecimal("0.30");

	// 2015
	private static final BigDecimal BD90000 = new BigDecimal("90000.00");
	private static final BigDecimal BD5550 = new BigDecimal("5550.00");
	private static final BigDecimal BD2000 = new BigDecimal("2000.00");
	private static final BigDecimal BD1400 = new BigDecimal("1400.00");
	private static final BigDecimal BD8100 = new BigDecimal("8100.00");
	private static final BigDecimal BD7750 = new BigDecimal("7750.00");
	private static final BigDecimal BD3500 = new BigDecimal("3500.00");
	private static final BigDecimal BD1150 = new BigDecimal("1150.00");
	private static final BigDecimal BD2400 = new BigDecimal("2400.00");
	private static final BigDecimal BD2700 = new BigDecimal("2700.00");
	private static final BigDecimal BD4000 = new BigDecimal("4000.00");
	private static final BigDecimal BD4500 = new BigDecimal("4500.00");
	private static final BigDecimal BD2800 = new BigDecimal("2800.00");
	private static final BigDecimal BD9000 = new BigDecimal("9000.00");
	private static final BigDecimal BD3000 = new BigDecimal("3000.00");
	private static final BigDecimal BD1980 = new BigDecimal("1980.00");
	private static final BigDecimal BD2 = new BigDecimal("2.00");
	
	// LPE
	private static final BigDecimal BD5565 = new BigDecimal("5565.00");
	private static final BigDecimal BD13115 = new BigDecimal("13115.00");
	private static final BigDecimal BD16825 = new BigDecimal("16825.00");
	private static final BigDecimal BD15 = new BigDecimal("1.5");
	private static final BigDecimal BD040 = new BigDecimal("0.40");
	private static final BigDecimal BD66014 = new BigDecimal("660.14");
	
	private static final BigDecimal BD12450 = new BigDecimal("12450.00");
	private static final BigDecimal BD019 = new BigDecimal("0.19");
	private static final BigDecimal BD20200 = new BigDecimal("20200.00");
	private static final BigDecimal BD236550 = new BigDecimal("2365.50");
	private static final BigDecimal BD024 = new BigDecimal("0.24");
	private static final BigDecimal BD60000 = new BigDecimal("60000.00");
	private static final BigDecimal BD872550 = new BigDecimal("8725.50");
	private static final BigDecimal BD045 = new BigDecimal("0.45");
	private static final BigDecimal BD1790150 = new BigDecimal("17901.50");
	
	private static final BigDecimal BD047 = new BigDecimal("0.47");
	private static final BigDecimal BD300000 = new BigDecimal("300000.00");
	private static final BigDecimal BD12590150 = new BigDecimal("125901.50");

	private static final BigDecimal BD35200 = new BigDecimal("35200.00");
	private static final BigDecimal BD42255 = new BigDecimal("4225.50");
	private static final BigDecimal BD037 = new BigDecimal("0.37");

	private static final String POR_MITAD = "Por mitad";
	private static final String POR_ENTERO = "Por entero";
	private static final String DESCENDIENTES_ORDENADOS = "descendientesOrdenados";
	private static final String ERR_RETRIBA = "retriba";
	private static final String ERR_MINORADO = "minorado";
	private static final String ERR_MINOPAGOA = "minopagoa";
	private static final String ERR_TIPOA = "tipoa";
	private static final String ERR_MINPERFAA = "minperfaa";
	private static final String ERR_BASEA = "basea";
	private static final String ERR_CAUSA = "causa";
	private static final String ERR_PRESVIV = "presviv";
	private static final String ERR_DESCENDIENTES = "descendientes";
	private static final String ERR_NIFCON = "nifcon";
	private static final String ERR_ANOPER = "anoper";
	private static final String ERR_NIFPER = "nifper";
	private static final String ERR_NIFRET = "nifret";
	private static final String ERR_SITUFAM = "situfam";
	private static final String ERR_PERCIBIDO = "percibido";
	private static final String ERR_RETRIB = "retrib";
	private static final String ERR_IRREGULAR1 = "irregular1";
	
	// 2019
	private static final BigDecimal BD17634 = new BigDecimal("17634.00");
	private static final BigDecimal BD15947 = new BigDecimal("15947.00");
	private static final BigDecimal BD17100 = new BigDecimal("17100.00");
	private static final BigDecimal BD15456 = new BigDecimal("15456.00");
	private static final BigDecimal BD16481 = new BigDecimal("16481.00");
	private static final BigDecimal BD14000 = new BigDecimal("14000.00");
	private static final BigDecimal BD14516 = new BigDecimal("14516.00"); 
	private static final BigDecimal BD15093 = new BigDecimal("15093.00");

	
	@SuppressWarnings("unchecked")
	@Override
	public boolean validar(PerceptorBean perceptorBean, boolean desdeFichero) {
		// INCIDENCIAS 5. 6. 7. 8. 11. 12. 15. 17.
		// revisar 9, 10
		// NO OCURREN PORQUE SE CIERRAN LOS CAMPOS O POR ESQUEMA INCORRECTO
		
		calculoYComputoDeDescendientes(perceptorBean);
		calculoYComputoDeAscendientes(perceptorBean);
		setRegularizacion(perceptorBean);
		
		if (perceptorBean.getErr() == null) {
			perceptorBean.borrarErr();
		}

		ValidaNif vln = new ValidaNif();
		String nifRet = (String) perceptorBean.getValor(PerceptorBeanTipos.P_NIFRET);
		int resul = vln.checkNif(nifRet);

		// 0. Validacin del NIF del retenedor. (Para clculos desde fichero)
		if ("".equals(nifRet.trim())) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
					"R9001", 
					"No existe NIF del retenedor.", 
					ERR_NIFRET, -1));
		} else if (!validaNifMayus(nifRet)) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
					"R9002", 
					"El NIF del retenedor es incorrecto.", 
					ERR_NIFRET, -1));
		} else if (resul == ValidaNif.NIF_ERROR || !vln.isOk()) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
					"R9003", 
					"El NIF del retenedor es incorrecto.", 
					ERR_NIFRET, -1));
		}
		
		// extra aburrimiento para los clculos o importacin
		String nifRetenedor=(String) perceptorBean.getValor(PerceptorBeanTipos.P_NIFRET);
		String nombreRetenedor=(String) perceptorBean.getValor(PerceptorBeanTipos.P_APERET);
		
		if (!"".equals(nifRetenedor.trim()) && !"".equals(nombreRetenedor)){
			resul = vln.checkNif(nifRetenedor);
			if((vln.esPersonaFisica(resul, false) && !esAlfabeticoAEAT(nombreRetenedor)) ||
					(!vln.esPersonaFisica(resul, false) && !esAlfanumericaAEAT(nombreRetenedor)) ){
				// la parte de persona juridica deberia hacerlo el esquema, pero que mas da...
				perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
						"R9004", 
						"Nombre del retenedor incorrecto.", 
						ERR_NIFPER, -1));
			} 
		}

		// lo quito porque se hace desde el esquema, y ahora con los caracteres extendidos es mas lio
		// 0. Comprobar apellidos y nombre		
//		if (!ValidaNif.validaNombre(resul, (String) perceptorBean.getValor(PerceptorBeanTipos.P_APERET))) {
//			perceptorBean.setErr(new ErrorValidacionBeanImpl(
//					TipoErrorValidacion.ERROR,
//					"R9004",
//					"Contenido incorrecto en Apellidos y nombre del retenedor.",
//					"aperet", -1));
//		}

		// 1. Si NIF = blancos o de persona jurdica: NIF del perceptor obligatorio de persona fsica
		String nifPer = (String) perceptorBean.getValor(PerceptorBeanTipos.P_NIFPER);
		resul = vln.checkNif(nifPer);

		if ("".equals(nifPer.trim()) || !vln.esPersonaFisica(resul, false)) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
					"R9005", 
					"NIF del perceptor obligatorio de persona fsica.", 
					ERR_NIFPER, -1));
		} else if (!validaNifMayus(nifPer)) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
					"R9006", 
					"NIF del perceptor obligatorio de persona fsica.", 
					ERR_NIFPER, -1));
		} else if (resul == ValidaNif.NIF_ERROR || !vln.isOk()) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
					"R9007", 
					"NIF del perceptor incorrecto.", 
					ERR_NIFPER, -1));
		}

		// lo quito porque se hace desde el esquema, y ahora con los caracteres extendidos es mas lio
		// APELLIDOS Y NOMBRE DEL PERCEPTOR
		/* CLCULOS DESDE FICHERO */
//		if (!validaNombrePerceptor((String) perceptorBean.getValor(PerceptorBeanTipos.P_APEPER), resul)) {
//			perceptorBean.setErr(new ErrorValidacionBeanImpl(
//					TipoErrorValidacion.ERROR,
//					"R9009",
//					"Contenido incorrecto en Apellidos y nombre del perceptor.",
//					"apeper", -1));
//		}

		
		
		
		// 2. Si AOPER = 0: Ao de nacimiento del perceptor obligatorio
		boolean bValidarRangoAnio = true;
		Integer anioPer = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_ANIOPER);
		if (anioPer == 0) {
			if (!desdeFichero) {
				// Estamos en validacin desde pantalla
				perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
						"R9010",
						"Ao de nacimiento del perceptor obligatorio.",
						ERR_ANOPER, -1));
			} else {
				// Estamos en validacin desde fichero o desde XML
				perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
						"R9011", 
						"Ao nacimiento perceptor incorrecto.",
						ERR_ANOPER, -1));
			}
			bValidarRangoAnio = false;
		}

		// SEGN ESQUEMA
		if (bValidarRangoAnio && (anioPer < PerceptorBeanTipos.ANIOMIN || anioPer > PerceptorBeanTipos.ANIOEJ_21)) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
					"R9012", 
					"Ao nacimiento perceptor incorrecto.", 
					ERR_ANOPER, -1));
		}

		// 3. Si SITUFAM = 0: Situacin familiar del perceptor obligatoria
		int situFam = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_SITUFAM);
		if (situFam < PerceptorBeanTipos.SITUACION1 || situFam > PerceptorBeanTipos.SITUACION3) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
					"R9013",
					"La situacin familiar del perceptor es obligatoria.",
					ERR_SITUFAM, -1));
		}

		// 14. Si (NUMDES = 0 y SITUFAM = SITUACION1): La situacin familiar 1 exige que el contribuyente tenga al menos un descendiente que 
		// d derecho a la reduccin de la tributacin conjunta para familias monoparentales
		int numDes = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_NUMDES);
		if (situFam == PerceptorBeanTipos.SITUACION1 && (numDes == 0)) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9014",
						"La situacin familiar \"1\" exige que el contribuyente tenga al menos un descendiente que"
								+ " d derecho a la reduccin de la tributacin conjunta para familias monoparentales.",
						ERR_SITUFAM, -1));
		}

		// 4. Si (NIFCON = blancos y SITUFAM = SITUACION2): NIF del cnyuge obligatorio
		if (situFam == PerceptorBeanTipos.SITUACION2) {
			String nifCon = (String) perceptorBean.getValor(PerceptorBeanTipos.P_NIFCON);
			resul = vln.checkNif(nifCon);
			if ("".equals(nifCon.trim())) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
						"R9015", 
						"NIF del cnyuge obligatorio.", 
						ERR_NIFCON, -1));
			} else if (!validaNifMayus(nifCon)) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR, 
						"R9016", 
						"El NIF del cnyuge es incorrecto.", 
						ERR_NIFCON, -1));
			} else if (resul == ValidaNif.NIF_ERROR || !vln.isOk()) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
						"R9017", 
						"El NIF del cnyuge es incorrecto.", 
						ERR_NIFCON, -1));
			} else if (!vln.esPersonaFisica(resul, false)) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
						"R9018", 
						"El NIF del cnyuge ha de ser de persona fsica.", 
						ERR_NIFCON, -1));
			} else if (nifCon.equals(nifPer)) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9019", 
						"El NIF del cnyuge no puede ser el mismo que el del contribuyente.", 
						ERR_NIFCON, -1));
			}
		}

		vln = null;

		// 9. Si SITUPER = blancos: Situacin laboral del perceptor obligatoria
		// Situper siempre tiene contenido, si metemos uno incorrecto damos error
		int situPer = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_SITUPER);
		if (situPer != PerceptorBeanTipos.ACTIVO
				&& situPer != PerceptorBeanTipos.PENSIONISTA
				&& situPer != PerceptorBeanTipos.DESEMPLEADO
				&& situPer != PerceptorBeanTipos.OTRASSITUACIONES) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
					"R9020",
					"Situacin laboral del perceptor incorrecta.",
					"situper", -1));
		}

		// 10. Si (SITUPER = ACTIVO y CONTRATO = blancos): Tipo de contrato obligatorio
		// Tipo contrato siempre tiene contenido, si metemos uno incorrecto damos error 
		int contrato = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_CONTRATO);
		if (situPer == PerceptorBeanTipos.ACTIVO
				&& contrato != PerceptorBeanTipos.GENERAL
				&& contrato != PerceptorBeanTipos.INFERIORALANIO
				&& contrato != PerceptorBeanTipos.RELACIONESPECIAL
				&& contrato != PerceptorBeanTipos.MANUALES) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
					"R9021", 
					"Tipo de contrato incorrecto.",
					"contrato", -1));
		}

		// 13. Si (EDADES > 24 y DISCADES = SIN DISCAPACIDAD): Descendientes mayores de 25 aos sin discapacidad no dan derecho a mnimo
		List<DescendienteBean> descendientes = (List<DescendienteBean>) perceptorBean.getValor(PerceptorBeanTipos.P_DESCENDIENTES);
		int nD = descendientes.size();
		for (int i = 0; i < nD; i++) {
			int edad = PerceptorBeanTipos.ANIOEJ_21 - descendientes.get(i).getAnioNacimiento();
			if (edad > 24 && descendientes.get(i).getDiscapacidad() == PerceptorBeanTipos.SINDISCAPACIDAD) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9022",
						"Descendientes mayores de 25 aos sin discapacidad no dan derecho a mnimo.",
						ERR_DESCENDIENTES, i));
			}

			// si tenemos adopcion
			if (descendientes.get(i).getAnioAdopcion() != 0) {
				// comprobamos que ao nacimiento<ao adopcion
				if (descendientes.get(i).getAnioNacimiento() > descendientes.get(i).getAnioAdopcion()) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9024",
							"El ao de adopcin debe ser igual o mayor al ao de nacimiento.",
							ERR_DESCENDIENTES, i));
				}
			}
		}
		descendientes = null;
		
		// 16. Si (EDADAS < 65 y DISCAS = SIN DISCAPACIDAD): Ascendientes menores de 65 aos sin discapacidad no dan derecho a mnimo
		List<AscendienteBean> ascendientes = (List<AscendienteBean>) perceptorBean.getValor(PerceptorBeanTipos.P_ASCENDIENTES);
		int nA = ascendientes.size();
		for (int i = 0; i < nA; i++) {
			int edad = PerceptorBeanTipos.ANIOEJ_21 - ascendientes.get(i).getAnioNacimiento();
			if (edad < 65 && ascendientes.get(i).getDiscapacidad() == PerceptorBeanTipos.SINDISCAPACIDAD) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9023",
						"Ascendientes menores de 65 aos sin discapacidad no dan derecho a mnimo.",
						"ascendientes", i));
			}
		}
		ascendientes=null;
		
		// 18. Si RETRIB = 0,00: Las retribuciones totales son obligatorias
		BigDecimal retrib = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB);
		if (retrib.compareTo(BigDecimal.ZERO) == 0 ){
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
					"R9025", 
					"Las retribuciones totales son obligatorias.",
					ERR_RETRIB, -1));
		}

		BigDecimal irregular1 = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IRREGULAR1);
		// 19. Si IRREGULAR1 > 90.000,00: La cuanta mxima de la reduccin (art. 18.2 LIRPF) no puede superar el importe de 90.000 euros
		if (irregular1.compareTo(BD90000) > 0) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(
					TipoErrorValidacion.ERROR,
					"R9026",
					"La cuanta mxima de la reduccin (art. 18.2 LIRPF) no puede superar el importe de 90.000 euros.",
					ERR_IRREGULAR1, -1));
		}

		// 20. Si IRREGULAR1> RETRIB x 0,30: La cuanta mxima de la reduccin (art.18.2 LIRPF) no puede superar, con carcter general, el 30% de las retribuciones totales
		if (irregular1.compareTo(retrib.multiply(BD030)) > 0) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(
					TipoErrorValidacion.ERROR,
					"R90281",
					"La cuanta mxima de la reduccin (art.18.2 LIRPF) no puede superar con carcter general, el 30% de las retribuciones totales.",
					ERR_IRREGULAR1, -1));
		}

		// 21. Si RETRIB >= 33.007,20 y PRESVIV= S: Las retribuciones totales anuales consignadas no son inferiores a 33.007,20 euros, por lo que en la pantalla 
		// de datos econmicos deber desactivarse la casilla relativa a los pagos por prstamos destinados a la adquisicin o rehabilitacin de la 
		// vivienda habitual del perceptor
		Boolean presviv = (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_PRESVIV);
		if (presviv && retrib.compareTo(LIMITE_33007_CON_20) >= 0) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(
					TipoErrorValidacion.ERROR,
					"R9028",
					"Las retribuciones totales anuales consignadas no son"
							+ " inferiores a 33.007,20 euros, por lo que en la pantalla de"
							+ " datos econmicos deber desactivarse la casilla relativa a"
							+ " los pagos por prstamos destinados a la adquisicin o"
							+ " rehabilitacin de la vivienda habitual del perceptor.",
					ERR_PRESVIV, -1));

		}

		boolean regularizacion = (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_REGULARIZACION);
		BigDecimal tipoa = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOA);
		BigDecimal minperfaa = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFAA);
		BigDecimal basea = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASEA);
		boolean[] causa = (boolean[]) perceptorBean.getValor(PerceptorBeanTipos.P_CAUSA);
		boolean minorado = (Boolean)perceptorBean.getValor(PerceptorBeanTipos.P_MINORADO);
		BigDecimal minopagoa = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGOA);
		BigDecimal percibido = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PERCIBIDO);
		BigDecimal retriba = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIBA);
		BigDecimal importea = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTEA);
		boolean resiceme = (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_RESICEME);
		boolean rencemea = (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_RENCEMEA);
		boolean renceme = (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_RENCEME);
		
		if (regularizacion) {
			if (causa[9]) {
				// 47. Si (REGULARIZACION = S y CAUSA9 = S y CAUSA10 = S): Ha seleccionado dos causas incompatibles entre si
				// 48. Si (REGULARIZACION = S y CAUSA9 = S y CAUSA1 a CAUSA8 = S y CAUSA11 = S  ): Ha seleccionado causas de regularizacin incompatibles entre s
				for (int i = 1; i <= 11; i++) {
					if (causa[i] && i != 9) {
						perceptorBean.setErr(new ErrorValidacionBeanImpl(
								TipoErrorValidacion.ERROR,
								"R9032",
								REGULARIZACION_INCOMPATIBLES_ENTRE_SI,
								ERR_CAUSA, 9));
						break;
					}
				}

				// 50. Si REGULARIZACION = S y CAUSA9 = S y PRESVIV = N: Si el perceptor no comunica que efecta pagos por prstamos, la causa de regularizacin no 
				// puede ser la realizacin de pagos por prstamos destinados para la adquisicin de la vivienda habitual
				if (!presviv) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9033",
							"Si el perceptor no comunica que efecta pagos por prstamos, la causa"
									+ " de regularizacin no puede ser la realizacin de pagos por prstamos"
									+ " destinados para la adquisicin de la vivienda habitual.",
							ERR_PRESVIV, -1));
				}

				// 60. Si (REGULARIZACIN = S y CAUSA9 = S y BASEA > 0,00): Base para calcular el tipo de retencin determinada antes de la regularizacin incompatible 
				// con la causa de regularizacin consignada
				if (basea.compareTo(BigDecimal.ZERO) > 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9034",
							"Base para calcular el tipo de retencin determinada antes de la regularizacin incompatible con"
									+ " la causa de regularizacin consignada.",
							ERR_BASEA, -1));
				}

				// 61. Si (REGULARIZACIN = S y CAUSA9 = S y MINPERFAA > 0,00): Mnimo personal y familiar determinado antes de la regularizacin incompatible 
				// con la causa de regularizacin consignada
				if (minperfaa.compareTo(BigDecimal.ZERO) > 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9035",
							"Mnimo personal y familiar determinado antes de la regularizacin incompatible con la causa de regularizacin consignada.",
							ERR_MINPERFAA, -1));
				}

				// 62. Si (REGULARIZACIN = S y CAUSA9 = S y TIPOA > 0,00): Tipo de retencin aplicado con anterioridad a la regularizacin incompatible 
				// con la causa de regularizacin consignada
				if (tipoa.compareTo(BigDecimal.ZERO) > 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9036",
							"Tipo de retencin aplicado con anterioridad a la regularizacin incompatible con la causa de "+ REGULARIZACION_CONSIGNADA, 
							ERR_TIPOA, -1));
				}
			}

			if (causa[10]) {
				// 49. Si (REGULARIZACION = S y CAUSA10 = S y CAUSA1 a CAUSA8 = S y CAUSA11 = S ): Ha seleccionado causas de regularizacin incompatibles entre s
				for (int i = 1; i <= 11; i++) {
					if (causa[i] && i != 10) {
						perceptorBean.setErr(new ErrorValidacionBeanImpl(
								TipoErrorValidacion.ERROR,
								"R9037",
								REGULARIZACION_INCOMPATIBLES_ENTRE_SI,
								ERR_CAUSA, 10));
						break;
					}
				}

				// 63. Si (REGULARIZACIN = S y CAUSA10 = S y BASEA > 0,00): Base para calcular el tipo de retencin determinada antes de la regularizacin 
				// incompatible con la causa de regularizacin consignada
				if (basea.compareTo(BigDecimal.ZERO) > 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9038",
							"Base para calcular el tipo de retencin determinada antes de la regularizacin incompatible con"
									+ " la causa de regularizacin consignada.",
							ERR_BASEA, -1));
				}

				// 64. Si (REGULARIZACIN = S y CAUSA10 = S y MINPERFAA > 0,00): Mnimo personal y familiar determinado antes de la regularizacin incompatible 
				// con la causa de regularizacin consignada
				if (minperfaa.compareTo(BigDecimal.ZERO) > 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9039",
							"Mnimo personal y familiar determinado antes de la regularizacin incompatible con la causa de "+ REGULARIZACION_CONSIGNADA,
							ERR_MINPERFAA, -1));
				}

				// 65. Si (REGULARIZACIN = S y CAUSA10 = S y TIPOA > 0,00): Tipo de retencin aplicado con anterioridad a la regularizacin incompatible 
				// con la causa de regularizacin consignada
				if (tipoa.compareTo(BigDecimal.ZERO) > 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9040",
							"Tipo de retencin aplicado con anterioridad a la regularizacin incompatible con la causa de "+ REGULARIZACION_CONSIGNADA, 
							ERR_TIPOA, -1));
				}

				// ??
				if (presviv && retrib.compareTo(LIMITE_33007_CON_20) < 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9041",
							"Si el perceptor ha comunicado que efecta pagos para el prstamo de su vivienda la causa de"
									+ " regularizacin no puede ser la improcedencia de reduccin del tipo de retencin por pagos de"
									+ " prstamos destinados a la adquisicin o rehabilitacin de su vivienda habitual.",
							ERR_PRESVIV, -1));
				}
			}

			// 51 Si (REGULARIZACION = S y MINORADO = S y MINOPAGOA = 0): Debe consignar el importe de la minoracin por pagos de prstamos para vivienda 
			// antes de la regularizacin
			if (minorado && minopagoa.compareTo(BigDecimal.ZERO) == 0) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
						"R9042",
						"Debe consignar el importe de la minoracin por pagos de prstamos para vivienda antes de la regularizacin.",
						ERR_MINOPAGOA, -1));

			}

			// 52. Si (REGULARIZACION = S y MINORADO= S y (MINOPAGOA > 660.14 o MINOPAGOA>2,00%*RETRIBA)): El importe de la minoracin por pagos de prstamos 
			// para vivienda determinado  antes de la regularizacin no puede superar el 2 por 100 de las retribuciones totales anuales determinadas antes de 
			// la regularizacin ni tampoco ser mayor de 660,14 euros
			if (minorado && 
					(minopagoa.compareTo(BD66014) > 0 || minopagoa.compareTo(retriba.multiply(CERODOS).setScale(2,BigDecimal.ROUND_DOWN)) > 0)) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9044",
						"El importe de la minoracin por pagos de prstamos para vivienda determinado antes de la"
								+ " regularizacin no puede superar el 2 por 100 de las retribuciones totales anuales determinadas"
								+ " antes de la regularizacin ni tampoco ser mayor de 660,14 euros.",
							ERR_MINORADO, -1));

			}
			
			// 53. Si (REGULARIZACION = S y CAUSA9 = N y PRESVIV = S y MINORADO= N): Si el perceptor ha comunicado que realiza pagos para el prstamo de su vivienda 
			// y antes de la regularizacin no se aplic minoracin por dicho concepto por pagos, la causa de regularizacin debe ser 'El perceptor ha comunicado 
			// que realiza pagos por prstamos destinados a la adquisicin o rehabilitacin de su vivienda habitual'
			if (!causa[9] && !causa[11] && presviv && !minorado) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9045",
						"Si el perceptor ha comunicado que realiza pagos para el prstamo de su vivienda"
								+ " y antes de la regularizacin no se aplic minoracin por dicho concepto por pagos,"
								+ " la causa de regularizacin debe ser \"El perceptor ha comunicado que realiza pagos por"
								+ " prstamos destinados a la adquisicin o rehabilitacin de su vivienda habitual\".",
							ERR_MINORADO, -1));
			}

			if (causa[11]) {
				// 74. Si (REGULARIZACIN = S y CAUSA11 = S y CAUSA1 a CAUSA10 = S): Ha seleccionado causas de regularizacin incompatibles entre s
				for (int i = 1; i <= 11; i++) {
					if (causa[i] && i != 11) {
						perceptorBean.setErr(new ErrorValidacionBeanImpl(
								TipoErrorValidacion.ERROR,
								"R9046",
								REGULARIZACION_INCOMPATIBLES_ENTRE_SI,
								ERR_CAUSA, 11));
						break;
					}
				}

				// 66. Si (REGULARIZACIN = S y CAUSA11 = S y IMPORTEA > 0,00): Retenciones totales anuales determinadas antes de la regularizacin incompatible 
				// con Otras causas de regularizacin
				if (importea.compareTo(BigDecimal.ZERO) > 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9051",
							"Retenciones totales anuales determinadas antes de la regularizacin incompatible con Otras causas de regularizacin.",
							ERR_CAUSA, 11));
				}

				// 67. Si (REGULARIZACIN = S y CAUSA11 = S y BASEA > 0,00): Base para calcular el tipo de retencin determinada antes de la regularizacin incompatible 
				// con Otras causas de regularizacin
				if (basea.compareTo(BigDecimal.ZERO) > 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9053",
							"Base para calcular el tipo de retencin determinada antes de la regularizacin incompatible con Otras causas de regularizacin.",
							ERR_CAUSA, 11));
				}

				// 68. Si (REGULARIZACIN = S y CAUSA11 = S y MINPERFAA > 0,00): Mnimo personal y familiar determinado antes de la regularizacin incompatible 
				// con Otras causas de regularizacin
				if (minperfaa.compareTo(BigDecimal.ZERO) > 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9054",
							"Mnimo personal y familiar determinado antes de la regularizacin incompatible con Otras causas de regularizacin.",
							ERR_CAUSA, 11));
				}

				// 69. Si (REGULARIZACIN = S y CAUSA11 = S y TIPOA > 0,00): Tipo de retencin aplicado con anterioridad a la regularizacin incompatible 
				// con Otras causas de regularizacin
				if (tipoa.compareTo(BigDecimal.ZERO) > 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9055",
							"Tipo de retencin aplicado con anterioridad a la regularizacin incompatible con Otras causas de regularizacin.",
							ERR_CAUSA, 11));
				}
				
				// 70. Si (REGULARIZACIN = S y CAUSA11 = S y RETRIBA > 0,00): Retribuciones anuales consideradas con anterioridad a la regularizacin incompatible 
				// con Otras causas de regularizacin
				if (retriba.compareTo(BigDecimal.ZERO)>0){
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9047",
							"Retribuciones anuales consideradas con anterioridad a la regularizacin incompatible con Otras causas de regularizacin.",
							ERR_CAUSA, 11));
				}
				
				// 71. Si (REGULARIZACIN = S y CAUSA11 = S y RENCEMEA = S): Los rendimientos anteriores a la regularizacin fueron obtenidos en Ceuta o Melilla 
				// incompatible con Otras causas de regularizacin
				if(rencemea){
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9048",
							"Los rendimientos anteriores a la regularizacin fueron obtenidos en Ceuta o Melilla incompatible con Otras causas de regularizacin.",
							ERR_CAUSA, 11));
				}
				
				// 72. Si (REGULARIZACIN = S y CAUSA11 = S y MINORADO = S): En algn momento antes de la regularizacin se aplic minoracin por pagos de prstamos 
				// para vivienda es incompatible con otras causas de regularizacin
				if(minorado){
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9049",
							"En algn momento antes de la regularizacin se aplic minoracin por pagos de prstamos para vivienda es incompatible "
									+ "con otras causas de regularizacin.",
							ERR_CAUSA, 11));
				}
				
				// 73. Si (REGULARIZACIN = S y CAUSA11 = S y MINOPAGOA != 0,00) : Importe de la minoracin por pagos de prstamos para vivienda determinado antes 
				// de la regularizacin es incompatible con otras causas de regularizacin
				if(minopagoa.compareTo(BigDecimal.ZERO)!=0){
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9050",
							"Importe de la minoracin por pagos de prstamos para vivienda determinado antes de la regularizacin es incompatible con otras "
									+ "causas de regularizacin.",
							ERR_CAUSA, 11));
				}
				
			} // fin if CAUSA[11] == true

			else if (!causa[11]) {
				// 33. Si (REGULARIZACIN = S y CAUSA11 = N y RETRIBA < PERCIBIDO): Las Retribuciones ya satisfechas con anterioridad a la regularizacin no pueden ser 
				// superiores a las Retribuciones anuales consideradas con anterioridad
				if (retriba.compareTo(percibido) < 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9056",
							"Las Retribuciones ya satisfechas con anterioridad a la regularizacin no pueden ser"
									+ " superiores a las Retribuciones anuales consideradas con anterioridad.",
							ERR_RETRIBA, -1));
				}

				// 35. Si (REGULARIZACION = S y CAUSA11 = N y RETRIBA = 0,00): Las Retribuciones anuales consideradas con anterioridad a la regularizacin son obligatorias
				if (retriba.compareTo(BigDecimal.ZERO) == 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR, 
							"R9057",
							"Las retribuciones anuales consideradas con anterioridad a la regularizacin son obligatorias.",
							ERR_RETRIBA, -1));
				}

				// 37. Si (REGULARIZACION = S y CAUSA9 = N y CAUSA10 = N y CAUSA11 = N y MINPERFAA = 0,00): Mnimo personal y familiar determinado antes de 
				// la regularizacin es obligatorio  
				if (!causa[9] && !causa[10] && minperfaa.compareTo(BigDecimal.ZERO) == 0) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9058",
							"Mnimo personal y familiar determinado antes de la regularizacin es obligatorio.",
							ERR_MINPERFAA, -1));
				}
			}// fin if CAUSA[11] == false

			// 36. Si (REGULARIZACION = S y PERCIBIDO = 0,00): Las Retribuciones ya satisfechas con anterioridad a la regularizacin son obligatorias
			if (percibido.compareTo(BigDecimal.ZERO) == 0) {
				if (!desdeFichero) {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR,
							"R9059",
							"Las retribuciones ya satisfechas con anterioridad a la regularizacin son obligatorias.",
							ERR_PERCIBIDO, -1));
				} else {
					perceptorBean.setErr(new ErrorValidacionBeanImpl(
							TipoErrorValidacion.ERROR, "R9060",
							"Falta contenido en Retribuciones ya satisfechas.",
							ERR_PERCIBIDO, -1));
				}
			}

			// 34. Si (REGULARIZACIN = S y RETRIB <= PERCIBIDO): Las Retribuciones totales consignadas en Datos econmicos (importes anuales) no pueden ser inferiores 
			// o iguales a las Retribuciones ya satisfechas con anterioridad a la regularizacin.
			if (retrib.compareTo(percibido) <= 0) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9061",
						"Las Retribuciones totales consignadas en Datos econmicos"
								+ " (importes anuales) no pueden ser inferiores o iguales a las"
								+ " Retribuciones ya satisfechas con anterioridad a la regularizacin.",
						ERR_RETRIB, -1));
			}

			// 38. Si [ (REGULARIZACION = S) y (CAUSA1 a CAUSA11 = N)]: No ha seleccionado ninguna causa de regularizacin
			int i;
			for (i = 1; i < causa.length; i++) {
				if (causa[i]) {
					break;
				}
			}
			if (i == causa.length) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
						"R9062",
						"No ha seleccionado ninguna causa de regularizacin.",
						ERR_CAUSA, -1));
			}
			// fin 35.2009

			// 41. Si (REGULARIZACION = S y CAUSA3 = S y CONYUGE = 0,00): No ha consignado el importe de la Pensin compensatoria a favor del cnyuge
			if (causa[3] && perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CONYUGE).compareTo(BigDecimal.ZERO) == 0) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9063",
						"No ha consignado el importe de la Pensin compensatoria a favor del cnyuge.",
						"conyuge", -1));
			}

			// 42. Si (REGULARIZACION = S y CAUSA4 = S y ANUALIDADES = 0,00): No ha consignado el importe de las Anualidades por alimentos a favor de hijos
			if (causa[4] && perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_ANUALIDADES).compareTo(BigDecimal.ZERO) == 0) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9064",
						"No ha consignado el importe de las Anualidades por alimentos a favor de hijos.",
						"anualidades", -1));
			}

			// 43. Si (REGULARIZACION = S y CAUSA5 = S y SITUFAM no= SITUACION3): Si selecciona como causa de regularizacin el cambio de la situacin familiar 2 
			// a la situacin familiar 3, slo puede seleccionar situacin familiar 3
			if (causa[5] && situFam != PerceptorBeanTipos.SITUACION3) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9065",
						"Si selecciona como causa de regularizacin el cambio de la situacin familiar"
								+ " '2' a la situacin familiar '3', slo puede seleccionar situacin familiar '3'.",
						ERR_SITUFAM, -1));
			}

			// 44. Si (REGULARIZACION = S y CAUSA6 = S y CAUSA7 = S): Ha seleccionado dos causas incompatibles entre si
			// 45. Si (REGULARIZACION = S y CAUSA6 = S y CAUSA8 = S): Ha seleccionado dos causas incompatibles entre si.
			// 46. Si (REGULARIZACION = S y CAUSA7 = S y CAUSA8 = S): Ha seleccionado dos causas incompatibles entre si.

			if ((causa[6] && causa[7]) || (causa[6] && causa[8]) || (causa[7] && causa[8])) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9066",
						"Ha seleccionado dos causas de regularizacin incompatibles entre s.",
						ERR_CAUSA, -1));
			}

			// 54. Si (REGULARIZACION = S y RESICEME = S y CAUSA6 = S): Si el contribuyente es residente en Ceuta o Melilla, la causa de regularizacin 
			// no puede ser la prdida de la condicin de residente en Ceuta o Melilla
			if (resiceme && causa[6]) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9068",
						"Si el contribuyente es residente en Ceuta o Melilla, la causa de regularizacin"
								+ " no puede ser la prdida de la condicin de residente en Ceuta o Melilla.",
						ERR_CAUSA, 6));
			}

			// 55. Si (REGULARIZACION = S y RESICEME = N y CAUSA7 = S): Si el contribuyente no es residente en Ceuta o Melilla, la causa de regularizacin 
			// no puede ser la adquisicin de la condicin de residente en Ceuta o Melilla
			if (!resiceme && causa[7]) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9069",
						"Si el contribuyente no es residente en Ceuta o Melilla, la causa de regularizacin"
								+ " no puede ser la adquisicin de la condicin de residente en Ceuta o Melilla.",
						ERR_CAUSA, 7));
			}

			// 56. Si (REGULARIZACION = S y RESICEME = N y CAUSA8 = S): Si el contribuyente no es residente en Ceuta o Melilla, la causa de regularizacin
			// no puede ser Comenzar a realizar trabajos fuera de Ceuta o Melilla por residentes en Ceuta o Melilla
			if (!resiceme && causa[8]) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9070",
						"Si el contribuyente no es residente en Ceuta o Melilla, la causa de regularizacin"
								+ " no puede ser comenzar a realizar trabajos fuera de Ceuta o Melilla por residentes"
								+ " en Ceuta o Melilla.", 
						"resiceme", -1));
			}

			// 57. Si (REGULARIZACION = S y RENCEME = S y CAUSA8 = S): Si el contribuyente obtiene rendimientos en Ceuta o Melilla, la causa de Regularizacin 
			// no puede ser comenzar a realizar trabajos fuera de Ceuta o Melilla
			if (renceme && causa[8]) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9071",
						"Si el contribuyente obtiene rendimientos en Ceuta o Melilla, la causa de Regularizacin"
								+ " no puede ser comenzar a realizar trabajos fuera de Ceuta o Melilla.",
						ERR_CAUSA, 8));
			}

			// 58. Si (REGULARIZACION = S y RENCEMEA = N y CAUSA6 = S): Si el contribuyente no obtena rendimientos en Ceuta o Melilla con anterioridad a la regularizacin, 
			// no podr seleccionar como causa de regularizacin la prdida de la condicin de residente en Ceuta o Melilla
			if (!rencemea && causa[6]) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9072",
						"Si el contribuyente no obtena rendimientos en Ceuta o Melilla con anterioridad"
								+ " a la regularizacin, no podr seleccionar como causa de regularizacin la prdida"
								+ " de la condicin de residente en Ceuta o Melilla.",
						ERR_CAUSA, 6));
			}

			// 59. Si (REGULARIZACION = S y RENCEMEA = N y CAUSA8 = S): Si el contribuyente no obtena rendimientos en Ceuta o Melilla con anterioridad a la regularizacin,
			// la causa de sta no puede ser comenzar a realizar trabajos fuera de Ceuta o Melilla
			if (!rencemea && causa[8]) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9073",
						"Si el contribuyente no obtena rendimientos en Ceuta o Melilla con anterioridad"
								+ " a la regularizacin, la causa de sta no puede ser comenzar a realizar trabajos"
								+ " fuera de Ceuta o Melilla.", 
						ERR_CAUSA, 8));
			}
			
			// ?? Tipo de retencin no puede ser superior a TIPO_MAXIMO
//			if (tipoa.compareTo(BigDecimal.ZERO) < 0 || tipoa.compareTo(PerceptorBeanTipos.TIPO_MAXIMO_N2019) > 0) {
//				perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR,
//						"R9074",
//						"Tipo de retencin anterior debe estar comprendido entre 0 y "+ PerceptorBeanTipos.TIPO_MAXIMO_N2019.intValue()+ ".", 
//						ERR_TIPOA, -1));
//			}
		
			// 75. Si (REGULARIZACION =S y RETRIB>RETRIBA y (CAUSA9 = S o CAUSA10 = S)): La causa de regularizacin consignada es incompatible con el aumento del importe 
			// de las retribuciones totales anuales. En consecuencia, debern efectuarse dos regularizaciones sucesivas: la primera por la causa consignada, sin considerar 
			// el aumento de retribuciones, y la segunda, por la causa de regularizacin correspondiente a dicho aumento
			if (retrib.compareTo(retriba) > 0 && (causa[9] || causa[10])) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9079",
						"La causa de regularizacin consignada es incompatible con el"
								+ " aumento del importe de las retribuciones totales anuales."
								+ " En consecuencia, debern efectuarse dos regularizaciones sucesivas:"
								+ " la primera, por la causa consignada, sin considerar el aumento de"
								+ " retribuciones, y la segunda, por la causa de regularizacin correspondiente"
								+ " a dicho aumento.",
							ERR_CAUSA, 9));
			}

			// 76. Si (REGULARIZACION =S y RETRIB<RETRIBA y (CAUSA9 = S o CAUSA10 = S)): La causa de regularizacin consignada es incompatible con la disminucin del 
			// importe de las retribuciones totales anuales. En consecuencia, debern efectuarse dos regularizaciones sucesivas: la primera por la causa de regularizacin 
			// correspondiente a la disminucin de retribuciones, y la segunda, por la causa de regularizacin consignada
			if (retrib.compareTo(retriba) < 0 && (causa[9] || causa[10])) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9080",
						"La causa de regularizacin consignada es incompatible con la disminucin"
								+ " del importe de las retribuciones totales anuales. En consecuencia, debern"
								+ " efectuarse dos regularizaciones sucesivas: la primera, por la causa de"
								+ " regularizacin correspondiente a la disminucin de retribuciones, y la segunda,"
								+ " por la causa de regularizacin consignada.",
						ERR_CAUSA, 9));
			}

			// 77. Si (REGULARIZACION = S y PRESVIV= S y CAUSA10 = S): La causa de regularizacin consignada es incompatible con la activacin de la casilla de la 
			// pantalla de Datos Econmicos relativa a los pagos por prstamos destinados a la vivienda habitual del perceptor. En consecuencia, deber desactivarse 
			// dicha casilla
			if (causa[10] && presviv) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9081",
						"La causa de regularizacin consignada es incompatible con la activacin de la"
								+ " casilla de la pantalla de Datos Econmicos relativa a los pagos por prstamos"
								+ " destinados a la vivienda habitual del perceptor. En consecuencia, deber desactivarse"
								+ " dicha casilla.", 
							ERR_PRESVIV, -1));
			}

			// 78. Si (REGULARIZACION = S y CAUSA10 = S y MINORADO= N y MINOPAGOA = 0): Si la causa de regularizacin es la 10 debe indicar, que en algn momento se 
			// aplic la minoracin por pagos y consignar el importe de la misma anteriormente determinado
			if (causa[10] && minopagoa.compareTo(BigDecimal.ZERO) == 0 && !minorado) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9082",
						"Si la causa de regularizacin es la 10 debe indicar,"
								+ " que en algn momento se aplic la minoracin por pagos y consignar el"
								+ " importe de la misma anteriormente determinado.",
						ERR_MINOPAGOA, -1));
			}

			// 79. Si [REGULARIZACION = S y CAUSA10 = N y PRESVIV = N y (MINOPAGOA > 2,00% * PERCIBIDO)]: El importe de la minoracin por pagos de 
			// prstamos para vivienda determinado antes de la regularizacin no puede superar el 2 por 100 de las retribuciones ya satisfechas con anterioridad a la 
			// regularizacin
			if (!causa[10] && !presviv && minopagoa.compareTo(CERODOS.multiply(percibido)) > 0) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9086",
						"El importe de la minoracin por pagos de prstamos para vivienda determinado antes de la"
								+ " regularizacin no puede superar el 2 por 100 de las retribuciones ya satisfechas con anterioridad"
								+ " a la regularizacin.", 
							ERR_MINOPAGOA, -1));
			}

		} else if (!regularizacion) {

			// 22. Si (REGULARIZACIN = N y PERCIBIDO > 0,00): Retribuciones ya satisfechas con anterioridad a la regularizacin incompatible con 
			// Regularizacin no cumplimentada
			if (percibido.compareTo(BigDecimal.ZERO) > 0) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9087",
						"Retribuciones ya satisfechas con anterioridad a la regularizacin incompatible con Regularizacin no cumplimentada.",
						ERR_PERCIBIDO, -1));
			}
			
			// 23. Si (REGULARIZACIN = N y RETENIDO > 0,00): Retenciones e ingresos a cuenta ya practicados incompatible con Regularizacin no cumplimentada
			if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO).compareTo(BigDecimal.ZERO) > 0) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9088",
						"Retenciones e ingresos a cuenta ya practicados incompatible con Regularizacin no cumplimentada.",
						"retenido", -1));
			}
			
			// 24. Si (REGULARIZACIN = N y RETRIBA > 0,00): Retribuciones anuales consideradas con anterioridad a la regularizacin incompatible con 
			// Regularizacin no cumplimentada
			if (retriba.compareTo(BigDecimal.ZERO) > 0) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9089",
						"Retribuciones anuales consideradas con anterioridad a la regularizacin incompatible con Regularizacin no cumplimentada.",
						ERR_RETRIBA, -1));
			}
			
			// 25. Si (REGULARIZACIN = N y IMPORTEA > 0,00): Retenciones totales anuales determinadas antes de la regularizacin incompatible con 
			// Regularizacin no cumplimentada
			if (importea.compareTo(BigDecimal.ZERO) > 0) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9090",
						"Retenciones totales anuales determinadas antes de la regularizacin incompatible con Regularizacin no cumplimentada.",
						"importea", -1));
			}
			
			// 26. Si (REGULARIZACIN = N y RENCEMEA = S): Los rendimientos anteriores a la regularizacin fueron obtenidos en Ceuta o Melilla incompatible con 
			// Regularizacin no cumplimentada
			if (rencemea) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9077",
						"Los rendimientos anteriores a la regularizacin fueron obtenidos en Ceuta o Melilla incompatible con Regularizacin no cumplimentada.",
						ERR_CAUSA, -1));
			}
						
			// 27. Si (REGULARIZACIN = N y BASEA > 0,00): Base para calcular el tipo de retencin determinada antes de la regularizacin incompatible con 
			// Regularizacin no cumplimentada
			if (basea.compareTo(BigDecimal.ZERO) > 0) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9091",
						"Base para calcular el tipo de retencin determinada antes de la regularizacin incompatible con Regularizacin no cumplimentada.",
						ERR_BASEA, -1));
			}
			
			// 28. Si (REGULARIZACIN = N y MINPERFAA > 0,00): Mnimo personal y familiar determinado antes de la regularizacin incompatible con 
			// Regularizacin no cumplimentada
			if (minperfaa.compareTo(BigDecimal.ZERO) > 0) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9092",
						"Mnimo personal y familiar determinado antes de la regularizacin incompatible con Regularizacin no cumplimentada.",
						ERR_MINPERFAA, -1));
			}
			
			// 29. Si (REGULARIZACIN = N y TIPOA > 0,00): Tipo de retencin aplicado con anterioridad a la regularizacin incompatible con Regularizacin no cumplimentada
			if (tipoa.compareTo(BigDecimal.ZERO) > 0) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9093",
						"Tipo de retencin aplicado con anterioridad a la regularizacin incompatible con Regularizacin no cumplimentada.",
						ERR_TIPOA, -1));
			}
			
			// 30. Si REGULARIZACIN = N y MINORADO = S: Minoracin por pagos de prstamos para vivienda antes de la regularizacin incompatible con
			// Regularizacin no cumplimentada
			if (minorado) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9075",
						"Minoracin por pagos de prstamos para vivienda antes de la regularizacin incompatible con Regularizacin no cumplimentada.",
						ERR_MINORADO, -1));
			}

			// 31. Si (REGULARIZACIN = N y MINOPAGOA != 0,00): Importe de la minoracin por pagos de prstamos  para vivienda antes de la regularizacin 
			// incompatible con Regularizacin no cumplimentada
			if (minopagoa.compareTo(BigDecimal.ZERO) != 0) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9076",
						"Importe de la minoracin por pagos de prstamos para vivienda antes de la regularizacin incompatible con Regularizacin no cumplimentada.",
						"minopago", -1));
			}

			// 32. Si (REGULARIZACIN = N y CAUSA1 a CAUSA11 = S): Si no hay Regularizacin no puede seleccionar ninguna Causa de regularizacin
			int i;
			for (i = 1; i <= causa.length; i++) {
				if (!causa[i]) {
					break;
				}
			}
			if (i == causa.length) {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(
						TipoErrorValidacion.ERROR,
						"R9078",
						"Si no hay Regularizacin no puede seleccionar ninguna causa de Regularizacin.",
						ERR_CAUSA, -1));
			}
		
		}

		return perceptorBean.getErr().isEmpty();
	}

	@Override
	public void calcular(PerceptorBean perceptorBean) {
		calculosGastosDeducibles(perceptorBean);
		rendimientoNetoTrabajo(perceptorBean);
		reduccionPorObtencionDeRendimientosDelTrabajo(perceptorBean);
		rendimientoNetoReducido(perceptorBean);
		reduccionPensionistaDeLaSSOClasesPasivas(perceptorBean);
		reduccionMasDe2Descendientes(perceptorBean);
		reduccionPorSerDesempleado(perceptorBean);
		minimoPersonalYFamiliar(perceptorBean);
		baseParaCalcularElTipoDeretencion(perceptorBean);
		cuotaDeRetencion(perceptorBean);
		tipoPrevioRetencion(perceptorBean);
		aplicacionReduccionPagoPrestamos(perceptorBean);
		tipoDeRetencionAplicable(perceptorBean);
		importeAnualRetencionesIngresosACuenta(perceptorBean);

		if ((Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_REGULARIZACION)) {
			regularizacion(perceptorBean);
		}
	}

	// REGULARIZACIN
	private void regularizacion(PerceptorBean perceptorBean) {
		// Clculo importe para la determinacin del tipo de retencin a partir de la regularizacin.
		BigDecimal aux1;
		BigDecimal aux2;
		boolean[] causa = (boolean[]) perceptorBean.getValor(PerceptorBeanTipos.P_CAUSA);
		Boolean rencemea = (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_RENCEMEA);
		Boolean resiceme = (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_RESICEME);
		Boolean renceme = (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_RENCEME);
		Boolean ceumeli = (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_CEUMELI);

		BigDecimal retrib = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB);
		BigDecimal retriba = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIBA);
		BigDecimal percibido = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PERCIBIDO);
		BigDecimal cuota = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CUOTA);
		
		if (ceumeli && !rencemea && causa[7]) {
			aux1 = percibido.multiply(cuota.divide(retrib, 10, BigDecimal.ROUND_HALF_UP));
			aux2 = retrib.subtract(percibido).multiply(cuota.multiply(BD040).divide(retrib, 10,BigDecimal.ROUND_HALF_UP));
			perceptorBean.setValor(PerceptorBeanTipos.P_IMPORTEREG, aux1.add(aux2));
			perceptorBean.escribirDesarrollo("IMPORTEREG = "+percibido+" * ("+cuota+" / "+retrib
					+") + ("+retrib+" - " + percibido+") * ("+ cuota+" * 0.40) / "+retrib+" = "
					+perceptorBean.getValor(PerceptorBeanTipos.P_IMPORTEREG));
			
		} else if (resiceme && !renceme && rencemea && causa[8]) {
			aux1 = percibido.multiply((cuota.multiply(BD040)).divide(retrib, 10,BigDecimal.ROUND_HALF_UP));
			aux2 = retrib.subtract(percibido).multiply(cuota.divide(retrib, 10,BigDecimal.ROUND_HALF_UP));
			perceptorBean.setValor(PerceptorBeanTipos.P_IMPORTEREG, aux1.add(aux2));
			perceptorBean.escribirDesarrollo("IMPORTEREG = "+percibido+" * ("+cuota+" * 0.40) / "+retrib
					+" + ("+retrib+" - " + percibido+") * "+ cuota+" / "+retrib+" = "
					+perceptorBean.getValor(PerceptorBeanTipos.P_IMPORTEREG));
			
		} else if(!resiceme && !renceme && rencemea && causa[6]) {
			aux1 = percibido.multiply((cuota.multiply(BD040)).divide(retrib, 10,BigDecimal.ROUND_HALF_UP));
			aux2 = retrib.subtract(percibido).multiply(cuota.divide(retrib, 10,BigDecimal.ROUND_HALF_UP));
			perceptorBean.setValor(PerceptorBeanTipos.P_IMPORTEREG, aux1.add(aux2));
			perceptorBean.escribirDesarrollo("IMPORTEREG = "+percibido+" * ("+cuota+" * 0.40) / "+retrib
					+" + ("+retrib+" - " + percibido+") * "+ cuota+" / "+retrib+" = "
					+perceptorBean.getValor(PerceptorBeanTipos.P_IMPORTEREG));
			
		} else if (ceumeli && rencemea) {
			perceptorBean.setValor(PerceptorBeanTipos.P_IMPORTEREG, cuota.multiply(BD040));
			perceptorBean.escribirDesarrollo("IMPORTEREG = "+cuota+" * 0,40");
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_IMPORTEREG,cuota);
			perceptorBean.escribirDesarrollo("IMPORTEREG = "+cuota);
		}
		aux1 = null;
		aux2 = null;

		// Tratamiento especial por minoracin por pagos de prstamos para la vivienda habitual
		BigDecimal aux;
		Boolean presviv = (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_PRESVIV);
		Boolean minorado = (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_MINORADO);
		BigDecimal minopagoa = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGOA);

		if (causa[1] || causa[2] || causa[3] || causa[4] || causa[5] || causa[6] || causa[7] || causa[8]) {
			if (minorado && presviv && retrib.compareTo(LIMITE_33007_CON_20) < 0) {
				aux = retrib.subtract(retriba).abs();
				if (retrib.compareTo(retriba) > 0) {
					perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO, minopagoa.add(aux.multiply(CERODOS)));
					perceptorBean.escribirDesarrollo("MINOPAGO = "+minopagoa+" + 2% * ("+retrib+"  "+retriba+") = "+perceptorBean.getValor(PerceptorBeanTipos.P_MINOPAGO));
				} else if (retrib.compareTo(retriba) < 0) {
					perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO, minopagoa.subtract(aux.multiply(CERODOS)));
					perceptorBean.escribirDesarrollo("MINOPAGO = "+minopagoa+" - 2% * ("+retriba+"  "+retrib+") = "+perceptorBean.getValor(PerceptorBeanTipos.P_MINOPAGO));
				} else {
					perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO, minopagoa);
					perceptorBean.escribirDesarrollo("MINOPAGO = "+minopagoa);
				}
			} else if (minorado && !presviv) {
				perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO, minopagoa);
				perceptorBean.escribirDesarrollo("MINOPAGO = "+minopagoa);
			} else {
				perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO,BigDecimal.ZERO);
				perceptorBean.escribirDesarrollo("MINOPAGO = 0  ");
			}

		} else if (causa[9] && presviv && retrib.compareTo(LIMITE_33007_CON_20) < 0) {
			aux = retrib.subtract(percibido);
			if (minorado) {
				perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO, minopagoa.add(aux.multiply(CERODOS)));
				perceptorBean.escribirDesarrollo("MINOPAGO = "+minopagoa+" + 2% * ("+retrib+"  "+percibido+") = "+perceptorBean.getValor(PerceptorBeanTipos.P_MINOPAGO));
			} else {
				perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO,aux.multiply(CERODOS));
				perceptorBean.escribirDesarrollo("MINOPAGO = 2% * ("+retrib+"  "+percibido+") = "+perceptorBean.getValor(PerceptorBeanTipos.P_MINOPAGO));
			}
		} else if (causa[10] && minorado && !presviv) {
			aux = retrib.subtract(percibido).multiply(CERODOS);
			perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO, minopagoa.subtract(aux));
			perceptorBean.escribirDesarrollo("MINOPAGO = "+minopagoa+" - 2% * ("+retrib+"  "+percibido+") = "+perceptorBean.getValor(PerceptorBeanTipos.P_MINOPAGO));
		} else if(causa[11] && presviv && retrib.compareTo(LIMITE_33007_CON_20) < 0) {
			aux1 = retrib.subtract(percibido);
			perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO,aux1.multiply(CERODOS));
			perceptorBean.escribirDesarrollo("MINOPAGO = 2% * ("+retrib+"  "+percibido+") = "+perceptorBean.getValor(PerceptorBeanTipos.P_MINOPAGO));
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
			perceptorBean.escribirDesarrollo("MINOPAGO = 0,00");
		}

		if (presviv	&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGO).compareTo(PerceptorBeanTipos.PORCENTAJE2) > 0) {
			perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO,PerceptorBeanTipos.PORCENTAJE2);
			perceptorBean.escribirDesarrollo("MINOPAGO = 2,00%*33.007,20 = "+perceptorBean.getValor(PerceptorBeanTipos.P_MINOPAGO));
		}

		perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO,perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGO).setScale(2, BigDecimal.ROUND_DOWN));
		//perceptorBean.escribirDesarrollo("MINOPAGO = "+perceptorBean.getValor(PerceptorBeanTipos.P_MINOPAGO));
		
		// ????
		aux = CERODOS.multiply(LIMITE_33007_CON_20).setScale(2,BigDecimal.ROUND_HALF_UP);
		if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGO).compareTo(aux) > 0) {
			perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO, aux);
		}

		aux = null;

		// Clculo del tipo de retencin a partir de la regularizacin
		BigDecimal dividendo = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTEREG)
								.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO))
								.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGO));
		BigDecimal divisor = retrib.subtract(percibido);
		BigDecimal resul = dividendo.divide(divisor, 10,BigDecimal.ROUND_HALF_UP);

		perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG, resul.movePointRight(2));
	
		perceptorBean.escribirDesarrollo("TIPOREG = [( "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTEREG)+" - "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO)+" - "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGO)+") / ("
				+retrib+ " - "+percibido+")] * 100 = "
				+perceptorBean.getValor(PerceptorBeanTipos.P_TIPOREG));
		

		dividendo = null;
		divisor = null;
		resul = null;

		if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG).compareTo(BigDecimal.ZERO) < 0) {
			perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
			perceptorBean.escribirDesarrollo("TIPOREG = 0,00");
		}

		perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,
				perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG).setScale(2, BigDecimal.ROUND_DOWN));
		perceptorBean.escribirDesarrollo("TIPOREG = "+perceptorBean.getValor(PerceptorBeanTipos.P_TIPOREG));

		int situper = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_SITUPER);
		int contrato = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_CONTRATO);

		// Lmites generales en la aplicacin del tipo (mximo del 45 %  y mnimos del  15 % y 2 %)
		if (ceumeli) {
			if (rencemea && perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG).compareTo(PerceptorBeanTipos.TIPO_MAXIMO_CEUTA_N2019) > 0) {
				perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,PerceptorBeanTipos.TIPO_MAXIMO_CEUTA_N2019);
				perceptorBean.escribirDesarrollo("TIPOREG = 18,00");
			} else if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG).compareTo(PerceptorBeanTipos.TIPO_MAXIMO_N2019) > 0) {
				perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,PerceptorBeanTipos.TIPO_MAXIMO_N2019);
				perceptorBean.escribirDesarrollo("TIPOREG = 45,00 ");
			} else if (situper == PerceptorBeanTipos.ACTIVO && contrato == PerceptorBeanTipos.RELACIONESPECIAL) {
				perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG).max(PerceptorBeanTipos.TIPO_MINIMO_RELACIONESPECIAL_CEUTA));
				perceptorBean.escribirDesarrollo("TIPOREG = 6,00");
			} else if (situper == PerceptorBeanTipos.ACTIVO && contrato == PerceptorBeanTipos.INFERIORALANIO) {
				perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG).max(PerceptorBeanTipos.TIPO_MINIMO_PEONADAS_CEUTA));
				perceptorBean.escribirDesarrollo("TIPOREG = 0,80");
			}
		} else if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG).compareTo(PerceptorBeanTipos.TIPO_MAXIMO_N2019) > 0) {
			perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,PerceptorBeanTipos.TIPO_MAXIMO_N2019);
			perceptorBean.escribirDesarrollo("TIPOREG = 45,00");
		} else if (situper == PerceptorBeanTipos.ACTIVO && contrato == PerceptorBeanTipos.RELACIONESPECIAL) {
			perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,
					perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG).max(PerceptorBeanTipos.TIPO_MINIMO_REL_ESPECIALES));
			perceptorBean.escribirDesarrollo("TIPOREG = 15,00");
		} else if (situper == PerceptorBeanTipos.ACTIVO && contrato == PerceptorBeanTipos.INFERIORALANIO) {
			perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG, 
					perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG).max(PerceptorBeanTipos.TIPO_MINIMO_PEONADAS));
			perceptorBean.escribirDesarrollo("TIPOREG = 2,00");
		}

		// Clculo del importe anual de la retencin
		perceptorBean.setValor(PerceptorBeanTipos.P_IMPORTE,retrib.subtract(percibido)
								.multiply(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG))
								.movePointLeft(2)
								.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO))
								.setScale(2, BigDecimal.ROUND_HALF_UP));
		
		perceptorBean.escribirDesarrollo("IMPORTE = REDONDEAR ({[("+retrib+"  "+ percibido+") * "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG)+"] / 100 + "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO)+") = "
				+ perceptorBean.getValor(PerceptorBeanTipos.P_IMPORTE));

		// Causas de regularizacin a las que no son aplicables los lmites del art. 87.5 del RIRPF (R.D.439/2007).
		if (!causa[5] && !causa[6] && !causa[8]	&& !causa[9] && !causa[10] && !causa[11]) {
			// Limites del art. 81.5 del RIRPF
			
			boolean revisar = false;
			BigDecimal diferencia = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASEA)
					.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFAA))
					.compareTo(BigDecimal.ZERO) > 0 
						? perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASEA).subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFAA))
						: BigDecimal.ZERO;
			perceptorBean.escribirDesarrollo("DIFERENCIA = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASEA)+"  "
						+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFAA)+" = "+ diferencia);

			BigDecimal increimporte = BigDecimal.ZERO;
			BigDecimal increbasemin = BigDecimal.ZERO;
			
			if (diferencia.compareTo(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASE)
					.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFA))) >= 0
					&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG)
							.compareTo(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOA)) > 0) {
				perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG, perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOA));
				perceptorBean.escribirDesarrollo("TIPOREG = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOA));
				revisar = true;
			} else if (diferencia.compareTo(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASE)
					.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFA))) < 0
					&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTEA)
							.compareTo(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTE)) < 0) {
				increimporte = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTE)
						.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTEA));
				perceptorBean.escribirDesarrollo("INCREIMPORTE = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTE)+" - "
						+ perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTEA));
				
				increbasemin = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASE)
						.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFA))
						.subtract(diferencia);
				
				perceptorBean.escribirDesarrollo("INCREBASEMIN = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASE)+" - "
						+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFA)+ " - "+diferencia+" = "
						+increbasemin);

				if (increimporte.compareTo(increbasemin) > 0) {
					revisar = true;
					perceptorBean.setValor(PerceptorBeanTipos.P_IMPORTE,perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTEA).add(increbasemin));
					
					perceptorBean.escribirDesarrollo("IMPORTE = "+ perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTEA)+" + "+increbasemin +" = "
							+perceptorBean.getValor(PerceptorBeanTipos.P_IMPORTE));
					
					perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTE)
											.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO))
											.divide(retrib.subtract(percibido),10,BigDecimal.ROUND_HALF_UP)
											.movePointRight(2));
					
					perceptorBean.escribirDesarrollo("TIPOREG = [( "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTE)+" - "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO)+") / ("
							+retrib+" - "+ percibido+ ")] * 100  = "
							+perceptorBean.getValor(PerceptorBeanTipos.P_TIPOREG));
					
					if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG).compareTo(BigDecimal.ZERO) < 0) {
						perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,BigDecimal.ZERO);
						perceptorBean.escribirDesarrollo("TIPOREG = 0");
					} else {
						// truncar
						perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,perceptorBean.getValorAsBigDecimal(
										PerceptorBeanTipos.P_TIPOREG).setScale(2,BigDecimal.ROUND_DOWN));
						perceptorBean.escribirDesarrollo("TIPOREG = "+perceptorBean.getValor(PerceptorBeanTipos.P_TIPOREG));
						perceptorBean.setValor(PerceptorBeanTipos.P_IMPORTE,
										retrib.subtract(percibido).multiply(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG))
											.movePointLeft(2)
											.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO)));
						
						perceptorBean.escribirDesarrollo("IMPORTE = [( "+retrib+" - "
								+percibido+") * "
								+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG)+"] / 100  + "
								+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO) +" = "
								+perceptorBean.getValor(PerceptorBeanTipos.P_IMPORTE)+ " = "+perceptorBean.getValor(PerceptorBeanTipos.P_IMPORTE) );
						
						increimporte = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTE)
											.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTEA));
						perceptorBean.escribirDesarrollo("INCREIMPORTE = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTE)+" - "
								+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTEA)+ " = "
								+increimporte);
					}

					if (increimporte.compareTo(increbasemin) > 0 
							&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG).compareTo(BigDecimal.ZERO) > 0) {
						perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,
										perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTEA)
												.add(increbasemin)
												.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO))
												.divide(retrib.subtract(percibido),10,BigDecimal.ROUND_HALF_UP)
												.movePointRight(2));
						perceptorBean.escribirDesarrollo("TIPOREG = [( "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTEA)+" + "
								+increbasemin+" - "
								+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO)+") / ("
								+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB) +" - "
								+percibido+ ")] * 100 = "
								+perceptorBean.getValor(PerceptorBeanTipos.P_TIPOREG));

						// Truncar
						perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,
										perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG).setScale(2,BigDecimal.ROUND_DOWN));
						perceptorBean.escribirDesarrollo("TIPOREG = TRUNCAR (TIPOREG) = "+perceptorBean.getValor(PerceptorBeanTipos.P_TIPOREG));
					}
				}
			}

			increimporte = null;
			increbasemin = null;
			diferencia = null;

			// Lmites del art. 87.5 del RIRPF (R.D.439/2007), especficos de los procedimientos de regularizacin.
			if (revisar) {
				if (ceumeli) {
					if (situper == PerceptorBeanTipos.ACTIVO
							&& contrato == PerceptorBeanTipos.RELACIONESPECIAL
							&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG)
									.compareTo(PerceptorBeanTipos.TIPO_MINIMO_RELACIONESPECIAL_CEUTA) < 0) {
						perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,PerceptorBeanTipos.TIPO_MINIMO_RELACIONESPECIAL_CEUTA);
						perceptorBean.escribirDesarrollo("TIPOREG = 6,00");
					} else if (situper == PerceptorBeanTipos.ACTIVO
							&& contrato == PerceptorBeanTipos.INFERIORALANIO
							&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG)
									.compareTo(PerceptorBeanTipos.TIPO_MINIMO_PEONADAS_CEUTA) < 0) {
						perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,PerceptorBeanTipos.TIPO_MINIMO_PEONADAS_CEUTA);
						perceptorBean.escribirDesarrollo("TIPOREG = 0,80");
					}
				} else {
					if (situper == PerceptorBeanTipos.ACTIVO
							&& contrato == PerceptorBeanTipos.RELACIONESPECIAL
							&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG)
									.compareTo(PerceptorBeanTipos.TIPO_MINIMO_REL_ESPECIALES) < 0) {
						perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,PerceptorBeanTipos.TIPO_MINIMO_REL_ESPECIALES);
						perceptorBean.escribirDesarrollo("TIPOREG = 15");
					} else if (situper == PerceptorBeanTipos.ACTIVO
							&& contrato == PerceptorBeanTipos.INFERIORALANIO
							&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG)
									.compareTo(PerceptorBeanTipos.TIPO_MINIMO_PEONADAS) < 0) {
						perceptorBean.setValor(PerceptorBeanTipos.P_TIPOREG,PerceptorBeanTipos.TIPO_MINIMO_PEONADAS);
						perceptorBean.escribirDesarrollo("TIPOREG = 2");
					}
				}

				perceptorBean.setValor(PerceptorBeanTipos.P_IMPORTE,
								retrib.subtract(percibido).multiply(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG))
										.movePointLeft(2)
										.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO)));
			
				perceptorBean.escribirDesarrollo("IMPORTE = {[ ( "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB)+" - "
						+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PERCIBIDO)+") * "
						+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOREG)+"] / 100 } + "
						+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO)+" = "
						+perceptorBean.getValor(PerceptorBeanTipos.P_IMPORTE));
			}

			perceptorBean.setValor(PerceptorBeanTipos.P_IMPORTE,
							perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTE).setScale(2, BigDecimal.ROUND_HALF_UP));
		}
	}

	// IMPORTE ANUAL DE LAS RETENCIONES E INGRESOS A CUENTA
	private void importeAnualRetencionesIngresosACuenta(PerceptorBean perceptorBean) {
		perceptorBean.setValor(PerceptorBeanTipos.P_IMPORTE,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB)
								.multiply(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPO))
								.movePointLeft(2)
								.setScale(2, BigDecimal.ROUND_HALF_UP));
	
		perceptorBean.escribirDesarrollo("IMPORTE = REDONDEAR1(( "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB)+" * "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPO)+") / 100 = "
				+perceptorBean.getValor(PerceptorBeanTipos.P_IMPORTE));
	}

	// TIPO DE RETENCIN APLICABLE
	private void tipoDeRetencionAplicable(PerceptorBean perceptorBean) {
		perceptorBean.setValor(PerceptorBeanTipos.P_TIPO,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DIFERENCIAPOSITIVA)
								.divide(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB),
										10, BigDecimal.ROUND_HALF_UP).movePointRight(2)
								.setScale(2, BigDecimal.ROUND_DOWN));
			perceptorBean.escribirDesarrollo("TIPO = TRUNCAR(( "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DIFERENCIAPOSITIVA)+" / "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB)+") * 100) = "
				+perceptorBean.getValor(PerceptorBeanTipos.P_TIPO));
		

		// ** Limites generales (mnimos del 15% y 2%)
		int situper = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_SITUPER);
		int contrato = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_CONTRATO);
		if ((Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_CEUMELI)) {
			if (situper == PerceptorBeanTipos.ACTIVO && contrato == PerceptorBeanTipos.RELACIONESPECIAL) {
				perceptorBean.setValor(PerceptorBeanTipos.P_TIPO,
								perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPO).max(PerceptorBeanTipos.TIPO_MINIMO_RELACIONESPECIAL_CEUTA));
				perceptorBean.escribirDesarrollo("TIPO = 6,00");
			} else if (situper == PerceptorBeanTipos.ACTIVO && contrato == PerceptorBeanTipos.INFERIORALANIO) {
				perceptorBean.setValor(PerceptorBeanTipos.P_TIPO,
								perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPO).max(PerceptorBeanTipos.TIPO_MINIMO_PEONADAS_CEUTA));
				perceptorBean.escribirDesarrollo("TIPO = 0,80");
			}
		} else if (situper == PerceptorBeanTipos.ACTIVO && contrato == PerceptorBeanTipos.RELACIONESPECIAL) {
			perceptorBean.setValor(PerceptorBeanTipos.P_TIPO,
							perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPO).max(PerceptorBeanTipos.TIPO_MINIMO_REL_ESPECIALES));
			perceptorBean.escribirDesarrollo("TIPO = 15,00");
		} else if (situper == PerceptorBeanTipos.ACTIVO && contrato == PerceptorBeanTipos.INFERIORALANIO) {
			perceptorBean.setValor(PerceptorBeanTipos.P_TIPO,
							perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPO).max(PerceptorBeanTipos.TIPO_MINIMO_PEONADAS));
			perceptorBean.escribirDesarrollo("TIPO = 2,00");
		}
	}

	// APLICACION DE LA REDUCCION POR PAGO DE PRSTAMOS PARA ADQUISICION O REHABILITACION DE LA VIVIENDA HABITUAL (RD 1975/2008)
	private void aplicacionReduccionPagoPrestamos(PerceptorBean perceptorBean) {
		if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB).compareTo(LIMITE_33007_CON_20) < 0 
				&& (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_PRESVIV)) {
			perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO,
							perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB).multiply(CERODOS));
			
			perceptorBean.escribirDesarrollo("MINOPAGO = 2,00% * "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB)+" = "
					+ perceptorBean.getValor(PerceptorBeanTipos.P_MINOPAGO));
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
			perceptorBean.escribirDesarrollo("MINOPAGO = 0,00");
		}

		perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGO).setScale(2, BigDecimal.ROUND_DOWN));
		perceptorBean.escribirDesarrollo("MINOPAGO = TRUNCAR (MINOPAGO) = "+ perceptorBean.getValor(PerceptorBeanTipos.P_MINOPAGO));
		
		if ((Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_CEUMELI)) {
			perceptorBean.setValor(PerceptorBeanTipos.P_DIFERENCIAPOSITIVA,
							(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CUOTA).multiply(BD040)).subtract(perceptorBean
								.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGO)));
			
			perceptorBean.escribirDesarrollo("DIFERENCIA POSITIVA = ("+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CUOTA)+ " * 0.40) - "
					+ perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGO)+" = "
					+ perceptorBean.getValor(PerceptorBeanTipos.P_DIFERENCIAPOSITIVA));
			
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_DIFERENCIAPOSITIVA,
							perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CUOTA)
								.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGO)));
			
			perceptorBean.escribirDesarrollo("DIFERENCIA POSITIVA = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CUOTA)+" - "
					+ perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGO)+" = "
					+ perceptorBean.getValor(PerceptorBeanTipos.P_DIFERENCIAPOSITIVA));
		}

		if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DIFERENCIAPOSITIVA).compareTo(BigDecimal.ZERO) < 0) {
			perceptorBean.setValor(PerceptorBeanTipos.P_DIFERENCIAPOSITIVA, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
			perceptorBean.escribirDesarrollo("DIFERENCIAPOSITIVA = 0,00 ");
		}
	}

	private void tipoPrevioRetencion(PerceptorBean perceptorBean) {
		// NO SE USA ???
		perceptorBean.setValor(PerceptorBeanTipos.P_CEUMELI,
						(Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_RESICEME) && (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_RENCEME));

		if ((Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_CEUMELI)) {
			perceptorBean.setValor(PerceptorBeanTipos.P_CUOTACM, perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CUOTA).divide(BD2));
			
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_CUOTACM, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
		}
	}

	// CUOTA DE RETENCIN
	private void cuotaDeRetencion(PerceptorBean perceptorBean) {
		rendimientosExentosDeRetencion(perceptorBean);
		if ((Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_EXENTOS)) {
			perceptorBean.setValor(PerceptorBeanTipos.P_CUOTA, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
			perceptorBean.setValor(PerceptorBeanTipos.P_TIPO, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
			perceptorBean.escribirDesarrollo("CUOTA = 0,00 ");
			perceptorBean.escribirDesarrollo("TIPO = 0,00");
		} else {
			rendimientosSujetosARetencion(perceptorBean);
		}
	}

	// B.  RENDIMIENTOS SUJETOS A RETENCIN
	private void rendimientosSujetosARetencion(PerceptorBean perceptorBean) {
		BigDecimal base1 = BigDecimal.ZERO;
		BigDecimal base2 = BigDecimal.ZERO;
		BigDecimal cuota1_1 = BigDecimal.ZERO;
		BigDecimal cuota1_2 = BigDecimal.ZERO;
		BigDecimal limite = BigDecimal.ZERO;

		// B1. Cuota 1
		// Anualidades
		if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_ANUALIDADES).compareTo(BigDecimal.ZERO) > 0
				&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASE)
						.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_ANUALIDADES))
						.compareTo(BigDecimal.ZERO) > 0) {
			base1 = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASE).subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_ANUALIDADES));
			base2 = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_ANUALIDADES);
			cuota1_1 = escala(base1, perceptorBean);
			cuota1_2 = escala(base2, perceptorBean);
			perceptorBean.setValor(PerceptorBeanTipos.P_CUOTA1,cuota1_1.add(cuota1_2));
			perceptorBean.escribirDesarrollo("CUOTA1 = "+cuota1_1+" + "+cuota1_2+" = "+perceptorBean.getValor(PerceptorBeanTipos.P_CUOTA1)); 
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_CUOTA1, escala(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASE),perceptorBean));
			perceptorBean.escribirDesarrollo("CUOTA1 = ESCALA ("+ perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASE) +") = "
					+perceptorBean.getValor(PerceptorBeanTipos.P_CUOTA1));
		}

		// B2 Cuota 2
		// Anualidades
		if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_ANUALIDADES).compareTo(BigDecimal.ZERO) > 0
				&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASE)
					.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_ANUALIDADES))
					.compareTo(BigDecimal.ZERO) > 0) {

			perceptorBean.setValor(PerceptorBeanTipos.P_CUOTA2,
							escala(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFA).add(BD1980), perceptorBean));
			perceptorBean.escribirDesarrollo("CUOTA 2 = ESCALA ("+ perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFA)+" + 1980) = "
					+perceptorBean.getValor(PerceptorBeanTipos.P_CUOTA2));
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_CUOTA2, escala(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFA), perceptorBean));
			perceptorBean.escribirDesarrollo("CUOTA2 = ESCALA ("+ perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFA)+") = "
					+perceptorBean.getValor(PerceptorBeanTipos.P_CUOTA2));
		}

		// B3. CUOTA
		if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CUOTA1)
				.compareTo(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CUOTA2)) > 0) {
			perceptorBean.setValor(PerceptorBeanTipos.P_CUOTA,
							perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CUOTA1)
									.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CUOTA2)));
			perceptorBean.escribirDesarrollo("CUOTA = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CUOTA1)+" - "
					+ perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CUOTA2)+" = "
					+ perceptorBean.getValor(PerceptorBeanTipos.P_CUOTA));
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_CUOTA, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
			perceptorBean.escribirDesarrollo("CUOTA = 0,00");
		}

		// Limite del 43%
		BigDecimal retrib = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB);
		if(retrib.compareTo(LIMITE_22000)<=0){
			Integer situfam = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_SITUFAM);
			Integer numdes = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_NUMDES);
			BigDecimal pension = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PENSION);
			BigDecimal desem = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DESEM);
			
			if(situfam == PerceptorBeanTipos.SITUACION1){
				if(numdes == 1){
					limite = (retrib.subtract(BD15947.add(pension).add(desem))).multiply(LIMITE);
					perceptorBean.escribirDesarrollo("LIMITE = ["+retrib+" - (15.947,00 + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PENSION)+" + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DESEM)+")] * 0,43 = "
							+limite);
				} else if(numdes > 1){
					limite = (retrib.subtract(BD17100.add(pension).add(desem))).multiply(LIMITE);
					perceptorBean.escribirDesarrollo("LIMITE = ["+retrib+" - (17.100,00 + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PENSION)+" + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DESEM)+")] * 0,43 = "
							+limite);
				}
			} else if(situfam == PerceptorBeanTipos.SITUACION2){
				if(numdes == 0){
					limite = (retrib.subtract(BD15456.add(pension).add(desem))).multiply(LIMITE);
					perceptorBean.escribirDesarrollo("LIMITE = ["+retrib+" - (15.456,00 + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PENSION)+" + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DESEM)+")] * 0,43 = "
							+limite);
				} else if(numdes == 1){
					limite = (retrib.subtract(BD16481.add(pension).add(desem))).multiply(LIMITE);
					perceptorBean.escribirDesarrollo("LIMITE = ["+retrib+" - (16.481,00 + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PENSION)+" + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DESEM)+")] * 0,43 = "
							+limite);
				} else if(numdes > 1){
					limite = (retrib.subtract(BD17634.add(pension).add(desem))).multiply(LIMITE);
					perceptorBean.escribirDesarrollo("LIMITE = ["+retrib+" - (17.634,00 + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PENSION)+" + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DESEM)+")] * 0,43 = "
							+limite);
				}
			} else if(situfam == PerceptorBeanTipos.SITUACION3){
				if(numdes == 0){
					limite = (retrib.subtract(BD14000.add(pension).add(desem))).multiply(LIMITE);
					perceptorBean.escribirDesarrollo("LIMITE = ["+retrib+" - (14.000,00 + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PENSION)+" + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DESEM)+")] * 0,43 = "
							+limite);
				} else if(numdes == 1){
					limite = (retrib.subtract(BD14516.add(pension).add(desem))).multiply(LIMITE);
					perceptorBean.escribirDesarrollo("LIMITE = ["+retrib+" - (14.516,00 + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PENSION)+" + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DESEM)+")] * 0,43 = "
							+limite);
				} else if(numdes > 1){
					limite = (retrib.subtract(BD15093.add(pension).add(desem))).multiply(LIMITE);
					perceptorBean.escribirDesarrollo("LIMITE = ["+retrib+" - (15.093,00 + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PENSION)+" + "
							+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DESEM)+")] * 0,43 = "
							+limite);
				}
			}
			
			if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CUOTA).compareTo(limite) > 0 && limite.compareTo(BigDecimal.ZERO) > 0) {
				perceptorBean.setValor(PerceptorBeanTipos.P_CUOTA, limite);
				perceptorBean.escribirDesarrollo("CUOTA = "+limite);
			}
		}
		
		base1 = null;
		base2 = null;
		cuota1_1 = null;
		cuota1_2 = null;
		limite = null;
	}

	private BigDecimal escala(BigDecimal blt, PerceptorBean perceptroBean) {
		BigDecimal cuota;

		if (blt.compareTo(BD12450) < 0) {
			cuota = blt.multiply(BD019);
			perceptroBean.escribirDesarrollo("CUOTA = "+blt+" * 0.19 = "+cuota);
			
		} else if (blt.compareTo(BD20200) < 0) {
			cuota = BD236550.add(blt.subtract(BD12450).multiply(BD024));
			perceptroBean.escribirDesarrollo("CUOTA = 2365.50 + ("+blt+" - 12450.00 * 0.24) = "+cuota);

		} else if (blt.compareTo(BD35200) < 0) {
			cuota = BD42255.add(blt.subtract(BD20200).multiply(BD030));
			perceptroBean.escribirDesarrollo("CUOTA = 4225.50 + ("+blt+" - 20200.00 * 0.30) = "+cuota);

		} else if (blt.compareTo(BD60000) < 0) {
			cuota = BD872550.add(blt.subtract(BD35200).multiply(BD037));
			perceptroBean.escribirDesarrollo("CUOTA = 8725.50 + ("+blt+" - 35200.00 * 0.37) = "+cuota);

		} else if(blt.compareTo(BD300000) < 0){
			cuota = BD1790150.add(blt.subtract(BD60000).multiply(BD045));
			perceptroBean.escribirDesarrollo("CUOTA = 17901.50 + ("+blt+" - 60000.00 * 0.45) = "+cuota);
			
		} else {
			cuota = BD12590150.add(blt.subtract(BD300000).multiply(BD047));
			perceptroBean.escribirDesarrollo("CUOTA = 125901.50 + ("+blt+" - 300000.00 * 0.47) = "+cuota);
			
		}

		return cuota;
	}

	// CUOTA DE RETENCIN
	private void rendimientosExentosDeRetencion(PerceptorBean perceptorBean) {
		
		perceptorBean.setValor(PerceptorBeanTipos.P_EXENTOS, false);

		// A. RENDIMIENTOS EXENTOS DE RETENCIN 
		BigDecimal pension = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PENSION);
		BigDecimal desem = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DESEM);
		BigDecimal retrib = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB);
			
		// Si RETRIB <= (17.634,00 + PENSION + DESEM):
		if(retrib.compareTo(BD17634.add(pension).add(desem))<=0){
			
			Integer situfam = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_SITUFAM);
			Integer numdes = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_NUMDES);
			
			if (situfam == PerceptorBeanTipos.SITUACION1) {
				if(numdes == 1 && retrib.compareTo(BD15947.add(pension).add(desem))<=0){
					perceptorBean.setValor(PerceptorBeanTipos.P_EXENTOS, true);
					perceptorBean.escribirDesarrollo("EXENTOS = S");
				} else if(numdes > 1 && retrib.compareTo(BD17100.add(pension).add(desem))<=0){
					perceptorBean.setValor(PerceptorBeanTipos.P_EXENTOS, true);
					perceptorBean.escribirDesarrollo("EXENTOS = S");
				}
			} else if(situfam == PerceptorBeanTipos.SITUACION2){
				if(numdes == 0 && retrib.compareTo(BD15456.add(pension).add(desem))<=0){
					perceptorBean.setValor(PerceptorBeanTipos.P_EXENTOS, true);
					perceptorBean.escribirDesarrollo("EXENTOS = S");
				} else if(numdes == 1 && retrib.compareTo(BD16481.add(pension).add(desem))<=0){
					perceptorBean.setValor(PerceptorBeanTipos.P_EXENTOS, true);
					perceptorBean.escribirDesarrollo("EXENTOS = S");
				} else if(numdes > 1 && retrib.compareTo(BD17634.add(pension).add(desem))<=0){
					perceptorBean.setValor(PerceptorBeanTipos.P_EXENTOS, true);
					perceptorBean.escribirDesarrollo("EXENTOS = S");
				} 
			} else if(situfam == PerceptorBeanTipos.SITUACION3){
				if(numdes == 0 && retrib.compareTo(BD14000.add(pension).add(desem))<=0){
					perceptorBean.setValor(PerceptorBeanTipos.P_EXENTOS, true);
					perceptorBean.escribirDesarrollo("EXENTOS = S");
				} else if(numdes == 1 && retrib.compareTo(BD14516.add(pension).add(desem))<=0){
					perceptorBean.setValor(PerceptorBeanTipos.P_EXENTOS, true);
					perceptorBean.escribirDesarrollo("EXENTOS = S");
				} else if(numdes > 1  && retrib.compareTo(BD15093.add(pension).add(desem))<=0){
					perceptorBean.setValor(PerceptorBeanTipos.P_EXENTOS, true);
					perceptorBean.escribirDesarrollo("EXENTOS = S");
				} 
			}
		}
	}

	// BASE PARA CALCULAR EL TIPO DE RETENCION.
	private void baseParaCalcularElTipoDeretencion(PerceptorBean perceptorBean) {
		// Suma de reducciones
		perceptorBean.setValor(PerceptorBeanTipos.P_REDU,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PENSION)
								.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_HIJOS))
								.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DESEM))
								.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CONYUGE)));
		
		perceptorBean.escribirDesarrollo("REDU = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PENSION)+" + "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_HIJOS)+" + "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DESEM)+" + "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_CONYUGE)+ " = "
				+perceptorBean.getValor(PerceptorBeanTipos.P_REDU));
		
		// Clculo de la base
		if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RNTREDU)
				.compareTo(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_REDU)) > 0) {
			perceptorBean.setValor(PerceptorBeanTipos.P_BASE,
							perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RNTREDU)
									.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_REDU)));
			perceptorBean.escribirDesarrollo("BASE = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RNTREDU)+" - "
					+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_REDU)+" = "
					+perceptorBean.getValor(PerceptorBeanTipos.P_BASE));
			
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_BASE, BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
			perceptorBean.escribirDesarrollo("BASE = 0,00");
		}
	}

	// MNIMO PERSONAL Y FAMILIAR
	private void minimoPersonalYFamiliar(PerceptorBean perceptorBean) {
		minimoDelContribuyente(perceptorBean);
		minimoPorDescendientesMenor25AniosODiscapacitados(perceptorBean);
		minimoPorAscendientesMayor65AniosODiscapacitados(perceptorBean);
		minimoPorDiscapacidad(perceptorBean);

		perceptorBean.setValor(PerceptorBeanTipos.P_MINPERFA,
				perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINCON)
						.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINDES))
						.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINAS))
						.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINDIS)));
	}

	// D. MINIMO POR DISCAPACIDAD
	private void minimoPorDiscapacidad(PerceptorBean perceptorBean) {
		minimoPorDiscapacidadDelContribuyente(perceptorBean);
		minimoPordiscapacidadDeDescendientesYAscendientes(perceptorBean);
		perceptorBean.setValor(PerceptorBeanTipos.P_MINDIS,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINDISC)
								.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MDISDEAS)));
	}

	// D2. DISCAPACIDAD DE DESCENDIENTES Y ASCENDIENTES
	@SuppressWarnings("unchecked")
	private void minimoPordiscapacidadDeDescendientesYAscendientes(PerceptorBean perceptorBean) {
		List<DescendienteBean> descendientes = (List<DescendienteBean>) perceptorBean.getValor(PerceptorBeanTipos.P_DESCENDIENTES);
		int tamDesc = descendientes.size();
		descendientes = null;
		BigDecimal disDes = BigDecimal.ZERO;
		BigDecimal asisDesc = BigDecimal.ZERO;

		for (int i = 0; i < tamDesc; i++) {
			DescendienteBean d = (DescendienteBean) perceptorBean.getValor(DESCENDIENTES_ORDENADOS, i);
			BigDecimal porEntero = d.isPorEntero() ? PerceptorBeanTipos.UNO: PerceptorBeanTipos.UNMEDIO;
			int disca = d.getDiscapacidad();

			// Descendiente discapacitado
			if (disca == PerceptorBeanTipos.ENTRE33Y65) {
				disDes = disDes.add(BD3000.multiply(porEntero));
			} else if (disca == PerceptorBeanTipos.MAS65) {
				disDes = disDes.add(BD9000.multiply(porEntero));
			}

			// ** Gastos de asistencia descendiente
			if (disca == PerceptorBeanTipos.MAS65 || (disca == PerceptorBeanTipos.ENTRE33Y65 && d.isMovilidadReducida())) {
				asisDesc = asisDesc.add(BD3000.multiply(porEntero));
			} 
			d = null;
			porEntero = null;
		}

		perceptorBean.setValor(PerceptorBeanTipos.P_DISDES, disDes.setScale(2, BigDecimal.ROUND_HALF_UP));
		perceptorBean.setValor(PerceptorBeanTipos.P_ASISDES, asisDesc.setScale(2, BigDecimal.ROUND_HALF_UP));

		disDes = null;
		asisDesc = null;

		// Ascendiente discapacitado.
		List<AscendienteBean> ascendientes = (List<AscendienteBean>) perceptorBean.getValor(PerceptorBeanTipos.P_ASCENDIENTES);
		int tamAsc = ascendientes.size();
		
		BigDecimal disAsc = BigDecimal.ZERO;
		BigDecimal asisAsc = BigDecimal.ZERO;

		for (int i = 0; i < tamAsc; i++) {
			AscendienteBean a = ascendientes.get(i);
			BigDecimal convivencia = new BigDecimal(a.getConvivencia());

			// Ascendiente discapacitado
			int disca = a.getDiscapacidad();

			if (disca == PerceptorBeanTipos.ENTRE33Y65) {
				disAsc = disAsc.add(BD3000.divide(convivencia, 10, BigDecimal.ROUND_HALF_UP));
			} else if (disca == PerceptorBeanTipos.MAS65) {
				disAsc = disAsc.add(BD9000.divide(convivencia, 10, BigDecimal.ROUND_HALF_UP));
			}

			// Gastos asistencia ascendiente
			if (disca == PerceptorBeanTipos.MAS65 || (disca == PerceptorBeanTipos.ENTRE33Y65 && a.isMovilidadReducida())) {
				asisAsc = asisAsc.add(BD3000.divide(convivencia, 10, BigDecimal.ROUND_HALF_UP));
			}

			a = null;
			convivencia = null;
		}
		ascendientes=null;
		
		perceptorBean.setValor(PerceptorBeanTipos.P_DISAS, disAsc.setScale(2, BigDecimal.ROUND_HALF_UP));

		perceptorBean.setValor(PerceptorBeanTipos.P_ASISAS, asisAsc.setScale(2, BigDecimal.ROUND_HALF_UP));

		perceptorBean.setValor(PerceptorBeanTipos.P_MDISDEAS,
				perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DISDES)
						.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DISAS))
						.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_ASISDES))
						.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_ASISAS)));

		disAsc = null;
		asisAsc = null;
	}

	// D1. DISCAPACIDAD DEL CONTRIBUYENTE
	private void minimoPorDiscapacidadDelContribuyente(PerceptorBean perceptorBean) {
		// Contribuyente discapacitado
		Integer discaper = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_DISCAPER);
		if (discaper == PerceptorBeanTipos.MAS65) {
			perceptorBean.setValor(PerceptorBeanTipos.P_DISPER, BD9000);
		} else if (discaper == PerceptorBeanTipos.ENTRE33Y65) {
			perceptorBean.setValor(PerceptorBeanTipos.P_DISPER, BD3000);
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_DISPER, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
		}

		// Gastos asistencia contribuyente
		if ((discaper == PerceptorBeanTipos.MAS65) 
				|| (discaper == PerceptorBeanTipos.ENTRE33Y65 && (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_MOVILPER))) {
			perceptorBean.setValor(PerceptorBeanTipos.P_ASISPER, BD3000); 
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_ASISPER, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
		}

		perceptorBean.setValor(PerceptorBeanTipos.P_MINDISC,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_DISPER)
								.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_ASISPER)));
	}

	// C.MNIMO POR ASCENDIENTES >= 65 AOS O DISCAPACITADOS
	@SuppressWarnings("unchecked")
	private void minimoPorAscendientesMayor65AniosODiscapacitados(PerceptorBean perceptorBean) {
		BigDecimal as65 = BigDecimal.ZERO;
		BigDecimal as75 = BigDecimal.ZERO;

		List<AscendienteBean> ascendientes = (List<AscendienteBean>) perceptorBean.getValor(PerceptorBeanTipos.P_ASCENDIENTES);
		if (ascendientes == null) {
			ascendientes = new ArrayList<>();
		}
		// cambiamos la forma de recorrer
		int nD = ascendientes.size();
		for (int i = 0; i < nD; i++) {
			AscendienteBean a = ascendientes.get(i);

			BigDecimal convivencia = new BigDecimal(a.getConvivencia());

			// C1. ASCENDIENTES MAYOR 65 AOS O DISCAPACITADOS
			as65 = as65.add(BD1150.divide(convivencia, 10, BigDecimal.ROUND_HALF_UP));

			int anioAsc = a.getAnioNacimiento(); 
			int edadAsc = PerceptorBeanTipos.ANIOEJ_21 - anioAsc;

			// C2. ASCENDIENTES MAYOR 75 AOS
			if (edadAsc > 74) {
				as75 = as75.add(BD1400.divide(convivencia, 10, BigDecimal.ROUND_HALF_UP));
			}

			a = null;
			convivencia = null;
		}
		ascendientes=null;
		
		perceptorBean.setValor(PerceptorBeanTipos.P_AS65, as65.setScale(2, BigDecimal.ROUND_HALF_UP));
		perceptorBean.setValor(PerceptorBeanTipos.P_AS75, as75.setScale(2, BigDecimal.ROUND_HALF_UP));
		perceptorBean.setValor( PerceptorBeanTipos.P_MINAS,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_AS65)
							.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_AS75)));

		as65 = null;
		as75 = null;
	}

	// B. MINIMO POR DESCENDIENTES < 25 AOS  DISCAPACITADOS
	@SuppressWarnings("unchecked")
	private void minimoPorDescendientesMenor25AniosODiscapacitados(PerceptorBean perceptorBean) {
		List<DescendienteBean> descendientes = (List<DescendienteBean>) perceptorBean.getValor(PerceptorBeanTipos.P_DESCENDIENTES);

		if (descendientes == null) {
			descendientes = new ArrayList<>();
		}
		
		int tamDesc = descendientes.size();
		descendientes = null;
		
		BigDecimal mindesg = BigDecimal.ZERO;
		BigDecimal mindes3 = BigDecimal.ZERO;

		for (int i = 0; i < tamDesc; i++) {

			DescendienteBean d = (DescendienteBean) perceptorBean.getValor(DESCENDIENTES_ORDENADOS, i);
			int anioDesc = d.getAnioNacimiento();
			BigDecimal porEntero = d.isPorEntero() ? PerceptorBeanTipos.UNO : PerceptorBeanTipos.UNMEDIO;

			// B1. CON CARACTER GENERAL
			switch (i) {
			case 0:
				mindesg = mindesg.add(BD2400.multiply(porEntero));
				break;
			case 1:
				mindesg = mindesg.add(BD2700.multiply(porEntero));
				break;
			case 2:
				mindesg = mindesg.add(BD4000.multiply(porEntero));
				break;
			default:
				mindesg = mindesg.add(BD4500.multiply(porEntero));
				break;
			}

			// B2. Descendientes < 3 aos
			int anioAdop = d.getAnioAdopcion();
			if (anioDesc > PerceptorBeanTipos.ANIODESCMENORTRES3_21 
					|| ((anioAdop >= anioDesc) && (anioAdop > PerceptorBeanTipos.ANIODESCMENORTRES3_21))) {
				mindes3 = mindes3.add(BD2800.multiply(porEntero));
			}
			d = null;

			porEntero = null;
		}
		perceptorBean.setValor(PerceptorBeanTipos.P_MINDESG, mindesg.setScale(2, BigDecimal.ROUND_HALF_UP));

		perceptorBean.setValor(PerceptorBeanTipos.P_MINDES3, mindes3.setScale(2, BigDecimal.ROUND_HALF_UP));

		mindesg = null;
		mindes3 = null;

		perceptorBean.setValor(PerceptorBeanTipos.P_MINDES,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINDESG)
							.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINDES3)));

	}

	// A. MNIMO DEL CONTRIBUYENTE	
	private void minimoDelContribuyente(PerceptorBean perceptorBean) {
		// A1.CON CARCTER GENERAL
		perceptorBean.setValor(PerceptorBeanTipos.P_MINPER, BD5550);
		// A2.- EDAD >= 65
		long edad = PerceptorBeanTipos.ANIOEJ_21 - (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_ANIOPER);

		if (edad > 64) {
			perceptorBean.setValor(PerceptorBeanTipos.P_PER65, BD1150);
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_PER65, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
		}

		// A3. SI EDAD >= 75
		if (edad > 74) {
			perceptorBean.setValor(PerceptorBeanTipos.P_PER75, BD1400);
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_PER75, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
		}

		perceptorBean.setValor(PerceptorBeanTipos.P_MINCON,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPER)
							.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PER65))
							.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PER75)));
		perceptorBean.escribirDesarrollo("MINCON = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPER)+" + "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PER65)+" + "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PER75)+ " = "
				+perceptorBean.getValor(PerceptorBeanTipos.P_MINCON));

		// <= 8.100,00 POR ESQUEMA
		if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINCON).compareTo(BD8100) > 0) {
			perceptorBean.setValor(PerceptorBeanTipos.P_MINCON, BD8100);
		}
	}

	// REDUCCIN POR SER DESEMPLEADO
	private void reduccionPorSerDesempleado(PerceptorBean perceptorBean) {
		if ((Integer) perceptorBean.getValor(PerceptorBeanTipos.P_SITUPER) == PerceptorBeanTipos.DESEMPLEADO) {
			perceptorBean.setValor(PerceptorBeanTipos.P_DESEM, BD1200);
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_DESEM, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
		}
	}

	// REDUCCIN MAS DE DOS DESCENDIENTES
	private void reduccionMasDe2Descendientes(PerceptorBean perceptorBean) {
		if ((Integer) perceptorBean.getValor(PerceptorBeanTipos.P_NUMDES) > 2) {
			perceptorBean.setValor(PerceptorBeanTipos.P_HIJOS, BD600);
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_HIJOS, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
		}
	}

	// REDUCCIN PENSIONISTA DE LA S. SOCIAL O CLASES PASIVAS
	private void reduccionPensionistaDeLaSSOClasesPasivas(
			PerceptorBean perceptorBean) {
		// A. Reduccin por pensionista
		if ((Integer) perceptorBean.getValor(PerceptorBeanTipos.P_SITUPER) == PerceptorBeanTipos.PENSIONISTA) {
			perceptorBean.setValor(PerceptorBeanTipos.P_PENSION, BD600);
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_PENSION, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
		}
	}

	// CLCULO DE LOS GASTOS DEDUCIBLES
	private void calculosGastosDeducibles(PerceptorBean perceptorBean) {
		// A. CON CARCTER GENERAL
		perceptorBean.setValor(PerceptorBeanTipos.P_GASTOSGEN, BD2000);

		// B. INCREMENTO POR MOVILIDAD GEOGRAFICA
		if ((Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_MOVIL)) {
			perceptorBean.setValor(PerceptorBeanTipos.P_INCREGASMOVIL, BD2000);
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_INCREGASMOVIL,BigDecimal.ZERO);
		}

		// C. INCREMENTO PARA TRABAJADORES ACTIVOS CON DISCAPACIDAD
		if ((Integer) perceptorBean.getValor(PerceptorBeanTipos.P_SITUPER) == PerceptorBeanTipos.ACTIVO) {
			int discaper = (Integer) perceptorBean.getValor(PerceptorBeanTipos.P_DISCAPER);
			if (discaper == PerceptorBeanTipos.MAS65
					|| (discaper == PerceptorBeanTipos.ENTRE33Y65 && (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_MOVILPER))) {
				perceptorBean.setValor(PerceptorBeanTipos.P_INCREGASDISTRA, BD7750);
			} else if (discaper == PerceptorBeanTipos.ENTRE33Y65) {
				perceptorBean.setValor(PerceptorBeanTipos.P_INCREGASDISTRA, BD3500);
			} else {
				perceptorBean.setValor(PerceptorBeanTipos.P_INCREGASDISTRA, BigDecimal.ZERO.setScale(2,BigDecimal.ROUND_HALF_UP));
			}
		} else {
			// si no es activo no tiene que tener este gasto
			perceptorBean.setValor(PerceptorBeanTipos.P_INCREGASDISTRA,BigDecimal.ZERO);
		}

		// D.TOTAL OTROS GASTOS 
		perceptorBean.setValor(PerceptorBeanTipos.P_OTROSGASTOS,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_GASTOSGEN)
							.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_INCREGASMOVIL))
							.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_INCREGASDISTRA)));
		
		perceptorBean.escribirDesarrollo("OTROS GASTOS = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_GASTOSGEN)+" + "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_INCREGASMOVIL)+" + "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_INCREGASDISTRA)+ " = "
				+perceptorBean.getValor(PerceptorBeanTipos.P_OTROSGASTOS));

		BigDecimal valor = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB)
							.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_COTIZACIONES));

		if (valor.compareTo(BigDecimal.ZERO) < 0) {
			perceptorBean.setValor(PerceptorBeanTipos.P_OTROSGASTOS,BigDecimal.ZERO);
			perceptorBean.escribirDesarrollo("OTROS GASTOS = 0");
		} else if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_OTROSGASTOS).compareTo(valor) > 0) {
			perceptorBean.setValor(PerceptorBeanTipos.P_OTROSGASTOS, valor);
			perceptorBean.escribirDesarrollo("OTROS GASTOS = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB)+" - "
					+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_COTIZACIONES)+" = "+valor);
		}

		// GASTOS DEDUCIBLES
		perceptorBean.setValor(PerceptorBeanTipos.P_GASTOS,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_COTIZACIONES)
							.add(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_OTROSGASTOS)));
		
		perceptorBean.escribirDesarrollo("GASTOS = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_COTIZACIONES)+" + "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_OTROSGASTOS)+" = "		
				+perceptorBean.getValor(PerceptorBeanTipos.P_GASTOS));
	}

	// RENDIMIENTO NETO DEL TRABAJO (a efectos del clculo de la reduccin por obtencin de rendimientos del trabajo).
	private void rendimientoNetoTrabajo(PerceptorBean perceptorBean) {
		perceptorBean.setValor(PerceptorBeanTipos.P_RNT,
						BigDecimal.ZERO.max(
							perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB)
								.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IRREGULAR1))
								.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IRREGULAR2))
								.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_COTIZACIONES))));
		
		perceptorBean.escribirDesarrollo("RNT = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB)+" - "
			+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IRREGULAR1)+" - "
			+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IRREGULAR2)+" - "
			+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_COTIZACIONES)+" = "
			+perceptorBean.getValor(PerceptorBeanTipos.P_RNT));
	}

	// REDUCCIN POR OBTENCIN DE RENDIMIENTOS DEL TRABAJO 
	private void reduccionPorObtencionDeRendimientosDelTrabajo(PerceptorBean perceptorBean) {
		reduccionDeCaracterGeneral(perceptorBean);
	}

	// REDUCCIN DE CARCTER GENERAL
	private void reduccionDeCaracterGeneral(PerceptorBean perceptorBean) {
		//Si RNT <= 13.115,00: RED20 = 5.565,00 
		if(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RNT).compareTo(BD13115) <= 0){
			perceptorBean.setValor(PerceptorBeanTipos.P_RED20, BD5565);
			perceptorBean.escribirDesarrollo("RED20 = 5.565,00");
		} else if (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RNT).compareTo(BD16825) <= 0){
			//Else: Si RNT <= 16.825,00: RED20 = 5.565 - [1,5 * (RNT- 13.115,00)]
			BigDecimal red20 = BD5565.subtract(BD15.multiply(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RNT).subtract(BD13115)));
			perceptorBean.setValor(PerceptorBeanTipos.P_RED20, new BigDecimal(red20.setScale(2, BigDecimal.ROUND_HALF_UP).toString()));
			
			perceptorBean.escribirDesarrollo("RED20 = 5.565 - [1.5 * ("+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RNT)+" - 13.115,00)] = "
					+perceptorBean.getValor(PerceptorBeanTipos.P_RED20));
			
		} else {
			//Else: RED20 = 0,00
			perceptorBean.setValor(PerceptorBeanTipos.P_RED20, BigDecimal.ZERO.setScale(2, BigDecimal.ROUND_HALF_UP));
			perceptorBean.escribirDesarrollo("RED20 = 0");
		}
	}

	// RENDIMIENTO NETO REDUCIDO
	private void rendimientoNetoReducido(PerceptorBean perceptorBean) {
		perceptorBean.setValor(PerceptorBeanTipos.P_RNTREDU,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RNT)
							.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_OTROSGASTOS))
							.subtract(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RED20)));

		perceptorBean.setValor(PerceptorBeanTipos.P_RNTREDU,
						perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RNTREDU).max(BigDecimal.ZERO));
		
		perceptorBean.escribirDesarrollo("RNTREDU = "+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RNT)+" - "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_OTROSGASTOS)+" - "
				+perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RED20)+" = "		
				+perceptorBean.getValor(PerceptorBeanTipos.P_RNTREDU));
	}

	@Override
	public PerceptorBean createPerceptorBean() {
		return new PerceptorBeanImpl();
	}

	@Override
	public List<ErrorValidacionBean> getErrores(PerceptorBean perceptorBean) {
		return Collections.unmodifiableList(perceptorBean.getErr());
	}

	// CALCULO Y COMPUTO DE DESCENDIENTES
	@SuppressWarnings("unchecked")
	private void calculoYComputoDeDescendientes(PerceptorBean perceptorBean) {
		int numDesc = 0;
		int numDes3 = 0;
		int numDes325 = 0;
		int numDes3En = 0;
		int numDes325En = 0;
		int numDesMas3 = 0;
		int numDesMas3En = 0;
		int	numDes3365 = 0;
		int numDes3365En = 0;
		int numDescMov = 0;
		int numDes65 = 0;
		int numDes65En = 0;
		int numDescMovEn = 0;

		ordenarDescendientes(perceptorBean);
		List<DescendienteBean> descendientesOrdenados = (List<DescendienteBean>) perceptorBean.getValor(DESCENDIENTES_ORDENADOS);

		String comhijo1 = "";
		String comhijo2 = "";
		String comhijo3 = "";

		int nD = descendientesOrdenados.size();
		for (int i = 0; i < nD; i++) {
			DescendienteBean descendiente = descendientesOrdenados.get(i);

			int anioDesc = descendiente.getAnioNacimiento();
			int edadDesc = PerceptorBeanTipos.ANIOEJ_21 - anioDesc;

			int anioAdop = descendiente.getAnioAdopcion();
			BigDecimal porEntero = descendiente.isPorEntero() ? PerceptorBeanTipos.UNO : PerceptorBeanTipos.UNMEDIO;
			int disca = descendiente.getDiscapacidad();

			numDesc++;

			// Calculo para menores de tres aos
			if (edadDesc < 3 || anioAdop > PerceptorBeanTipos.ANIODESCMENORTRES3_21) {
				numDes3++;
				if (porEntero.compareTo(PerceptorBeanTipos.UNO) == 0) {
					numDes3En++;
				}
			} else if ((edadDesc >= 3 && edadDesc < 25) || (edadDesc >= 25 && disca != PerceptorBeanTipos.SINDISCAPACIDAD)) {
				numDes325++;
				if (porEntero.compareTo(PerceptorBeanTipos.UNO) == 0) {
					numDes325En++;
				}
			}

			// CMPUTOS DEL HIJO 1, 2, 3 Y RESTANTES
			switch (numDesc) {
			case 1:
				comhijo1 = porEntero.compareTo(PerceptorBeanTipos.UNO) == 0 ? POR_ENTERO : POR_MITAD;
				break;

			case 2:
				comhijo2 = porEntero.compareTo(PerceptorBeanTipos.UNO) == 0 ? POR_ENTERO : POR_MITAD;
				break;

			case 3:
				comhijo3 = porEntero.compareTo(PerceptorBeanTipos.UNO) == 0 ? POR_ENTERO : POR_MITAD;
				break;

			default:
				numDesMas3++;
				if (porEntero.compareTo(PerceptorBeanTipos.UNO) == 0){
					numDesMas3En++;
				}
				break;
			}

			// Clculo del nmero total de descendientes con discapacidad >=33 y < 65
			if (disca == PerceptorBeanTipos.ENTRE33Y65) {
				numDes3365++;
				if (descendiente.isMovilidadReducida()) {
					numDescMov++;
				}
				if (porEntero.compareTo(PerceptorBeanTipos.UNO) == 0){
					numDes3365En++;
					if (descendiente.isMovilidadReducida()) {
						numDescMovEn++;
					}
				}
			} else if (disca == PerceptorBeanTipos.MAS65) {
				numDes65++;
				if (porEntero.compareTo(PerceptorBeanTipos.UNO) == 0){
					numDes65En++;
				}
			}

			descendiente = null;
			porEntero = null;
		}
		descendientesOrdenados = null;
		
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMDES, numDesc);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMDES3, numDes3);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMDES325, numDes325);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMDESMAS3, numDesMas3);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMDESMAS3EN, numDesMas3En);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMDES325EN, numDes325En);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMDES3EN, numDes3En);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMDES3365, numDes3365);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMDES3365EN, numDes3365En);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMDESMOV, numDescMov);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMDESMOVEN, numDescMovEn);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMDES65, numDes65);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMDES65EN, numDes65En);

		perceptorBean.setValor(PerceptorBeanTipos.P_COMHIJO1, comhijo1);
		perceptorBean.setValor(PerceptorBeanTipos.P_COMHIJO2, comhijo2);
		perceptorBean.setValor(PerceptorBeanTipos.P_COMHIJO3, comhijo3);
	}

	// CALCULO Y COMPUTO DE ASCENDIENTES
	@SuppressWarnings("unchecked")
	private void calculoYComputoDeAscendientes(PerceptorBean perceptorBean) {
		int numAsc = 0;
		int numAs65A = 0;
		int numAs65AEn = 0;
		int numAs75A = 0;
		int numAs75AEn = 0;
		int numAs3365 = 0; 
		int numAs3365En = 0;
		int numAs65 = 0;
		int numAs65En = 0;
		int numAsMov = 0;
		int numAsMovEn = 0;

		List<AscendienteBean> ascendientes = (List<AscendienteBean>) perceptorBean.getValor("ascendientes");

		int nD = ascendientes.size();
		for (int i = 0; i < nD; i++) {
			AscendienteBean ascendiente = ascendientes.get(i);
			BigDecimal convivencia = new BigDecimal(ascendiente.getConvivencia());
			int edadAs = PerceptorBeanTipos.ANIOEJ_21 - ascendiente.getAnioNacimiento();
			int disca = ascendiente.getDiscapacidad();

			numAsc++;

			// Cmputo del numero de ascendientes mayores y menores de 75 aos
			if (edadAs > 74) {
				numAs75A++;
				if (convivencia.intValue() == 1) {
					numAs75AEn++;
				}
			} else if ((edadAs <= 74 && edadAs > 64) || (edadAs <= 64 && disca != PerceptorBeanTipos.SINDISCAPACIDAD)) {
				numAs65A++;
				if (convivencia.intValue() == 1) {
					numAs65AEn++;
				}
			}

			// Clculo del numero de ascendientes discapacitados 33 al 65 %
			if (disca == PerceptorBeanTipos.ENTRE33Y65) {
				numAs3365++;
				if (convivencia.intValue() == 1) {
					numAs3365En++;
				}
				if (ascendiente.isMovilidadReducida()) {
					numAsMov++;
					if (convivencia.intValue() == 1) {
						numAsMovEn++;
					}
				}
			} else if (disca == PerceptorBeanTipos.MAS65) {
				numAs65++;
				if (convivencia.intValue() == 1) {
					numAs65En++;
				}
			}

			ascendiente = null;
			convivencia = null;
		}
		ascendientes = null;
		
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMAS, numAsc);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMAS65A, numAs65A);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMAS65AEN, numAs65AEn);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMAS75A, numAs75A);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMAS75AEN, numAs75AEn);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMAS3365, numAs3365);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMAS3365EN, numAs3365En);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMAS65, numAs65);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMAS65EN, numAs65En);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMASMOV, numAsMov);
		perceptorBean.setValor(PerceptorBeanTipos.P_NUMASMOVEN, numAsMovEn);
	}

	private void setRegularizacion(PerceptorBean perceptorBean) {
		boolean[] causa = (boolean[]) perceptorBean.getValor(PerceptorBeanTipos.P_CAUSA);
		boolean regularizacion = false;
		for (int i = 1; i < causa.length; i++) {
			if ((Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_CAUSA, i)) {
				regularizacion = true;
				break;
			}
		}
		perceptorBean.setValor(PerceptorBeanTipos.P_REGULARIZACION, regularizacion);
	}

	private boolean validaNifMayus(String nif) {
		int length = nif.length();

		for (int i = 0; i < length; i++) {
			if (VALIDOSNIF.indexOf(nif.charAt(i)) == -1) {
				return false;
			}
		}
		return true;
	}

//	ya no lo usamos, validamos por esquema
//	private static boolean validaNombrePerceptor(String nombre, int resul) {
//		return ValidaNif.validaNombre(resul, nombre);
//	}

	@SuppressWarnings("unchecked")
	protected void ordenarDescendientes(PerceptorBean perceptorBean) {

		List<DescendienteBean> descendientes = (List<DescendienteBean>) perceptorBean.getValor(ERR_DESCENDIENTES);

		List<DescendienteBean> descendientesOrdenados = (List<DescendienteBean>) perceptorBean.getValor(DESCENDIENTES_ORDENADOS);

		descendientesOrdenados.clear();

		descendientesOrdenados.addAll(Collections.nCopies(descendientes.size(), perceptorBean.createDescendienteBean()));

		Collections.copy(descendientesOrdenados, descendientes);

		Collections.sort(descendientesOrdenados, new Comparator<DescendienteBean>() {
					public int compare(DescendienteBean o1, DescendienteBean o2) {
						return o1.getAnioNacimiento() - o2.getAnioNacimiento();
					}
				});
		perceptorBean.setValor(DESCENDIENTES_ORDENADOS, descendientesOrdenados);
		descendientes = null;
		descendientesOrdenados = null;
	}

	@Override
	@SuppressWarnings("unchecked")
	public boolean avisoMonoparental(PerceptorBean perceptorBean) {

		List<DescendienteBean> descendientes = (List<DescendienteBean>) perceptorBean.getValor(ERR_DESCENDIENTES);
		int nD = descendientes.size();

		DescendienteBean d;
		for (int i = 0; i < nD; i++) {
			d = descendientes.get(i);

			int anioDesc = d.getAnioNacimiento();
			int disca = d.getDiscapacidad();

			if (anioDesc > PerceptorBeanTipos.ANIODESCMENORDIECIOCHO_21) {
				return false;
			}

			if (anioDesc <= PerceptorBeanTipos.ANIODESCMENORDIECIOCHO_21 && disca == PerceptorBeanTipos.MAS65) {
				return false;
			}			
		}
		d = null;
		descendientes = null;
		return true;
	}
	
	@Override
	public boolean avisoTipoA(PerceptorBean perceptorBean) {
		if (!(Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_REGULARIZACION)) {
			return false;
		}

		boolean[] causa = (boolean[]) perceptorBean.getValor(PerceptorBeanTipos.P_CAUSA);

		if (causa[9] || causa[11] || causa[10] ) {
			return false;
		}

		BigDecimal tipoACalculado = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETENIDO)
				.divide(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PERCIBIDO),10, BigDecimal.ROUND_HALF_UP)
				.setScale(4, BigDecimal.ROUND_DOWN);

		BigDecimal porcentajeTipoA = perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPOA).divide(BigDecimal.valueOf(100));
		
		BigDecimal diferencia = (porcentajeTipoA.subtract(tipoACalculado)).abs();
		int resultado = PerceptorBeanTipos.MARGEN_ERROR_TIPO.compareTo(diferencia);
		diferencia = null;
		tipoACalculado = null;

		if (resultado == 0 || resultado > 0) {
			return false;
		} else {
			return true;
		}
	}
	
	@Override
	public boolean avisosBaseA(PerceptorBean perceptorBean) {
		if (!(Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_REGULARIZACION)) {
			return false;
		}

		boolean[] causa = (boolean[]) perceptorBean.getValor(PerceptorBeanTipos.P_CAUSA);

		if (!causa[11] && !causa[10]&& !causa[9] 
				&& (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASEA).compareTo(BigDecimal.ZERO) == 0)) {
			return true;
		}
		return false;
	}

	@Override
	public boolean avisosRetribA(PerceptorBean perceptorBean) {
		if ((Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_REGULARIZACION)
				&& (Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_CAUSA, 11)
				&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_RETRIB)
						.compareTo(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_PERCIBIDO)) < 0) {
			return true;
		}
		return false;
	}

	@Override
	public boolean validarPostCalculos(PerceptorBean perceptorBean) {
		// 39. Si [ (REGULARIZACION = S) y (CAUSA1 = S) y (BASE=BASEA)]: De los datos introducidos no se desprende que se hayan producido variaciones en 
		// la base para determinar el tipo de retencin, lo cual es incompatible con la causa de regularizacin consignada
		boolean[] causa = (boolean[]) perceptorBean.getValor(PerceptorBeanTipos.P_CAUSA);
		if (causa[1]
				&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASE)
						.compareTo(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_BASEA)) == 0) {

			perceptorBean.setErr(new ErrorValidacionBeanImpl(
					TipoErrorValidacion.ERROR,
					"R9083",
					"De los datos introducidos no se desprende que se hayan producido"
							+ " variaciones en la base para determinar el tipo de retencin,"
							+ " lo cual es incompatible con la causa de regularizacin consignada.",
					ERR_BASEA, -1));
		}

		// 40. Si [ (REGULARIZACION = S) y (CAUSA2 = S) y (MINPERFA=MINPERFAA)]: De los datos introducidos no se desprende que se hayan producido variaciones en
		// el mnimo personal y familiar para determinar el tipo de retencin, lo cual es incompatible con la causa de regularizacin consignada
		if (causa[2] 
				&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFA)
						.compareTo(perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINPERFAA)) == 0) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(
					TipoErrorValidacion.ERROR,
					"R9084",
					"De los datos introducidos no se desprende que se hayan producido"
							+ " variaciones en el mnimo personal y familiar para determinar el"
							+ " tipo de retencin, lo cual es incompatible con la causa de "
							+ REGULARIZACION_CONSIGNADA, ERR_MINPERFAA, -1));
		}
		// 80. Si (REGULARIZACION = S y MINOPAGOA != 0 y MINOPAGO < 0): La cantidad consignada en importe de la minoracin por pagos de prstamos para 
		// la vivienda determinado antes de la regularizacin es incorrecta.
		if ((Boolean) perceptorBean.getValor(PerceptorBeanTipos.P_REGULARIZACION)
				&& (perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGOA).compareTo(BigDecimal.ZERO) != 0) 
				&& perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_MINOPAGO).compareTo(BigDecimal.ZERO) < 0) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(
					TipoErrorValidacion.ERROR,
					"R9085",
					"La cantidad consignada en importe de la minoracin por pagos de prstamos"
							+ " para la vivienda determinado antes de la regularizacin es incorrecta.",
					ERR_MINOPAGOA, -1));
		}

		return perceptorBean.getErr().isEmpty();
	}

	@Override
	public String getVersion() {
		Properties prop = new Properties();

		try {
			prop.load(getClass().getResourceAsStream("/WEB-INF/R210/modelo.properties"));
		} catch (IOException e) {
			// no hacemos nada
		}
		return prop.getProperty("version.mc");
	}

	@Override
	public PerceptorBean createPerceptorBeanFromJson(String perceptorJson) {

		class DescendienteAdapter extends TypeAdapter<DescendienteBean> {
			@Override
			public DescendienteBean read(JsonReader reader) throws IOException {
				if (reader.peek() == JsonToken.NULL) {
					reader.nextNull();
					return null;
				}

				int anioNacimiento = 0;
				int anioAdopcion = 0;
				boolean porEntero = false;
				int discapacidad = 0;
				boolean movilidadReducida = false;

				reader.beginObject();
				while (reader.hasNext()) {
					String name = reader.nextName();
					if ("anioNacimiento".equals(name)) {
						anioNacimiento = reader.nextInt();
					} else if ("anioAdopcion".equals(name)) {
						anioAdopcion = reader.nextInt();
					} else if ("porEntero".equals(name)) {
						porEntero = reader.nextBoolean();
					} else if ("discapacidad".equals(name)) {
						discapacidad = reader.nextInt();
					} else if ("movilidadReducida".equals(name)) {
						movilidadReducida = reader.nextBoolean();
					} else {
						reader.skipValue();
					}
				}
				reader.endObject();
				return new DescendienteBeanImpl(anioNacimiento, anioAdopcion, porEntero, discapacidad, movilidadReducida);
			}

			@Override
			public void write(JsonWriter arg0, DescendienteBean arg1)
					throws IOException {
				// no hace nada
			}
		}

		class AscendienteAdapter extends TypeAdapter<AscendienteBean> {
			@Override
			public AscendienteBean read(JsonReader reader) throws IOException {
				if (reader.peek() == JsonToken.NULL) {
					reader.nextNull();
					return null;
				}

				int anioNacimiento = 0;
				int convivencia = 0;
				int discapacidad = 0;
				boolean movilidadReducida = false;

				reader.beginObject();
				while (reader.hasNext()) {
					String name = reader.nextName();
					if ("anioNacimiento".equals(name)) {
						anioNacimiento = reader.nextInt();
					} else if ("convivencia".equals(name)) {
						convivencia = reader.nextInt();
					} else if ("discapacidad".equals(name)) {
						discapacidad = reader.nextInt();
					} else if ("movilidadReducida".equals(name)) {
						movilidadReducida = reader.nextBoolean();
					} else {
						reader.skipValue();
					}
				}
				reader.endObject();
				return new AscendienteBeanImpl(anioNacimiento, convivencia,
						discapacidad, movilidadReducida);
			}

			@Override
			public void write(JsonWriter arg0, AscendienteBean arg1)
					throws IOException {
				// no hace nada
			}
		}

		Gson gson = new GsonBuilder()
				.registerTypeAdapter(DescendienteBean.class,new DescendienteAdapter())
				.registerTypeAdapter(AscendienteBean.class,new AscendienteAdapter()).create();
		
		return gson.fromJson(perceptorJson, PerceptorBeanImpl.class);
	}
	
	public static boolean esAlfabeticoAEAT(String sCadena){
		try{
			for (int i = 0; i < sCadena.length(); i++) {
				if (!esAlfabeticoAEAT(sCadena.charAt(i),true)){
					return false;
				}
			}
			return true;
		}catch (Exception ex){            
			return false;
		}
	}
	
	public static boolean esAlfabeticoAEAT(char c,boolean admitirExtendido){
		try{
			if (admitirExtendido){
				//twiki https://www.aeat/twiki6sh/bin/view/ApInfrTecnicas/JuegoCaracteresValido
				//Correo :
				/*
				 * - Minsculas (incluidas cedilla y ee).
				 * - Tildes, tanto a la derecha como a la izquierda de todas las vocales (maysculas y minsculas).
				 * - Diresis, para todas las vocales (maysculas y minsculas)
				 */
				//Minusculas
				if ((byte) c >= 97 && (byte) c <= 122){
					return true;
				}
				if (c == ''){
					return true;            
				}
				if (c == ''){
					return true;            
				}
				if (c == '' || c == '' || c == '' || c == '' || c == '' || c == ''){
					return true;            
				}
				if (c == '' || c == '' || c == '' || c == '' || c == '' || c == ''){
					return true;            
				}
				if (c == '' || c == '' || c == '' || c == '' || c == '' || c == ''){
					return true;            
				}
				if (c == '' || c == '' || c == '' || c == '' || c == '' || c == ''){
					return true;            
				}
				if (c == '' || c == '' || c == '' || c == '' || c == '' || c == ''){
					return true;            
				}
			}
	        	
			//Ascii 65-90
			if (esAlfabetico(c)){
				return true;	
			}
	        	
			//Ascii 165            
			if (c == ''){
				return true;            
			}
			//Ascii 199
			if (c == ''){
				return true;            
			}
			//Ascii 45
			if (c == '-'){
				return true;            
			}
			//Ascii 32
			if (c == ' '){
				return true;            
			}
			//Ascii 39
			if (c == '\''){
				return true;            
			}
//	            //Ascii 180
//	            if (c == ''){
//	            	return true;   
//	            }
			//Ascii 46
			if (c == '.'){
				return true;            
			}
			//Ascii 44
			if (c == ','){
				return true;            
			}
	            
			//JUAN 11-03-2015
			//Nos mandan de especificaciones los siguientes 4 caracteres nuevos : ":()_"
			//Ascii 58
			if (c == ':'){
				return true;            
			}
			//Ascii 95
			if (c == '_'){
				return true;            
			}
			//Ascii 40
			if (c == '('){
				return true;            
			}
			//Ascii 41
			if (c == ')'){
				return true;            
			}  

			//Ascii 38
			if (c == '&'){
				return true;            
			}
	                        
			return false;
		}catch(Exception ex){
			return false;
		}
	}
	    
	public static boolean esAlfabetico(char c){
		return ascii65a90(c);
	}
	    
	private static boolean ascii65a90(char c){
		//Ascii 65-90
		return (byte) c >= 65 && (byte) c <= 90; 
	}
	
	/**
	 *Indica si es alfanumerica una cadena
	 */     
	public static boolean esAlfanumericaAEAT(String sCadena){
		try{
			//Comprueba --->   A  - Z,   ,   ,  , _ . Blanco    		
			for (int i = 0; i < sCadena.length(); i++) {
				if (!esAlfanumericaAEAT(sCadena.charAt(i))) {
					return false;
				}
			}
			return true;
		}catch (Exception Ex){            
			return false;
		}
	}
	    
	public static boolean esAlfanumericaAEAT(char c) {
		try{
			if (esAlfabeticoAEAT(c,true)){
				return true;
			}
	             
			//Axcii 48-57
			if (esNumerica(c)){
				return true;            
			}
	             
			//Ascii 58 ':' comprobado en esAlfabeticoAEAT
			
			//Ascii 59
			if (c == ';'){
				return true;            
			}
			//Ascii 95 "_" comprobado en esAlfabeticoAEAT
			
			//Ascii 47
			if (c == '/'){
				return true;            
			}
			
			return false;
		}catch(Exception ex){
			return false;
		}
	} 
	
	public static boolean esNumerica(char c){
		return ascii48a57(c);
	}
	
	private static boolean ascii48a57(char c){
		//Ascii 48-57
		return (byte) c >= 48 && (byte) c <= 57;
	}

}
