package es.aeat.pret.c200.c210.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

//import com.sun.xml.internal.txw2.output.IndentingXMLStreamWriter;

import es.aeat.pret.c200.api.bean.AscendienteBean;
import es.aeat.pret.c200.api.bean.DescendienteBean;
import es.aeat.pret.c200.api.bean.PerceptorBean;
import es.aeat.pret.c200.api.bean.PerceptorBeanTipos;
import es.aeat.pret.c200.api.staxi.IEscribirSalida;
import es.aeat.pret.c200.imp.bean.PerceptorBeanImpl;

public class EscribirFicheroSalida implements IEscribirSalida{
	
	private static final long serialVersionUID = 1L;
	private static final String CAUSA = "Causa";
	private static final String POR_ENTERO = "PorEntero";
	private static final String ASISTENCIA = "Asistencia";
	private static final String TOTAL = "Total";
	private static final String GENERAL = "General";
	private static final String GRADO2 = "Grado2";
	private static final String MOVILIDAD_REDUCIDA = "MovilidadReducida";
	private static final String GRADO1 = "Grado1";
	private static final String DISCAPACIDAD = "Discapacidad";
	private static final String ANIO_NACIMIENTO = "AoNacimiento";
	FileOutputStream os;
	XMLOutputFactory xof;
	XMLStreamWriter writer = null;

	PerceptorBean modelo=null;
	boolean terminado=false;
	
	@Override
	public boolean isTerminado() {
		return terminado;
	}

	@Override
	public void startDocument(PerceptorBean modelo) {
		xof = XMLOutputFactory.newInstance(); 
		this.modelo=modelo;
		
		writer = null;
		
		try {
			os = new FileOutputStream(modelo.getFicheroSalida());
			
//			writer = new IndentingXMLStreamWriter(xof.createXMLStreamWriter(os, "ISO-8859-1"));
			writer = xof.createXMLStreamWriter(os, "ISO-8859-1");
			xof=null;
			
			// EMPEZAMOS DOCUMENTO
			writer.writeStartDocument("ISO-8859-1","1.0");
			
			writer.writeStartElement("AEATRetencionesSalida2021");
			writer.writeAttribute("Sello", "             ");
			writer.writeStartElement("IdDoc");
			writer.writeStartElement("CodModelo");
			writer.writeCharacters("RET");
			//CodModelo
			writer.writeEndElement();
			writer.writeStartElement("Ejercicio");
			writer.writeCharacters("2021");
			//Ejercicio
			writer.writeEndElement();
			//IdDoc
			writer.writeEndElement();

			writer.flush();
		
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		} catch (FileNotFoundException e) {
			getLog().severe(e.getMessage());
		} 
	}

	
	
	
	@Override
	public void endDocument() {
		try {
			// AEATRetencionesSalida2021
			writer.writeEndElement(); 
			writer.writeEndDocument();
			
			writer.flush();
			writer.close();
			
			os.flush();
			os.close();
			
			writer=null;
			terminado=true;
			
			os=null;
			modelo=null;
			
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		} catch (IOException e) {
			getLog().severe(e.getMessage());
		} 
	}

	@Override
	public void endRetenedor() {
		try {
			// Retenedor
			writer.writeEndElement(); 
			writer.flush();
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		} 
	}

	@Override
	public void startRetenedor() {
		try {
			writer.writeStartElement("Retenedor");
			writer.writeStartElement("Nif");
			writer.writeCharacters((String)modelo.getValor(PerceptorBeanTipos.P_NIFRET));
			//Nif
			writer.writeEndElement();
			writer.writeStartElement("ApellidosNombre");
			writer.writeCharacters((String)modelo.getValor(PerceptorBeanTipos.P_APERET));
			//ApellidosNombre
			writer.writeEndElement();
			writer.flush();
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		} 
	}

	@Override
	public void escribirRetenido() {
		try {
			writer.writeStartElement("Retenido");
			writer.writeStartElement("Nif");
			writer.writeCharacters((String)modelo.getValor(PerceptorBeanTipos.P_NIFPER));
			//Nif
			writer.writeEndElement();
			writer.writeStartElement("ApellidosNombre");
			writer.writeCharacters((String)modelo.getValor(PerceptorBeanTipos.P_APEPER));
			//ApellidosNombre
			writer.writeEndElement();
			writer.writeStartElement(ANIO_NACIMIENTO);
			writer.writeCharacters(((Integer)modelo.getValor(PerceptorBeanTipos.P_ANIOPER)).toString());
			//AoNacimiento	
			writer.writeEndElement();
			
			// Ceuta Melilla
			Boolean bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_RESICEME);
			if(bool){
				writer.writeEmptyElement("ResidenciaCeutaMelilla");
			}
			
			// Situacion Familiar
			writer.writeStartElement("SituacionFamiliar");
			Integer integ = (Integer)modelo.getValor(PerceptorBeanTipos.P_SITUFAM);
			if(integ==1){
				writer.writeEmptyElement("Situacion1");
			} else if(integ==2){
				writer.writeStartElement("Situacion2");
				writer.writeStartElement("NifConyuge");
				writer.writeCharacters((String)modelo.getValor(PerceptorBeanTipos.P_NIFCON));
				//NifConyuge
				writer.writeEndElement();
				//Situacion2
				writer.writeEndElement();
			} else if(integ==3){
				writer.writeEmptyElement("Situacion3");
			}
			//SituacionFamiliar
			writer.writeEndElement();
				
			// Discapacidad
			integ = (Integer)modelo.getValor(PerceptorBeanTipos.P_DISCAPER);
			if(integ==1){
				writer.writeStartElement(DISCAPACIDAD);
				
				bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_MOVILPER);
				if(bool){
					writer.writeStartElement(GRADO1);
					writer.writeEmptyElement(MOVILIDAD_REDUCIDA);
					//Grado1
					writer.writeEndElement();
				} else{
					writer.writeEmptyElement(GRADO1);
				}
				
				//Discapacidad
				writer.writeEndElement();
			} else if(integ==2){
				writer.writeStartElement(DISCAPACIDAD);
				writer.writeEmptyElement(GRADO2);
				//Discapacidad
				writer.writeEndElement();
			}
				
			// Situacion Laboral
			integ = (Integer)modelo.getValor(PerceptorBeanTipos.P_SITUPER);
			writer.writeStartElement("SituacionLaboral");
			// ACTIVO
			if(integ==1){ 
				writer.writeStartElement("TrabajadorActivo");
				writer.writeStartElement("Contrato");
				writer.writeCharacters(((Integer)modelo.getValor(PerceptorBeanTipos.P_CONTRATO)).toString());
				//contrato
				writer.writeEndElement();
				
				bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_MOVIL);
				if(bool){
					// 2015 ahora tenemos la fecha del cambio
					
					writer.writeStartElement("MovilidadGeografica");
					//2016 QUITAMOS CAMBIORESI
//					writer.writeStartElement("CambioResidencia")
//					writer.writeCharacters((String)modelo.getValor("CAMBIORESI"))
//					writer.writeEndElement();//CambioResidencia
					writer.writeEndElement();//MovilidadGeografica
				}

				//TrabajadorActivo
				writer.writeEndElement();
			} else if(integ==2){
				//PENSIONISTA
				writer.writeEmptyElement("Pensionista");
			} else if(integ==3){
				//DESEMPLEADO
				writer.writeEmptyElement("Desempleado");
			} else if(integ==4){
				//OTRAS SITUACIONES
				writer.writeEmptyElement("OtraSituacion");
			}
			//SituacionLaboral
			writer.writeEndElement();
				
			List<? extends DescendienteBean> listaDesc = modelo.getDescendientes();
			escribirDescendientes(listaDesc);
			listaDesc = null;
			List<AscendienteBean> listaAsc = modelo.getAscendientes();
			escribirAscendientes(listaAsc);
			listaAsc = null;
			
			writer.writeStartElement("RetribAnuales");
			writer.writeCharacters(((BigDecimal)modelo.getValor(PerceptorBeanTipos.P_RETRIB)).toString());
			//RetribAnuales
			writer.writeEndElement();
				
			BigDecimal valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_IRREGULAR1);
			BigDecimal valor2 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_IRREGULAR2);
			BigDecimal valor3 = null;
			if(valor1.compareTo(BigDecimal.ZERO)!=0 || valor2.compareTo(BigDecimal.ZERO)!=0){
				writer.writeStartElement("Reducciones");
				if(valor1.compareTo(BigDecimal.ZERO)!=0){
					writer.writeStartElement("Irregularidad1");
					writer.writeCharacters(valor1.toString());
					//Irregularidad1
					writer.writeEndElement();
				}
				if(valor2.compareTo(BigDecimal.ZERO)!=0){
					writer.writeStartElement("Irregularidad2");
					writer.writeCharacters(valor2.toString());
					//Irregularidad2
					writer.writeEndElement();
				}
				//Reducciones
				writer.writeEndElement();
			}
				
			//GastosAnuales
			// 2015 GASTOS pasa a ser COTIZACIONES			
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_COTIZACIONES);
			if(valor1.compareTo(BigDecimal.ZERO)!=0){
				writer.writeStartElement("Cotizaciones");
				writer.writeCharacters(valor1.toString());
				//Cotizaciones
				writer.writeEndElement();
			}

			//PensionCompensatoria
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_CONYUGE);
			if(valor1.compareTo(BigDecimal.ZERO)!=0){
				writer.writeStartElement("PensionCompensatoria");
				writer.writeCharacters(valor1.toString());
				//PensionCompensatoria
				writer.writeEndElement();
			}
			//AnualidadesHijos
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_ANUALIDADES);
			if(valor1.compareTo(BigDecimal.ZERO)!=0){
				writer.writeStartElement("AnualidadesHijos");
				writer.writeCharacters(valor1.toString());
				//AnualidadesHijos
				writer.writeEndElement();
			}
				
			//RdtosObtenidosCeutaMelilla
			bool =(Boolean)modelo.getValor(PerceptorBeanTipos.P_RENCEME) ;
			if(bool){
				writer.writeEmptyElement("RdtosObtenidosCeutaMelilla");
			}
			//PagoPrestamosVivienda 
			bool =(Boolean)modelo.getValor(PerceptorBeanTipos.P_PRESVIV) ;
			if(bool){
				writer.writeEmptyElement("PagoPrestamosVivienda");
			}
				
			//Regularizacin si tenemos alguna causa
			bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_REGULARIZACION);
			if(bool){
				escribirCausas();
				valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_PERCIBIDO);
				// aunque sea 0 hay que ponerlo
				writer.writeStartElement("RetribSatisfechas");
				writer.writeCharacters(valor1.toString());
				//RetribSatisfechas
				writer.writeEndElement();
				
				valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_RETENIDO);
				if(valor1.compareTo(BigDecimal.ZERO)!=0){
					writer.writeStartElement("RetencionPracticada");
					writer.writeCharacters(valor1.toString());
					//RetencionPracticada
					writer.writeEndElement();
				}
				valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_RETRIBA);
				if(valor1.compareTo(BigDecimal.ZERO)!=0){
					writer.writeStartElement("RetribAnualesIniciales");
					writer.writeCharacters(valor1.toString());
					//RetribAnualesIniciales
					writer.writeEndElement();
				}
				valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_IMPORTEA);
				if(valor1.compareTo(BigDecimal.ZERO)!=0){
					writer.writeStartElement("RetencionAnualInicial");
					writer.writeCharacters(valor1.toString());
					//RetencionAnualInicial
					writer.writeEndElement();
				}
				valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_BASEA);
				if(valor1.compareTo(BigDecimal.ZERO)!=0){
					writer.writeStartElement("BaseRetencion");
					writer.writeCharacters(valor1.toString());
					//BaseRetencion
					writer.writeEndElement();
				}
				valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_TIPOA);
				// aunque sea 0 hay que ponerlo
				writer.writeStartElement("TipoRetencion");
				writer.writeCharacters(valor1.toString());
				//TipoRetencion
				writer.writeEndElement();
				
				bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_RENCEMEA);
				if(bool){
					writer.writeEmptyElement("ResidenciaInicialCeutaMelilla");
				}
					
				valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_MINPERFAA);
				if(valor1.compareTo(BigDecimal.ZERO)!=0){
					writer.writeStartElement("MinimoPersonalFamiliarInicial");
					writer.writeCharacters(valor1.toString());
					//MinimoPersonalFamiliarInicial
					writer.writeEndElement();
				}

				bool = (Boolean) modelo.getValor(PerceptorBeanTipos.P_MINORADO);
				if(bool){
					valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_MINOPAGOA);
					// aunque sea 0 hay que ponerlo
					writer.writeStartElement("MinoracionPrestamosVivienda");
					writer.writeCharacters(valor1.toString());
					//MinoracionPrestamosVivienda
					writer.writeEndElement();
				}
				//Regularizacion
				writer.writeEndElement();
			}
			
			// 2015 GASTOS
			writer.writeStartElement("Gastos");
			writer.writeStartElement("OtrosGastos");
			writer.writeStartElement(GENERAL);
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_GASTOSGEN);
			writer.writeCharacters(valor1.toString());
			//General
			writer.writeEndElement();
			// incremento por movilidad geografica
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_INCREGASMOVIL);
			if(valor1.compareTo(BigDecimal.ZERO)>0){
				writer.writeStartElement("MovilidadGeografica");
				writer.writeCharacters(valor1.toString());
				//MovilidadGeografica
				writer.writeEndElement();
			}
			// incremento para trabajadores activos con discapacidad
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_INCREGASDISTRA);
			if(valor1.compareTo(BigDecimal.ZERO)>0){
				writer.writeStartElement("DiscapacidadTrabajadoresActivos");
				writer.writeCharacters(valor1.toString());
				//DiscapacidadTrabajadoresActivos
				writer.writeEndElement();
			}
			// OTROSGASTOS (TOTAL)
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_OTROSGASTOS);
			writer.writeStartElement(TOTAL);
			writer.writeCharacters(valor1.toString());
			//Total
			writer.writeEndElement();
			
			//OtrosGastos
			writer.writeEndElement();
					
			// TOTAL
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_GASTOS);
			writer.writeStartElement(TOTAL);
			writer.writeCharacters(valor1.toString());
			//Total
			writer.writeEndElement();					
			//Gastos
			writer.writeEndElement();
			
			//RdtoNeto
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_RNT);
			if(valor1.compareTo(BigDecimal.ZERO)!=0){
				writer.writeStartElement("RdtoNeto");
				writer.writeCharacters(valor1.toString());
				//RdtoNeto
				writer.writeEndElement();
			}
			//RdtoNetoReducido
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_RNTREDU);
			if(valor1.compareTo(BigDecimal.ZERO)!=0){
				writer.writeStartElement("RdtoNetoReducido");
				writer.writeCharacters(valor1.toString());
				//RdtoNetoReducido
				writer.writeEndElement();
			}
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_MINOPAGO);
			if(valor1.compareTo(BigDecimal.ZERO)!=0){
				writer.writeStartElement("MinoracionPrestamo");
				writer.writeCharacters(valor1.toString());
				//MinoracionPrestamo
				writer.writeEndElement();
			}
				
			// MINIMO PERSONAL FAMILIAR
			writer.writeStartElement("MinimoPersonalFamiliar");
			// MINIMO CONTRIBUYENTE
			writer.writeStartElement("MinimoCtye");
			writer.writeStartElement(GENERAL);
			writer.writeCharacters(((BigDecimal)modelo.getValor(PerceptorBeanTipos.P_MINPER)).toString());
			//General
			writer.writeEndElement();
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_PER65);
			if(valor1.compareTo(BigDecimal.ZERO)!=0){
				writer.writeStartElement("Edad");
				writer.writeCharacters(valor1.toString());
				//Edad
				writer.writeEndElement();
			}
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_PER75);
			if(valor1.compareTo(BigDecimal.ZERO)!=0){
				writer.writeStartElement(ASISTENCIA);
				writer.writeCharacters(valor1.toString());
				//Asistencia
				writer.writeEndElement();
			}
			writer.writeStartElement(TOTAL);
			writer.writeCharacters(((BigDecimal)modelo.getValor(PerceptorBeanTipos.P_MINCON)).toString());
			//Total
			writer.writeEndElement();
			
			//MinimoCtye
			writer.writeEndElement();
			
			//MINIMO DESCENDIENTES
			Integer num = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMDES);
			if(num > 0){
				writer.writeStartElement("MinimoDescendientes");
				valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_MINDESG);
				// aunque sea 0 hay que ponerlo
				writer.writeStartElement(GENERAL);
				writer.writeCharacters(valor1.toString());
				//General
				writer.writeEndElement();
				
				valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_MINDES3);
				if(valor1.compareTo(BigDecimal.ZERO)!=0){
					writer.writeStartElement("CuidadoHijos");
					writer.writeCharacters(valor1.toString());
					//CuidadoHijos
					writer.writeEndElement();
				}
				valor2 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_MINDES);
				writer.writeStartElement(TOTAL);
				writer.writeCharacters(valor2.toString());
				//Total
				writer.writeEndElement();
				//MinimoDescendientes
				writer.writeEndElement();
			}
				
			//MINIMO ASCENDIENTES
			num = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMAS);
			if(num > 0){
				writer.writeStartElement("MinimoAscendientes");
				valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_AS65);
				// aunque sea 0 hay que ponerlo
				writer.writeStartElement("Edad");
				writer.writeCharacters(valor1.toString());
				//Edad
				writer.writeEndElement();
				
				valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_AS75);
				if(valor1.compareTo(BigDecimal.ZERO)!=0){
					writer.writeStartElement(ASISTENCIA);
					writer.writeCharacters(valor1.toString());
					//Asistencia
					writer.writeEndElement();
				}
				valor2 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_MINAS);
				writer.writeStartElement(TOTAL);
				writer.writeCharacters(valor2.toString());
				//Total
				writer.writeEndElement();
				//MinimoAscendientes
				writer.writeEndElement();
			}
				
			//MINIMO DISCAPACIDAD
			valor2 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_MINDIS);
			if(valor2.compareTo(BigDecimal.ZERO)!=0){
				writer.writeStartElement("MinimoDiscapacidad");
				// DISCAPACIDAD CONTRIBUYENTE
				valor3 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_MINDISC);
				if(valor3.compareTo(BigDecimal.ZERO)!=0){
					writer.writeStartElement("DiscapacidadCtye");
					valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_DISPER);
					// aunque sea 0 hay que ponerlo
					writer.writeStartElement(DISCAPACIDAD);
					writer.writeCharacters(valor1.toString());
					//Discapacidad
					writer.writeEndElement();
					
					valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_ASISPER);
					if(valor1.compareTo(BigDecimal.ZERO)!=0){
						writer.writeStartElement(ASISTENCIA);
						writer.writeCharacters(valor1.toString());
						//Asistencia
						writer.writeEndElement();
					}
					writer.writeStartElement(TOTAL);
					writer.writeCharacters(valor3.toString());
					//Total
					writer.writeEndElement();
					
					//DiscapacidadCtye
					writer.writeEndElement();
				}
					
				// DISCAPACIDAD DESC Y ASC
				valor3 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_MDISDEAS);
				if(valor3.compareTo(BigDecimal.ZERO)!=0){
					writer.writeStartElement("DiscapacidadDescAsc");
					valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_DISDES);
					if(valor1.compareTo(BigDecimal.ZERO)!=0){
						writer.writeStartElement("DiscapacidadDesc");
						writer.writeCharacters(valor1.toString());
						//DiscapacidadDesc
						writer.writeEndElement();
					}
					valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_ASISDES);
					if(valor1.compareTo(BigDecimal.ZERO)!=0){
						writer.writeStartElement("AsistenciaDesc");
						writer.writeCharacters(valor1.toString());
						//AsistenciaDesc
						writer.writeEndElement();
					}
					valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_DISAS);
					if(valor1.compareTo(BigDecimal.ZERO)!=0){
						writer.writeStartElement("DiscapacidadAsc");
						writer.writeCharacters(valor1.toString());
						//DiscapacidadAsc
						writer.writeEndElement();
					}
					valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_ASISAS);
					if(valor1.compareTo(BigDecimal.ZERO)!=0){
						writer.writeStartElement("AsistenciaAsc");
						writer.writeCharacters(valor1.toString());
						//AsistenciaAsc
						writer.writeEndElement();
					}
					writer.writeStartElement(TOTAL);
					writer.writeCharacters(valor3.toString());
					//Total
					writer.writeEndElement();
					
					//DiscapacidadDescAsc
					writer.writeEndElement();
				}
				writer.writeStartElement(TOTAL);
				writer.writeCharacters(valor2.toString());
				//Total
				writer.writeEndElement();
				
				//MinimoDiscapacidad
				writer.writeEndElement();
			}
			writer.writeStartElement(TOTAL);
			// TOTAL DEL MINIMO PERSONAL FAMILIAR
			writer.writeCharacters(((BigDecimal)modelo.getValor(PerceptorBeanTipos.P_MINPERFA)).toString()); 
			//Total
			writer.writeEndElement();
			//MinimoPersonalFamiliar
			writer.writeEndElement();

			writer.writeStartElement("Reduccion");
			// para el total final 
//			valor1 = BigDecimal.ZERO
			// RENDIMIENTOS TRABAJO
			//RdtosTrabajo
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_RED20);
			
			// aunque sea 0 hay que ponerlo
			writer.writeStartElement("RdtosTrabajo");
			// QUITAMOS GENERAL Y DEJAMOS RDTOS TRABAJO 2016
			//writer.writeStartElement("General")
			writer.writeCharacters(valor1.toString());
			//writer.writeEndElement();//General

//2016
/*			valor3 = (BigDecimal)modelo.getValor("MOVILGEO")
			if(valor3.compareTo(BigDecimal.ZERO)!=0){
				valor1=valor1.add(valor3);
				writer.writeStartElement("MovilidadGeografica");
				writer.writeCharacters(valor3.toString());
				writer.writeEndElement();//MovilidadGeografica
			}
*/
			// N 2015 se quita DISTRA
//			valor3 = (BigDecimal)modelo.getDato("DISTRA")

			//RdtosTrabajo
			writer.writeEndElement();
			
			//ReduccionMas2
			valor2 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_HIJOS);
			if(valor2.compareTo(BigDecimal.ZERO)!=0){
				valor1=valor1.add(valor2);
				writer.writeStartElement("ReduccionMas2");
				writer.writeCharacters(valor2.toString());
				writer.writeEndElement();//ReduccionMas2
			}
			
			// PENSIONISTA 
			valor2 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_PENSION);
			if(valor2.compareTo(BigDecimal.ZERO)!=0){
				valor1=valor1.add(valor2);
				writer.writeStartElement("Pensionista");
				writer.writeCharacters(valor2.toString());
				//Pensionista
				writer.writeEndElement();
			}
			// DESEMPLEADO 
			valor2 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_DESEM);
			if(valor2.compareTo(BigDecimal.ZERO)!=0){
//??				valor1=valor1.add(valor2)
				writer.writeStartElement("Desempleado");
				writer.writeCharacters(valor2.toString());
				//Desempleado
				writer.writeEndElement();
			}
			
			//Reduccion
			writer.writeEndElement();
			
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_BASE);
			writer.writeStartElement("BaseRetencion");
			writer.writeCharacters(valor1.toString());
			//BaseRetencion
			writer.writeEndElement();
			
			valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_IMPORTE);
			writer.writeStartElement("ImpAnualRetencionesIngresosCuenta");
			writer.writeCharacters(valor1.toString());
			writer.writeEndElement();//ImpAnualRetencionesIngresosCuenta
				
			// si tenemos regularizacion tenemos que coger TIPOREG sino TIPO
			bool = (Boolean) modelo.getValor(PerceptorBeanTipos.P_REGULARIZACION);
			if(bool){
				valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_TIPOREG);
			} else{
				valor1 = (BigDecimal)modelo.getValor(PerceptorBeanTipos.P_TIPO);
			}
			
			writer.writeStartElement("TipoRetencion");
			writer.writeCharacters(valor1.toString());
			//TipoRetencion
			writer.writeEndElement();
		
			// COMPUTO DESCENDIENTES
			escribirComputoDescendientes(modelo.getDescendientes().size());
			escribirComputoAscendientes(modelo.getAscendientes().size());

			valor1=null;
			valor2=null;
			valor3=null;
			bool=null;
			integ=null;
			num=null;
				
			//Retenido
			writer.writeEndElement();
			
			writer.flush();
		
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		} 
	}
	
	private void escribirComputoDescendientes(int num){
		try{				
			Integer entero = 0;
				
			if(num!=0){
				writer.writeStartElement("Descendientes");
				writer.writeStartElement("ComputoDescendientes");
				if(!"".equals(modelo.getValor(PerceptorBeanTipos.P_COMHIJO1))){
					writer.writeStartElement("Hijo1");
					writer.writeCharacters((String)modelo.getValor(PerceptorBeanTipos.P_COMHIJO1));
					//Hijo1
					writer.writeEndElement();
				}
				if(!"".equals(modelo.getValor(PerceptorBeanTipos.P_COMHIJO2))){
					writer.writeStartElement("Hijo2");
					writer.writeCharacters((String)modelo.getValor(PerceptorBeanTipos.P_COMHIJO2));
					//Hijo2
					writer.writeEndElement();
				}
				if(!"".equals(modelo.getValor(PerceptorBeanTipos.P_COMHIJO3))){
					writer.writeStartElement("Hijo3");
					writer.writeCharacters((String)modelo.getValor(PerceptorBeanTipos.P_COMHIJO3));
					//Hijo3
					writer.writeEndElement();
				}
				Integer cuatro = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMDESMAS3);
				if(cuatro>0){
					writer.writeStartElement("CuartoySucesivos");
					writer.writeStartElement(TOTAL);
					writer.writeCharacters(cuatro.toString());
					//Total
					writer.writeEndElement();
					entero = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMDESMAS3EN);
					if(entero>0){
						writer.writeStartElement(POR_ENTERO);
						writer.writeCharacters(entero.toString());
						writer.writeEndElement();//Entero
					}
					writer.writeEndElement();//CuartoySucesivos
				}
				cuatro=null;
				writer.writeEndElement();//ComputoDescendientes
					
				// MENORES 3 AOS
				Integer menores = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMDES3);
				if(menores>0){
					writer.writeStartElement("Menores3Aos");
					writer.writeStartElement(TOTAL);
					writer.writeCharacters(menores.toString());
					writer.writeEndElement();//Total
					entero = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMDES3EN);
					if(entero>0){
						writer.writeStartElement(POR_ENTERO);
						writer.writeCharacters(entero.toString());
						//Entero
						writer.writeEndElement();
					}
					//Menores3Aos
					writer.writeEndElement();
				}
				menores=null;
				//RESTO
				Integer resto = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMDES325);
				if(resto>0){
					writer.writeStartElement("Resto");
					writer.writeStartElement(TOTAL);
					writer.writeCharacters(resto.toString());
					//Total
					writer.writeEndElement();
					entero = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMDES325EN);
					if(entero>0){
						writer.writeStartElement(POR_ENTERO);
						writer.writeCharacters(entero.toString());
						//PorEntero
						writer.writeEndElement();
					}
					//Resto
					writer.writeEndElement();
				}
				resto=null;
				//ConDiscapacidad
				Integer disc3365 = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMDES3365);
				Integer disc65 = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMDES65);
				Integer movRed = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMDESMOV);
				if(disc3365+disc65+movRed>0){
					writer.writeStartElement("ConDiscapacidad");
					//GRADO1
					if(disc3365>0){
						writer.writeStartElement("EnGrado1");
						writer.writeStartElement(TOTAL);
						writer.writeCharacters(disc3365.toString());
						//Total
						writer.writeEndElement();
						entero = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMDES3365EN);
						if(entero>0){
							writer.writeStartElement(POR_ENTERO);
							writer.writeCharacters(entero.toString());
							//PorEntero
							writer.writeEndElement();
						}
						if(movRed>0){
							writer.writeStartElement("ConMovilidadReducida");
							writer.writeStartElement(TOTAL);
							writer.writeCharacters(movRed.toString());
							//Total
							writer.writeEndElement();
							entero = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMDESMOVEN);
							if(entero>0){
								writer.writeStartElement(POR_ENTERO);
								writer.writeCharacters(entero.toString());
								//PorEntero
								writer.writeEndElement();
							}
							//ConMovilidadReducida
							writer.writeEndElement();
						}
						//EnGrado1
						writer.writeEndElement();
					}
					//GRADO2
					if(disc65>0){
						writer.writeStartElement("EnGrado2");
						writer.writeStartElement(TOTAL);
						writer.writeCharacters(disc65.toString());
						//Total
						writer.writeEndElement();
						entero = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMDES65EN);
						if(entero>0){
							writer.writeStartElement(POR_ENTERO);
							writer.writeCharacters(entero.toString());
							//PorEntero
							writer.writeEndElement();
						}
						//EnGrado2
						writer.writeEndElement();
					}
					//ConDiscapacidad
					writer.writeEndElement();
				}
				disc3365=null;
				disc65=null;
				movRed=null;
				entero=null;
				//Descendientes
				writer.writeEndElement();
			}
			entero=null;
				
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		} 
	}
	
	private void escribirComputoAscendientes(int num){
		try{				
			if(num!=0){
				Integer entero = 0;
				writer.writeStartElement("Ascendientes");
				
				// MENORES 75 AOS
				Integer menores = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMAS65A);
				if(menores>0){
					writer.writeStartElement("Menores75");
					writer.writeStartElement(TOTAL);
					writer.writeCharacters(menores.toString());
					//Total
					writer.writeEndElement();
					entero = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMAS65AEN);
					if(entero>0){
						writer.writeStartElement(POR_ENTERO);
						writer.writeCharacters(entero.toString());
						//PorEntero
						writer.writeEndElement();
					}
					//Menores3Aos
					writer.writeEndElement();
				}
				menores=null;
				// MAYORES 75 AOS
				Integer mayores = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMAS75A);
				if(mayores>0){
					writer.writeStartElement("Mayores75");
					writer.writeStartElement(TOTAL);
					writer.writeCharacters(mayores.toString());
					//Total
					writer.writeEndElement();
					entero = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMAS75AEN);
					if(entero>0){
						writer.writeStartElement(POR_ENTERO);
						writer.writeCharacters(entero.toString());
						//PorEntero
						writer.writeEndElement();
					}
					//Menores3Aos
					writer.writeEndElement();
				}
				mayores=null;
				
				//ConDiscapacidad
				Integer disc3365 = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMAS3365);
				Integer disc65 = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMAS65);
				Integer movRed = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMASMOV);
				if(disc3365+disc65+movRed>0){
					writer.writeStartElement("ConDiscapacidad");
					//GRADO1
					if(disc3365>0){
						writer.writeStartElement("EnGrado1");
						writer.writeStartElement(TOTAL);
						writer.writeCharacters(disc3365.toString());
						//Total
						writer.writeEndElement();
						entero = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMAS3365EN);
						if(entero>0){
							writer.writeStartElement(POR_ENTERO);
							writer.writeCharacters(entero.toString());
							//PorEntero
							writer.writeEndElement();
						}
						if(movRed>0){
							writer.writeStartElement("ConMovilidadReducida");
							writer.writeStartElement(TOTAL);
							writer.writeCharacters(movRed.toString());
							//Total
							writer.writeEndElement();
							entero = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMASMOVEN);
							if(entero>0){
								writer.writeStartElement(POR_ENTERO);
								writer.writeCharacters(entero.toString());
								//PorEntero
								writer.writeEndElement();
							}
							//ConMovilidadReducida
							writer.writeEndElement();
						}
						movRed=null;
						//EnGrado1
						writer.writeEndElement();
					}
					//GRADO2
					if(disc65>0){
						writer.writeStartElement("EnGrado2");
						writer.writeStartElement(TOTAL);
						writer.writeCharacters(disc65.toString());
						//Total
						writer.writeEndElement();
						entero = (Integer)modelo.getValor(PerceptorBeanTipos.P_NUMAS65EN);
						if(entero>0){
							writer.writeStartElement(POR_ENTERO);
							writer.writeCharacters(entero.toString());
							//PorEntero
							writer.writeEndElement();
						}
						//EnGrado2
						writer.writeEndElement();
					}
					//ConDiscapacidad
					writer.writeEndElement();
				}
				disc65=null;
				disc3365=null;
				movRed=null;
				entero=null;
				//Ascendientes
				writer.writeEndElement();
			}
			
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		} 
	}
	
	private void escribirCausas(){
		try{
			writer.writeStartElement("Regularizacion");
			Boolean bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_CAUSA, 1);
			if(bool){
				writer.writeStartElement(CAUSA);
				writer.writeCharacters("1");
				writer.writeEndElement();
			}
			bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_CAUSA, 2);
			if(bool){
				writer.writeStartElement(CAUSA);
				writer.writeCharacters("2");
				writer.writeEndElement();
			}
			bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_CAUSA, 3);
			if(bool){
				writer.writeStartElement(CAUSA);
				writer.writeCharacters("3");
				writer.writeEndElement();
			}
			bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_CAUSA, 4);
			if(bool){
				writer.writeStartElement(CAUSA);
				writer.writeCharacters("4");
				writer.writeEndElement();
			}
			bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_CAUSA, 5);
			if(bool){
				writer.writeStartElement(CAUSA);
				writer.writeCharacters("5");
				writer.writeEndElement();
			}
			bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_CAUSA, 6);
			if(bool){
				writer.writeStartElement(CAUSA);
				writer.writeCharacters("6");
				writer.writeEndElement();
			}
			bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_CAUSA, 7);
			if(bool){
				writer.writeStartElement(CAUSA);
				writer.writeCharacters("7");
				writer.writeEndElement();
			}
			bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_CAUSA, 8);
			if(bool){
				writer.writeStartElement(CAUSA);
				writer.writeCharacters("8");
				writer.writeEndElement();
			}
			bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_CAUSA, 9);
			if(bool){
				writer.writeStartElement(CAUSA);
				writer.writeCharacters("9");
				writer.writeEndElement();
			}
			bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_CAUSA, 10);
			if(bool){
				writer.writeStartElement(CAUSA);
				writer.writeCharacters("10");
				writer.writeEndElement();
			}
			bool = (Boolean)modelo.getValor(PerceptorBeanTipos.P_CAUSA, 11);
			if(bool){
				writer.writeStartElement(CAUSA);
				writer.writeCharacters("11");
				writer.writeEndElement();
			}
			bool=null;
			
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		} 
	}
	
	private void escribirDescendientes(List<? extends DescendienteBean> lista){
		try{			
			int num = lista.size();
			
			for(int i=0;i<num;i++){
				DescendienteBean des = lista.get(i);
				writer.writeStartElement("Descendiente");
				writer.writeStartElement(ANIO_NACIMIENTO);
				writer.writeCharacters(des.getAnioNacimiento().toString());
				//AoNacimientoDesc
				writer.writeEndElement();
				
				// adopcion 
				if(des.getAnioAdopcion()!=0){
					writer.writeStartElement("AoAdopcion");
					writer.writeCharacters(des.getAnioAdopcion().toString());
					//AoAdopcion
					writer.writeEndElement();
				}
				// entero 
				if(des.isPorEntero()){
						//lista.get(i)[2].equals("1"))
					writer.writeEmptyElement("ComputadoEntero");
				}
				// discapacidad 
				if(des.getDiscapacidad()==1){
						//lista.get(i)[3].equals("1"))
					writer.writeStartElement(DISCAPACIDAD);
					
					// movRed 
					if(des.isMovilidadReducida()){
							//lista.get(i)[4].equals("1"))
						writer.writeStartElement(GRADO1);
						writer.writeEmptyElement(MOVILIDAD_REDUCIDA);
						//Grado1
						writer.writeEndElement();
					} else {
						writer.writeEmptyElement(GRADO1);
					}
					
					//Discapacidad
					writer.writeEndElement();
				} else if(des.getDiscapacidad()==2){
						//lista.get(i)[3].equals("2"))
					writer.writeStartElement(DISCAPACIDAD);
					writer.writeEmptyElement(GRADO2);
					//Discapacidad
					writer.writeEndElement();
				}
				
				//Descendiente
				writer.writeEndElement();
			}
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		} 
	}
	
	private void escribirAscendientes(List<AscendienteBean> lista){
		try{
			int num = lista.size();
			
			for(int i=0;i<num;i++){
				AscendienteBean asc = (AscendienteBean)lista.get(i);
				writer.writeStartElement("Ascendiente");
				writer.writeStartElement(ANIO_NACIMIENTO);
				writer.writeCharacters(asc.getAnioNacimiento().toString());
				//AoNacimiento
				writer.writeEndElement();
				writer.writeStartElement("Convivencia");
				writer.writeCharacters(asc.getConvivencia().toString());
				//Convivencia
				writer.writeEndElement();
				
				//discapacidad
				if(asc.getDiscapacidad()==1){
					writer.writeStartElement(DISCAPACIDAD);
					
					if(asc.isMovilidadReducida()){
						writer.writeStartElement(GRADO1);
						writer.writeEmptyElement(MOVILIDAD_REDUCIDA);
						//Grado1
						writer.writeEndElement();
					} else {
						writer.writeEmptyElement(GRADO1);
					}
					
					//Discapacidad
					writer.writeEndElement();
				} else if(asc.getDiscapacidad()==2){
					writer.writeStartElement(DISCAPACIDAD);
					writer.writeEmptyElement(GRADO2);
					//Discapacidad
					writer.writeEndElement();
				}
				
				//Ascendiente
				writer.writeEndElement();
			}
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		} 
	}
	
	private Logger getLog() {
		return Logger.getLogger(PerceptorBeanImpl.class.getName());
	}
}
