package es.aeat.pret.c200.c230.imp.srv;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.XMLConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import es.aeat.pret.c200.api.bean.ErrorValidacionBean;
import es.aeat.pret.c200.api.bean.PerceptorBean;
import es.aeat.pret.c200.api.bean.PerceptorBeanTipos;
import es.aeat.pret.c200.c230.api.srv.CalculoRetencionesSrv;
import es.aeat.pret.c200.c230.api.srv.ValidarLeerFicheroSrv;
import es.aeat.pret.c200.c230.util.EscribirFicheroError;
import es.aeat.pret.c200.c230.util.EscribirFicheroSalida;
import es.aeat.pret.c200.c230.util.LeeRetenedor;
import es.aeat.pret.c200.c230.util.LeeRetenido;
import es.aeat.pret.c200.imp.bean.PerceptorBeanImpl;
import es.aeat.pret.c200.util.Sello;


public class ValidarLeerFicheroSrvImpl implements ValidarLeerFicheroSrv{

	private static final long serialVersionUID = 1L;
	public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

	private Logger getLog() {
		return Logger.getLogger(PerceptorBeanImpl.class.getName());
	}
	
	private void crearValidadorXML(String salida, String errores, PerceptorBean per, Validator validator) {
		try {
			per.setFicheroSalida(File.createTempFile("r230",salida));
			per.setFicheroError(File.createTempFile("r230",errores));
//			log.warn("CREAMOS FICHEROS "+ficheroSalida.getAbsolutePath()+" "+ficheroError.getAbsolutePath())
		} catch (IOException e) {
			getLog().severe(e.getMessage());
		}
		
		if (per.getFicheroSalida().exists()) {
			per.getFicheroSalida().delete();
		}
		if (per.getFicheroError().exists()) {
			per.getFicheroError().delete();
		}
		
		validator.setErrorHandler(new ErrorHandler(){
			@Override
			public void fatalError(SAXParseException arg0) throws SAXException {
//				System.out.println("TENEMOS FATAL ERROR "+arg0.getMessage())
				if(per.isComprobandoSalida() && arg0.getMessage().startsWith("cvc-elt.1")){
				//	System.out.println("TENEMOS ERROR DE QUE NO ES SALIDA, NO LO GUARDAMOS")
					per.setErrorImportacion(true);
				} else {
					crearStaxError(per);
					
					per.getStaxE().escribirErrorGeneral(arg0);
					per.setErrorImportacion(true);
					int erroresNuevos=per.getErroresImportacion()+1;
					per.setErroresImportacion(erroresNuevos);
					// cerramos posible stax 
					terminaFicheroStax(per);
				}
			}

			@Override
			public void error(SAXParseException arg0)
			throws SAXException {
//				System.out.println("TENEMOS ERROR "+arg0.getMessage())
				if(per.isComprobandoSalida() && arg0.getMessage().startsWith("cvc-elt.1")){
				//	System.out.println("TENEMOS ERROR DE QUE NO ES SALIDA, NO LO GUARDAMOS")
					per.setErrorImportacion(true);
				} else {
					crearStaxError(per);
					
					per.getStaxE().escribirErrorGeneral(arg0);
					per.setErrorImportacion(true);
					int erroresNuevos = per.getErroresImportacion()+1;
					per.setErroresImportacion(erroresNuevos);
					// cerramos posible stax 
					terminaFicheroStax(per);
				}
			}

			@Override
			public void warning(SAXParseException arg0) throws SAXException {
				// no hace nada
			}
		}); 
	}
	
	private void crearStaxError(PerceptorBean per){
		if(per.getStaxE()==null){
			per.setStaxE(new EscribirFicheroError());
			per.getStaxE().startDocument(per.getFicheroError());
		}
	}
	
	public void terminaFicheroStax(PerceptorBean per){
		if(per.getStax()!=null && !per.getStax().isTerminado()){
			per.getStax().endDocument();
			per.setStax(null);
		}
	}
	
	public void terminaFicheroStaxError(PerceptorBean per){
		if(per.getStaxE()!=null && !per.getStaxE().isTerminado()){
			per.getStaxE().endDocument();
			per.setStaxE(null);
		}
	}

	public boolean validaXmlSalidaStax(String ficheroXMLEntrada, PerceptorBean per) throws SAXException{
		SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);
		// Prevenir ataques XXE
		sf.setProperty(XMLConstants.ACCESS_EXTERNAL_SCHEMA, ""); 
		sf.setProperty(XMLConstants.ACCESS_EXTERNAL_DTD, "");
		sf.setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true);
		sf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
		URL resource = getClass().getClassLoader().getResource("es/aeat/pret/c200/xml/xsd/AEATRetenciones2023S.xsd");
		Schema schema = sf.newSchema(resource);
		
		// por si venimos de un intento de lectura de fichero de salida con error de esquema
		per.setErrorImportacion(false);
		per.setErroresImportacion(0);

		per.setNombreFicheroEntrada(ficheroXMLEntrada);
//		log.warn("CREAMOS FICHERO ENTRADA "+ficheroEntrada.getAbsolutePath())
		
		Validator validator = schema.newValidator();
		crearValidadorXML("SRET2023.xml", "ERR2023.xml", per, validator);

		return xmlCorrectoSalidaStax(per, validator);
	}
	
	public boolean validaXmlEntradaStax(String ficheroXMLEntrada, PerceptorBean per) throws SAXException{
		SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);				
		// Prevenir ataques XXE
		sf.setProperty(XMLConstants.ACCESS_EXTERNAL_SCHEMA, ""); 
		sf.setProperty(XMLConstants.ACCESS_EXTERNAL_DTD, "");
		sf.setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true);
		sf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
		URL resource = getClass().getClassLoader().getResource("es/aeat/pret/c200/xml/xsd/AEATRetenciones2023E.xsd");
		Schema schema = sf.newSchema(resource);				
		
		//Ya tendriamos el fichero de entrada guardado, pero se lo dejamos como argumento
		per.setNombreFicheroEntrada(ficheroXMLEntrada);
//		log.warn("CREAMOS FICHERO ENTRADA "+ficheroEntrada.getAbsolutePath())
		
		// si tenemos erroresImportacion es que hubo errores de esquema comprobando que era salida, 
		// el fichero no ser correcto
		if(per.getErroresImportacion()>0){
//			System.out.println("SALIMOS POR ERRORES DE ESQUEMA")
			terminaFicheroStaxError(per);
			return false;
		}
		per.setComprobandoSalida(false);
		per.setErrorImportacion(false);
		per.setErroresImportacion(0);
		
		Validator validator = schema.newValidator();
		crearValidadorXML("SRET2023.xml", "ERR2023.xml", per, validator);

		return xmlCorrectoEntradaStax(false, per, validator);
	}

	public void validaXmlEntradaParaCalculos(String ficheroXMLEntrada, PerceptorBean per){
		try {
			SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);				
			// Prevenir ataques XXE
			sf.setProperty(XMLConstants.ACCESS_EXTERNAL_SCHEMA, ""); 
			sf.setProperty(XMLConstants.ACCESS_EXTERNAL_DTD, "");
			sf.setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true);
			sf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
			URL resource = getClass().getClassLoader().getResource("es/aeat/pret/c200/xml/xsd/AEATRetenciones2023E.xsd");
			Schema schema = sf.newSchema(resource);
		
			per.setNumRetenidos(0);
			per.setNuneroRetenedorese(0);
			
			// guardamos el nombre del fichero
			per.setNombreFicheroEntrada(ficheroXMLEntrada);
	
			StringBuilder fileNameSalida = new StringBuilder("SRET2023-");
			StringBuilder fileNameErr = new StringBuilder("ERR2023-");
			SimpleDateFormat formatFileName = new SimpleDateFormat("yyyyMMdd-HHmmss");
			String date = formatFileName.format(new Date());
			fileNameSalida.append(date);
			fileNameErr.append(date);
			fileNameSalida.append(".xml");
			fileNameErr.append(".xml");
		
			Validator validator = schema.newValidator();
			crearValidadorXML(fileNameSalida.toString(), fileNameErr.toString(), per, validator);

			fileNameSalida=null;
			fileNameErr=null;
			
			if(xmlCorrectoEntradaStax(true, per, validator)){
				FileInputStream fisReto = null;
				FileInputStream fisReti = null;
				try {
					fisReto = new FileInputStream(new File(per.getNombreFicheroEntrada()));
					// solo leemos! antes modelo=null
					prepararReaderRetenedor(fisReto, per, false, false, true);
					int numR = leeRetenedor(0, per).size();
					per.setNuneroRetenedorese(numR);

					int miCuantosRetenidos[] = new int[numR];
					fisReto.close();
					fisReto=null;
					cerrarReaderRetenedor(per);

					// recogemos el numero de retenidos de cada retenedor para no hacerlo en calcularXML
					fisReti = new FileInputStream(new File(per.getNombreFicheroEntrada()));
					// solo leemos modelo=null
					prepararReaderRetenido(fisReti, per, false, false, true);
					int totalRetenidos = 0;
					int numReti = 0;
					for (int i = 0; i < numR; i++) {
						numReti = leeRetenido(i,0, per).size();
						totalRetenidos+=numReti;
						miCuantosRetenidos[i]=numReti;
					}
					per.setCuantosRetenidos(miCuantosRetenidos);
					per.setNumRetenidos(totalRetenidos);
					fisReti.close();
					fisReti=null;
					cerrarReaderRetenido(per);

				} catch (FileNotFoundException e) {
					getLog().severe(e.getMessage());
				} 
			}
			
			if(per.isTenemosError()){
				per.setNumRetenidos(0);
				per.setNuneroRetenedorese(0);
			}
			
		}catch (Exception e) {
			getLog().severe(e.getMessage());
		}
	}
	
	public void cerrarReaderRetenedor(PerceptorBean per){
		if(per.getStaxReto()!=null){
			per.getStaxReto().cerrarReader();
			per.setStaxReto(null);
		}
	}
	
	public void cerrarReaderRetenido(PerceptorBean per){
		if(per.getStaxReti()!=null){
			per.getStaxReti().cerrarReader();
			per.setStaxReti(null);
		}
	}
	
	public List<String> leeRetenido(int indiceRetenedor, int indiceRetenido, PerceptorBean per) {
		try {
			per.getStaxReti().readXml(indiceRetenedor, indiceRetenido);
			
			// si tenemos que leer todos, devolvemos el numero de retenidos leidos, sirve para calculo xml
			if(per.getStaxReti().getLista()!=null){
				return per.getStaxReti().getLista();
			} else {
				return null;
			}
		} catch (XMLStreamException e) {
			// en principio no deberiamos entrar aqui
			crearStaxError(per);
			
			per.getStaxE().escribirErrorImportacion(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e.getMessage());
			per.setTenemosError(true);
			return null;
		}
	}
	
	public List<String> leeRetenedor(int indiceRetenedor, PerceptorBean per) {
		try {
			per.getStaxReto().readXml(indiceRetenedor);
			
			// si tenemos que leer todos, devolvemos el numero de retenedores leidos, sirve para calculo xml
			if(per.getStaxReto().getLista()!=null){
				return per.getStaxReto().getLista();
			} else {
				return null;
			}
		} catch (XMLStreamException e) {
			// en principio no deberiamos entrar aqui
			crearStaxError(per);
			
			per.getStaxE().escribirErrorImportacion(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e.getMessage());
			per.setTenemosError(true);
			return null;
		}
	}
	
	public void prepararReaderRetenido(FileInputStream fisReti, PerceptorBean per, boolean importarXML, boolean buscarRetenido, boolean soloLeer){
		try {
			if(per.getStaxReti()==null){
				per.setStaxReti(new LeeRetenido());
			}
			per.getStaxReti().crearXMLReader(fisReti, per, importarXML, buscarRetenido, soloLeer);
			per.getStaxReti().preparamosLectura();
		} catch (XMLStreamException e) {
			// en principio no deberiamos entrar aqui
			crearStaxError(per);
			
			per.getStaxE().escribirErrorImportacion(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e.getMessage());
			per.setTenemosError(true);
		} 
	}
	
	public void prepararReaderRetenedor(FileInputStream fisReto, PerceptorBean per, boolean importarXML, boolean buscarRetenedor, boolean soloLeer){
		try {
			if(per.getStaxReto()==null){
				per.setStaxReto(new LeeRetenedor());
			}
			per.getStaxReto().crearXMLReader(fisReto, per, importarXML, buscarRetenedor, soloLeer);
			per.getStaxReto().preparamosLectura();
		} catch (XMLStreamException e) {
			// en principio no deberiamos entrar aqui
			crearStaxError(per);
			
			per.getStaxE().escribirErrorImportacion(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e.getMessage());
			per.setTenemosError(true);
		}
	}

	public boolean xmlCorrectoEntradaStax(boolean calculo, PerceptorBean per, Validator validator){
//		log.warn("COMPROBAMOS ENTRADA")
		InputStream ruta = null;
		try {
			if (per.getNombreFicheroEntrada().endsWith(".tmp")) {
				ruta = new FileInputStream(new File(per.getNombreFicheroEntrada()));
			} else {
				ruta = new ByteArrayInputStream(per.getNombreFicheroEntrada().getBytes());
			}
			
			//validaXML((FileInputStream)ruta, per)
			try {
				validator.validate(new SAXSource(new InputSource((FileInputStream)ruta)));
			} catch (SAXException e) {
				getLog().severe("ERROR DE ESQUEMA "+e.getMessage());
			}
			
			if(per.isErrorImportacion()){
//				log.warn("DESPUES DE VALIDAR TENEMOS ERROR IMPORTACION")
				ruta.close();
				
				terminaFicheroStaxError(per);
				ruta=null;
//				log.warn("NO ES UNA ENTRADA")
				return false;
			}
			ruta.close();
			ruta=null;
			
		} catch (FileNotFoundException e) {
			getLog().severe("No esiste fichero entrada:" + e.getMessage());
			per.setTenemosError(true);
			try {
				if(ruta!=null){
					ruta.close();
				}
			} catch (IOException e1) {
				getLog().severe(e1.getMessage());
			}
			ruta=null;
			return false;
		} catch (IOException e) {
			getLog().severe("IO EXCEPTION 2");
			getLog().severe(e.getMessage());
			per.setTenemosError(true);
			try {
				ruta.close();
			} catch (IOException e1) {
				getLog().severe(e1.getMessage());
			}
			ruta=null;
			return false;
		} 
		
//		log.warn("ES UNA ENTRADA")
		terminaFicheroStaxError(per);
		return true;
	}

	public boolean xmlCorrectoSalidaStax(PerceptorBean per, Validator validator){
//		log.warn("COMPROBAMOS SALIDA")
		per.setComprobandoSalida(true);
		InputStream ruta = null;
		try {
			if (per.getNombreFicheroEntrada().endsWith(".tmp")) {
				ruta = new FileInputStream(new File(per.getNombreFicheroEntrada()));
			} else {
				ruta = new ByteArrayInputStream(per.getNombreFicheroEntrada().getBytes());
			}

			//validaXML((FileInputStream)ruta, per)
			try {
				validator.validate(new SAXSource(new InputSource((FileInputStream)ruta)));
			} catch (SAXException e) {
				getLog().severe("ERROR VALIDATOR " + e.getMessage());
			}

			per.setComprobandoSalida(false);
			
			if(per.isErrorImportacion()){
				ruta.close();
				ruta=null;
//				log.warn("NO ES SALIDA")
				return false;
			}
			ruta.close();
			ruta=null;
		} catch (FileNotFoundException e) {
			getLog().severe("No esiste fichero entrada: " + e.getMessage());
			per.setComprobandoSalida(false);
			per.setTenemosError(true);
			try {
				if(ruta!=null){
					ruta.close();
				}
			} catch (IOException e1) {
				getLog().severe(e1.getMessage());
			}
			ruta=null;
			return false;
		} catch (IOException e) {
			getLog().severe("IO EXCEPTION 4");
			getLog().severe(e.getMessage());
			per.setTenemosError(true);
			try {
				ruta.close();
			} catch (IOException e1) {
				getLog().severe(e1.getMessage());
			}
			ruta=null;
			return false;
		} 
		
		terminaFicheroStaxError(per);
//		log.warn("ES SALIDA")
		return true;
	}

	public File salidaXML(boolean errorPerceptor, PerceptorBean per) {
		if(!per.isTenemosError() && !per.isErrorImportacion() && !errorPerceptor){
			// borramos posible fichero de error
			if(per.getFicheroError()!=null && per.getFicheroError().exists()){
//				System.out.println("BORRAMOS "+ficheroError.getAbsolutePath()+" "+ficheroError.delete())
				per.getFicheroError().delete();
			}
			return per.getFicheroSalida();
		} else {
			// borramos posible fichero de error
			if(per.getFicheroSalida().exists()){
//				System.out.println("BORRAMOS "+ficheroSalida.getAbsolutePath()+" "+ficheroSalida.delete())
				per.getFicheroSalida().delete();
			}
			return per.getFicheroError();
		}
	}
	
	public boolean isOk(PerceptorBean per) {
		if(!per.isTenemosError() && !per.isErrorImportacion()){
			return true;
		} else {
			if(per.getStaxE()!=null){
				terminaFicheroStaxError(per);
			}
			return false;
		}
	}
	
	public void generarXML(String nifRetenedor, String nombreRetenedor, String nombreRetenido, PerceptorBean per){
		per.setValor(PerceptorBeanTipos.P_APEPER, nombreRetenido);
		per.setValor(PerceptorBeanTipos.P_NIFRET, nifRetenedor);
		per.setValor(PerceptorBeanTipos.P_APERET, nombreRetenedor);

		// creamos fichero de salida
		try {
			per.setFicheroSalida(File.createTempFile("genXMLr230","SRET2023.xml"));
		} catch (IOException e1) {
			getLog().severe(e1.getMessage());
		}
		if (per.getFicheroSalida().exists()) {
			per.getFicheroSalida().delete();
		}

		per.setStax(new EscribirFicheroSalida());
		per.getStax().startDocument(per);
		per.getStax().startRetenedor();
		per.getStax().escribirRetenido();
		per.getStax().endRetenedor();
		per.getStax().endDocument();
		
		ponerSello(per);
		per.setStax(null);
	}
	
	@Override
	public void ponerSello(PerceptorBean per){
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(per.getFicheroSalida());

			String sello = crearSello(fis);
			
			RandomAccessFile raf = new RandomAccessFile(per.getFicheroSalida(), "rw");
			int indexLine = raf.readLine().indexOf("Sello=");
			
			// salto de linea win rad +2, salto linea linux servidor +1
			indexLine +="Sello=".length(); // sin salto para movernos por lo menos una posicin 
			raf.seek(indexLine);
			
			byte[] c1 = new byte[1]; 
			String s;
			do{
				raf.read(c1,0,1);
				s = new String(c1);
			}while(!"\"".equals(s));

			raf.write(sello.getBytes());
			raf.close();
			raf=null;
			
			sello=null;
			
		} catch (Exception e1) {
			getLog().severe(e1.getMessage());
		} finally{
			if(fis!=null)
				try {
					fis.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			
		}
	}
	
	public String crearSello(InputStream bys) throws java.io.IOException {

		byte[] datos = new byte[5120];
		int leidos;
		Sello sello = new Sello();
		while ((leidos = bys.read(datos)) != -1) {
			sello.update(datos, 0, leidos);
		}
		
		datos=null;
		String cad = sello.sellar();
		cad = cad + "M";
		sello=null;
		
		return cad;
	}

	@Override
	public void empiezaDocumento(PerceptorBean per){
		// creamos fichero de salida
		per.setStax(new EscribirFicheroSalida());
		per.getStax().startDocument(per);
	}
	
	@Override
	public void terminarDocumento(PerceptorBean per){
		per.getStax().endDocument();
	}
	
	@Override
	public void empiezaRetenedor(PerceptorBean per){
		per.getStax().startRetenedor();
	}
	
	@Override
	public void terminaRetenedor(PerceptorBean per){
		per.getStax().endRetenedor();
	}
	
	@Override
	public void empiezaRetenido(PerceptorBean per){
		per.getStax().escribirRetenido();
	}

	@Override
	public void empiezaDocumentoError(PerceptorBean per) {
		// si tenemos error, borramos el fichero de salida si se cre
		if (per.getFicheroSalida().exists()) {
			if(per.getStax()!=null){
				per.getStax().endDocument();
				per.setStax(null);
			}
			per.getFicheroSalida().delete();
		}
		
		crearStaxError(per);
	}
	
	@Override
	public void crearFicheroErrorRetenidoSTAX(CalculoRetencionesSrv calculo, PerceptorBean per,
			int ordenRetenedor, int ordenRetenido){

		crearStaxError(per);		
		
		if(!per.getStaxE().isEmpezadoErrorNormal()){
			per.getStaxE().empiezaErrorNormal();
		}
		
		if(!per.getStaxE().isEmpezadoRetenedor()){
			per.getStaxE().empiezaErrorRetenedor((String)per.getValor(PerceptorBeanTipos.P_NIFRET),ordenRetenedor+1);
		}
		List<ErrorValidacionBean> lista = calculo.getErrores(per);
		per.getStaxE().errorRetenido(lista,(String)per.getValor(PerceptorBeanTipos.P_NIFPER),ordenRetenido+1);
		lista=null;
	}
	
	@Override
	public void terminarDocumentoError(PerceptorBean per) {
		if(per.getStaxE()!=null){
			per.getStaxE().endDocument();
		}
	}
	
	@Override
	public void terminaRetenedorError(PerceptorBean per){
		if(per.getStaxE()!=null){
			per.getStaxE().endErrorRetenedor();
		}
	}
	
	@Override
	public void inicializaValidador(PerceptorBean per){
		per.setStax(null);
		per.setStaxE(null);
		per.setTenemosError(false);
		per.setErrorImportacion(false);
		per.setErroresImportacion(0);
		per.setComprobandoSalida(false);
		per.setStaxReti(null);
		per.setStaxReto(null);
		
		per.setFicheroSalida(null);
		per.setFicheroError(null);
		per.setNumRetenidos(0);
		per.setNuneroRetenedorese(0);
		per.setCuantosRetenidos(null);
		per.setNombreFicheroEntrada(null);
	}

	@Override
	public int[] getListaRetenidos(PerceptorBean per) {
		return per.getCuantosRetenidos();
	}

	@Override
	public int getNumeroRetenedoresTotal(PerceptorBean per) {
		return per.getNuneroRetenedorese();
	}
	
	@Override
	public int getNumeroRetenidosTotal(PerceptorBean per) {
		return per.getNumRetenidos();
	}

}