package es.aeat.pret.c200.c242.imp.srv;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import es.aeat.adht.util.api.ADHT_UTIL_Factory;
import es.aeat.adht.util.api.utilidades.DitDataInputStreamBean;
import es.aeat.adht.util.api.utilidades.DitDataOutputStreamBean;
import es.aeat.pret.c200.api.PRET_C200_Factory;
import es.aeat.pret.c200.api.bean.AscendienteBean;
import es.aeat.pret.c200.api.bean.DescendienteBean;
import es.aeat.pret.c200.api.bean.ErrorValidacionBean.TipoErrorValidacion;
import es.aeat.pret.c200.api.bean.PerceptorBean;
import es.aeat.pret.c200.api.bean.PerceptorBeanTipos;
import es.aeat.pret.c200.c242.api.PRET_C242_Factory;
import es.aeat.pret.c200.c242.api.srv.CalculoRetencionesCICSSrv;
import es.aeat.pret.c200.c242.api.srv.CalculoRetencionesSrv;
import es.aeat.pret.c200.imp.bean.ErrorValidacionBeanImpl;


/**
 * Implementacin del servicio {@link CalculoRetencionesCICSSrv}
 * 
 */
public class CalculoRetencionesCICSSrvImpl implements CalculoRetencionesCICSSrv {


	@Override
	public DitDataOutputStreamBean procesaJDIT(DitDataInputStreamBean datos) throws Throwable {
		traza("Leyendo de la COMAREA");
		PerceptorBean perceptorBean = leerBeanDeComarea(datos);
		traza("Bean construido");
		
		if (perceptorBean.getErr().isEmpty()) {
			CalculoRetencionesSrv srv = PRET_C242_Factory.getCalculoRetencionesSrv();
			
			traza("Validando bean");
			if (srv.validar(perceptorBean, true)) {
				traza("Calculando resultado");
				srv.calcular(perceptorBean);
			} else {
				traza("Errores de validacin en clculo:\n\t" + perceptorBean.getErr());
			}
		} else {
			traza("Errores de validacin en clculo:\n\t" + perceptorBean.getErr());
		}
		return getComareaSalida(perceptorBean);
	}

	private DitDataOutputStreamBean getComareaSalida(PerceptorBean perceptorBean) {
		DitDataOutputStreamBean outputStreamBean = ADHT_UTIL_Factory.getDOSSrv().getDOS();
		
		if (perceptorBean.getErr().isEmpty()) {
			try {
				outputStreamBean.writeDouble((perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_TIPO)).doubleValue());
				outputStreamBean.writeDouble((perceptorBean.getValorAsBigDecimal(PerceptorBeanTipos.P_IMPORTE)).doubleValue());
			} catch (IOException e) {
				traza(e.getMessage());
			}
		}
		return outputStreamBean;
	}

	private PerceptorBean leerBeanDeComarea(DitDataInputStreamBean datos) throws IOException {
		byte[] b = new byte[500];
		
		datos.read(b);
		String registro = new String(b);
		final PerceptorBean perceptorBean = PRET_C200_Factory.getCalculoRetencionesSrv().createPerceptorBean();
		
		registroABean(perceptorBean, registro);
		
		return perceptorBean;
	}

	private void registroABean(PerceptorBean perceptorBean, String registro) {
		List<ErrorValidacionBeanImpl> erroresRegistro = new ArrayList<>();
		
		// NIF del perceptor
		// El 190 admite NIF de personas jurdicas en el TIPO2.
		perceptorBean.setValor(PerceptorBeanTipos.P_NIFPER, registro.substring(17, 26));
		
		// AO NACIMIENTO
		perceptorBean.setValor(PerceptorBeanTipos.P_ANIOPER, registro.substring(152, 156));
		
		// CEUTA MELILLA
		final String ceutaMelilla = registro.substring(151, 152);
		if ("1".equals(ceutaMelilla)) {
			perceptorBean.setValor(PerceptorBeanTipos.P_RESICEME, Boolean.TRUE);
			perceptorBean.setValor(PerceptorBeanTipos.P_RENCEME, Boolean.TRUE);
		}
		
		// DISCAPACIDAD
		final int discapacidad = Integer.parseInt(registro.substring(166, 167));
		switch (discapacidad) {
		case 1:
			perceptorBean.setValor(PerceptorBeanTipos.P_DISCAPER, PerceptorBeanTipos.ENTRE33Y65);
			break;
		case 2:
			perceptorBean.setValor(PerceptorBeanTipos.P_DISCAPER, PerceptorBeanTipos.ENTRE33Y65);
			perceptorBean.setValor(PerceptorBeanTipos.P_MOVILPER, Boolean.TRUE);
			break;
		case 3:
			perceptorBean.setValor(PerceptorBeanTipos.P_DISCAPER, PerceptorBeanTipos.MAS65);
			break;
		default:
			break;
		}
		
		// SITUACIN FAMILIAR
		final String situacionFamiliar = registro.substring(156, 157);
		perceptorBean.setValor(PerceptorBeanTipos.P_SITUFAM, situacionFamiliar);
		if ("2".equals(situacionFamiliar)) {
			// NIF DEL CNYUGE
			perceptorBean.setValor(PerceptorBeanTipos.P_NIFCON, registro.substring(157, 166));
		}
		
		// SITUACIN PERSONAL
		final String clave = registro.substring(77, 78);
		
		if (!"ABC".contains(clave)) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR, "E1901", "Clave de percepcin no admitida", "", -1));
		} else if ("A".equals(clave)) {
			perceptorBean.setValor(PerceptorBeanTipos.P_SITUPER, 1);
			perceptorBean.setValor(PerceptorBeanTipos.P_CONTRATO, Integer.parseInt(registro.substring(167, 168)));
			// Movilidad geogrfica. Como no existe registro del 190 2017 an, no se de donde extraer este dato.
			// Vamos a suponer que sigue en el mismo sitio que en 2015.
			final String movilidadGeografica = registro.substring(169, 170);
			if ("1".equals(movilidadGeografica)) {
				perceptorBean.setValor(PerceptorBeanTipos.P_MOVIL, Boolean.TRUE);
			}
		} else if ("B".equals(clave)) {
			final String subclave = registro.substring(78, 80);
			
			if ("01".equals(subclave)) {
				perceptorBean.setValor(PerceptorBeanTipos.P_SITUPER, 2);
			} else if ("02".equals(subclave)) {
				perceptorBean.setValor(PerceptorBeanTipos.P_SITUPER, 4);
			} else {
				perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR, "E1902", "Subclave de percepcin no admitida", "", -1));
			}
		} else {
			perceptorBean.setValor(PerceptorBeanTipos.P_SITUPER, 3);
		}
		
		// RETRIBUCIONES NTEGRAS. La suma de las percepciones dinerarias y en especie. 
		// De momento se ignora el signo porque para retenciones no admite cantidades negativas.
		// Hay que controlarlo o solo van a llamarnos con registros correctos?.
		if ("N".equals(registro.substring(80,81)) || "N".equals(registro.substring(107,108))) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR, "E1903", "No se admiten reembolsos", "", -1));
		}
		if (Integer.parseInt(registro.substring(147, 151)) != 0) {
			perceptorBean.setErr(new ErrorValidacionBeanImpl(TipoErrorValidacion.ERROR, "E1904", "No se admiten atrasos", "", -1));
		} else {
			final BigDecimal retrib = new BigDecimal(registro.substring(81, 94)).add(new BigDecimal(registro.substring(108, 121))).movePointLeft(2);
			perceptorBean.setValor(PerceptorBeanTipos.P_RETRIB, retrib);
		}
		
		// REDUCCIONES POR IRREGULARIDAD
		final BigDecimal irregular1 = new BigDecimal(registro.substring(170, 183)).movePointLeft(2);
		perceptorBean.setValor(PerceptorBeanTipos.P_IRREGULAR1, irregular1);
		
		// COTIZACIONES. 
		final BigDecimal cotizaciones = new BigDecimal(registro.substring(183, 196)).movePointLeft(2);
		perceptorBean.setValor(PerceptorBeanTipos.P_COTIZACIONES, cotizaciones);

		// PENSION COMPENSATORIA. 
		final BigDecimal pension = new BigDecimal(registro.substring(196, 209)).movePointLeft(2);
		perceptorBean.setValor(PerceptorBeanTipos.P_PENSION, pension);

		// ANUALIDADES. 
		final BigDecimal anualidades = new BigDecimal(registro.substring(209, 222)).movePointLeft(2);
		perceptorBean.setValor(PerceptorBeanTipos.P_ANUALIDADES, anualidades);
		
		// COMUNICACIN PRSTAMOS VIVIENDA
		if ("1".equals(registro.substring(254, 255))) {
			perceptorBean.setValor(PerceptorBeanTipos.P_MINOPAGO, Boolean.TRUE);
		}
		
		descendientes(perceptorBean, registro);
		ascencientes(perceptorBean, registro);
		
		if (!erroresRegistro.isEmpty()) {
			for (ErrorValidacionBeanImpl errorValidacionBean : erroresRegistro) {
				perceptorBean.setErr((ErrorValidacionBeanImpl) errorValidacionBean);
			}
		}
	}

	private void descendientes(PerceptorBean perceptorBean, String registro) {
		// Descendientes menores
		final int numDescendietesMenor3 = Integer.parseInt(registro.substring(222, 223));
		final int numDescendientesResto = Integer.parseInt(registro.substring(224, 226));
		
		if (numDescendietesMenor3 + numDescendientesResto == 0) {
			return;
		}
		
		List<DescendienteBean> descendientes = new ArrayList<>();

		// Primero los de tres o ms aos.
		for (int i = 0; i < numDescendientesResto; i++) {
			DescendienteBean bean = perceptorBean.createDescendienteBean();
			bean.setAnioNacimiento(2000);
			descendientes.add(bean);
		}
		
		// Ahora los de menos de tres.
		for (int i = 0; i < numDescendietesMenor3; i++) {
			DescendienteBean bean = perceptorBean.createDescendienteBean();
			bean.setAnioNacimiento(2020);
			descendientes.add(bean);
		}
		
		// Resto de por enteros
		int numRestoPorEntero = Integer.parseInt(registro.substring(226, 228));
		int numMenor3PorEntero = Integer.parseInt(registro.substring(223, 224));
		
		// Asignamos por entero a los tres primeros hijos si los hubiera
		final boolean porEnteroHijo1 = "1".equals(registro.substring(250, 251));
		descendientes.get(0).setPorEntero(porEnteroHijo1);
		if (porEnteroHijo1 && descendientes.get(0).getAnioNacimiento() == 2000) {
			numRestoPorEntero--;
		} else if (porEnteroHijo1) {
			numMenor3PorEntero--;
		}
		
		if (descendientes.size() > 1) {
			final boolean porEnteroHijo2 = "1".equals(registro.substring(251, 252));
			descendientes.get(1).setPorEntero(porEnteroHijo2);
			if (porEnteroHijo2 && descendientes.get(1).getAnioNacimiento() == 2000) {
				numRestoPorEntero--;
			} else if (porEnteroHijo2) {
				numMenor3PorEntero--;
			}
		}
		
		if (descendientes.size() > 2) {
			final boolean porEnteroHijo3 = "1".equals(registro.substring(252, 253));
			descendientes.get(2).setPorEntero(porEnteroHijo3);
			if (porEnteroHijo3 && descendientes.get(2).getAnioNacimiento() == 2000) {
				numRestoPorEntero--;
			} else if (porEnteroHijo3) {
				numMenor3PorEntero--;
			}
		}
		// Resto de por enteros
		int i = 2;
		while (i < numDescendientesResto + numDescendietesMenor3 && (numMenor3PorEntero > 0 || numRestoPorEntero > 0)) {
			DescendienteBean bean = descendientes.get(i);
			
			bean.setPorEntero(true);
			if (bean.getAnioNacimiento() == 2000) {
				numRestoPorEntero--;
			} else {
				numMenor3PorEntero--;
			}
		}
		
		// DISCAPACITADOS
		int total3365 = Integer.parseInt(registro.substring(228, 230));
		int total3365Porentero = Integer.parseInt(registro.substring(230, 232));
		i = 0;
		//33-65 Por entero
		while (total3365Porentero > 0) {
			DescendienteBean bean = descendientes.get(i); 
			if (bean.isPorEntero()) {
				bean.setDiscapacidad(PerceptorBeanTipos.ENTRE33Y65);
				total3365Porentero--;
				total3365--;
			}
			i++;
		}
		// 33-65 Por mitad
		i = 0;
		while (total3365 > 0) {
			DescendienteBean bean = descendientes.get(i); 
			if (!bean.isPorEntero()) {
				bean.setDiscapacidad(PerceptorBeanTipos.ENTRE33Y65);
				total3365--;
			}
			i++;
		}

		// Movilidad reducida
		int totalMovilidad = Integer.parseInt(registro.substring(232, 234));
		int totalMovilidadPorentero = Integer.parseInt(registro.substring(234, 236));
		// Movilidad por entero
		i = 0;
		while (totalMovilidadPorentero > 0) {
			DescendienteBean bean = descendientes.get(i); 
			if (bean.isPorEntero() && bean.getDiscapacidad() == PerceptorBeanTipos.ENTRE33Y65) {
				bean.setMovilidadReducida(true);
				totalMovilidadPorentero--;
				totalMovilidad--;
			}
			i++;
		}
		// Movilidad por mitad
		i = 0;
		while (totalMovilidad > 0) {
			DescendienteBean bean = descendientes.get(i); 
			if (!bean.isPorEntero() && bean.getDiscapacidad() == PerceptorBeanTipos.ENTRE33Y65) {
				bean.setMovilidadReducida(true);
				totalMovilidad--;
			}
			i++;
		}

		// 65%
		int total65 = Integer.parseInt(registro.substring(236, 238));
		int total65Porentero = Integer.parseInt(registro.substring(238, 240));
		// Movilidad por entero
		i = 0;
		while (total65Porentero > 0) {
			DescendienteBean bean = descendientes.get(i); 
			if (bean.isPorEntero() && bean.getDiscapacidad() == PerceptorBeanTipos.SINDISCAPACIDAD) {
				bean.setDiscapacidad(PerceptorBeanTipos.MAS65);
				total65Porentero--;
				total65--;
			}
			i++;
		}
		// Movilidad por mitad
		i = 0;
		while (total65 > 0) {
			DescendienteBean bean = descendientes.get(i); 
			if (!bean.isPorEntero() && bean.getDiscapacidad() == PerceptorBeanTipos.SINDISCAPACIDAD) {
				bean.setDiscapacidad(PerceptorBeanTipos.MAS65);
				total65--;
			}
			i++;
		}
		
		//Asignamos los descendientes
		perceptorBean.setValor(PerceptorBeanTipos.P_DESCENDIENTES, descendientes);
	}

	private void ascencientes(PerceptorBean perceptorBean, String registro) {
		final int numMenos75 = Integer.parseInt(registro.substring(240, 241));
		final int numMas75 = Integer.parseInt(registro.substring(242, 243));
		
		if (numMenos75 + numMas75 == 0) {
			return;
		}
		
		List<AscendienteBean> ascendientes = new ArrayList<>();
		
		// Ascendientes de menos de 75 aos.
		int numMenos75Porentero = Integer.parseInt(registro.substring(241, 242));
		for(int i = 0; i < numMenos75; i++) {
			AscendienteBean ascendiente = perceptorBean.createAscendienteBean();
			ascendiente.setAnioNacimiento(PerceptorBeanTipos.ANIOEJ_24 - 65);
			if (numMenos75Porentero > 0) {
				ascendiente.setConvivencia(1);
				numMenos75Porentero--;
			} else {
				// Desde el 190 no disponemos del grado de convivencia
				// de cada descendiente. Este dato es necesario para calcular el mnimo
				// personal y familiar. Esto impide calcular las retenciones tal y como
				// est ahora mismo el algoritmo diseado.
				ascendiente.setConvivencia(2);
			}
			ascendientes.add(ascendiente);
		}
		
		// Ascendientes de 75 aos o ms.
		int numMas75Porentero = Integer.parseInt(registro.substring(243, 244));
		for(int i = 0; i < numMas75; i++) {
			AscendienteBean ascendiente = perceptorBean.createAscendienteBean();
			ascendiente.setAnioNacimiento(PerceptorBeanTipos.ANIOEJ_24 - 76);
			if (numMas75Porentero > 0) {
				ascendiente.setConvivencia(1);
				numMas75Porentero--;
			} else {
				// Desde el 190 no disponemos del grado de convivencia
				// de cada descendiente. Este dato es necesario para calcular el mnimo
				// personal y familiar. Esto impide calcular las retenciones tal y como
				// est ahora mismo el algoritmo diseado.
				ascendiente.setConvivencia(2);
			}
			ascendientes.add(ascendiente);
		}
		
		perceptorBean.setValor(PerceptorBeanTipos.P_ASCENDIENTES, ascendientes);
	}

	private void traza(String mensaje) {
		final SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.S");
		String laTraza = String.format("c200::CalculoRetencionesCICSSrv [%s]: %s", df.format(new Date()), mensaje);
		
		Logger.getLogger(getClass().getName()).log(Level.INFO, laTraza);
	}
}
