/** Java class "AnalizarLineaComandos.java" generated from Poseidon for UML.
 *  Poseidon for UML is developed by <A HREF="http://www.gentleware.com">Gentleware</A>.
 *  Generated with <A HREF="http://jakarta.apache.org/velocity/">velocity</A> template engine.
 *  
 *   
 */

package es.aeat.pret.c200.mc.comun;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/**
 *   <b>Agencia Tributaria 2003</b><br><br>
 * 
 *Esta clase sirve para generar una lista de parmetros, validarlos y poder recuperar sus valores
 *estableciendo si son parmetros nicos as como el posible valor por defecto.
 *@version 1.0
 *@author DIT, Agencia Tributaria
 */
@SuppressWarnings({"rawtypes", "unchecked"})
public class AnalizarLineaComandos {
    /**Esta constante, identifica internamente el error que se produce al utilizar la funcin parse.  */
    private static final String NUM_ERROR1 = "0001";
    /**Esta constante, indica el texto del error que se produce.  */
    private static final String TEXTO_ERROR1 = " Error en el formato de parmetro";
    /**Esta constante, identifica internamente el error que se produce al utilizar la funcin parse.  */
    private static final String NUM_ERROR2 = "0002";
    /**Esta constante, indica el texto del error que se produce.  */
    private static final String TEXTO_ERROR2 = " Error, este nombre de parmetro no existe";
    /**Esta constante, identifica internamente el error que se produce al utilizar la funcin parse.  */
    private static final String NUM_ERROR3 = "0003";
    /**Esta constante, indica el texto del error que se produce.  */
    private static final String TEXTO_ERROR3 = " Error, Tiene un parmetro con valor obligatorio";
    /**Esta constante, identifica internamente el error que se produce al utilizar la funcin parse.  */
    private static final String NUM_ERROR4 = "0004";
    /**Esta constante, identifica internamente el error que se produce al utilizar la funcin parse.  */
    private static final String NUM_ERROR5 = "0005";
    /**Esta constante, indica el texto del error que se produce.  */
    private static final String TEXTO_ERROR4 = " Error, Tiene un parmetro con valor nico";
    /**Esta constante, indica el texto del error que se produce.  */
    private static final String TEXTO_ERROR5 = " Error, Valor no permitido";
    /**Es una Collection que guarda los parmetros */
	private Collection listaParametros; 
    private StringBuilder sParametro;

    /**
     *<p>
     *Este constructor declara un ArrayList para guardar los parmetros
     * <p>
     */
    public  AnalizarLineaComandos() {
        listaParametros = new ArrayList();
    }
    
    /**
     * <p>
     *Permite establecer par&#225;metros soportados por el sistema, pasndole las cuatro variables 
     *requeridas, el parmetro se incluir en una coleccin, para su posterior utilizacin.
     * 
     *
     *@param nombres Tipo String. Indica la letra del parmetro.
     *</p>
     * <p>
     * @param obligatorio Tipo boolean. Indica true para obligado cumplimiento.
     * </p>
     * <p>
     * @param valorDefecto Tipo String. Indica el valor por defecto del parmetro.
     * </p>
     * <p>
     * @param valorUnico Tipo boolean. Indica true cuando el valor del parmetro es nico.
     * </p>
     */
	public void setParametro(String nombres, boolean obligatorio, String valorDefecto, boolean valorUnico,String []valores) {
        Parametro miParam = new Parametro();
        if(nombres == null) {
			miParam.setNombre(null);
		} else {
			miParam.setNombre(nombres.toUpperCase());
		}
        
        miParam.setObligatorio(obligatorio);
        miParam.setValorDefecto(valorDefecto);
        
        miParam.setValorUnico(valorUnico);
        miParam.setValores(valores);
        listaParametros.add(miParam);        
        
    }
	
    public void setParametro(String nombres, boolean obligatorio, String valorDefecto, boolean valorUnico) {
        Parametro miParam = new Parametro();
        if(nombres == null) {
			miParam.setNombre(null);
		} else {
			miParam.setNombre(nombres.toUpperCase());
		}
        
        miParam.setObligatorio(obligatorio);
        miParam.setValorDefecto(valorDefecto);
        
        miParam.setValorUnico(valorUnico);
        listaParametros.add(miParam);
    } 
    
    /**
     * <p>
     *Permite recuperar el valor de un par&#225;metro indicndole la letra que identifica al parmetro.
     * </p>
     * <p>
     *
     *@param nombre Recibe la letra que identifica el parmetro para recuperar su valor.
     * </p>
     *@return Un String que es el valor del parmetro.
     * <p>
     * @throws AnalizarLineaComandoException
     * </p>
     */
    public String getParametro(String nombre) throws AnalizarLineaComandoException {
        // recorrer la tabla para devolver el valor del parmetro requerido
        Iterator it = listaParametros.iterator();
        while(it.hasNext()){
            Parametro paramAux = (Parametro) it.next();
            if(paramAux.getNombre().equals(nombre)  ){
                if(paramAux.getValorParametro() == null || paramAux.getValorParametro() == "") {
					if(paramAux.getValorDefecto() == null || paramAux.getValorDefecto() == ""){
						// porque est mal generado en origen
						throw new AnalizarLineaComandoException("ERROR"); 
                    } else{
                        return paramAux.getValorDefecto();
                    }
				} else{
                    return paramAux.getValorParametro();
                }
            }
        }
        throw new AnalizarLineaComandoException("ERROR");
    } 
    
    /** <p>
     * Valida una linea de comando seg&#250;n los par&#225;metros definidos por la aplicacin que
     * se est ejecutando.
     * </p>
     * Al utilizar esta funcin, hay que implementar el manejo de la excepcin
     * AnalizarLineaComandoException obligatoriamente.
     * @see AnalizarLineaComandoException
     * @param lineaComando Es la lista de los argumentos recibidos en la lnea de comandos.
     * </p>
     * @throws AnalizarLineaComandoException
     */
    public void parse(String[] lineaComando) throws AnalizarLineaComandoException {
        /*
        *  Se utilizan las funciones:
        *  - boolean validaFormatoParametro(String _lineaComando)
        *  - boolean validaNombreParametro(String _lineaComando)
        *  - boolean validaValorObligatorio()
        *  - boolean validaValorUnico() 
        *
        */
        for(int i=0; i < lineaComando.length;i++) {
            if(!validaFormatoParametro(lineaComando[i])){
                throw new AnalizarLineaComandoException(generaMensaje(NUM_ERROR1,lineaComando[i],TEXTO_ERROR1).toString());
            }
            if(!validaNombreParametro(lineaComando[i])){
                throw new AnalizarLineaComandoException(generaMensaje(NUM_ERROR2,lineaComando[i].substring(0,3),TEXTO_ERROR2).toString());
            }
        }
        
        if(!validaValorObligatorio()){
            throw new AnalizarLineaComandoException(generaMensaje(NUM_ERROR3,sParametro.toString(),TEXTO_ERROR3).toString());
        }
        if(!validaValorUnico()){
            throw new AnalizarLineaComandoException(generaMensaje(NUM_ERROR4,sParametro.toString(),TEXTO_ERROR4).toString());
        }
        Parametro mal=validaValoresPermitidos();
        if (mal!=null){
            throw new AnalizarLineaComandoException(generaMensaje(NUM_ERROR5,"/"+mal.getNombre()+":",TEXTO_ERROR5).toString());
        }
    }
    
    private StringBuilder generaMensaje(String sNumero,String lineaComando,String sTexto){
        StringBuilder mesError = new StringBuilder();
        mesError.append(sNumero);
        if(lineaComando != null){
            mesError.append(" ");
            mesError.append(lineaComando);
        }
        mesError.append(sTexto);
        return mesError;
        
    }
    
    /**
     * <p>
     * Valida el formato de un par&#225;metro individual:
     * </p>
     * <p>
     * &quot;/nombre:valor&quot;
     * </p>
     * <p>
     *
     * @return a boolean with ...
     * </p>
     * <p>
     * @param _parametro ...
     * </p>
     */
    /**
         *Esta funcin validaFormatoParametro
         * analiza que el parmetro se compone de /, letra,: y  valor.
         * No puede haber ms de una barra, ni ms de :
         **/
            private boolean validaFormatoParametro(String parametro) {
        //la primera posicion tiene que ser "/"
        
        if(parametro.charAt(0) != '/'){
            return false;
        }
        
        //no encuentro los ":"
        int pos = parametro.indexOf(':');
        if(pos == -1) {
            return false;
        }
        // Los : tienen que estar forzosamente en la segunda posicin
        if (pos != 2){
            return false;
        }
        
       
        // Tenemos que comprobar si el tamao del parmetro es mayor que 3,
        // Esto quiere decir que ha tecleado algo en Valor.
        // por ejemplo /E:HOLA devolver un length de 7
        if(parametro.length() <= 3){
            return false;
        }
        //si el formato es correcto...
        return true;
    } 
    
    /**
     * <p>
     * Valida el nombre de un par&#225;metro individual:
     * </p>
     * <p>
     * &quot;/nombre:valor&quot;
     * </p>
     * <p>
     *
     * @return a boolean with ...
     * </p>
     * <p>
     * @param parametro ...
     * </p>
     */
    private boolean validaNombreParametro(String parametro) {
        //localizamos los : y obtenemos la posicin del ParametroNombre, que es la letra anterior
        int pos = parametro.indexOf(':');
        String sAux = parametro;
        pos = pos - 1;
        String  letra =   sAux.substring(pos,pos+1);
        // en listaParametros buscaremos el elemento nombre
        Iterator it = listaParametros.iterator();
        while(it.hasNext()){
            Parametro paramAux = (Parametro) it.next();
            if(paramAux.getNombre().equalsIgnoreCase(letra)  ){
                // a parte de saber que si lo contiene, vamos a guardar el valor del parmetro
                pos = pos + 2;
                //String valor = sAux.substring(pos, _parametro.length())
                //paramAux.setValorParametro(valor)
                paramAux.setValorParametro(sAux.substring(pos, parametro.length()));
                return true;
            }
        }
        return false;
    }
    
    /**
     * <p>
     * Valida la aparici&#243;n de todos los par&#225;metros obligatorios definidos...
     * </p>
     * <p>
     *
     * @return a boolean with ...
     * </p>
     */
    private boolean validaValorObligatorio() {
        // en listaParametros buscaremos el elemento nombre
        
        Iterator it = listaParametros.iterator();
        while(it.hasNext()){
            Parametro paramAux = (Parametro) it.next();
            // Para que tenga el valor del parametro en caso de dar error
            sParametro = new StringBuilder(4);
            sParametro.append('/');
            sParametro.append(paramAux.getNombre() );
            sParametro.append(':');
            
            if(paramAux.isObligatorio()){
                
                if( paramAux.getValorParametro() == null || "".equals(paramAux.getValorParametro())) {
                    return false;
                }
            } else {
                // primero miro el valor del parmetro
                if( paramAux.getValorParametro() == null || "".equals(paramAux.getValorParametro())){
                    // vamos a mirar el valor por defecto
                    if(paramAux.getValorDefecto() == null || "".equals(paramAux.getValorDefecto())){
                        // Es ERROR  no tiene valor el parmetro y no tiene val. por defecto
                        return false;
                    }
                }
            } 
        } 
        return true;
    } 
    
    private Parametro validaValoresPermitidos() {
    	Iterator it = listaParametros.iterator();
        while(it.hasNext()){
            Parametro paramAux = (Parametro) it.next();
            if (!paramAux.validaValores()){
            	return paramAux;
            }
        }
        return null;
     }
    
    /**
     * <p>
     * Valida valores &#250;nicos para los par&#225;metros definidos...
     * </p>
     * <p>
     *
     * @return a boolean with ...
     * </p>
     */
    private boolean validaValorUnico() {
        Iterator it = listaParametros.iterator();
        int i = 0;
        while(it.hasNext()){
            Parametro paramAux = (Parametro) it.next();
            // Para que tenga el valor del parametro en caso de dar error
            sParametro = new StringBuilder(4);
            sParametro.append('/');
            sParametro.append(paramAux.getNombre() );
            sParametro.append(':');
            
            if(paramAux.isValorUnico()) {
                String cadAux;
                if( paramAux.getValorParametro() == null || "".equals(paramAux.getValorParametro())) {
                    if(paramAux.getValorDefecto() == null || "".equals(paramAux.getValorDefecto())){
                    	// es un error...
                    	return false; 
                    } else {
                        // Valor por defecto tiene contenido
                        cadAux = paramAux.getValorDefecto();
                    }
                } else{
                    cadAux = paramAux.getValorParametro();
                }
                
                if(buscaValorRepetido(i, cadAux)){
                    return false;
                }
            } 
            
            i++;
        }
        return true;
    } 
    
    private boolean buscaValorRepetido(int actual, String cadena){
        Iterator it = listaParametros.iterator();
        int j = 0;
        while(it.hasNext()){
            Parametro paramAux = (Parametro) it.next();
            
            if(actual != j){
                if( paramAux.getValorParametro() == null || "".equals(paramAux.getValorParametro())) { 
                	// preguntaremos por el valor por defecto.
                    if(paramAux.getValorDefecto().equals(cadena)) {   
                    	// REPETIDOS
                        return true;
                    }
                } else {
                    // Entonces preguntaremos por el contenido del parametro.
                    if(paramAux.getValorParametro().equals(cadena)) {  
                    	 // REPETIDOS
                        return true;
                    }
                }
            }
            j++;
        } 
        // porque no ha encontrado valores repetidos
        return false; 
        
    } 
 }

 class Parametro {
 
    private String nombre = null; 
    private boolean obligatorio = true; 
    private String valorDefecto = null; 
    private String valorParametro = null; 
    private boolean valorUnico = true; 
    
    protected String []m_valores=null;
   
    Parametro() {        
    	// no hacemos nada
    } 
    
    protected  Parametro(String nombre, boolean obligatorio, String valorDefecto, boolean valorUnico) {        
    	// no hacemos nada
    }  

    public String[]valores(){
    	return m_valores;
    }       

    String getNombre() {        
    	return nombre;
    }        

    void setNombre(String nombre) {        
    	this.nombre = nombre;
    }         

    boolean isObligatorio() {        
    	return obligatorio;
    }         

    void setObligatorio(boolean obligatorio) {        
    	this.obligatorio = obligatorio;
    }         

    String getValorDefecto() {        
    	return valorDefecto;
    }         

    void setValorDefecto(String valorDefecto) {        
    	this.valorDefecto = valorDefecto;
    }        

    String getValorParametro() {        
    	return valorParametro;
    }         

    void setValorParametro(String valorParametro) {        
    	this.valorParametro = valorParametro;
    } 

    boolean isValorUnico() {        
    	return valorUnico;
    }

    void setValorUnico(boolean valorUnico) {        
    	this.valorUnico = valorUnico;
    } 
     
    void setValores(String []valores) {
        m_valores = valores.clone();
    }

    public boolean validaValores() {
    	if (m_valores==null){
    		return true;
    	}
        
    	for (int ii=0;ii<m_valores.length;ii++) {
            if (m_valores[ii]==null || getValorParametro()==null || m_valores[ii].equalsIgnoreCase(getValorParametro())){
                return true;
            }
        }
        return false;
    }
}
