package es.aeat.pret.c200.c220.imp.srv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

import es.aeat.pret.c200.api.bean.PerceptorBean;
import es.aeat.pret.c200.c220.api.srv.CalculoRetencionesSrv;
import es.aeat.pret.c200.c220.api.srv.CalculoRetencionesXMLSrv;
import es.aeat.pret.c200.c220.api.srv.ValidarLeerFicheroSrv;
import es.aeat.pret.c200.imp.bean.PerceptorBeanImpl;


public class CalculoRetencionesXMLSrvImpl implements CalculoRetencionesXMLSrv {

	class RetenedorBeanImpl {
		String nif;
		String nombre;
		
		public String getNif() {
			return nif;
		}
		public void setNif(String nif) {
			this.nif = nif;
		}
		public String getNombre() {
			return nombre;
		}
		public void setNombre(String nombre) {
			this.nombre = nombre;
		}
	}


	private Logger getLog() {
		return Logger.getLogger(PerceptorBeanImpl.class.getName());
	}
	
	@Override
	public String procesar(File xml, PerceptorBean perceptor) {
		
//		CalculoRetencionesSrv retencionesSrv = ModuloCalculo.isModuloCalculo() ? new CalculoRetencionesSrvImpl() : PRET_C220_Factory.getCalculoRetencionesSrv();
//		ValidarLeerFicheroSrv validaFicheroSrv = ModuloCalculo.isModuloCalculo() ? new ValidarLeerFicheroSrvImpl() : PRET_C220_Factory.getValidarFicheroSrv();

		CalculoRetencionesSrv retencionesSrv = new CalculoRetencionesSrvImpl();
		ValidarLeerFicheroSrv validaFicheroSrv = new ValidarLeerFicheroSrvImpl();
		
//		PerceptorBean per = ModuloCalculo.isModuloCalculo() ? retencionesSrv.createPerceptorBean() : perceptor;
		
		PerceptorBean per = perceptor == null ? retencionesSrv.createPerceptorBean() : perceptor;
		
		PerceptorBean controla = retencionesSrv.createPerceptorBean();
		
		per.setCerradaSalidaPorError(true);
		per.setHuboErroresAntes(false);
		per.setErrorValidacion(false);
		per.setIndiceRetenedor(0);
		per.setIndiceRetenido(0);
		per.setFicheroSalidaCalculo(null);
		
		validaFicheroSrv.inicializaValidador(per);

		// para que se borre el fichero temporal de entrada
		FileInputStream fiso = null;
		FileInputStream fisi = null;
		
		int numeroRetenedoresTotal = 0;
		int numeroRetenidosTotal = 0;
		
		if (validarEsquema(xml,validaFicheroSrv, per)) {

			if(numeroRetenedoresTotal==0 && numeroRetenidosTotal==0){
				// aqui ya tenemos los nombres de los ficheros de entrada y error
				controla.setFicheroError(per.getFicheroError());
				controla.setFicheroSalida(per.getFicheroSalida());
				controla.setFicheroSalidaCalculo(per.getFicheroSalidaCalculo());
			}
			
			try {
				fiso = new FileInputStream(xml);
				fisi = new FileInputStream(xml);
				validaFicheroSrv.prepararReaderRetenedor(fiso, per, false, true, false);
				validaFicheroSrv.prepararReaderRetenido(fisi, per, false, true, false);
				
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} 
				
			controla.setIndiceRetenedor(0);
			controla.setIndiceRetenido(0);
			
			numeroRetenedoresTotal = validaFicheroSrv.getNumeroRetenedoresTotal(per);
			int[] numeroRetenidosRetenedor = validaFicheroSrv.getListaRetenidos(per);
			// AQUI HACEMOS EL BUCLE DE LOS RETENEDORES
			for (int i=0;i<numeroRetenedoresTotal;i++) {
				per.setIndiceRetenedor(controla.getIndiceRetenedor());
				getSiguienteRetenedor(validaFicheroSrv,per);
				
				for (int j=0;j<numeroRetenidosRetenedor[i];j++) {
					numeroRetenidosTotal = numeroRetenidosTotal+1;
					per.setIndiceRetenedor(controla.getIndiceRetenedor());
					per.setIndiceRetenido(controla.getIndiceRetenido());
					
					// esto borra per entero
					getSiguientePerceptor(validaFicheroSrv,per);

					per.setIndiceRetenedor(controla.getIndiceRetenedor());
					per.setIndiceRetenido(controla.getIndiceRetenido());
					
					boolean valido = retencionesSrv.validar(per, true);

					if ( valido ) {
						retencionesSrv.calcular(per);

						valido = retencionesSrv.validarPostCalculos(per);
						if(valido && !controla.isHuboErroresAntes()){
							//System.out.println("GENERAMOS SALIDA PORQUE NO HUBO ERRORES ANTES")
							generarXMLSalida(per, validaFicheroSrv);
							if(per.getIndiceRetenido()==0){
								controla.setAbiertoRetenedor(true);
							}
							
						}else{
							// ya teniamos errores antes del que vamos a escribir
//							System.out.println("GENERAMOS ERROR")
							controla.setHuboErroresAntes(true);
							if(!controla.isCerradaSalidaPorError()){
								if(controla.isAbiertoRetenedor()){
									validaFicheroSrv.terminaRetenedor(per);
									controla.setAbiertoRetenedor(false);
								}

								// puede que hubiera un error en el primer retenido del primer retenedor,
								// en ese caso no tenemos que terminar nada
								if(per.getStax()!=null){
									validaFicheroSrv.terminarDocumento(per);
								}
								controla.setCerradaSalidaPorError(true);
							}
							
							// PUEDE QUE ESTEMOS AQUI PORQUE HUBO ERRORES ANTES O PORQUE
							// TENEMOS ERROR EN ESTE RETENIDO, SI ES ASI LO ESCRIBIMOS
							if(!retencionesSrv.getErrores(per).isEmpty()){
								validaFicheroSrv.crearFicheroErrorRetenidoSTAX(retencionesSrv, per,
										controla.getIndiceRetenedor(), controla.getIndiceRetenido());
								controla.setAbiertoRetenedor(true);
							}
						}
					}else if (!retencionesSrv.getErrores(per).isEmpty() || !valido){	
//						System.out.println("VALIDAR NO CORRECTO "+indiceRetenedor+" "+indiceRetenido)
						controla.setHuboErroresAntes(true);
						
						if(!controla.isCerradaSalidaPorError()){
							if(controla.isAbiertoRetenedor()){
								validaFicheroSrv.terminaRetenedor(per);
								controla.setAbiertoRetenedor(false);
							}
							
							// puede que hubiera un error en el primer retenido del primer retenedor,
							// en ese caso no tenemos que terminar nada
							if(per.getStax()!=null){
								validaFicheroSrv.terminarDocumento(per);
							}
							controla.setCerradaSalidaPorError(true);
						}
						
						// PUEDE QUE ESTEMOS AQUI PORQUE HUBO ERRORES ANTES O PORQUE
						// TENEMOS ERROR EN ESTE RETENIDO, SI ES ASI LO ESCRIBIMOS ??
						if(!retencionesSrv.getErrores(per).isEmpty()){
							validaFicheroSrv.crearFicheroErrorRetenidoSTAX(retencionesSrv, per,
									controla.getIndiceRetenedor(), controla.getIndiceRetenido());
							controla.setAbiertoRetenedor(true);
						}
					}
					int indiceRetenido = controla.getIndiceRetenido()+1;
					controla.setIndiceRetenido(indiceRetenido);
				}
				if(!controla.isHuboErroresAntes()){
					if(controla.isAbiertoRetenedor()){
						validaFicheroSrv.terminaRetenedor(per);
						controla.setAbiertoRetenedor(false);
					}
				} else{
					if(controla.isAbiertoRetenedor()) {
						validaFicheroSrv.terminaRetenedorError(per);
						controla.setAbiertoRetenedor(false);
					}
				}
				
				controla.setIndiceRetenedor(controla.getIndiceRetenedor()+1);
				controla.setIndiceRetenido(0);
			}

			numeroRetenidosRetenedor=null;
			
			if(!controla.isHuboErroresAntes()){
				validaFicheroSrv.terminarDocumento(per);
				validaFicheroSrv.ponerSello(per);
			} else{
				validaFicheroSrv.terminarDocumentoError(per);
			}
			
			// no hubo errores
			if(!controla.isHuboErroresAntes()){
				controla.setFicheroSalidaCalculo(per.getFicheroSalida());
			} else{
				// hubo errores
				controla.setFicheroSalidaCalculo(per.getFicheroError());
			}
		} else {
			// tenemos error de esquema
			controla.setFicheroSalidaCalculo(per.getFicheroError());
		}
		
		// aqui ya tenemos los nombres de los ficheros de entrada y error
		controla.setFicheroError(per.getFicheroError());
		controla.setFicheroSalida(per.getFicheroSalida());
		controla.setErrorImportacion(per.isErrorImportacion());
		controla.setErrorValidacion(per.isErrorValidacion());
		controla.setErroresImportacion(per.getErroresImportacion());
		controla.setTenemosError(per.isTenemosError());
				
		String salida = validaFicheroSrv.salidaXML(controla.isHuboErroresAntes(), controla).getAbsolutePath();
//		System.out.println("SALIDA "+salida)

		try {
			if(fiso!=null){
				fiso.close();
				fiso=null;
			}
			if(fisi!=null){
				fisi.close();
				fisi=null;
			}
		} catch (IOException e) {
			getLog().severe(e.getMessage());
		}
		
		validaFicheroSrv.cerrarReaderRetenedor(per);
		validaFicheroSrv.cerrarReaderRetenido(per);
		validaFicheroSrv.inicializaValidador(per);
		
		validaFicheroSrv = null;
		retencionesSrv = null;

		// modulo de calculo
		if(perceptor==null){
			controla.borraDatos();
			controla=null;
			per.borraDatos();
			per=null;
		} else{
			per.borraDatos();
			per=null;
			
			// generar xml desde programa
			perceptor.setFicheroError(controla.getFicheroError());
			perceptor.setFicheroSalida(controla.getFicheroSalida());
			perceptor.setFicheroSalidaCalculo(controla.getFicheroSalidaCalculo());
			perceptor.setNumeroRetenedoresCalculo(numeroRetenedoresTotal);
			perceptor.setNumeroRetenidosCalculo(numeroRetenidosTotal);
			perceptor.setHuboErroresAntes(controla.isHuboErroresAntes());
			perceptor.setCerradaSalidaPorError(controla.isCerradaSalidaPorError());
			perceptor.setErrorImportacion(controla.isErrorImportacion());
			perceptor.setErrorValidacion(controla.isErrorValidacion());
			perceptor.setTenemosError(controla.isTenemosError());
						
			controla.borraDatos();
			controla=null;
		}

		return salida;
	}

	
	
	
	private void generarXMLSalida(PerceptorBean perceptorActual, ValidarLeerFicheroSrv validaFicheroSrv) {
		perceptorActual.setCerradaSalidaPorError(false);
		if(perceptorActual.getIndiceRetenedor()==0 && perceptorActual.getIndiceRetenido()==0){
			validaFicheroSrv.empiezaDocumento(perceptorActual);
		}
		if(perceptorActual.getIndiceRetenido()==0){
			validaFicheroSrv.empiezaRetenedor(perceptorActual);
		}
		validaFicheroSrv.empiezaRetenido(perceptorActual);
	}
	
	private void getSiguientePerceptor(ValidarLeerFicheroSrv validaFicheroSrv,PerceptorBean per) {
		validaFicheroSrv.leeRetenido(per.getIndiceRetenedor(), per.getIndiceRetenido(), per);
	}

	private void getSiguienteRetenedor(ValidarLeerFicheroSrv validaFicheroSrv,PerceptorBean per) {
		validaFicheroSrv.leeRetenedor(per.getIndiceRetenedor(), per);
	}
	
	private boolean validarEsquema(File xml,ValidarLeerFicheroSrv validaFicheroSrv, PerceptorBean per) {
		validaFicheroSrv.validaXmlEntradaParaCalculos(xml.getPath(), per);
		if(!validaFicheroSrv.isOk(per) ){
			per.setErrorValidacion(true);
		}
		return !per.isErrorValidacion();
	}

	@Override
	public Integer getNumeroRetenedores(PerceptorBean per) {
		return per.getNumeroRetenedoresCalculo();
	}

	@Override
	public Integer getNumeroRetenidos(PerceptorBean per) {
		return per.getNumeroRetenidosCalculo();
	}

	@Override
	public Boolean getErrorCalculo(PerceptorBean per) {
		return per.isErrorValidacion() || per.isHuboErroresAntes() || per.isCerradaSalidaPorError();
	}

	@Override
	public File getSalida(PerceptorBean per) {
		return per.getFicheroSalidaCalculo();
	}
}
