package es.aeat.pret.c200.util;

import java.io.Serializable;

public class Sello  extends MD5 implements Serializable{
    
	   /** Creates a new instance of Sello */
    public Sello() {
    }

    
    public final String sellar() {
        // Obtengo el MD5
        String byteMd5 = super.asHex();
        
        // Aado el resultado al MD5
        this.update(byteMd5);
        
        // Y vuelvo a calcular
        byteMd5 = super.asHex();

        // Y cojo 12 posiciones de este MD5
        byte[] sello = to12(byteMd5.getBytes());
        
        return new String(sello).toUpperCase();
    }

    
    private byte[] to12 (byte[] byteMd5) {
        if (byteMd5.length<32){
            return null;
        }
        
        byte[] md512 = new byte[12];
        md512[0]   = byteMd5[4];
        md512[1]   = byteMd5[7];
        md512[2]   = byteMd5[8];
        md512[3]   = byteMd5[0];
        md512[4]   = byteMd5[14];
        md512[5]   = byteMd5[21];
        md512[6]   = byteMd5[16];
        md512[7]   = byteMd5[30];
        md512[8]   = byteMd5[15];
        md512[9]   = byteMd5[25];
        md512[10] = byteMd5[6];
        md512[11] = byteMd5[28];
        
        return md512;
    }
    
    
}
